/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.watchface;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.support.wearable.watchface.WatchFaceService;
import android.util.Log;
import android.view.Choreographer;
import android.view.SurfaceHolder;

@TargetApi(value=21)
public abstract class CanvasWatchFaceService
extends WatchFaceService {
    private static final String TAG = "CanvasWatchFaceService";
    private static final boolean LOG_VERBOSE = false;
    private static final boolean TRACE_DRAW = false;

    @Override
    public Engine onCreateEngine() {
        return new Engine();
    }

    public class Engine
    extends WatchFaceService.Engine {
        private static final int MSG_INVALIDATE = 0;
        private boolean mDrawRequested;
        private boolean mDestroyed;
        private Choreographer mChoreographer = Choreographer.getInstance();
        private final Choreographer.FrameCallback mFrameCallback = new Choreographer.FrameCallback(){

            public void doFrame(long frameTimeNs) {
                if (Engine.this.mDestroyed) {
                    return;
                }
                if (Engine.this.mDrawRequested) {
                    Engine.this.draw(Engine.this.getSurfaceHolder());
                }
            }
        };
        private final Handler mHandler = new Handler(){

            public void handleMessage(Message message) {
                switch (message.what) {
                    case 0: {
                        Engine.this.invalidate();
                    }
                }
            }
        };

        public void onDestroy() {
            this.mDestroyed = true;
            this.mHandler.removeMessages(0);
            this.mChoreographer.removeFrameCallback(this.mFrameCallback);
            super.onDestroy();
        }

        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (Log.isLoggable((String)CanvasWatchFaceService.TAG, (int)3)) {
                Log.d((String)CanvasWatchFaceService.TAG, (String)"onSurfaceChanged");
            }
            super.onSurfaceChanged(holder, format, width, height);
            this.invalidate();
        }

        public void onSurfaceRedrawNeeded(SurfaceHolder holder) {
            if (Log.isLoggable((String)CanvasWatchFaceService.TAG, (int)3)) {
                Log.d((String)CanvasWatchFaceService.TAG, (String)"onSurfaceRedrawNeeded");
            }
            super.onSurfaceRedrawNeeded(holder);
            this.draw(holder);
        }

        public void onSurfaceCreated(SurfaceHolder holder) {
            if (Log.isLoggable((String)CanvasWatchFaceService.TAG, (int)3)) {
                Log.d((String)CanvasWatchFaceService.TAG, (String)"onSurfaceCreated");
            }
            super.onSurfaceCreated(holder);
            this.invalidate();
        }

        public void invalidate() {
            if (!this.mDrawRequested) {
                this.mDrawRequested = true;
                this.mChoreographer.postFrameCallback(this.mFrameCallback);
            }
        }

        public void postInvalidate() {
            this.mHandler.sendEmptyMessage(0);
        }

        public void onDraw(Canvas canvas, Rect bounds) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void draw(SurfaceHolder holder) {
            this.mDrawRequested = false;
            Canvas canvas = holder.lockCanvas();
            if (canvas == null) {
                return;
            }
            try {
                this.onDraw(canvas, holder.getSurfaceFrame());
            }
            finally {
                holder.unlockCanvasAndPost(canvas);
            }
        }
    }
}

