/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.PointF;
import android.os.Handler;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.support.wearable.view.SimpleAnimatorListener;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.Scroller;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@TargetApi(value=20)
public class WearableListView
extends RecyclerView {
    private static final String TAG = "WearableListView";
    private static final long FLIP_ANIMATION_DURATION_MS = 150L;
    private static final long CENTERING_ANIMATION_DURATION_MS = 150L;
    private static final float TOP_TAP_REGION_PERCENTAGE = 0.33f;
    private static final float BOTTOM_TAP_REGION_PERCENTAGE = 0.33f;
    private static final int THIRD = 3;
    private final int mMinFlingVelocity;
    private final int mMaxFlingVelocity;
    private boolean mCanClick = true;
    private int mTapPositionX;
    private int mTapPositionY;
    private ClickListener mClickListener;
    private Animator mScrollAnimator;
    private int mLastScrollChange;
    private SetScrollVerticallyProperty mSetScrollVerticallyProperty = new SetScrollVerticallyProperty();
    private final Set<OnScrollListener> mOnScrollListeners = new HashSet<OnScrollListener>();
    private OnOverScrollListener mOverScrollListener;
    private boolean mGreedyTouchMode;
    private float mStartX;
    private float mStartY;
    private float mStartFirstTop;
    private final int mTouchSlop;
    private boolean mPossibleVerticalSwipe;
    private int mInitialOffset = 0;
    private Scroller mScroller;
    private final float[] mTapRegions = new float[2];
    private boolean mGestureDirectionLocked;
    private int mPreviousCentral = 0;
    private final int[] mLocation = new int[2];
    private final Handler mPressedHandler = new Handler();
    private View mPressedView = null;
    private final Runnable mPressedRunnable = new Runnable(){

        @Override
        public void run() {
            WearableListView.this.mPressedView = WearableListView.this.getChildAt(WearableListView.this.findCenterViewIndex());
            WearableListView.this.mPressedView.setPressed(true);
        }
    };
    private final Runnable mReleasedRunnable = new Runnable(){

        @Override
        public void run() {
            WearableListView.this.releasePressedItem();
        }
    };
    private final RecyclerView.AdapterDataObserver mObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            WearableListView.this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    WearableListView.this.removeOnLayoutChangeListener(this);
                    if (WearableListView.this.getChildCount() > 0) {
                        WearableListView.this.animateToCenter();
                    }
                }
            });
        }
    };

    public WearableListView(Context context) {
        this(context, null);
    }

    public WearableListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WearableListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setHasFixedSize(true);
        this.setOverScrollMode(2);
        this.setLayoutManager(new LayoutManager());
        RecyclerView.OnScrollListener onScrollListener = new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == 0 && WearableListView.this.getChildCount() > 0) {
                    WearableListView.this.handleTouchUp(null, newState);
                }
                for (OnScrollListener listener : WearableListView.this.mOnScrollListeners) {
                    listener.onScrollStateChanged(newState);
                }
            }
        };
        this.setOnScrollListener(onScrollListener);
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.mTouchSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        RecyclerView.Adapter currentAdapter = this.getAdapter();
        if (currentAdapter != null) {
            currentAdapter.unregisterAdapterDataObserver(this.mObserver);
        }
        super.setAdapter(adapter);
        if (adapter != null) {
            adapter.registerAdapterDataObserver(this.mObserver);
        }
    }

    public void resetLayoutManager() {
        this.setLayoutManager(new LayoutManager());
    }

    public void setGreedyTouchMode(boolean greedy) {
        this.mGreedyTouchMode = greedy;
    }

    public void setInitialOffset(int top) {
        this.mInitialOffset = top;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.mGreedyTouchMode && this.getChildCount() > 0) {
            int action = event.getActionMasked();
            if (action == 0) {
                this.mStartX = event.getX();
                this.mStartY = event.getY();
                this.mStartFirstTop = this.getChildCount() > 0 ? (float)this.getChildAt(0).getTop() : 0.0f;
                this.mPossibleVerticalSwipe = true;
                this.mGestureDirectionLocked = false;
            } else if (action == 2 && this.mPossibleVerticalSwipe) {
                this.handlePossibleVerticalSwipe(event);
            }
            this.getParent().requestDisallowInterceptTouchEvent(this.mPossibleVerticalSwipe);
        }
        return super.onInterceptTouchEvent(event);
    }

    private boolean handlePossibleVerticalSwipe(MotionEvent event) {
        float deltaY;
        if (this.mGestureDirectionLocked) {
            return this.mPossibleVerticalSwipe;
        }
        float deltaX = Math.abs(this.mStartX - event.getX());
        float distance = deltaX * deltaX + (deltaY = Math.abs(this.mStartY - event.getY())) * deltaY;
        if (distance > (float)(this.mTouchSlop * this.mTouchSlop)) {
            if (deltaX > deltaY) {
                this.mPossibleVerticalSwipe = false;
            }
            this.mGestureDirectionLocked = true;
        }
        return this.mPossibleVerticalSwipe;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int scrollState = this.getScrollState();
        boolean result = super.onTouchEvent(event);
        if (this.getChildCount() > 0) {
            int action = event.getActionMasked();
            if (action == 0) {
                this.handleTouchDown(event);
            } else if (action == 1) {
                this.handleTouchUp(event, scrollState);
                this.getParent().requestDisallowInterceptTouchEvent(false);
            } else if (action == 2) {
                if (Math.abs(this.mTapPositionX - (int)event.getX()) >= this.mTouchSlop || Math.abs(this.mTapPositionY - (int)event.getY()) >= this.mTouchSlop) {
                    this.releasePressedItem();
                    this.mCanClick = false;
                }
                result |= this.handlePossibleVerticalSwipe(event);
                this.getParent().requestDisallowInterceptTouchEvent(this.mPossibleVerticalSwipe);
            } else if (action == 3) {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        return result;
    }

    private void releasePressedItem() {
        if (this.mPressedView != null) {
            this.mPressedView.setPressed(false);
            this.mPressedView = null;
        }
        this.mPressedHandler.removeCallbacks(this.mPressedRunnable);
    }

    private void onScroll(int dy) {
        for (OnScrollListener listener : this.mOnScrollListeners) {
            listener.onScroll(dy);
        }
    }

    public void addOnScrollListener(OnScrollListener listener) {
        this.mOnScrollListeners.add(listener);
    }

    public void removeOnScrollListener(OnScrollListener listener) {
        this.mOnScrollListeners.remove(listener);
    }

    private boolean checkForTap(MotionEvent event) {
        float rawY = event.getRawY();
        int index = this.findCenterViewIndex();
        View view = this.getChildAt(index);
        ViewHolder holder = this.getChildViewHolder(view);
        this.computeTapRegions(this.mTapRegions);
        if (rawY > this.mTapRegions[0] && rawY < this.mTapRegions[1]) {
            if (this.mClickListener != null && this.isEnabled()) {
                this.mClickListener.onClick(holder);
            }
            return true;
        }
        if (index > 0 && rawY <= this.mTapRegions[0]) {
            this.animateToMiddle(index - 1, index);
            return true;
        }
        if (index < this.getChildCount() - 1 && rawY >= this.mTapRegions[1]) {
            this.animateToMiddle(index + 1, index);
            return true;
        }
        if (index == 0 && rawY <= this.mTapRegions[0] && this.mClickListener != null && this.isEnabled()) {
            this.mClickListener.onTopEmptyRegionClick();
            return true;
        }
        return false;
    }

    private void animateToMiddle(int newCenterIndex, int oldCenterIndex) {
        if (newCenterIndex == oldCenterIndex) {
            throw new IllegalArgumentException("newCenterIndex must be different from oldCenterIndex");
        }
        ArrayList<Animator> animators = new ArrayList<Animator>();
        View child = this.getChildAt(newCenterIndex);
        int scrollToMiddle = this.getCentralViewTop() - child.getTop();
        this.startScrollAnimation(animators, scrollToMiddle, 150L);
    }

    private void startScrollAnimation(List<Animator> animators, int scroll, long duration) {
        this.startScrollAnimation(animators, scroll, duration, 0L);
    }

    private void startScrollAnimation(List<Animator> animators, int scroll, long duration, long delay) {
        this.startScrollAnimation(animators, scroll, duration, delay, null);
    }

    private void startScrollAnimation(int scroll, long duration, long delay, Animator.AnimatorListener listener) {
        this.startScrollAnimation(null, scroll, duration, delay, listener);
    }

    private void startScrollAnimation(List<Animator> animators, int scroll, long duration, long delay, Animator.AnimatorListener listener) {
        if (this.mScrollAnimator != null) {
            this.mScrollAnimator.cancel();
        }
        this.mLastScrollChange = 0;
        ObjectAnimator scrollAnimator = ObjectAnimator.ofInt((Object)((Object)this), (Property)this.mSetScrollVerticallyProperty, (int[])new int[]{0, -scroll});
        if (animators != null) {
            animators.add((Animator)scrollAnimator);
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.playTogether(animators);
            this.mScrollAnimator = animatorSet;
        } else {
            this.mScrollAnimator = scrollAnimator;
        }
        this.mScrollAnimator.setDuration(duration);
        if (listener != null) {
            this.mScrollAnimator.addListener(listener);
        }
        if (delay > 0L) {
            this.mScrollAnimator.setStartDelay(delay);
        }
        this.mScrollAnimator.start();
    }

    public boolean fling(int velocityX, int velocityY) {
        if (this.getChildCount() == 0) {
            return false;
        }
        int index = this.findCenterViewIndex();
        View child = this.getChildAt(index);
        int currentPosition = this.getChildPosition(child);
        if (currentPosition == 0 && velocityY < 0 || currentPosition == this.getAdapter().getItemCount() - 1 && velocityY > 0) {
            return super.fling(velocityX, velocityY);
        }
        if (Math.abs(velocityY) < this.mMinFlingVelocity) {
            return false;
        }
        velocityY = Math.max(Math.min(velocityY, this.mMaxFlingVelocity), -this.mMaxFlingVelocity);
        if (this.mScroller == null) {
            this.mScroller = new Scroller(this.getContext(), null, true);
        }
        this.mScroller.fling(0, 0, 0, velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        int finalY = this.mScroller.getFinalY();
        int delta = finalY / (this.getPaddingTop() + this.getAdjustedHeight() / 2);
        if (delta == 0) {
            delta = velocityY > 0 ? 1 : -1;
        }
        int finalPosition = Math.max(0, Math.min(this.getAdapter().getItemCount() - 1, currentPosition + delta));
        this.smoothScrollToPosition(finalPosition);
        return true;
    }

    public ViewHolder getChildViewHolder(View child) {
        return (ViewHolder)super.getChildViewHolder(child);
    }

    public void setClickListener(ClickListener clickListener) {
        this.mClickListener = clickListener;
    }

    public void setOverScrollListener(OnOverScrollListener listener) {
        this.mOverScrollListener = listener;
    }

    private int findCenterViewIndex() {
        int count = this.getChildCount();
        int index = -1;
        int closest = Integer.MAX_VALUE;
        int centerY = WearableListView.getCenterYPos((View)this);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int childCenterY = this.getTop() + WearableListView.getCenterYPos(child);
            int distance = Math.abs(centerY - childCenterY);
            if (distance >= closest) continue;
            closest = distance;
            index = i;
        }
        if (index == -1) {
            throw new IllegalStateException("Can't find central view.");
        }
        return index;
    }

    private static int getCenterYPos(View v) {
        return v.getTop() + v.getPaddingTop() + WearableListView.getAdjustedHeight(v) / 2;
    }

    private void handleTouchUp(MotionEvent event, int scrollState) {
        if (this.mCanClick && event != null && this.checkForTap(event)) {
            this.mPressedHandler.postDelayed(this.mReleasedRunnable, (long)ViewConfiguration.getTapTimeout());
            return;
        }
        if (scrollState != 0) {
            return;
        }
        if (this.isOverScrolling()) {
            this.mOverScrollListener.onOverScroll();
        } else {
            this.animateToCenter();
        }
    }

    private boolean isOverScrolling() {
        return this.getChildCount() > 0 && this.mStartFirstTop <= (float)this.getCentralViewTop() && this.getChildAt(0).getTop() >= this.getTopViewMaxTop() && this.mOverScrollListener != null;
    }

    private int getTopViewMaxTop() {
        return this.getHeight() / 2;
    }

    private int getItemHeight() {
        return this.getAdjustedHeight() / 3;
    }

    private int getCentralViewTop() {
        return this.getPaddingTop() + this.getItemHeight();
    }

    public void animateToCenter() {
        int index = this.findCenterViewIndex();
        View child = this.getChildAt(index);
        int scrollToMiddle = this.getCentralViewTop() - child.getTop();
        this.startScrollAnimation(scrollToMiddle, 150L, 0L, new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                if (!this.wasCanceled()) {
                    WearableListView.this.mCanClick = true;
                }
            }
        });
    }

    public void animateToInitialPosition(final Runnable endAction) {
        View child = this.getChildAt(0);
        int scrollToMiddle = this.getCentralViewTop() + this.mInitialOffset - child.getTop();
        this.startScrollAnimation(scrollToMiddle, 150L, 0L, new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                if (endAction != null) {
                    endAction.run();
                }
            }
        });
    }

    private void handleTouchDown(MotionEvent event) {
        if (this.mCanClick) {
            View view;
            this.mTapPositionX = (int)event.getX();
            this.mTapPositionY = (int)event.getY();
            float rawY = event.getRawY();
            this.computeTapRegions(this.mTapRegions);
            if (rawY > this.mTapRegions[0] && rawY < this.mTapRegions[1] && (view = this.getChildAt(this.findCenterViewIndex())) instanceof OnCenterProximityListener) {
                this.mPressedHandler.removeCallbacks(this.mReleasedRunnable);
                this.mPressedHandler.postDelayed(this.mPressedRunnable, (long)ViewConfiguration.getTapTimeout());
            }
        }
    }

    private void setScrollVertically(int scroll) {
        this.scrollBy(0, scroll - this.mLastScrollChange);
        this.mLastScrollChange = scroll;
    }

    private void notifyChildrenAboutProximity(boolean animate) {
        int count = this.getChildCount();
        int index = this.findCenterViewIndex();
        for (int i = 0; i < count; ++i) {
            View view = this.getChildAt(i);
            ViewHolder holder = this.getChildViewHolder(view);
            holder.onCenterProximity(i == index, animate);
        }
        int position = this.getChildViewHolder(this.getChildAt(index)).getPosition();
        if (position != this.mPreviousCentral) {
            for (OnScrollListener listener : this.mOnScrollListeners) {
                listener.onCentralPositionChanged(position);
            }
            this.mPreviousCentral = position;
        }
    }

    private int getAdjustedHeight() {
        return WearableListView.getAdjustedHeight((View)this);
    }

    private static int getAdjustedHeight(View v) {
        return v.getHeight() - v.getPaddingBottom() - v.getPaddingTop();
    }

    private void computeTapRegions(float[] tapRegions) {
        this.mLocation[1] = 0;
        this.mLocation[0] = 0;
        this.getLocationOnScreen(this.mLocation);
        int mScreenTop = this.mLocation[1];
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        tapRegions[0] = (float)mScreenTop + (float)(metrics.heightPixels - mScreenTop) * 0.33f;
        tapRegions[1] = (float)mScreenTop + (float)(metrics.heightPixels - mScreenTop) * 0.66999996f;
    }

    private class SetScrollVerticallyProperty
    extends Property<WearableListView, Integer> {
        public SetScrollVerticallyProperty() {
            super(Integer.class, "scrollVertically");
        }

        public Integer get(WearableListView wearableListView) {
            return wearableListView.mLastScrollChange;
        }

        public void set(WearableListView wearableListView, Integer value) {
            wearableListView.setScrollVertically(value);
        }
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ViewHolder(View itemView) {
            super(itemView);
        }

        protected void onCenterProximity(boolean isCentralItem, boolean animate) {
            if (!(this.itemView instanceof OnCenterProximityListener)) {
                return;
            }
            OnCenterProximityListener item = (OnCenterProximityListener)this.itemView;
            if (isCentralItem) {
                item.onCenterPosition(animate);
            } else {
                item.onNonCenterPosition(animate);
            }
        }
    }

    private static class SmoothScroller
    extends LinearSmoothScroller {
        private static final float MILLISECONDS_PER_INCH = 100.0f;
        private final LayoutManager mLayoutManager;

        public SmoothScroller(Context context, LayoutManager manager) {
            super(context);
            this.mLayoutManager = manager;
        }

        protected void onStart() {
            super.onStart();
        }

        protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
            return 100.0f / (float)displayMetrics.densityDpi;
        }

        public int calculateDtToFit(int viewStart, int viewEnd, int boxStart, int boxEnd, int snapPreference) {
            return (boxStart + boxEnd) / 2 - (viewStart + viewEnd) / 2;
        }

        public PointF computeScrollVectorForPosition(int targetPosition) {
            if (targetPosition < this.mLayoutManager.getFirstPosition()) {
                return new PointF(0.0f, -1.0f);
            }
            return new PointF(0.0f, 1.0f);
        }
    }

    public static abstract class Adapter
    extends RecyclerView.Adapter<ViewHolder> {
    }

    public static interface OnScrollListener {
        public void onScroll(int var1);

        public void onAbsoluteScrollChange(int var1);

        public void onScrollStateChanged(int var1);

        public void onCentralPositionChanged(int var1);
    }

    public static interface OnOverScrollListener {
        public void onOverScroll();
    }

    public static interface ClickListener {
        public void onClick(ViewHolder var1);

        public void onTopEmptyRegionClick();
    }

    public static interface OnCenterProximityListener {
        public void onCenterPosition(boolean var1);

        public void onNonCenterPosition(boolean var1);
    }

    private class LayoutManager
    extends RecyclerView.LayoutManager {
        private int mFirstPosition;
        private boolean mPushFirstHigher;
        private int mAbsoluteScroll;
        private boolean mUseOldViewTop = true;

        private LayoutManager() {
        }

        public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
            int parentBottom = this.getHeight() - this.getPaddingBottom();
            View oldTopView = this.getChildCount() > 0 ? this.getChildAt(0) : null;
            boolean hasOldTopView = oldTopView != null && this.mUseOldViewTop;
            int oldTop = WearableListView.this.getCentralViewTop() + WearableListView.this.mInitialOffset;
            if (this.mPushFirstHigher) {
                oldTop -= WearableListView.this.getAdjustedHeight() / 3;
            }
            if (hasOldTopView) {
                oldTop = oldTopView.getTop();
            }
            this.mUseOldViewTop = true;
            this.detachAndScrapAttachedViews(recycler);
            int top = oldTop;
            int left = this.getPaddingLeft();
            int right = this.getWidth() - this.getPaddingRight();
            int count = state.getItemCount();
            int i = 0;
            while (this.getFirstPosition() + i < count && top < parentBottom) {
                View v = recycler.getViewForPosition(this.getFirstPosition() + i);
                this.addView(v, i);
                this.measureView(v);
                int bottom = top + WearableListView.this.getItemHeight();
                v.layout(left, top, right, bottom);
                ++i;
                top = bottom;
            }
            if (this.getChildCount() > 0) {
                WearableListView.this.notifyChildrenAboutProximity(false);
            }
            if (!hasOldTopView) {
                this.setAbsoluteScroll(((this.mPushFirstHigher ? 1 : 0) + this.getFirstPosition()) * WearableListView.this.getItemHeight());
            }
        }

        private void setAbsoluteScroll(int absoluteScroll) {
            this.mAbsoluteScroll = absoluteScroll;
            for (OnScrollListener listener : WearableListView.this.mOnScrollListeners) {
                listener.onAbsoluteScrollChange(this.mAbsoluteScroll);
            }
        }

        private void measureView(View v) {
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)v.getLayoutParams();
            int widthSpec = LayoutManager.getChildMeasureSpec((int)this.getWidth(), (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin), (int)lp.width, (boolean)this.canScrollHorizontally());
            int heightSpec = LayoutManager.getChildMeasureSpec((int)this.getHeight(), (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin), (int)(this.getHeight() / 3), (boolean)this.canScrollVertically());
            v.measure(widthSpec, heightSpec);
        }

        public RecyclerView.LayoutParams generateDefaultLayoutParams() {
            return new RecyclerView.LayoutParams(-1, -2);
        }

        public boolean canScrollVertically() {
            return true;
        }

        public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
            if (this.getChildCount() == 0) {
                return 0;
            }
            int scrolled = 0;
            int left = this.getPaddingLeft();
            int right = this.getWidth() - this.getPaddingRight();
            if (dy < 0) {
                while (scrolled > dy) {
                    int scrollBy;
                    View topView = this.getChildAt(0);
                    if (this.getFirstPosition() > 0) {
                        int hangingTop = Math.max(-topView.getTop(), 0);
                        scrollBy = Math.min(scrolled - dy, hangingTop);
                        this.offsetChildrenVertical(scrollBy);
                        if (this.getFirstPosition() > 0 && (scrolled -= scrollBy) > dy) {
                            --this.mFirstPosition;
                            View v = recycler.getViewForPosition(this.getFirstPosition());
                            this.addView(v, 0);
                            this.measureView(v);
                            int bottom = topView.getTop();
                            int top = bottom - WearableListView.this.getItemHeight();
                            v.layout(left, top, right, bottom);
                            continue;
                        }
                    } else {
                        this.mPushFirstHigher = false;
                        int maxScroll = WearableListView.this.mOverScrollListener != null ? this.getHeight() : WearableListView.this.getTopViewMaxTop();
                        scrollBy = Math.min(-dy, maxScroll - topView.getTop());
                        scrolled -= scrollBy;
                        this.offsetChildrenVertical(scrollBy);
                    }
                    break;
                }
            } else if (dy > 0) {
                int parentHeight = this.getHeight();
                while (scrolled < dy) {
                    View bottomView = this.getChildAt(this.getChildCount() - 1);
                    if (state.getItemCount() > this.mFirstPosition + this.getChildCount()) {
                        int hangingBottom = Math.max(bottomView.getBottom() - parentHeight, 0);
                        int scrollBy = -Math.min(dy - scrolled, hangingBottom);
                        this.offsetChildrenVertical(scrollBy);
                        if ((scrolled -= scrollBy) < dy) {
                            View v = recycler.getViewForPosition(this.mFirstPosition + this.getChildCount());
                            int top = this.getChildAt(this.getChildCount() - 1).getBottom();
                            this.addView(v);
                            this.measureView(v);
                            int bottom = top + WearableListView.this.getItemHeight();
                            v.layout(left, top, right, bottom);
                            continue;
                        }
                    } else {
                        int scrollBy = Math.max(-dy, this.getHeight() / 2 - bottomView.getBottom());
                        scrolled -= scrollBy;
                        this.offsetChildrenVertical(scrollBy);
                    }
                    break;
                }
            }
            this.recycleViewsOutOfBounds(recycler);
            WearableListView.this.notifyChildrenAboutProximity(true);
            WearableListView.this.onScroll(scrolled);
            this.setAbsoluteScroll(this.mAbsoluteScroll + scrolled);
            return scrolled;
        }

        public void scrollToPosition(int position) {
            this.mUseOldViewTop = false;
            if (position > 0) {
                this.mFirstPosition = position - 1;
                this.mPushFirstHigher = true;
            } else {
                this.mFirstPosition = position;
                this.mPushFirstHigher = false;
            }
        }

        public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
            SmoothScroller linearSmoothScroller = new SmoothScroller(recyclerView.getContext(), this);
            linearSmoothScroller.setTargetPosition(position);
            this.startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
        }

        private void recycleViewsOutOfBounds(RecyclerView.Recycler recycler) {
            int i;
            int childCount = this.getChildCount();
            int parentWidth = this.getWidth();
            int parentHeight = this.getHeight();
            boolean foundFirst = false;
            int first = 0;
            int last = 0;
            for (i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                if (!v.hasFocus() && (v.getRight() < 0 || v.getLeft() > parentWidth || v.getBottom() < 0 || v.getTop() > parentHeight)) continue;
                if (!foundFirst) {
                    first = i;
                    foundFirst = true;
                }
                last = i;
            }
            for (i = childCount - 1; i > last; --i) {
                this.removeAndRecycleViewAt(i, recycler);
            }
            for (i = first - 1; i >= 0; --i) {
                this.removeAndRecycleViewAt(i, recycler);
            }
            if (this.getChildCount() == 0) {
                this.mFirstPosition = 0;
            } else if (first > 0) {
                this.mPushFirstHigher = true;
                this.mFirstPosition += first;
            }
        }

        public int getFirstPosition() {
            return this.mFirstPosition;
        }

        public void onAdapterChanged(RecyclerView.Adapter oldAdapter, RecyclerView.Adapter newAdapter) {
            this.removeAllViews();
        }
    }
}

