/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.wearable.R;
import android.support.wearable.view.Func;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.FrameLayout;

@TargetApi(value=20)
public class WatchViewStub
extends FrameLayout {
    private static final String TAG = "WatchViewStub";
    private boolean mLastKnownRound;
    private int mRectLayout;
    private int mRoundLayout;
    private boolean mInflateNeeded;
    private boolean mWindowInsetsApplied;
    private boolean mWindowOverscan;
    private OnLayoutInflatedListener mListener;

    public WatchViewStub(Context context) {
        this(context, null);
    }

    public WatchViewStub(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WatchViewStub(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WatchViewStub, 0, 0);
        this.mRectLayout = a.getResourceId(R.styleable.WatchViewStub_rectLayout, 0);
        this.mRoundLayout = a.getResourceId(R.styleable.WatchViewStub_roundLayout, 0);
        this.mInflateNeeded = true;
        a.recycle();
    }

    public void setOnLayoutInflatedListener(OnLayoutInflatedListener listener) {
        this.mListener = listener;
    }

    public void setRectLayout(int resId) {
        if (resId != this.mRectLayout) {
            this.mRectLayout = resId;
            if (!this.mLastKnownRound) {
                this.inflate();
                this.mInflateNeeded = false;
            }
        }
    }

    public void setRoundLayout(int resId) {
        if (resId != this.mRoundLayout) {
            this.mRoundLayout = resId;
            if (this.mLastKnownRound) {
                this.inflate();
                this.mInflateNeeded = false;
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mWindowOverscan = Func.getWindowOverscan((View)this);
        this.mWindowInsetsApplied = false;
        this.requestApplyInsets();
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mInflateNeeded && !this.mWindowOverscan) {
            this.inflate();
            this.mInflateNeeded = false;
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        this.mWindowInsetsApplied = true;
        boolean round = insets.isRound();
        if (round != this.mLastKnownRound) {
            this.mLastKnownRound = round;
            this.mInflateNeeded = true;
        }
        if (this.mInflateNeeded) {
            this.inflate();
            this.mInflateNeeded = false;
        }
        return insets;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mWindowOverscan && !this.mWindowInsetsApplied) {
            Log.w((String)TAG, (String)"onApplyWindowInsets was not called. WatchViewStub should be the the root of your layout. If an OnApplyWindowInsetsListener was attached to this view, it must forward the insets on by calling view.onApplyWindowInsets.");
        }
        super.onLayout(changed, left, top, right, bottom);
    }

    public void inflate() {
        this.removeAllViews();
        if (this.mRoundLayout == 0 && !this.isInEditMode()) {
            throw new IllegalStateException("You must supply a roundLayout resource");
        }
        if (this.mRectLayout == 0 && !this.isInEditMode()) {
            throw new IllegalStateException("You must supply a rectLayout resource");
        }
        int layout2 = this.mLastKnownRound ? this.mRoundLayout : this.mRectLayout;
        LayoutInflater.from((Context)this.getContext()).inflate(layout2, (ViewGroup)this);
        if (this.mListener != null) {
            this.mListener.onLayoutInflated(this);
        }
    }

    public static interface OnLayoutInflatedListener {
        public void onLayoutInflated(WatchViewStub var1);
    }
}

