/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.annotation.TargetApi;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;

@TargetApi(value=20)
public abstract class GridPagerAdapter {
    public static final Drawable BACKGROUND_NONE = new NoOpDrawable();
    public static final int OPTION_DISABLE_PARALLAX = 1;
    public static final int PAGE_DEFAULT_OPTIONS = 0;
    public static final Point POSITION_NONE = new Point(-1, -1);
    public static final Point POSITION_UNCHANGED = new Point(-2, -2);
    private DataSetObservable mObservable = new DataSetObservable();
    private OnBackgroundChangeListener mOnBackgroundChangeListener;

    public abstract int getRowCount();

    public abstract int getColumnCount(int var1);

    public int getCurrentColumnForRow(int row, int currentColumn) {
        return 0;
    }

    protected void setCurrentColumnForRow(int row, int currentColumn) {
    }

    protected void startUpdate(ViewGroup container) {
    }

    protected abstract Object instantiateItem(ViewGroup var1, int var2, int var3);

    protected abstract void destroyItem(ViewGroup var1, int var2, int var3, Object var4);

    protected void finishUpdate(ViewGroup container) {
    }

    public abstract boolean isViewFromObject(View var1, Object var2);

    public Drawable getBackgroundForRow(int row) {
        return BACKGROUND_NONE;
    }

    public Drawable getBackgroundForPage(int row, int column) {
        return BACKGROUND_NONE;
    }

    public int getOptionsForPage(int row, int column) {
        return 0;
    }

    public void notifyPageBackgroundChanged(int row, int column) {
        if (this.mOnBackgroundChangeListener != null) {
            this.mOnBackgroundChangeListener.onPageBackgroundChanged(row, column);
        }
    }

    public void notifyRowBackgroundChanged(int row) {
        if (this.mOnBackgroundChangeListener != null) {
            this.mOnBackgroundChangeListener.onRowBackgroundChanged(row);
        }
    }

    void setOnBackgroundChangeListener(OnBackgroundChangeListener listener) {
        this.mOnBackgroundChangeListener = listener;
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mObservable.registerObserver((Object)observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mObservable.unregisterObserver((Object)observer);
    }

    public void notifyDataSetChanged() {
        this.mObservable.notifyChanged();
    }

    public Point getItemPosition(Object object) {
        return POSITION_NONE;
    }

    public Parcelable saveState() {
        return null;
    }

    public void restoreState(Parcelable savedState, ClassLoader classLoader) {
    }

    private static final class NoOpDrawable
    extends Drawable {
        private NoOpDrawable() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return 0;
        }
    }

    static interface OnBackgroundChangeListener {
        public void onPageBackgroundChanged(int var1, int var2);

        public void onRowBackgroundChanged(int var1);
    }
}

