/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.animation.Animator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.support.wearable.R;
import android.support.wearable.view.GridPagerAdapter;
import android.support.wearable.view.GridViewPager;
import android.support.wearable.view.SimpleAnimatorListener;
import android.util.AttributeSet;
import android.view.View;
import java.util.concurrent.TimeUnit;

@TargetApi(value=20)
public class DotsPageIndicator
extends View
implements GridViewPager.OnPageChangeListener,
GridViewPager.OnAdapterChangeListener {
    private int mDotSpacing;
    private float mDotRadius;
    private float mDotRadiusSelected;
    private int mDotColor;
    private int mDotColorSelected;
    private boolean mDotFadeWhenIdle;
    private int mDotFadeOutDelay;
    private int mDotFadeOutDuration;
    private int mDotFadeInDuration;
    private float mDotShadowDx;
    private float mDotShadowDy;
    private float mDotShadowRadius;
    private int mDotShadowColor;
    private GridPagerAdapter mAdapter;
    private int mColumnCount;
    private int mSelectedColumn;
    private int mSelectedRow;
    private int mCurrentState;
    private final Paint mDotPaint;
    private final Paint mDotPaintShadow;
    private final Paint mDotPaintSelected;
    private final Paint mDotPaintShadowSelected;
    private boolean mVisible;
    private GridViewPager mPager;
    private GridViewPager.OnPageChangeListener mPageChangeListener;
    private GridViewPager.OnAdapterChangeListener mAdapterChangeListener;

    public DotsPageIndicator(Context context) {
        this(context, null);
    }

    public DotsPageIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DotsPageIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.DotsPageIndicator, 0, R.style.DotsPageIndicatorStyle);
        this.mDotSpacing = a.getDimensionPixelOffset(R.styleable.DotsPageIndicator_dotSpacing, 0);
        this.mDotRadius = a.getDimension(R.styleable.DotsPageIndicator_dotRadius, 0.0f);
        this.mDotRadiusSelected = a.getDimension(R.styleable.DotsPageIndicator_dotRadiusSelected, 0.0f);
        this.mDotColor = a.getColor(R.styleable.DotsPageIndicator_dotColor, 0);
        this.mDotColorSelected = a.getColor(R.styleable.DotsPageIndicator_dotColorSelected, 0);
        this.mDotFadeOutDelay = a.getInt(R.styleable.DotsPageIndicator_dotFadeOutDelay, 0);
        this.mDotFadeOutDuration = a.getInt(R.styleable.DotsPageIndicator_dotFadeOutDuration, 0);
        this.mDotFadeInDuration = a.getInt(R.styleable.DotsPageIndicator_dotFadeInDuration, 0);
        this.mDotFadeWhenIdle = a.getBoolean(R.styleable.DotsPageIndicator_dotFadeWhenIdle, false);
        this.mDotShadowDx = a.getDimension(R.styleable.DotsPageIndicator_dotShadowDx, 0.0f);
        this.mDotShadowDy = a.getDimension(R.styleable.DotsPageIndicator_dotShadowDy, 0.0f);
        this.mDotShadowRadius = a.getDimension(R.styleable.DotsPageIndicator_dotShadowRadius, 0.0f);
        this.mDotShadowColor = a.getColor(R.styleable.DotsPageIndicator_dotShadowColor, 0);
        a.recycle();
        this.mDotPaint = new Paint(1);
        this.mDotPaint.setColor(this.mDotColor);
        this.mDotPaint.setStyle(Paint.Style.FILL);
        this.mDotPaintSelected = new Paint(1);
        this.mDotPaintSelected.setColor(this.mDotColorSelected);
        this.mDotPaintSelected.setStyle(Paint.Style.FILL);
        this.mDotPaintShadow = new Paint(1);
        this.mDotPaintShadowSelected = new Paint(1);
        this.mCurrentState = 0;
        if (this.isInEditMode()) {
            this.mColumnCount = 5;
            this.mSelectedColumn = 2;
            this.mDotFadeWhenIdle = false;
        }
        if (this.mDotFadeWhenIdle) {
            this.mVisible = false;
            this.animate().alpha(0.0f).setStartDelay(2000L).setDuration((long)this.mDotFadeOutDuration).start();
        }
        this.updateShadows();
    }

    private void updateShadows() {
        this.updateDotPaint(this.mDotPaint, this.mDotPaintShadow, this.mDotRadius, this.mDotShadowRadius, this.mDotColor, this.mDotShadowColor);
        this.updateDotPaint(this.mDotPaintSelected, this.mDotPaintShadowSelected, this.mDotRadiusSelected, this.mDotShadowRadius, this.mDotColor, this.mDotShadowColor);
    }

    private void updateDotPaint(Paint dotPaint, Paint shadowPaint, float baseRadius, float shadowRadius, int color, int shadowColor) {
        float radius = baseRadius + shadowRadius;
        float shadowStart = baseRadius / radius;
        RadialGradient gradient = new RadialGradient(0.0f, 0.0f, radius, new int[]{shadowColor, shadowColor, 0}, new float[]{0.0f, shadowStart, 1.0f}, Shader.TileMode.CLAMP);
        shadowPaint.setShader((Shader)gradient);
        dotPaint.setColor(color);
        dotPaint.setStyle(Paint.Style.FILL);
    }

    public void setPager(GridViewPager pager) {
        if (this.mPager != pager) {
            if (this.mPager != null) {
                this.mPager.setOnPageChangeListener(null);
                this.mPager.setOnAdapterChangeListener(null);
                this.mPager = null;
            }
            this.mPager = pager;
            if (this.mPager != null) {
                this.mPager.setOnPageChangeListener(this);
                this.mPager.setOnAdapterChangeListener(this);
                this.mAdapter = this.mPager.getAdapter();
            }
        }
        if (this.mAdapter != null && this.mAdapter.getRowCount() > 0) {
            this.rowChanged(0, 0);
        }
    }

    public void setOnPageChangeListener(GridViewPager.OnPageChangeListener listener) {
        this.mPageChangeListener = listener;
    }

    public void setOnAdapterChangeListener(GridViewPager.OnAdapterChangeListener listener) {
        this.mAdapterChangeListener = listener;
    }

    public float getDotSpacing() {
        return this.mDotSpacing;
    }

    public void setDotSpacing(int spacing) {
        if (this.mDotSpacing != spacing) {
            this.mDotSpacing = spacing;
            this.requestLayout();
        }
    }

    public float getDotRadius() {
        return this.mDotRadius;
    }

    public void setDotRadius(int radius) {
        if (this.mDotRadius != (float)radius) {
            this.mDotRadius = radius;
            this.updateShadows();
            this.invalidate();
        }
    }

    public float getDotRadiusSelected() {
        return this.mDotRadiusSelected;
    }

    public void setDotRadiusSelected(int radius) {
        if (this.mDotRadiusSelected != (float)radius) {
            this.mDotRadiusSelected = radius;
            this.updateShadows();
            this.invalidate();
        }
    }

    public int getDotColor() {
        return this.mDotColor;
    }

    public void setDotColor(int color) {
        if (this.mDotColor != color) {
            this.mDotColor = color;
            this.invalidate();
        }
    }

    public int getDotColorSelected() {
        return this.mDotColorSelected;
    }

    public void setDotColorSelected(int color) {
        if (this.mDotColorSelected != color) {
            this.mDotColorSelected = color;
            this.invalidate();
        }
    }

    public boolean getDotFadeWhenIdle() {
        return this.mDotFadeWhenIdle;
    }

    public void setDotFadeWhenIdle(boolean fade) {
        this.mDotFadeWhenIdle = fade;
        if (!fade && !this.mVisible) {
            this.fadeIn();
        }
    }

    public int getDotFadeOutDuration() {
        return this.mDotFadeOutDuration;
    }

    public void setDotFadeOutDuration(int duration, TimeUnit unit) {
        this.mDotFadeOutDuration = (int)TimeUnit.MILLISECONDS.convert(duration, unit);
    }

    public int getDotFadeInDuration() {
        return this.mDotFadeInDuration;
    }

    public void setDotFadeInDuration(int duration, TimeUnit unit) {
        this.mDotFadeInDuration = (int)TimeUnit.MILLISECONDS.convert(duration, unit);
    }

    public int getDotFadeOutDelay() {
        return this.mDotFadeOutDelay;
    }

    public void setDotFadeOutDelay(int delay) {
        this.mDotFadeOutDelay = delay;
    }

    public float getDotShadowRadius() {
        return this.mDotShadowRadius;
    }

    public void setDotShadowRadius(float radius) {
        if (this.mDotShadowRadius != radius) {
            this.mDotShadowRadius = radius;
            this.updateShadows();
            this.invalidate();
        }
    }

    public float getDotShadowDx() {
        return this.mDotShadowDx;
    }

    public void setDotShadowDx(float dx) {
        this.mDotShadowDx = dx;
        this.invalidate();
    }

    public float getDotShadowDy() {
        return this.mDotShadowDy;
    }

    public void setDotShadowDy(float dy) {
        this.mDotShadowDy = dy;
        this.invalidate();
    }

    public int getDotShadowColor() {
        return this.mDotShadowColor;
    }

    public void setDotShadowColor(int color) {
        this.mDotShadowColor = color;
        this.updateShadows();
        this.invalidate();
    }

    private void columnChanged(int column) {
        this.mSelectedColumn = column;
        this.invalidate();
    }

    private void rowChanged(int row, int column) {
        int count = this.mAdapter.getColumnCount(row);
        if (count != this.mColumnCount) {
            this.mColumnCount = count;
            this.mSelectedColumn = column;
            this.requestLayout();
        } else if (column != this.mSelectedColumn) {
            this.mSelectedColumn = column;
            this.invalidate();
        }
    }

    private void fadeIn() {
        this.mVisible = true;
        this.animate().cancel();
        this.animate().alpha(1.0f).setStartDelay(0L).setDuration((long)this.mDotFadeInDuration).start();
    }

    private void fadeOut() {
        this.mVisible = false;
        this.animate().cancel();
        this.animate().alpha(0.0f).setStartDelay(0L).setDuration((long)this.mDotFadeOutDuration).start();
    }

    private void fadeInOut() {
        this.mVisible = true;
        this.animate().cancel();
        this.animate().alpha(1.0f).setStartDelay(0L).setDuration((long)this.mDotFadeInDuration).setListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationComplete(Animator animator) {
                DotsPageIndicator.this.mVisible = false;
                DotsPageIndicator.this.animate().alpha(0.0f).setListener(null).setStartDelay((long)DotsPageIndicator.this.mDotFadeOutDelay).setDuration((long)DotsPageIndicator.this.mDotFadeOutDuration).start();
            }
        }).start();
    }

    @Override
    public void onPageScrollStateChanged(int state) {
        if (this.mCurrentState != state) {
            this.mCurrentState = state;
            if (this.mDotFadeWhenIdle && state == 2) {
                if (this.mVisible) {
                    this.fadeOut();
                } else {
                    this.fadeInOut();
                }
            }
        }
        if (this.mPageChangeListener != null) {
            this.mPageChangeListener.onPageScrollStateChanged(state);
        }
    }

    @Override
    public void onPageScrolled(int row, int column, float rowOffset, float columnOffset, int rowOffsetPixels, int columnOffsetPixels) {
        if (this.mDotFadeWhenIdle) {
            if (columnOffset != 0.0f) {
                if (!this.mVisible) {
                    this.fadeIn();
                }
            } else if (this.mCurrentState == 1 && this.mVisible) {
                this.fadeOut();
            }
        }
        if (this.mPageChangeListener != null) {
            this.mPageChangeListener.onPageScrolled(row, column, rowOffset, columnOffset, rowOffsetPixels, columnOffsetPixels);
        }
    }

    @Override
    public void onPageSelected(int row, int column) {
        if (row != this.mSelectedRow) {
            this.rowChanged(row, column);
        } else if (column != this.mSelectedColumn) {
            this.columnChanged(column);
        }
        if (this.mPageChangeListener != null) {
            this.mPageChangeListener.onPageSelected(row, column);
        }
    }

    @Override
    public void onAdapterChanged(GridPagerAdapter oldAdapter, GridPagerAdapter newAdapter) {
        this.mAdapter = newAdapter;
        if (this.mAdapter != null) {
            this.rowChanged(0, 0);
            this.fadeInOut();
        }
        if (this.mAdapterChangeListener != null) {
            this.mAdapterChangeListener.onAdapterChanged(oldAdapter, newAdapter);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int contentWidth = 0;
        int totalWidth = 0;
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) == 0x40000000) {
            totalWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            contentWidth = totalWidth - this.getPaddingLeft() - this.getPaddingRight();
        } else {
            contentWidth = this.mColumnCount * this.mDotSpacing;
            totalWidth = contentWidth + this.getPaddingLeft() + this.getPaddingRight();
        }
        int contentHeight = 0;
        int totalHeight = 0;
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0x40000000) {
            totalHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            contentHeight = totalHeight - this.getPaddingTop() - this.getPaddingBottom();
        } else {
            float maxRadius = Math.max(this.mDotRadius + this.mDotShadowRadius, this.mDotRadiusSelected + this.mDotShadowRadius);
            contentHeight = (int)Math.ceil(maxRadius * 2.0f);
            contentHeight = (int)((float)contentHeight + this.mDotShadowDy);
            totalHeight = contentHeight + this.getPaddingTop() + this.getPaddingBottom();
        }
        this.setMeasuredDimension(DotsPageIndicator.resolveSizeAndState((int)totalWidth, (int)widthMeasureSpec, (int)0), DotsPageIndicator.resolveSizeAndState((int)totalHeight, (int)heightMeasureSpec, (int)0));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mColumnCount > 1) {
            float dotCenterLeft = (float)this.getPaddingLeft() + (float)this.mDotSpacing / 2.0f;
            float dotCenterTop = (float)this.getHeight() / 2.0f;
            canvas.save();
            canvas.translate(dotCenterLeft, dotCenterTop);
            for (int i = 0; i < this.mColumnCount; ++i) {
                float radius;
                if (i == this.mSelectedColumn) {
                    radius = this.mDotRadiusSelected + this.mDotShadowRadius;
                    canvas.drawCircle(this.mDotShadowDx, this.mDotShadowDy, radius, this.mDotPaintShadowSelected);
                    canvas.drawCircle(0.0f, 0.0f, this.mDotRadiusSelected, this.mDotPaint);
                } else {
                    radius = this.mDotRadius + this.mDotShadowRadius;
                    canvas.drawCircle(this.mDotShadowDx, this.mDotShadowDy, radius, this.mDotPaintShadow);
                    canvas.drawCircle(0.0f, 0.0f, this.mDotRadius, this.mDotPaint);
                }
                canvas.translate((float)this.mDotSpacing, 0.0f);
            }
            canvas.restore();
        }
    }

    @Override
    public void onDataSetChanged() {
        if (this.mAdapter.getRowCount() > 0) {
            this.rowChanged(0, 0);
        }
        if (this.mAdapterChangeListener != null) {
            this.mAdapterChangeListener.onDataSetChanged();
        }
    }
}

