/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.wearable.view.CardFrame;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.FrameLayout;

@TargetApi(value=20)
public class CardScrollView
extends FrameLayout {
    private static final String TAG = "CardScrollView";
    private static final boolean DEBUG = false;
    private static final int CARD_SHADOW_WIDTH_DP = 8;
    private CardFrame mCardFrame;
    private boolean mRoundDisplay;
    private final int mCardShadowWidth;

    public CardScrollView(Context context) {
        this(context, null);
    }

    public CardScrollView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.mCardShadowWidth = (int)(8.0f * this.getResources().getDisplayMetrics().density);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.requestApplyInsets();
    }

    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        boolean round = insets.isRound();
        if (this.mRoundDisplay != round) {
            this.mRoundDisplay = round;
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mCardFrame.getLayoutParams();
            lp.leftMargin = -this.mCardShadowWidth;
            lp.rightMargin = -this.mCardShadowWidth;
            lp.bottomMargin = -this.mCardShadowWidth;
            this.mCardFrame.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        if (insets.getSystemWindowInsetBottom() > 0) {
            int bottomInset = insets.getSystemWindowInsetBottom();
            ViewGroup.LayoutParams lp = this.getLayoutParams();
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                ((ViewGroup.MarginLayoutParams)lp).bottomMargin = bottomInset;
            }
        }
        if (this.mRoundDisplay && this.mCardFrame != null) {
            this.mCardFrame.onApplyWindowInsets(insets);
        }
        this.requestLayout();
        return insets;
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0 || !(child instanceof CardFrame)) {
            throw new IllegalStateException("CardScrollView may contain only a single CardFrame.");
        }
        super.addView(child, index, params);
        this.mCardFrame = (CardFrame)child;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() == 0 || !(this.getChildAt(0) instanceof CardFrame)) {
            Log.w((String)TAG, (String)"No CardFrame has been added!");
        }
    }

    private boolean hasCardFrame() {
        if (this.mCardFrame == null) {
            Log.w((String)TAG, (String)"No CardFrame has been added.");
            return false;
        }
        return true;
    }

    public void setExpansionEnabled(boolean enableExpansion) {
        boolean wasEnabled;
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("setExpansionEnabled: " + enableExpansion));
        }
        if (this.hasCardFrame() && enableExpansion != (wasEnabled = this.mCardFrame.isExpansionEnabled())) {
            this.mCardFrame.setExpansionEnabled(enableExpansion);
            if (!enableExpansion) {
                this.scrollTo(0, 0);
            }
        }
    }

    public boolean isExpansionEnabled() {
        if (this.hasCardFrame()) {
            return this.mCardFrame.isExpansionEnabled();
        }
        return false;
    }

    public void setExpansionDirection(int direction) {
        int curDirection;
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("setExpansionDirection: " + direction));
        }
        if (this.hasCardFrame() && direction != (curDirection = this.mCardFrame.getExpansionDirection())) {
            this.mCardFrame.setExpansionDirection(direction);
            if (direction == 1 && this.getScrollY() < 0) {
                this.scrollTo(0, 0);
            } else if (direction == -1 && this.getScrollY() > 0) {
                this.scrollTo(0, 0);
            }
            this.requestLayout();
        }
    }

    public float getExpansionFactor() {
        if (this.hasCardFrame()) {
            return this.mCardFrame.getExpansionFactor();
        }
        return 0.0f;
    }

    public void setExpansionFactor(float expansionFactor) {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("setExpansionFactor: " + expansionFactor));
        }
        if (this.hasCardFrame()) {
            this.mCardFrame.setExpansionFactor(expansionFactor);
        }
    }

    public int getExpansionDirection() {
        if (this.hasCardFrame()) {
            return this.mCardFrame.getExpansionDirection();
        }
        return 0;
    }

    public void setCardGravity(int gravity) {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("setCardGravity: " + gravity));
        }
        if (this.hasCardFrame()) {
            FrameLayout.LayoutParams existing = (FrameLayout.LayoutParams)this.mCardFrame.getLayoutParams();
            if (existing.gravity != (gravity &= 0x70)) {
                this.mCardFrame.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2, gravity));
                this.requestLayout();
            }
        }
    }

    public int getCardGravity() {
        if (this.hasCardFrame()) {
            FrameLayout.LayoutParams existing = (FrameLayout.LayoutParams)this.mCardFrame.getLayoutParams();
            return existing.gravity;
        }
        return 0;
    }

    public boolean canScrollHorizontally(int direction) {
        return false;
    }

    public int getAvailableScrollDelta(int direction) {
        if (!this.hasCardFrame()) {
            return 0;
        }
        int paddingHeight = this.getPaddingTop() + this.getPaddingBottom();
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mCardFrame.getLayoutParams();
        int marginHeight = lp.topMargin + lp.bottomMargin;
        int cardVerticalSpan = this.mCardFrame.getMeasuredHeight() + paddingHeight + marginHeight;
        if (cardVerticalSpan <= this.getMeasuredHeight()) {
            return 0;
        }
        int extra = cardVerticalSpan - this.getMeasuredHeight();
        int avail = 0;
        int sy = this.getScrollY();
        if (this.mCardFrame.getExpansionDirection() == 1) {
            if (sy >= 0) {
                if (direction < 0) {
                    avail = -sy;
                } else if (direction > 0) {
                    avail = Math.max(0, extra - sy);
                }
            }
        } else if (this.mCardFrame.getExpansionDirection() == -1 && sy <= 0) {
            if (direction > 0) {
                avail = -sy;
            } else if (direction < 0) {
                avail = -(extra + sy);
            }
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("getVerticalScrollableDistance: " + Math.max(0, avail)));
        }
        return avail;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mCardFrame != null) {
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mCardFrame.getLayoutParams();
            int paddingWidth = this.getPaddingLeft() + this.getPaddingRight();
            int paddingHeight = this.getPaddingTop() + this.getPaddingBottom();
            int availableHeight = View.MeasureSpec.getSize((int)heightMeasureSpec) - paddingHeight;
            int availableWidth = View.MeasureSpec.getSize((int)widthMeasureSpec) - paddingWidth;
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)(availableWidth -= lp.leftMargin + lp.rightMargin), (int)0x40000000);
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)(availableHeight -= lp.topMargin + lp.bottomMargin), (int)Integer.MIN_VALUE);
            this.mCardFrame.measure(widthSpec, heightSpec);
        }
        this.setMeasuredDimension(CardScrollView.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), CardScrollView.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mCardFrame != null) {
            int dir;
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mCardFrame.getLayoutParams();
            int cardHeight = this.mCardFrame.getMeasuredHeight();
            int cardWidth = this.mCardFrame.getMeasuredWidth();
            int parentHeight = bottom - top;
            boolean alignBottom = false;
            alignBottom = cardHeight <= parentHeight ? (lp.gravity & 0x70) == 80 : (dir = this.mCardFrame.getExpansionDirection()) == -1;
            int l = this.getPaddingLeft() + lp.leftMargin;
            int t = this.getPaddingTop() + lp.topMargin;
            int r = l + cardWidth;
            int b = t + cardHeight;
            if (alignBottom) {
                b = parentHeight - (this.getPaddingBottom() + lp.bottomMargin);
                t = b - cardHeight;
            }
            this.mCardFrame.layout(l, t, r, b);
        }
    }

    int roundAwayFromZero(float v) {
        return (int)(v < 0.0f ? Math.floor(v) : Math.ceil(v));
    }

    int roundTowardZero(float v) {
        return (int)(v > 0.0f ? Math.floor(v) : Math.ceil(v));
    }
}

