/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.activity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.graphics.drawable.AnimationDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.wearable.R;
import android.widget.ImageView;
import android.widget.TextView;

@TargetApi(value=20)
public class ConfirmationActivity
extends Activity {
    private static final String TAG = "ConfirmationActivity";
    public static final String EXTRA_MESSAGE = "message";
    public static final String EXTRA_ANIMATION_TYPE = "animation_type";
    public static final int SUCCESS_ANIMATION = 1;
    public static final int OPEN_ON_PHONE_ANIMATION = 2;
    public static final int FAILURE_ANIMATION = 3;
    private static final long SUCCESS_MESSAGE_DELAY_MS = 50L;
    private TextView mSuccessMessage;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.confirmation_activity_layout);
        this.mSuccessMessage = (TextView)this.findViewById(R.id.message);
        String message = null;
        int animationType = 1;
        if (this.getIntent() != null && this.getIntent().getExtras() != null) {
            message = this.getIntent().getStringExtra(EXTRA_MESSAGE);
            animationType = this.getIntent().getIntExtra(EXTRA_ANIMATION_TYPE, 1);
        }
        if (message != null) {
            this.mSuccessMessage.setText(message);
            ((TextView)this.findViewById(R.id.error_message)).setText((CharSequence)message);
        }
        boolean shouldRunAnimation = true;
        ImageView view = (ImageView)this.findViewById(R.id.animation);
        switch (animationType) {
            case 2: {
                view.setImageResource(R.drawable.go_to_phone_animation);
                break;
            }
            case 1: {
                view.setImageResource(R.drawable.confirmation_animation);
                break;
            }
            case 3: {
                shouldRunAnimation = false;
                this.findViewById(R.id.action_error).setVisibility(0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type of animation: " + animationType);
            }
        }
        if (shouldRunAnimation) {
            AnimationDrawable animation = (AnimationDrawable)view.getDrawable();
            this.findViewById(R.id.action_success).setVisibility(0);
            animation.start();
            final long duration = ConfirmationActivity.getAnimationDuration(animation);
            Handler handler = new Handler();
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConfirmationActivity.this.finish();
                    ConfirmationActivity.this.overridePendingTransition(0, 0x10A0001);
                }
            }, duration);
            this.mSuccessMessage.setAlpha(0.0f);
            this.mSuccessMessage.animate().alpha(1.0f).setStartDelay(50L).withEndAction(new Runnable(){

                @Override
                public void run() {
                    long fadeOutDuration = ConfirmationActivity.this.mSuccessMessage.animate().getDuration();
                    ConfirmationActivity.this.mSuccessMessage.animate().alpha(0.0f).setStartDelay(Math.max(0L, duration - 2L * (50L + fadeOutDuration)));
                }
            });
        }
    }

    private static long getAnimationDuration(AnimationDrawable animation) {
        int count = animation.getNumberOfFrames();
        long duration = 0L;
        for (int i = 0; i < count; ++i) {
            duration += (long)animation.getDuration(i);
        }
        return duration;
    }
}

