/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.os.Handler;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.support.wearable.view.SimpleAnimatorListener;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.Scroller;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WearableListView
extends RecyclerView
implements RecyclerView.OnScrollListener {
    public static final String TAG = "WearableListView";
    private static final long FLIP_ANIMATION_DURATION_MS = 150L;
    private static final long CENTERING_ANIMATION_DURATION_MS = 150L;
    private static final float TOP_TAP_REGION_PERCENTAGE = 0.25f;
    private static final float BOTTOM_TAP_REGION_PERCENTAGE = 0.25f;
    private static final int THIRD = 3;
    private final int mMinFlingVelocity;
    private final int mMaxFlingVelocity;
    private boolean mCanClick = true;
    private int mTapPositionX;
    private int mTapPositionY;
    private ClickListener mClickListener = null;
    private AnimatorSet mScrollAnimator;
    private int mLastScrollChange;
    private Set<OnScrollListener> mOnScrollListeners = new HashSet<OnScrollListener>();
    private boolean mGreedyTouchMode;
    private float mStartX;
    private float mStartY;
    private int mTouchSlop;
    private boolean mPossibleVerticalSwipe;
    private int mInitialOffset = 0;
    private Scroller mScroller;
    private float mTopTapRegion;
    private float mBottomTapRegion;
    private boolean mGestureDirectionLocked;
    private int mPreviousCentral = 0;
    private View mPressedItem = null;
    private Handler mPressedHandler = new Handler();
    private Runnable mPressedRunnable = new Runnable(){

        @Override
        public void run() {
            if (WearableListView.this.mPressedItem != null) {
                WearableListView.this.mPressedItem.setPressed(true);
            }
        }
    };

    public WearableListView(Context context) {
        this(context, null);
    }

    public WearableListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WearableListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setHasFixedSize(true);
        this.setOverScrollMode(2);
        this.setLayoutManager(new LayoutManager());
        this.setOnScrollListener(this);
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.mTouchSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mTopTapRegion = (float)metrics.heightPixels * 0.25f;
        this.mBottomTapRegion = (float)metrics.heightPixels * 0.75f;
    }

    public void resetLayoutManager() {
        this.setLayoutManager(new LayoutManager());
    }

    public void setGreedyTouchMode(boolean greedy) {
        this.mGreedyTouchMode = greedy;
    }

    public void setInitialOffset(int offset) {
        this.mInitialOffset = offset;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.mGreedyTouchMode && this.getChildCount() > 0) {
            int action = event.getActionMasked();
            if (action == 0) {
                this.mStartX = event.getX();
                this.mStartY = event.getY();
                this.mPossibleVerticalSwipe = true;
                this.mGestureDirectionLocked = false;
            } else if (action == 2 && this.mPossibleVerticalSwipe) {
                this.handlePossibleVerticalSwipe(event);
            }
            this.getParent().requestDisallowInterceptTouchEvent(this.mPossibleVerticalSwipe);
        }
        return super.onInterceptTouchEvent(event);
    }

    private boolean handlePossibleVerticalSwipe(MotionEvent event) {
        float deltaY;
        if (this.mGestureDirectionLocked) {
            return this.mPossibleVerticalSwipe;
        }
        float deltaX = Math.abs(this.mStartX - event.getX());
        float distance = deltaX * deltaX + (deltaY = Math.abs(this.mStartY - event.getY())) * deltaY;
        if (distance > (float)(this.mTouchSlop * this.mTouchSlop)) {
            if (deltaX > deltaY) {
                this.mPossibleVerticalSwipe = false;
            }
            this.mGestureDirectionLocked = true;
        }
        return this.mPossibleVerticalSwipe;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        if (this.getChildCount() > 0) {
            int action = event.getActionMasked();
            if (action == 0) {
                this.handleTouchDown(event);
            } else if (action == 1) {
                this.handleTouchUp(event);
                this.getParent().requestDisallowInterceptTouchEvent(false);
            } else if (action == 2) {
                if (Math.abs(this.mTapPositionX - (int)event.getX()) >= this.mTouchSlop || Math.abs(this.mTapPositionY - (int)event.getY()) >= this.mTouchSlop) {
                    this.releasePressedItem();
                    this.mCanClick = false;
                }
                result |= this.handlePossibleVerticalSwipe(event);
                this.getParent().requestDisallowInterceptTouchEvent(this.mPossibleVerticalSwipe);
            } else if (action == 3) {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        return result;
    }

    private void releasePressedItem() {
        if (this.mPressedItem != null) {
            this.mPressedItem.setPressed(false);
            this.mPressedHandler.removeCallbacks(this.mPressedRunnable);
            this.mPressedItem = null;
        }
    }

    @Override
    public void onScrollStateChanged(int newState) {
        if (newState == 0 && this.getChildCount() > 0) {
            this.handleTouchUp(null);
        }
        for (OnScrollListener listener : this.mOnScrollListeners) {
            listener.onScrollStateChanged(newState);
        }
    }

    @Override
    public void onScrolled(int dx, int dy) {
    }

    private void onScroll(int dy) {
        for (OnScrollListener listener : this.mOnScrollListeners) {
            listener.onScroll(dy);
        }
    }

    public void addOnScrollListener(OnScrollListener listener) {
        this.mOnScrollListeners.add(listener);
    }

    public void removeOnScrollListener(OnScrollListener listener) {
        this.mOnScrollListeners.remove(listener);
    }

    private boolean checkForTap(MotionEvent event) {
        float rawY = event.getRawY();
        int index = this.findCenterViewIndex();
        View view = this.getChildAt(index);
        ViewHolder holder = this.getChildViewHolder(view);
        if (rawY > this.mTopTapRegion && rawY < this.mBottomTapRegion) {
            if (this.mClickListener != null) {
                this.mClickListener.onClick(holder);
            }
            return true;
        }
        if (index > 0 && rawY <= this.mTopTapRegion) {
            this.animateToMiddle(index - 1, index);
            return true;
        }
        if (index < this.getChildCount() - 1 && rawY >= this.mBottomTapRegion) {
            this.animateToMiddle(index + 1, index);
            return true;
        }
        if (index == 0 && rawY <= this.mTopTapRegion) {
            this.mClickListener.onTopEmptyRegionClick();
            return true;
        }
        return false;
    }

    private void animateToMiddle(int newCenterIndex, int oldCenterIndex) {
        if (newCenterIndex == oldCenterIndex) {
            throw new IllegalArgumentException("newCenterIndex must be different from oldCenterIndex");
        }
        ArrayList<Animator> animators = new ArrayList<Animator>();
        View child = this.getChildAt(newCenterIndex);
        int scroll = (int)((float)(this.getHeight() / 3) - child.getY());
        this.startScrollAnimation(animators, scroll, 150L);
    }

    private void startScrollAnimation(List<Animator> animators, int scroll, long duration) {
        this.startScrollAnimation(animators, scroll, duration, 0L);
    }

    private void startScrollAnimation(List<Animator> animators, int scroll, long duration, long delay) {
        this.startScrollAnimation(animators, scroll, duration, delay, null);
    }

    private void startScrollAnimation(List<Animator> animators, int scroll, long duration, long delay, Animator.AnimatorListener listener) {
        if (this.mScrollAnimator != null) {
            this.mScrollAnimator.cancel();
        }
        this.mLastScrollChange = 0;
        ObjectAnimator scrollAnimator = ObjectAnimator.ofInt((Object)this, (String)"scrollVertically", (int[])new int[]{0, -scroll});
        animators.add((Animator)scrollAnimator);
        this.mScrollAnimator = new AnimatorSet();
        this.mScrollAnimator.playTogether(animators);
        this.mScrollAnimator.setDuration(duration);
        if (listener != null) {
            this.mScrollAnimator.addListener(listener);
        }
        if (delay > 0L) {
            this.mScrollAnimator.setStartDelay(delay);
        }
        this.mScrollAnimator.start();
    }

    @Override
    public boolean fling(int velocityX, int velocityY) {
        if (this.getChildCount() == 0) {
            return false;
        }
        int index = this.findCenterViewIndex();
        View child = this.getChildAt(index);
        int currentPosition = this.getChildPosition(child);
        if (currentPosition == 0 && velocityY < 0 || currentPosition == this.getAdapter().getItemCount() - 1 && velocityY > 0) {
            return super.fling(velocityX, velocityY);
        }
        if (Math.abs(velocityY) < this.mMinFlingVelocity) {
            return false;
        }
        velocityY = Math.max(Math.min(velocityY, this.mMaxFlingVelocity), -this.mMaxFlingVelocity);
        if (this.mScroller == null) {
            this.mScroller = new Scroller(this.getContext(), null, true);
        }
        this.mScroller.fling(0, 0, 0, velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        int finalY = this.mScroller.getFinalY();
        int delta = finalY / (this.getHeight() / 2);
        if (delta == 0) {
            delta = velocityY > 0 ? 1 : -1;
        }
        int finalPosition = Math.max(0, Math.min(this.getAdapter().getItemCount() - 1, currentPosition + delta));
        this.smoothScrollToPosition(finalPosition);
        return true;
    }

    @Override
    public ViewHolder getChildViewHolder(View child) {
        return (ViewHolder)super.getChildViewHolder(child);
    }

    public void setClickListener(ClickListener clickListener) {
        this.mClickListener = clickListener;
    }

    private int findCenterViewIndex() {
        int count = this.getChildCount();
        int index = -1;
        int closest = Integer.MAX_VALUE;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int distance = Math.abs(this.getHeight() / 2 - (child.getTop() + child.getHeight() / 2));
            if (distance >= closest) continue;
            closest = distance;
            index = i;
        }
        if (index == -1) {
            throw new IllegalStateException("Can't find central view.");
        }
        return index;
    }

    private void handleTouchUp(MotionEvent event) {
        if (this.mCanClick && event != null && this.checkForTap(event)) {
            return;
        }
        if (this.getScrollState() != 0) {
            return;
        }
        this.animateToCenter();
    }

    private void animateToCenter() {
        int index = this.findCenterViewIndex();
        ArrayList<Animator> animators = new ArrayList<Animator>();
        View child = this.getChildAt(index);
        int scrollToMiddle = (int)((float)(this.getHeight() / 3) - child.getY());
        this.startScrollAnimation(animators, scrollToMiddle, 150L, 0L, new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                if (!this.wasCanceled()) {
                    WearableListView.this.mCanClick = true;
                }
            }
        });
    }

    private void handleTouchDown(MotionEvent event) {
        if (this.mCanClick) {
            View view;
            this.mTapPositionX = (int)event.getX();
            this.mTapPositionY = (int)event.getY();
            float rawY = event.getRawY();
            if (rawY > this.mTopTapRegion && rawY < this.mBottomTapRegion && (view = this.getChildAt(this.findCenterViewIndex())) instanceof Item) {
                this.mPressedItem = view;
                this.mPressedHandler.postDelayed(this.mPressedRunnable, (long)ViewConfiguration.getTapTimeout());
            }
        }
    }

    private void setScrollVertically(int scroll) {
        this.scrollBy(0, scroll - this.mLastScrollChange);
        this.mLastScrollChange = scroll;
    }

    private void notifyChildrenAboutProximity(boolean animate) {
        int count = this.getChildCount();
        int index = this.findCenterViewIndex();
        for (int i = Math.max(0, index - 1); i < Math.min(index + 2, count); ++i) {
            View view = this.getChildAt(i);
            ViewHolder holder = this.getChildViewHolder(view);
            holder.onCenterProximity(i == index, animate);
        }
        int position = this.getChildViewHolder(this.getChildAt(index)).getPosition();
        if (position != this.mPreviousCentral) {
            for (OnScrollListener listener : this.mOnScrollListeners) {
                listener.onCentralPositionChanged(position);
            }
            this.mPreviousCentral = position;
        }
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public static final long DEFAULT_ANIMATION_DURATION = 150L;
        private static final String TAG = "WearableListView";
        private ObjectAnimator mScalingUpAnimator = null;
        private ObjectAnimator mScalingDownAnimator = null;
        private float mMinValue = 0.0f;
        private float mMaxValue = 0.0f;

        public ViewHolder(View itemView) {
            super(itemView);
            if (itemView instanceof Item) {
                Item item = (Item)itemView;
                this.mMinValue = item.getProximityMinValue();
                item.setScalingAnimatorValue(this.mMinValue);
                this.mMaxValue = item.getProximityMaxValue();
                this.mScalingUpAnimator = ObjectAnimator.ofFloat((Object)item, (String)"scalingAnimatorValue", (float[])new float[]{this.mMinValue, this.mMaxValue});
                this.mScalingUpAnimator.setDuration(150L);
                this.mScalingDownAnimator = ObjectAnimator.ofFloat((Object)item, (String)"scalingAnimatorValue", (float[])new float[]{this.mMaxValue, this.mMinValue});
                this.mScalingDownAnimator.setDuration(150L);
            }
        }

        public void onCenterProximity(boolean isCentralItem, boolean animate) {
            if (!(this.itemView instanceof Item)) {
                return;
            }
            Item item = (Item)this.itemView;
            if (isCentralItem) {
                if (animate) {
                    this.mScalingDownAnimator.cancel();
                    if (!this.mScalingUpAnimator.isRunning()) {
                        this.mScalingUpAnimator.setFloatValues(new float[]{item.getCurrentProximityValue(), this.mMaxValue});
                        this.mScalingUpAnimator.start();
                    }
                } else {
                    this.mScalingUpAnimator.cancel();
                    item.setScalingAnimatorValue(item.getProximityMaxValue());
                }
            } else {
                this.mScalingUpAnimator.cancel();
                if (animate) {
                    if (!this.mScalingDownAnimator.isRunning()) {
                        this.mScalingDownAnimator.setFloatValues(new float[]{item.getCurrentProximityValue(), this.mMinValue});
                        this.mScalingDownAnimator.start();
                        item.onScaleDownStart();
                    }
                } else {
                    this.mScalingDownAnimator.cancel();
                    item.setScalingAnimatorValue(item.getProximityMinValue());
                }
            }
            if (isCentralItem) {
                item.onScaleUpStart();
            } else {
                item.onScaleDownStart();
            }
        }
    }

    private static class SmoothScroller
    extends LinearSmoothScroller {
        private static final float MILLISECONDS_PER_INCH = 100.0f;
        private final LayoutManager mLayoutManager;

        public SmoothScroller(Context context, LayoutManager manager) {
            super(context);
            this.mLayoutManager = manager;
        }

        @Override
        protected void onStart() {
            super.onStart();
        }

        @Override
        protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
            return 100.0f / (float)displayMetrics.densityDpi;
        }

        @Override
        public int calculateDtToFit(int viewStart, int viewEnd, int boxStart, int boxEnd, int snapPreference) {
            return (boxStart + boxEnd) / 2 - (viewStart + viewEnd) / 2;
        }

        @Override
        public PointF computeScrollVectorForPosition(int targetPosition) {
            if (targetPosition < this.mLayoutManager.getFirstPosition()) {
                return new PointF(0.0f, -1.0f);
            }
            return new PointF(0.0f, 1.0f);
        }
    }

    public static abstract class Adapter
    extends RecyclerView.Adapter<ViewHolder> {
    }

    public static interface OnScrollListener {
        public void onScroll(int var1);

        public void onAbsoluteScrollChange(int var1);

        public void onScrollStateChanged(int var1);

        public void onCentralPositionChanged(int var1);
    }

    public static interface ClickListener {
        public void onClick(ViewHolder var1);

        public void onTopEmptyRegionClick();
    }

    public static interface Item {
        public float getProximityMinValue();

        public float getProximityMaxValue();

        public float getCurrentProximityValue();

        public void setScalingAnimatorValue(float var1);

        public void onScaleUpStart();

        public void onScaleDownStart();
    }

    private class LayoutManager
    extends RecyclerView.LayoutManager {
        private int mFirstPosition;
        private boolean mPushFirstHigher = false;
        private int mAbsoluteScroll = 0;

        private LayoutManager() {
        }

        @Override
        public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
            int parentBottom = this.getHeight() - this.getPaddingBottom();
            View oldTopView = this.getChildCount() > 0 ? this.getChildAt(0) : null;
            int oldTop = this.getHeight() / 3 + WearableListView.this.mInitialOffset;
            if (this.mPushFirstHigher) {
                oldTop -= this.getHeight() / 3;
            }
            if (oldTopView != null) {
                oldTop = oldTopView.getTop();
            }
            this.detachAndScrapAttachedViews(recycler);
            int top = oldTop;
            int left = this.getPaddingLeft();
            int right = this.getWidth() - this.getPaddingRight();
            int count = WearableListView.this.getAdapter().getItemCount();
            int i = 0;
            while (this.getFirstPosition() + i < count && top < parentBottom) {
                View v = recycler.getViewForPosition(this.getFirstPosition() + i);
                this.addView(v, i);
                this.measureView(v);
                int bottom = top + this.getItemHeight();
                v.layout(left, top, right, bottom);
                ++i;
                top = bottom;
            }
            if (this.getChildCount() > 0) {
                WearableListView.this.notifyChildrenAboutProximity(false);
            }
            if (oldTopView == null) {
                this.setAbsoluteScroll(((this.mPushFirstHigher ? 1 : 0) + this.getFirstPosition()) * this.getItemHeight());
            }
        }

        private void setAbsoluteScroll(int absoluteScroll) {
            this.mAbsoluteScroll = absoluteScroll;
            for (OnScrollListener listener : WearableListView.this.mOnScrollListeners) {
                listener.onAbsoluteScrollChange(this.mAbsoluteScroll);
            }
        }

        private void measureView(View v) {
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)v.getLayoutParams();
            int widthSpec = LayoutManager.getChildMeasureSpec(this.getWidth(), this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin, lp.width, this.canScrollHorizontally());
            int heightSpec = LayoutManager.getChildMeasureSpec(this.getHeight(), this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin, this.getHeight() / 3, this.canScrollVertically());
            v.measure(widthSpec, heightSpec);
        }

        @Override
        public RecyclerView.LayoutParams generateDefaultLayoutParams() {
            return new RecyclerView.LayoutParams(-1, -2);
        }

        @Override
        public boolean canScrollVertically() {
            return true;
        }

        @Override
        public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
            if (this.getChildCount() == 0) {
                return 0;
            }
            int scrolled = 0;
            int left = this.getPaddingLeft();
            int right = this.getWidth() - this.getPaddingRight();
            if (dy < 0) {
                while (scrolled > dy) {
                    View topView = this.getChildAt(0);
                    if (this.getFirstPosition() > 0) {
                        int hangingTop = Math.max(-topView.getTop(), 0);
                        int scrollBy = Math.min(scrolled - dy, hangingTop);
                        this.offsetChildrenVertical(scrollBy);
                        if (this.getFirstPosition() > 0 && (scrolled -= scrollBy) > dy) {
                            --this.mFirstPosition;
                            View v = recycler.getViewForPosition(this.getFirstPosition());
                            this.addView(v, 0);
                            this.measureView(v);
                            int bottom = topView.getTop();
                            int top = bottom - this.getItemHeight();
                            v.layout(left, top, right, bottom);
                            continue;
                        }
                    } else {
                        this.mPushFirstHigher = false;
                        int scrollBy = Math.min(-dy, this.getHeight() / 2 - topView.getTop());
                        scrolled -= scrollBy;
                        this.offsetChildrenVertical(scrollBy);
                    }
                    break;
                }
            } else if (dy > 0) {
                int parentHeight = this.getHeight();
                while (scrolled < dy) {
                    View bottomView = this.getChildAt(this.getChildCount() - 1);
                    if (this.getItemCount() > this.mFirstPosition + this.getChildCount()) {
                        int hangingBottom = Math.max(bottomView.getBottom() - parentHeight, 0);
                        int scrollBy = -Math.min(dy - scrolled, hangingBottom);
                        this.offsetChildrenVertical(scrollBy);
                        if ((scrolled -= scrollBy) < dy) {
                            View v = recycler.getViewForPosition(this.mFirstPosition + this.getChildCount());
                            int top = this.getChildAt(this.getChildCount() - 1).getBottom();
                            this.addView(v);
                            this.measureView(v);
                            int bottom = top + this.getItemHeight();
                            v.layout(left, top, right, bottom);
                            continue;
                        }
                    } else {
                        int scrollBy = Math.max(-dy, this.getHeight() / 2 - bottomView.getBottom());
                        scrolled -= scrollBy;
                        this.offsetChildrenVertical(scrollBy);
                    }
                    break;
                }
            }
            this.recycleViewsOutOfBounds(recycler);
            WearableListView.this.notifyChildrenAboutProximity(true);
            WearableListView.this.onScroll(scrolled);
            this.setAbsoluteScroll(this.mAbsoluteScroll + scrolled);
            return scrolled;
        }

        @Override
        public void scrollToPosition(int position) {
            if (position > 0) {
                this.mFirstPosition = position - 1;
                this.mPushFirstHigher = true;
            } else {
                this.mFirstPosition = position;
                this.mPushFirstHigher = false;
            }
        }

        @Override
        public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
            SmoothScroller linearSmoothScroller = new SmoothScroller(recyclerView.getContext(), this);
            linearSmoothScroller.setTargetPosition(position);
            this.startSmoothScroll(linearSmoothScroller);
        }

        private int getItemHeight() {
            return this.getHeight() / 3;
        }

        private void recycleViewsOutOfBounds(RecyclerView.Recycler recycler) {
            int i;
            int childCount = this.getChildCount();
            int parentWidth = this.getWidth();
            int parentHeight = this.getHeight();
            boolean foundFirst = false;
            int first = 0;
            int last = 0;
            for (i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                if (!v.hasFocus() && (v.getRight() < 0 || v.getLeft() > parentWidth || v.getBottom() < 0 || v.getTop() > parentHeight)) continue;
                if (!foundFirst) {
                    first = i;
                    foundFirst = true;
                }
                last = i;
            }
            for (i = childCount - 1; i > last; --i) {
                this.removeAndRecycleViewAt(i, recycler);
            }
            for (i = first - 1; i >= 0; --i) {
                this.removeAndRecycleViewAt(i, recycler);
            }
            if (this.getChildCount() == 0) {
                this.mFirstPosition = 0;
            } else if (first > 0) {
                this.mPushFirstHigher = true;
                this.mFirstPosition += first;
            }
        }

        public int getFirstPosition() {
            return this.mFirstPosition;
        }

        @Override
        public void onAdapterChanged(RecyclerView.Adapter oldAdapter, RecyclerView.Adapter newAdapter) {
            this.removeAllViews();
        }
    }
}

