/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.wearable.R;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.FrameLayout;

public class WatchViewStub
extends FrameLayout {
    private boolean mLastKnownRound;
    private int mRectLayout;
    private int mRoundLayout;
    private OnLayoutInflatedListener mListener;

    public WatchViewStub(Context context) {
        this(context, null);
    }

    public WatchViewStub(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WatchViewStub(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WatchViewStub, 0, 0);
        this.mRectLayout = a.getResourceId(0, 0);
        this.mRoundLayout = a.getResourceId(1, 0);
        a.recycle();
    }

    public void setOnLayoutInflatedListener(OnLayoutInflatedListener listener) {
        this.mListener = listener;
    }

    public void setRectLayout(int resId) {
        if (resId != this.mRectLayout) {
            this.mRectLayout = resId;
            if (!this.mLastKnownRound && this.getChildCount() > 0) {
                this.inflate();
            }
        }
    }

    public void setRoundLayout(int resId) {
        if (resId != this.mRoundLayout) {
            this.mRoundLayout = resId;
            if (this.mLastKnownRound && this.getChildCount() > 0) {
                this.inflate();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.requestApplyInsets();
    }

    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        boolean round = (insets = super.onApplyWindowInsets(insets)).isRound();
        if (round != this.mLastKnownRound) {
            this.mLastKnownRound = round;
            this.inflate();
        }
        return insets;
    }

    public void inflate() {
        this.removeAllViews();
        if (this.mRoundLayout == 0 && !this.isInEditMode()) {
            throw new IllegalStateException("You must supply a roundLayout resource");
        }
        if (this.mRectLayout == 0 && !this.isInEditMode()) {
            throw new IllegalStateException("You must supply a rectLayout resource");
        }
        int layout2 = this.mLastKnownRound ? this.mRoundLayout : this.mRectLayout;
        LayoutInflater.from((Context)this.getContext()).inflate(layout2, (ViewGroup)this);
        if (this.mListener != null) {
            this.mListener.onLayoutInflated(this);
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.getChildCount() == 0) {
            this.inflate();
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public static interface OnLayoutInflatedListener {
        public void onLayoutInflated(WatchViewStub var1);
    }
}

