/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.graphics.Bitmap;
import android.net.Uri;

public class ImageReference {
    public static final ImageReference NONE = new ImageReference(0);
    private int mHashcode;
    private Uri mImageUri;
    private int mDrawableResId;
    private Bitmap mBitmap;

    public static ImageReference forImageUri(Uri uri) {
        return new ImageReference(uri);
    }

    public static ImageReference forDrawable(int drawableResId) {
        return new ImageReference(drawableResId);
    }

    public static ImageReference forBitmap(Bitmap bitmap) {
        return new ImageReference(bitmap);
    }

    ImageReference(Uri uri) {
        this.mImageUri = uri;
        this.mHashcode = uri.hashCode();
    }

    ImageReference(int resource) {
        this.mDrawableResId = resource;
        this.mHashcode = resource;
    }

    ImageReference(Bitmap bitmap) {
        this.mBitmap = bitmap;
        this.mHashcode = this.hashBitmap(bitmap);
    }

    Bitmap getBitmap() {
        return this.mBitmap;
    }

    int getDrawableResId() {
        return this.mDrawableResId;
    }

    Uri getImageUri() {
        return this.mImageUri;
    }

    private int hashBitmap(Bitmap bitmap) {
        int hash = 17;
        hash = hash * bitmap.getWidth() + 31;
        hash = hash * bitmap.getHeight() + 31;
        hash = hash * bitmap.getByteCount() + 31;
        hash = hash * bitmap.getDensity() + 31;
        hash = hash * bitmap.getRowBytes() + 31;
        if (bitmap.getConfig() != null) {
            hash = hash * bitmap.getConfig().hashCode() + 31;
        }
        return hash;
    }

    public int hashCode() {
        return this.mHashcode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ImageReference) {
            ImageReference otherInfo = (ImageReference)other;
            if (this.mBitmap != null && otherInfo.mBitmap != null) {
                return this.mBitmap.sameAs(otherInfo.mBitmap);
            }
            if (this.mImageUri != null && otherInfo.mImageUri != null) {
                return this.mImageUri.equals((Object)otherInfo.mImageUri);
            }
            return this.mDrawableResId == otherInfo.mDrawableResId;
        }
        return false;
    }
}

