/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.support.v13.app.FragmentCompat;
import android.support.wearable.view.GridPagerAdapter;
import android.view.View;
import android.view.ViewGroup;

public abstract class FragmentGridPagerAdapter
extends GridPagerAdapter {
    private static final int MAX_ROWS = 65535;
    private final FragmentManager mFragmentManager;
    private FragmentTransaction mCurTransaction = null;
    private Fragment mCurrentPrimaryItem = null;

    public FragmentGridPagerAdapter(FragmentManager fm) {
        this.mFragmentManager = fm;
    }

    private static String makeFragmentName(int viewId, long id2) {
        return "android:switcher:" + viewId + ":" + id2;
    }

    public abstract Fragment getFragment(int var1, int var2);

    @Override
    public int getCurrentColumnForRow(int row, int currentColumn) {
        return 0;
    }

    protected long getFragmentId(int row, int column) {
        return column * 65535 + row;
    }

    protected Fragment instantiateItem(ViewGroup container, int row, int column) {
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        long itemId = this.getFragmentId(row, column);
        String name = FragmentGridPagerAdapter.makeFragmentName(container.getId(), itemId);
        Fragment fragment = this.mFragmentManager.findFragmentByTag(name);
        if (fragment == null) {
            fragment = this.getFragment(row, column);
            this.mCurTransaction.add(container.getId(), fragment, FragmentGridPagerAdapter.makeFragmentName(container.getId(), itemId));
        }
        if (fragment != this.mCurrentPrimaryItem) {
            FragmentCompat.setMenuVisibility((Fragment)fragment, (boolean)false);
            FragmentCompat.setUserVisibleHint((Fragment)fragment, (boolean)false);
        }
        return fragment;
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view == ((Fragment)object).getView();
    }

    @Override
    protected void destroyItem(ViewGroup container, int row, int column, Object object) {
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        this.mCurTransaction.remove((Fragment)object);
    }

    @Override
    protected void finishUpdate(ViewGroup container) {
        if (this.mFragmentManager.isDestroyed()) {
            this.mCurTransaction = null;
            return;
        }
        if (this.mCurTransaction != null) {
            this.mCurTransaction.commitAllowingStateLoss();
            this.mCurTransaction = null;
            this.mFragmentManager.executePendingTransactions();
        }
    }
}

