/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.wearable.R;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;

public class DismissOverlayView
extends FrameLayout {
    private static final String PREF_NAME = "android.support.wearable.DismissOverlay";
    private static final String KEY_FIRST_RUN = "first_run";
    private SharedPreferences mPrefs;
    private boolean mFirstRun;
    private TextView mFirstRunText;
    private View mDismissButton;

    public DismissOverlayView(Context context) {
        this(context, null, 0);
    }

    public DismissOverlayView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DismissOverlayView(final Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        LayoutInflater.from((Context)context).inflate(R.layout.dismiss_overlay, (ViewGroup)this, true);
        this.setBackgroundResource(R.color.dismiss_overlay_bg);
        this.setClickable(true);
        this.mPrefs = context.getSharedPreferences(PREF_NAME, 0);
        this.mFirstRun = this.mPrefs.getBoolean(KEY_FIRST_RUN, true);
        this.mFirstRunText = (TextView)this.findViewById(R.id.dismiss_overlay_explain);
        this.mDismissButton = this.findViewById(R.id.dismiss_overlay_button);
        this.mDismissButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (context instanceof Activity) {
                    ((Activity)context).finish();
                }
            }
        });
        this.setVisibility(8);
    }

    public void setIntroText(CharSequence str) {
        this.mFirstRunText.setText(str);
    }

    public void setIntroText(int textResId) {
        this.mFirstRunText.setText(textResId);
    }

    public void showIntroIfNecessary() {
        if (!this.mFirstRun) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mFirstRunText.getText())) {
            this.mFirstRun = false;
            return;
        }
        this.mFirstRunText.setVisibility(0);
        this.mDismissButton.setVisibility(8);
        this.setVisibility(0);
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                DismissOverlayView.this.hide();
            }
        }, 3000L);
    }

    public void show() {
        this.setAlpha(0.0f);
        this.mFirstRunText.setVisibility(8);
        this.mDismissButton.setVisibility(0);
        this.setVisibility(0);
        this.animate().alpha(1.0f).setDuration(200L).start();
    }

    private void hide() {
        this.animate().alpha(0.0f).setDuration(200L).withEndAction(new Runnable(){

            @Override
            public void run() {
                DismissOverlayView.this.setVisibility(8);
                DismissOverlayView.this.setAlpha(1.0f);
            }
        }).start();
        if (this.mFirstRun) {
            this.mFirstRun = false;
            this.mPrefs.edit().putBoolean(KEY_FIRST_RUN, false).apply();
        }
    }

    public boolean performClick() {
        this.hide();
        return true;
    }
}

