/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Message;
import android.support.wearable.R;
import android.support.wearable.view.CircledImageView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import java.util.Calendar;

public class DelayedConfirmationView
extends CircledImageView {
    private long mTotalTimeMs;
    private long mUpdateIntervalMs = 0L;
    private DelayedConfirmationListener mListener;
    private long mStartTimeMs;
    private long mCurrentTimeMs;
    private Handler mTimerHandler = new Handler(){

        public void handleMessage(Message msg) {
            DelayedConfirmationView.this.mCurrentTimeMs = Calendar.getInstance().getTimeInMillis();
            DelayedConfirmationView.this.invalidate();
            if (DelayedConfirmationView.this.mCurrentTimeMs - DelayedConfirmationView.this.mStartTimeMs < DelayedConfirmationView.this.mTotalTimeMs) {
                DelayedConfirmationView.this.mTimerHandler.sendEmptyMessageDelayed(0, DelayedConfirmationView.this.mUpdateIntervalMs);
            } else if (DelayedConfirmationView.this.mListener != null) {
                DelayedConfirmationView.this.mListener.onTimerFinished((View)DelayedConfirmationView.this);
            }
        }
    };

    public DelayedConfirmationView(Context context) {
        this(context, null);
    }

    public DelayedConfirmationView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DelayedConfirmationView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DelayedConfirmationView, defStyle, 0);
        this.mUpdateIntervalMs = a.getInteger(0, 100);
        this.setProgress(0.0f);
        a.recycle();
    }

    public void setTotalTimeMs(long time) {
        this.mTotalTimeMs = time;
    }

    public void setListener(DelayedConfirmationListener handler) {
        this.mListener = handler;
    }

    public void start() {
        this.mStartTimeMs = Calendar.getInstance().getTimeInMillis();
        this.mTimerHandler.sendEmptyMessageDelayed(0, this.mUpdateIntervalMs);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (this.mStartTimeMs > 0L) {
            this.mProgress = (float)(this.mCurrentTimeMs - this.mStartTimeMs) / (float)this.mTotalTimeMs;
        }
        super.onDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        switch (action) {
            case 0: 
            case 2: {
                if (this.mListener == null) break;
                this.mListener.onTimerSelected((View)this);
                break;
            }
        }
        return false;
    }

    public static interface DelayedConfirmationListener {
        public void onTimerFinished(View var1);

        public void onTimerSelected(View var1);
    }
}

