/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.wearable.R;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;

public class CircledImageView
extends FrameLayout {
    private ImageView mImageView;
    private final RectF mOval;
    private final Paint mPaint;
    private ColorStateList mCircleColor;
    float mCircleRadius;
    private float mCircleRadiusPressed;
    private int mCircleBorderColor;
    private float mCircleBorderWidth;
    protected float mProgress = 1.0f;
    private final float mShadowWidth;
    private float mShadowVisibility;
    private boolean mCircleHidden = false;
    private float mInitialCircleRadius;
    private boolean mPressed = false;

    public CircledImageView(Context context) {
        this(context, null);
    }

    public CircledImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircledImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        float circlePadding;
        this.mImageView = new ImageView(context);
        FrameLayout.LayoutParams imageViewLayoutParams = new FrameLayout.LayoutParams(-2, -2);
        imageViewLayoutParams.gravity = 17;
        this.mImageView.setLayoutParams((ViewGroup.LayoutParams)imageViewLayoutParams);
        this.addView((View)this.mImageView);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CircledImageView);
        Drawable d = a.getDrawable(0);
        if (d != null) {
            this.mImageView.setImageDrawable(d);
        }
        this.mCircleColor = a.getColorStateList(1);
        if (this.mCircleColor == null) {
            this.mCircleColor = ColorStateList.valueOf((int)0x1060000);
        }
        this.mInitialCircleRadius = this.mCircleRadius = a.getDimension(2, 0.0f);
        this.mCircleRadiusPressed = a.getDimension(3, this.mCircleRadius);
        this.mCircleBorderColor = a.getColor(5, -16777216);
        this.mCircleBorderWidth = a.getDimension(4, 0.0f);
        if (this.mCircleBorderWidth > 0.0f) {
            this.mCircleRadius -= this.mCircleBorderWidth;
            this.mCircleRadiusPressed -= this.mCircleBorderWidth;
        }
        if ((circlePadding = a.getDimension(6, 0.0f)) > 0.0f) {
            this.mCircleRadius -= circlePadding;
            this.mCircleRadiusPressed -= circlePadding;
        }
        this.mShadowWidth = a.getDimension(7, 0.0f);
        a.recycle();
        this.mOval = new RectF();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.setWillNotDraw(false);
    }

    public void setCircleHidden(boolean circleHidden) {
        this.mCircleHidden = circleHidden;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        float circleRadius;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        float f = circleRadius = this.mPressed ? this.mCircleRadiusPressed : this.mCircleRadius;
        if (this.mShadowWidth > 0.0f && this.mShadowVisibility > 0.0f) {
            this.mOval.set((float)paddingLeft, (float)paddingTop, (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()));
            float radius = circleRadius + this.mCircleBorderWidth + this.mShadowWidth * this.mShadowVisibility;
            this.mPaint.setColor(-16777216);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setShader((Shader)new RadialGradient(this.mOval.centerX(), this.mOval.centerY(), radius, new int[]{-16777216, 0}, new float[]{0.6f, 1.0f}, Shader.TileMode.MIRROR));
            canvas.drawCircle(this.mOval.centerX(), this.mOval.centerY(), radius, this.mPaint);
            this.mPaint.setShader(null);
        }
        if (this.mCircleBorderWidth > 0.0f) {
            this.mOval.set((float)paddingLeft, (float)paddingTop, (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()));
            this.mOval.set(this.mOval.centerX() - circleRadius, this.mOval.centerY() - circleRadius, this.mOval.centerX() + circleRadius, this.mOval.centerY() + circleRadius);
            this.mPaint.setColor(this.mCircleBorderColor);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(this.mCircleBorderWidth);
            canvas.drawArc(this.mOval, -90.0f, 360.0f * this.mProgress, false, this.mPaint);
        }
        if (!this.mCircleHidden) {
            this.mOval.set((float)paddingLeft, (float)paddingTop, (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()));
            int color2 = this.mCircleColor.getColorForState(this.getDrawableState(), this.mCircleColor.getDefaultColor());
            this.mPaint.setColor(color2);
            this.mPaint.setStyle(Paint.Style.FILL);
            float centerX = this.mOval.centerX();
            float centerY = this.mOval.centerY();
            if (this.mImageView.getDrawable() != null) {
                centerX = Math.round((float)this.mImageView.getLeft() + (float)this.mImageView.getWidth() / 2.0f);
                centerY = Math.round((float)this.mImageView.getTop() + (float)this.mImageView.getHeight() / 2.0f);
            }
            canvas.drawCircle(centerX, centerY, circleRadius, this.mPaint);
        }
        super.onDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float radius = this.mCircleRadius + this.mCircleBorderWidth + this.mShadowWidth * this.mShadowVisibility;
        float desiredWidth = radius * 2.0f;
        float desiredHeight = radius * 2.0f;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? (int)Math.min(desiredWidth, (float)widthSize) : (int)desiredWidth);
        int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? (int)Math.min(desiredHeight, (float)heightSize) : (int)desiredHeight);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    public void setImageDrawable(Drawable drawable2) {
        this.mImageView.setImageDrawable(drawable2);
        this.invalidate();
    }

    public void setImageResource(int resId) {
        this.mImageView.setImageResource(resId);
        this.invalidate();
    }

    public float getCircleRadius() {
        return this.mCircleRadius;
    }

    public void setCircleRadius(float circleRadius) {
        this.mCircleRadius = circleRadius;
        this.invalidate();
    }

    public void setCircleRadiusPressed(float circleRadiusPressed) {
        this.mCircleRadiusPressed = circleRadiusPressed;
        this.invalidate();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public void setCircleColor(int circleColor) {
        this.setCircleColorStateList(ColorStateList.valueOf((int)circleColor));
    }

    public void setCircleColorStateList(ColorStateList circleColor) {
        this.mCircleColor = circleColor;
        this.invalidate();
    }

    public void setProgress(float progress) {
        this.mProgress = progress;
        this.invalidate();
    }

    public void setShadowVisibility(float shadowVisibility) {
        if (shadowVisibility != this.mShadowVisibility) {
            this.mShadowVisibility = shadowVisibility;
            this.invalidate();
        }
    }

    public float getInitialCircleRadius() {
        return this.mInitialCircleRadius;
    }

    public void setCircleBorderColor(int circleBorderColor) {
        this.mCircleBorderColor = circleBorderColor;
    }

    public void setPressed(boolean pressed) {
        super.setPressed(pressed);
        this.mPressed = pressed;
        this.invalidate();
    }
}

