/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.support.wearable.R;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;

public class CardFrame
extends ViewGroup {
    private static final String TAG = "CardFrame";
    private static final boolean DEBUG = false;
    private static float BOX_FACTOR = 0.146467f;
    public static final float NO_EXPANSION = 1.0f;
    public static final int EXPAND_UP = -1;
    public static final int EXPAND_DOWN = 1;
    private static final int EDGE_FADE_DISTANCE_DP = 40;
    private static final float CARD_SHADOW_WIDTH_DP = 8.0f;
    private boolean mCanExpand;
    private boolean mExpansionEnabled = true;
    private float mExpansionFactor = 1.0f;
    private int mExpansionDirection = 1;
    private final int mEdgeFadeDistance;
    private final Rect mChildClipBounds = new Rect();
    private int mCardBaseHeight;
    private boolean mRoundDisplay;
    private int mBoxInset;
    private final EdgeFade mEdgeFade = new EdgeFade();

    public CardFrame(Context context) {
        this(context, null, 0);
    }

    public CardFrame(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CardFrame(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        Resources res = context.getResources();
        float density = res.getDisplayMetrics().density;
        this.mEdgeFadeDistance = (int)(40.0f * density);
        this.setBackgroundResource(R.drawable.card_background);
    }

    public void setExpansionEnabled(boolean enabled) {
        this.mExpansionEnabled = enabled;
        this.requestLayout();
        this.invalidate();
    }

    public void setExpansionDirection(int direction) {
        this.mExpansionDirection = direction;
        this.requestLayout();
        this.invalidate();
    }

    public void setExpansionFactor(float expansionFactor) {
        this.mExpansionFactor = expansionFactor;
        this.requestLayout();
        this.invalidate();
    }

    public int getExpansionDirection() {
        return this.mExpansionDirection;
    }

    public boolean isExpansionEnabled() {
        return this.mExpansionEnabled;
    }

    public float getExpansionFactor() {
        return this.mExpansionFactor;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.requestApplyInsets();
    }

    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        boolean round = insets.isRound();
        if (round != this.mRoundDisplay) {
            this.mRoundDisplay = round;
        }
        return insets.consumeSystemWindowInsets();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childHeightMeasureSpecSize;
        int childHeightMeasureSpecMode;
        int n = this.mBoxInset = this.mRoundDisplay ? (int)(BOX_FACTOR * (float)Math.max(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec))) : 0;
        if (this.mBoxInset > 0) {
            this.setPadding(this.mBoxInset, this.getPaddingTop(), this.mBoxInset, this.getPaddingBottom());
        }
        int cardMeasuredWidth = CardFrame.getDefaultSize(this.getSuggestedMinimumWidth(), widthMeasureSpec, true);
        int cardMeasuredHeight = CardFrame.getDefaultSize(this.getSuggestedMinimumHeight(), heightMeasureSpec, false);
        if (this.getChildCount() == 0) {
            this.setMeasuredDimension(cardMeasuredWidth, cardMeasuredHeight);
            return;
        }
        View content = this.getChildAt(0);
        int parentHeightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int parentHeightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int childWidthMeasureSpecSize = cardMeasuredWidth;
        int childWidthMeasureSpecMode = 0x40000000;
        boolean cardHeightMatchContent = false;
        this.mCanExpand = this.mExpansionEnabled;
        if (parentHeightMode == 0 || parentHeightSize == 0) {
            Log.w((String)TAG, (String)"height measure spec passed with mode UNSPECIFIED, or zero height.");
            this.mCanExpand = false;
            this.mCardBaseHeight = 0;
            cardMeasuredHeight = 0;
            cardHeightMatchContent = true;
            childHeightMeasureSpecMode = 0;
            childHeightMeasureSpecSize = 0;
        } else if (parentHeightMode == 0x40000000) {
            Log.w((String)TAG, (String)"height measure spec passed with mode EXACT");
            this.mCanExpand = false;
            cardMeasuredHeight = this.mCardBaseHeight = parentHeightSize;
            childHeightMeasureSpecMode = 0x40000000;
            childHeightMeasureSpecSize = cardMeasuredHeight;
        } else {
            cardMeasuredHeight = this.mCardBaseHeight = parentHeightSize;
            if (this.mCanExpand) {
                cardMeasuredHeight = (int)((float)cardMeasuredHeight * this.mExpansionFactor);
            }
            if (this.mExpansionDirection == -1) {
                childHeightMeasureSpecMode = 0;
                childHeightMeasureSpecSize = 0;
            } else {
                childHeightMeasureSpecMode = Integer.MIN_VALUE;
                childHeightMeasureSpecSize = cardMeasuredHeight;
                childHeightMeasureSpecSize += this.getPaddingBottom();
            }
        }
        int paddingWidth = this.getPaddingLeft() + this.getPaddingRight();
        int paddingHeight = this.getPaddingTop() + this.getPaddingBottom();
        int childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)(childWidthMeasureSpecSize - paddingWidth), (int)childWidthMeasureSpecMode);
        int childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)(childHeightMeasureSpecSize - paddingHeight), (int)childHeightMeasureSpecMode);
        ViewGroup.LayoutParams lp = content.getLayoutParams();
        childWidthSpec = CardFrame.getChildMeasureSpec((int)childWidthSpec, (int)0, (int)lp.width);
        content.measure(childWidthSpec, childHeightSpec);
        if (cardHeightMatchContent) {
            cardMeasuredHeight = content.getMeasuredHeight() + paddingHeight;
        } else {
            cardMeasuredHeight = Math.min(cardMeasuredHeight, content.getMeasuredHeight() + paddingHeight);
            this.mCanExpand &= content.getMeasuredHeight() > cardMeasuredHeight - paddingHeight;
        }
        this.setMeasuredDimension(cardMeasuredWidth, cardMeasuredHeight);
    }

    protected static int getDefaultSize(int size, int measureSpec, boolean greedy) {
        int result = size;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: {
                result = greedy ? specSize : size;
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int t;
        int b;
        if (this.getChildCount() == 0) {
            return;
        }
        View content = this.getChildAt(0);
        int l = this.getPaddingLeft();
        if (left < 0) {
            l -= left;
        }
        int r = l + content.getMeasuredWidth();
        if (this.mExpansionDirection == -1) {
            b = bottom - top;
            t = b - (content.getMeasuredHeight() + this.getPaddingTop());
        } else {
            t = this.getPaddingTop();
            b = t + content.getMeasuredHeight();
        }
        content.layout(l, t, r, b);
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        int fadeDistance = this.mEdgeFadeDistance;
        boolean more = false;
        boolean bottomFade = false;
        boolean topFade = false;
        this.mChildClipBounds.set(child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
        int paddingHeight = this.getPaddingTop() + this.getPaddingBottom();
        int contentHeight = child.getHeight();
        if (this.mCanExpand) {
            if (this.mExpansionDirection == -1 && contentHeight + paddingHeight > this.getHeight()) {
                topFade = true;
                this.mChildClipBounds.top = this.getPaddingTop();
            } else if (this.mExpansionDirection == 1 && contentHeight + paddingHeight > this.getHeight()) {
                bottomFade = true;
                this.mChildClipBounds.bottom = this.getHeight() - this.getPaddingBottom();
            }
        }
        int saveCount = canvas.getSaveCount();
        canvas.clipRect(this.mChildClipBounds);
        int flags = 4;
        if (topFade) {
            canvas.saveLayer((float)this.mChildClipBounds.left, (float)this.mChildClipBounds.top, (float)this.mChildClipBounds.right, (float)(this.mChildClipBounds.top + fadeDistance), null, 4);
        }
        if (bottomFade) {
            canvas.saveLayer((float)this.mChildClipBounds.left, (float)(this.mChildClipBounds.bottom - fadeDistance), (float)this.mChildClipBounds.right, (float)this.mChildClipBounds.bottom, null, 4);
        }
        more = super.drawChild(canvas, child, drawingTime);
        if (topFade) {
            this.mEdgeFade.matrix.reset();
            this.mEdgeFade.matrix.setScale(1.0f, (float)fadeDistance);
            this.mEdgeFade.matrix.postTranslate((float)this.mChildClipBounds.left, (float)this.mChildClipBounds.top);
            this.mEdgeFade.shader.setLocalMatrix(this.mEdgeFade.matrix);
            canvas.drawRect((float)this.mChildClipBounds.left, (float)this.mChildClipBounds.top, (float)this.mChildClipBounds.right, (float)(this.mChildClipBounds.top + fadeDistance), this.mEdgeFade.paint);
        }
        if (bottomFade) {
            this.mEdgeFade.matrix.reset();
            this.mEdgeFade.matrix.setScale(1.0f, (float)fadeDistance);
            this.mEdgeFade.matrix.postRotate(180.0f);
            this.mEdgeFade.matrix.postTranslate((float)this.mChildClipBounds.left, (float)this.mChildClipBounds.bottom);
            this.mEdgeFade.shader.setLocalMatrix(this.mEdgeFade.matrix);
            canvas.drawRect((float)this.mChildClipBounds.left, (float)(this.mChildClipBounds.bottom - fadeDistance), (float)this.mChildClipBounds.right, (float)this.mChildClipBounds.bottom, this.mEdgeFade.paint);
        }
        canvas.restoreToCount(saveCount);
        return more;
    }

    public void addView(View child) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("CardFrame can host only one direct child");
        }
        super.addView(child);
    }

    public void addView(View child, int index) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("CardFrame can host only one direct child");
        }
        super.addView(child, index);
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("CardFrame can host only one direct child");
        }
        super.addView(child, params);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("CardFrame can host only one direct child");
        }
        super.addView(child, index, params);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)CardFrame.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)CardFrame.class.getName());
    }

    private static class EdgeFade {
        private final Shader shader;
        private final Paint paint;
        private final Matrix matrix = new Matrix();

        public EdgeFade() {
            this.shader = new LinearGradient(0.0f, 0.0f, 0.0f, 1.0f, -16777216, 0, Shader.TileMode.CLAMP);
            this.paint = new Paint();
            this.paint.setShader(this.shader);
            this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        }
    }
}

