/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.app.Fragment;
import android.os.Bundle;
import android.support.wearable.R;
import android.support.wearable.view.CardFrame;
import android.support.wearable.view.CardScrollView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;

public class CardFragment
extends Fragment {
    private static final String CONTENT_SAVED_STATE = "CardScrollView_content";
    public static final int EXPAND_UP = -1;
    public static final int EXPAND_DOWN = 1;
    public static final String KEY_TITLE = "CardFragment_title";
    public static final String KEY_TEXT = "CardFragment_text";
    public static final String KEY_ICON_RESOURCE = "CardFragment_icon";
    private CardFrame mCard;
    private CardScrollView mCardScroll;
    private int mCardGravity = 80;
    private boolean mExpansionEnabled = true;
    private float mExpansionFactor = 10.0f;
    private int mExpansionDirection = 1;
    private boolean mScrollToTop;
    private boolean mScrollToBottom;

    public static CardFragment create(CharSequence title, CharSequence description) {
        return CardFragment.create(title, description, 0);
    }

    public static CardFragment create(CharSequence title, CharSequence text, int iconRes) {
        CardFragment fragment = new CardFragment();
        Bundle args = new Bundle();
        if (title != null) {
            args.putCharSequence(KEY_TITLE, title);
        }
        if (text != null) {
            args.putCharSequence(KEY_TEXT, text);
        }
        if (iconRes != 0) {
            args.putInt(KEY_ICON_RESOURCE, iconRes);
        }
        fragment.setArguments(args);
        return fragment;
    }

    public void setExpansionEnabled(boolean enabled) {
        this.mExpansionEnabled = enabled;
        if (this.mCard != null) {
            this.mCard.setExpansionEnabled(this.mExpansionEnabled);
        }
    }

    public void setExpansionDirection(int direction) {
        this.mExpansionDirection = direction;
        if (this.mCard != null) {
            this.mCard.setExpansionDirection(direction);
        }
    }

    public void setCardGravity(int gravity) {
        this.mCardGravity = gravity & 0x70;
        if (this.mCard != null) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mCard.getLayoutParams();
            lp.gravity = this.mCardGravity;
            this.mCard.requestLayout();
        }
    }

    public void setExpansionFactor(float factor) {
        this.mExpansionFactor = factor;
        if (this.mCard != null) {
            this.mCard.setExpansionFactor(factor);
        }
    }

    public void scrollToTop() {
        if (this.mCardScroll != null) {
            this.mCardScroll.scrollBy(0, this.mCardScroll.getAvailableScrollDelta(-1));
        } else {
            this.mScrollToTop = true;
            this.mScrollToBottom = false;
        }
    }

    public void scrollToBottom() {
        if (this.mCardScroll != null) {
            this.mCardScroll.scrollBy(0, this.mCardScroll.getAvailableScrollDelta(1));
        } else {
            this.mScrollToTop = true;
            this.mScrollToBottom = false;
        }
    }

    public final View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View content;
        this.mCardScroll = new CardScrollView(inflater.getContext());
        this.mCardScroll.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mCard = new CardFrame(inflater.getContext());
        this.mCard.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2, this.mCardGravity));
        this.mCard.setExpansionEnabled(this.mExpansionEnabled);
        this.mCard.setExpansionFactor(this.mExpansionFactor);
        this.mCard.setExpansionDirection(this.mExpansionDirection);
        this.mCardScroll.addView((View)this.mCard);
        if (this.mScrollToTop || this.mScrollToBottom) {
            this.mCardScroll.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    CardFragment.this.mCardScroll.removeOnLayoutChangeListener(this);
                    if (CardFragment.this.mScrollToTop) {
                        CardFragment.this.mScrollToTop = false;
                        CardFragment.this.scrollToTop();
                    } else if (CardFragment.this.mScrollToBottom) {
                        CardFragment.this.mScrollToBottom = false;
                        CardFragment.this.scrollToBottom();
                    }
                }
            });
        }
        Bundle contentSavedState = null;
        if (savedInstanceState != null) {
            contentSavedState = savedInstanceState.getBundle(CONTENT_SAVED_STATE);
        }
        if ((content = this.onCreateContentView(inflater, this.mCard, contentSavedState)) != null) {
            this.mCard.addView(content);
        }
        return this.mCardScroll;
    }

    public void onResume() {
        super.onResume();
    }

    public View onCreateContentView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.watch_card_content, container, false);
        Bundle args = this.getArguments();
        if (args != null) {
            TextView text;
            TextView title = (TextView)view.findViewById(R.id.title);
            if (args.containsKey(KEY_TITLE) && title != null) {
                title.setText(args.getCharSequence(KEY_TITLE));
            }
            if (args.containsKey(KEY_TEXT) && (text = (TextView)view.findViewById(R.id.text)) != null) {
                text.setText(args.getCharSequence(KEY_TEXT));
            }
            if (args.containsKey(KEY_ICON_RESOURCE) && title != null) {
                title.setCompoundDrawablesRelativeWithIntrinsicBounds(0, 0, args.getInt(KEY_ICON_RESOURCE), 0);
            }
        }
        return view;
    }
}

