/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.util.SimpleArrayMap;
import android.support.wearable.R;
import android.support.wearable.view.CrossfadeDrawable;
import android.support.wearable.view.GridPagerAdapter;
import android.support.wearable.view.ImageReference;
import android.support.wearable.view.ViewportDrawable;
import android.util.SparseArray;

class BackgroundController {
    private static final Drawable EMPTY_BACKGROUND = new ColorDrawable(R.color.light_grey);
    private final Context mContext;
    private GridPagerAdapter mAdapter;
    private CrossfadeDrawable mBackground;
    private int mCurrentColumn;
    private int mCurrentRow;
    private final ViewportDrawable mBaseLayer = new ViewportDrawable();
    private final ViewportDrawable mFadingLayer = new ViewportDrawable();
    private SparseArray<SparseArray<ImageReference>> mColSpans = new SparseArray();
    private SimpleArrayMap<ImageReference, Drawable> mImageCache = new SimpleArrayMap();

    BackgroundController(Context context, CrossfadeDrawable background) {
        this.mContext = context;
        this.mBackground = background;
        this.mFadingLayer.setFilterBitmap(true);
        this.mBaseLayer.setFilterBitmap(true);
        this.mBackground.setFading(this.mFadingLayer);
        this.mBackground.setBase(this.mBaseLayer);
    }

    public void setAdapter(GridPagerAdapter adapter) {
        this.mAdapter = adapter;
        this.computeColSpans();
        this.mFadingLayer.setDrawable(EMPTY_BACKGROUND);
        this.mBaseLayer.setDrawable(EMPTY_BACKGROUND);
        this.setPage(0, 0);
    }

    private void computeColSpans() {
        int rows = this.mAdapter.getRowCount();
        for (int row = 0; row < rows; ++row) {
            int cols = this.mAdapter.getColumnCount(row);
            SparseArray rowRefs = (SparseArray)this.mColSpans.get(row);
            if (rowRefs == null) {
                rowRefs = new SparseArray();
                this.mColSpans.put(row, (Object)rowRefs);
            }
            ImageReference prev = this.mAdapter.getBackground(row, 0);
            rowRefs.put(0, (Object)prev);
            for (int col = 1; col < cols; ++col) {
                ImageReference ref = this.mAdapter.getBackground(row, col);
                if (ref == prev || ref != null && ref.equals(prev)) continue;
                rowRefs.put(col, (Object)ref);
                prev = ref;
            }
            if (rowRefs.size() <= cols) continue;
            this.mColSpans.removeAtRange(cols, rowRefs.size() - cols);
        }
        if (this.mColSpans.size() > rows) {
            this.mColSpans.removeAtRange(rows, this.mColSpans.size() - rows);
        }
    }

    public void setPage(int row, int column) {
        this.mCurrentRow = row;
        this.mCurrentColumn = column;
        this.onVerticalScroll(row, 0.0f);
        this.onHorizontalScroll(column, 0.0f);
    }

    private int floorIndex(SparseArray<ImageReference> array, int key) {
        int pos = array.indexOfKey(key);
        if (pos < 0) {
            pos = -pos - 2;
        }
        return pos;
    }

    public void onHorizontalScroll(int column, float offset) {
        if (Math.abs(offset) >= 1.0f) {
            column = (int)((double)column + Math.floor(offset));
            offset -= (float)((int)offset);
        }
        if (this.mCurrentColumn - column > 2) {
            this.mCurrentColumn = column + 1;
        } else if (column > this.mCurrentColumn) {
            this.mCurrentColumn = column;
        }
        boolean left = column < this.mCurrentColumn;
        int current = this.mCurrentColumn;
        float shift = left ? 0.0f - (1.0f - offset) : offset;
        int numColumns = this.mAdapter.getColumnCount(this.mCurrentRow);
        SparseArray colspan = (SparseArray)this.mColSpans.get(this.mCurrentRow);
        if (colspan.size() == 0) {
            this.mBaseLayer.setDrawable(EMPTY_BACKGROUND);
            this.mFadingLayer.setDrawable(EMPTY_BACKGROUND);
        } else {
            int centerIndex = this.floorIndex((SparseArray<ImageReference>)colspan, current);
            int start = colspan.keyAt(centerIndex);
            int end = centerIndex < colspan.size() - 1 ? colspan.keyAt(centerIndex + 1) : numColumns;
            int xStops = 2 + (end - start);
            int yStops = 3;
            int xPos = 1 + (current - start);
            boolean yPos = true;
            if (Math.floor((float)current + shift) >= (double)start && Math.ceil((float)current + shift) < (double)end) {
                this.mBaseLayer.setDrawable(this.getDrawable((ImageReference)colspan.get(start)));
                this.mBaseLayer.setStops(xStops, yStops);
                this.mBaseLayer.setPosition((float)xPos + shift, (float)yPos);
                this.mFadingLayer.setDrawable(EMPTY_BACKGROUND);
                this.mBackground.setProgress(0.0f);
            } else if (shift >= 0.0f) {
                this.mBaseLayer.setDrawable(this.getDrawable((ImageReference)colspan.get(start)));
                this.mBaseLayer.setStops(xStops, yStops);
                this.mBaseLayer.setPosition((float)xPos + shift, (float)yPos);
                if (end < numColumns) {
                    int rightStart = end;
                    int rightEnd = centerIndex + 2 < colspan.size() ? colspan.keyAt(centerIndex + 2) : numColumns;
                    int rightXStops = 2 + (rightEnd - rightStart);
                    int rightXPos = 1 + (current - rightStart);
                    this.mFadingLayer.setDrawable(this.getDrawable((ImageReference)colspan.get(rightStart)));
                    this.mFadingLayer.setStops(rightXStops, yStops);
                    this.mFadingLayer.setPosition((float)rightXPos + shift, (float)yPos);
                    this.mBackground.setProgress(offset);
                } else {
                    this.mFadingLayer.setDrawable(EMPTY_BACKGROUND);
                }
            } else {
                this.mBaseLayer.setDrawable(this.getDrawable((ImageReference)colspan.get(start)));
                this.mBaseLayer.setStops(xStops, yStops);
                this.mBaseLayer.setPosition((float)xPos + shift, (float)yPos);
                if (start > 0) {
                    int leftEnd = start;
                    int leftStart = colspan.keyAt(centerIndex - 1);
                    int leftXStops = 2 + (leftEnd - leftStart);
                    int leftXPos = current - leftStart;
                    this.mFadingLayer.setDrawable(this.getDrawable((ImageReference)colspan.get(leftStart)));
                    this.mFadingLayer.setStops(leftXStops, yStops);
                    this.mFadingLayer.setPosition((float)leftXPos + offset, (float)yPos);
                    this.mBackground.setProgress(Math.abs(shift));
                } else {
                    this.mFadingLayer.setDrawable(EMPTY_BACKGROUND);
                }
            }
        }
    }

    private ImageReference getBackground(int row, int column) {
        ImageReference ref = null;
        SparseArray colspan = (SparseArray)this.mColSpans.get(row);
        if (colspan.size() > 0) {
            int pos = this.floorIndex((SparseArray<ImageReference>)colspan, column);
            ref = (ImageReference)colspan.valueAt(pos);
        }
        return ref;
    }

    private int getHorizontalStopCount(int row, int column) {
        SparseArray colspan = (SparseArray)this.mColSpans.get(row);
        int index = this.floorIndex((SparseArray<ImageReference>)colspan, column);
        int start = colspan.keyAt(index);
        int end = index < colspan.size() - 1 ? colspan.keyAt(index + 1) : this.mAdapter.getColumnCount(row);
        return 2 + (end - start);
    }

    public void onVerticalScroll(int row, float offset) {
        if (Math.abs(offset) >= 1.0f) {
            row = (int)((double)row + Math.floor(offset));
            offset -= (float)((int)offset);
        }
        if (this.mCurrentRow - row > 2) {
            this.mCurrentRow = row + 1;
        } else if (row > this.mCurrentRow) {
            this.mCurrentRow = row;
        }
        boolean up = row < this.mCurrentRow;
        float shift = up ? 0.0f - (1.0f - offset) : offset;
        int rows = this.mAdapter.getRowCount();
        ImageReference ref = this.getBackground(this.mCurrentRow, this.mCurrentColumn);
        this.mBaseLayer.setDrawable(this.getDrawable(ref));
        this.mBaseLayer.setHorizontalStops(this.getHorizontalStopCount(this.mCurrentRow, this.mCurrentColumn));
        this.mBaseLayer.setVerticalPosition(1.0f + shift);
        if (shift < 0.0f && this.mCurrentRow > 0) {
            int colAbove = this.mAdapter.getCurrentColumnForRow(this.mCurrentRow - 1, this.mCurrentColumn);
            ImageReference aboveRef = this.getBackground(this.mCurrentRow - 1, colAbove);
            this.mFadingLayer.setDrawable(this.getDrawable(aboveRef));
            this.mFadingLayer.setVerticalPosition(2.0f + shift);
            this.mFadingLayer.setHorizontalStops(this.getHorizontalStopCount(this.mCurrentRow - 1, colAbove));
            this.mBackground.setProgress(Math.abs(shift));
        } else if (shift > 0.0f && this.mCurrentRow < rows - 1) {
            int colBelow = this.mAdapter.getCurrentColumnForRow(this.mCurrentRow + 1, this.mCurrentColumn);
            ImageReference belowRef = this.getBackground(this.mCurrentRow + 1, colBelow);
            this.mFadingLayer.setDrawable(this.getDrawable(belowRef));
            this.mFadingLayer.setVerticalPosition(shift);
            this.mFadingLayer.setHorizontalStops(this.getHorizontalStopCount(this.mCurrentRow + 1, colBelow));
            this.mBackground.setProgress(shift);
        } else {
            this.mBackground.setProgress(0.0f);
            this.mFadingLayer.setDrawable(EMPTY_BACKGROUND);
        }
    }

    private Drawable getDrawable(ImageReference ref) {
        Drawable drawable2 = EMPTY_BACKGROUND;
        if (ref != null && (drawable2 = (Drawable)this.mImageCache.get((Object)ref)) == null) {
            if (ref.getBitmap() != null) {
                drawable2 = new BitmapDrawable(this.mContext.getResources(), ref.getBitmap());
            }
            if (ref.getDrawableResId() != 0) {
                drawable2 = this.mContext.getResources().getDrawable(ref.getDrawableResId());
            }
            if (ref.getImageUri() != null) {
                throw new UnsupportedOperationException("Uri loading not yet implemented!");
            }
            if (drawable2 != null) {
                this.mImageCache.put((Object)ref, (Object)drawable2);
            }
        }
        return drawable2;
    }
}

