/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.activity;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.wearable.view.DismissOverlayView;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.widget.FrameLayout;
import org.xmlpull.v1.XmlPullParser;

public abstract class InsetActivity
extends Activity {
    private InsetView mInsetView;
    private DismissOverlayView mDismissOverlay;

    protected void onCreate(Bundle state) {
        super.onCreate(state);
        Window window = this.getWindow();
        ViewGroup decor = (ViewGroup)window.getDecorView();
        this.mDismissOverlay = new DismissOverlayView((Context)this);
        this.mDismissOverlay.setVisibility(8);
        this.mInsetView = new InsetView((Context)this);
        super.setContentView((View)this.mInsetView);
        decor.setOnApplyWindowInsetsListener((View.OnApplyWindowInsetsListener)this.mInsetView);
        decor.setFitsSystemWindows(true);
        decor.requestApplyInsets();
    }

    public boolean isRound() {
        this.checkInsetsApplied();
        return this.mInsetView.isRound();
    }

    public Rect getSystemInsets() {
        this.checkInsetsApplied();
        return this.mInsetView.getInsets();
    }

    public abstract void onReadyForContent();

    public void setContentView(int layoutResID) {
        this.checkInsetsApplied();
        this.getLayoutInflater().inflate((XmlPullParser)this.getResources().getLayout(layoutResID), (ViewGroup)this.mInsetView, true);
        this.mInsetView.addView((View)this.mDismissOverlay);
    }

    public void setContentView(View view) {
        this.checkInsetsApplied();
        this.mInsetView.addView(view);
        this.mInsetView.addView((View)this.mDismissOverlay);
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        this.checkInsetsApplied();
        this.mInsetView.addView(view, params);
        this.mInsetView.addView((View)this.mDismissOverlay);
    }

    private void checkInsetsApplied() {
        if (!this.mInsetView.isReady()) {
            throw new IllegalStateException("method called before onReadyForContent");
        }
    }

    private class InsetView
    extends FrameLayout
    implements View.OnApplyWindowInsetsListener {
        private GestureDetector mGestureDetector;
        private boolean mIsRound;
        private boolean mInsetsApplied;
        private Rect mInsets;

        InsetView(Context ctx) {
            super(ctx);
            this.mInsets = new Rect();
            this.mGestureDetector = new GestureDetector(ctx, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                public void onLongPress(MotionEvent ev) {
                    InsetActivity.this.mDismissOverlay.setAlpha(0.0f);
                    InsetActivity.this.mDismissOverlay.setVisibility(0);
                    InsetActivity.this.mDismissOverlay.animate().alpha(1.0f).setDuration(200L).start();
                }
            });
            this.setOnApplyWindowInsetsListener(this);
        }

        private boolean isRound() {
            return this.mIsRound;
        }

        private Rect getInsets() {
            return this.mInsets;
        }

        private boolean isReady() {
            return this.mInsetsApplied;
        }

        public WindowInsets onApplyWindowInsets(View v, WindowInsets insets) {
            if (!this.mInsetsApplied) {
                if (insets.isRound()) {
                    this.mIsRound = true;
                    this.mInsets.set(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
                }
                this.mInsetsApplied = true;
                InsetActivity.this.onReadyForContent();
            }
            return insets.consumeSystemWindowInsets();
        }

        public boolean onInterceptTouchEvent(MotionEvent ev) {
            return this.mGestureDetector.onTouchEvent(ev) || super.onInterceptTouchEvent(ev);
        }
    }
}

