/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.database.Observable;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.Pools;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.EdgeEffectCompat;
import android.support.v4.widget.ScrollerCompat;
import android.support.v7.widget.DefaultItemAnimator;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.FocusFinder;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Interpolator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RecyclerView
extends ViewGroup {
    private static final String TAG = "RecyclerView";
    private static final boolean DEBUG = false;
    private static final boolean DISPATCH_TEMP_DETACH = false;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int NO_POSITION = -1;
    public static final long NO_ID = -1L;
    public static final int INVALID_TYPE = -1;
    private static final int MAX_SCROLL_DURATION = 2000;
    private final RecyclerViewDataObserver mObserver = new RecyclerViewDataObserver();
    private final Recycler mRecycler = new Recycler();
    private SavedState mPendingSavedState;
    private final Runnable mUpdateChildViewsRunnable = new Runnable(){

        @Override
        public void run() {
            RecyclerView.this.eatRequestLayout();
            RecyclerView.this.updateChildViews();
            RecyclerView.this.resumeRequestLayout(true);
        }
    };
    private final Rect mTempRect = new Rect();
    private final ArrayList<UpdateOp> mPendingUpdates = new ArrayList();
    private final ArrayList<UpdateOp> mPendingLayoutUpdates = new ArrayList();
    private Pools.Pool<UpdateOp> mUpdateOpPool = new Pools.SimplePool(30);
    private Adapter mAdapter;
    private LayoutManager mLayout;
    private RecyclerListener mRecyclerListener;
    private final ArrayList<ItemDecoration> mItemDecorations = new ArrayList();
    private final ArrayList<OnItemTouchListener> mOnItemTouchListeners = new ArrayList();
    private OnItemTouchListener mActiveOnItemTouchListener;
    private boolean mIsAttached;
    private boolean mHasFixedSize;
    private boolean mFirstLayoutComplete;
    private boolean mEatRequestLayout;
    private boolean mLayoutRequestEaten;
    private boolean mAdapterUpdateDuringMeasure;
    private final boolean mPostUpdatesOnAnimation;
    private EdgeEffectCompat mLeftGlow;
    private EdgeEffectCompat mTopGlow;
    private EdgeEffectCompat mRightGlow;
    private EdgeEffectCompat mBottomGlow;
    ItemAnimator mItemAnimator = new DefaultItemAnimator();
    private static final int INVALID_POINTER = -1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    private int mScrollState = 0;
    private int mScrollPointerId = -1;
    private VelocityTracker mVelocityTracker;
    private int mInitialTouchX;
    private int mInitialTouchY;
    private int mLastTouchX;
    private int mLastTouchY;
    private final int mTouchSlop;
    private final int mMinFlingVelocity;
    private final int mMaxFlingVelocity;
    private final ViewFlinger mViewFlinger = new ViewFlinger();
    private final State mState = new State();
    private OnScrollListener mScrollListener;
    boolean mItemsAddedOrRemoved = false;
    boolean mItemsChanged = false;
    int mAnimatingViewIndex = -1;
    int mNumAnimatingViews = 0;
    boolean mInPreLayout = false;
    private ItemAnimator.ItemAnimatorListener mItemAnimatorListener = new ItemAnimatorRestoreListener();
    private boolean mPostedAnimatorRunner = false;
    private Runnable mItemAnimatorRunner = new Runnable(){

        @Override
        public void run() {
            if (RecyclerView.this.mItemAnimator != null) {
                RecyclerView.this.mItemAnimator.runPendingAnimations();
            }
            RecyclerView.this.mPostedAnimatorRunner = false;
        }
    };
    private static final Interpolator sQuinticInterpolator = new Interpolator(){

        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * t * t * t + 1.0f;
        }
    };

    public RecyclerView(Context context) {
        this(context, null);
    }

    public RecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int version = Build.VERSION.SDK_INT;
        this.mPostUpdatesOnAnimation = version >= 16;
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.mTouchSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.setWillNotDraw(ViewCompat.getOverScrollMode((View)this) == 2);
        this.mItemAnimator.setListener(this.mItemAnimatorListener);
    }

    public void setHasFixedSize(boolean hasFixedSize) {
        this.mHasFixedSize = hasFixedSize;
    }

    public boolean hasFixedSize() {
        return this.mHasFixedSize;
    }

    public void setAdapter(Adapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterAdapterDataObserver(this.mObserver);
        }
        Adapter oldAdapter = this.mAdapter;
        this.mAdapter = adapter;
        if (adapter != null) {
            adapter.registerAdapterDataObserver(this.mObserver);
        }
        if (this.mLayout != null) {
            this.mLayout.onAdapterChanged(oldAdapter, this.mAdapter);
        }
        this.mRecycler.onAdapterChanged(oldAdapter, this.mAdapter);
        this.mState.mStructureChanged = true;
        this.markKnownViewsInvalid();
        this.requestLayout();
    }

    public Adapter getAdapter() {
        return this.mAdapter;
    }

    public void setRecyclerListener(RecyclerListener listener) {
        this.mRecyclerListener = listener;
    }

    public void setLayoutManager(LayoutManager layout) {
        if (layout == this.mLayout) {
            return;
        }
        this.mRecycler.clear();
        this.removeAllViews();
        if (this.mLayout != null) {
            if (this.mIsAttached) {
                this.mLayout.onDetachedFromWindow(this);
            }
            this.mLayout.mRecyclerView = null;
        }
        this.mLayout = layout;
        if (layout != null) {
            if (layout.mRecyclerView != null) {
                throw new IllegalArgumentException("LayoutManager " + layout + " is already attached to a RecyclerView: " + (Object)((Object)layout.mRecyclerView));
            }
            layout.mRecyclerView = this;
            if (this.mIsAttached) {
                this.mLayout.onAttachedToWindow(this);
            }
        }
        this.requestLayout();
    }

    protected Parcelable onSaveInstanceState() {
        SavedState state = new SavedState(super.onSaveInstanceState());
        if (this.mPendingSavedState != null) {
            state.copyFrom(this.mPendingSavedState);
        } else {
            state.mLayoutState = this.mLayout != null ? this.mLayout.onSaveInstanceState() : null;
        }
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        this.mPendingSavedState = (SavedState)state;
        super.onRestoreInstanceState(this.mPendingSavedState.getSuperState());
        if (this.mLayout != null && this.mPendingSavedState.mLayoutState != null) {
            this.mLayout.onRestoreInstanceState(this.mPendingSavedState.mLayoutState);
        }
    }

    private void addAnimatingView(View view) {
        boolean alreadyAdded = false;
        if (this.mNumAnimatingViews > 0) {
            for (int i = this.mAnimatingViewIndex; i < this.getChildCount(); ++i) {
                if (this.getChildAt(i) != view) continue;
                alreadyAdded = true;
                break;
            }
        }
        if (!alreadyAdded) {
            if (this.mNumAnimatingViews == 0) {
                this.mAnimatingViewIndex = this.getChildCount();
            }
            ++this.mNumAnimatingViews;
            this.addView(view);
        }
        this.mRecycler.unscrapView(this.getChildViewHolder(view));
    }

    private void removeAnimatingView(View view) {
        if (this.mNumAnimatingViews > 0) {
            for (int i = this.mAnimatingViewIndex; i < this.getChildCount(); ++i) {
                if (this.getChildAt(i) != view) continue;
                this.removeViewAt(i);
                --this.mNumAnimatingViews;
                if (this.mNumAnimatingViews == 0) {
                    this.mAnimatingViewIndex = -1;
                }
                this.mRecycler.recycleView(view);
                return;
            }
        }
    }

    private View getAnimatingView(int position, int type) {
        if (this.mNumAnimatingViews > 0) {
            for (int i = this.mAnimatingViewIndex; i < this.getChildCount(); ++i) {
                View view = this.getChildAt(i);
                ViewHolder holder = this.getChildViewHolder(view);
                if (holder.getPosition() != position || holder.getItemViewType() != type) continue;
                return view;
            }
        }
        return null;
    }

    public LayoutManager getLayoutManager() {
        return this.mLayout;
    }

    public RecycledViewPool getRecycledViewPool() {
        return this.mRecycler.getRecycledViewPool();
    }

    public void setRecycledViewPool(RecycledViewPool pool) {
        this.mRecycler.setRecycledViewPool(pool);
    }

    public void setItemViewCacheSize(int size) {
        this.mRecycler.setViewCacheSize(size);
    }

    public int getScrollState() {
        return this.mScrollState;
    }

    private void setScrollState(int state) {
        if (state == this.mScrollState) {
            return;
        }
        this.mScrollState = state;
        if (state != 2) {
            this.stopScroll();
        }
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(state);
        }
    }

    public void addItemDecoration(ItemDecoration decor, int index) {
        if (this.mItemDecorations.isEmpty()) {
            this.setWillNotDraw(false);
        }
        if (index < 0) {
            this.mItemDecorations.add(decor);
        } else {
            this.mItemDecorations.add(index, decor);
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    public void addItemDecoration(ItemDecoration decor) {
        this.addItemDecoration(decor, -1);
    }

    public void removeItemDecoration(ItemDecoration decor) {
        this.mItemDecorations.remove(decor);
        if (this.mItemDecorations.isEmpty()) {
            this.setWillNotDraw(ViewCompat.getOverScrollMode((View)this) == 2);
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    public void setOnScrollListener(OnScrollListener listener) {
        this.mScrollListener = listener;
    }

    public void scrollToPosition(int position) {
        this.stopScroll();
        this.mLayout.scrollToPosition(position);
        this.awakenScrollBars();
    }

    public void smoothScrollToPosition(int position) {
        this.mLayout.smoothScrollToPosition(this, this.mState, position);
    }

    public void scrollTo(int x, int y) {
        throw new UnsupportedOperationException("RecyclerView does not support scrolling to an absolute position.");
    }

    public void scrollBy(int x, int y) {
        if (this.mLayout == null) {
            throw new IllegalStateException("Cannot scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
        }
        boolean canScrollHorizontal = this.mLayout.canScrollHorizontally();
        boolean canScrollVertical = this.mLayout.canScrollVertically();
        if (canScrollHorizontal || canScrollVertical) {
            this.scrollByInternal(canScrollHorizontal ? x : 0, canScrollVertical ? y : 0);
        }
    }

    void scrollByInternal(int x, int y) {
        if (this.mItemAnimator != null) {
            this.mItemAnimator.endAnimations();
        }
        int overscrollX = 0;
        int overscrollY = 0;
        if (this.mAdapter != null) {
            this.eatRequestLayout();
            if (x != 0) {
                int hresult = this.mLayout.scrollHorizontallyBy(x, this.mRecycler, this.mState);
                overscrollX = x - hresult;
            }
            if (y != 0) {
                int vresult = this.mLayout.scrollVerticallyBy(y, this.mRecycler, this.mState);
                overscrollY = y - vresult;
            }
            this.resumeRequestLayout(false);
        }
        if (!this.mItemDecorations.isEmpty()) {
            this.invalidate();
        }
        if (ViewCompat.getOverScrollMode((View)this) != 2) {
            this.pullGlows(overscrollX, overscrollY);
        }
        if (this.mScrollListener != null && (x != 0 || y != 0)) {
            this.mScrollListener.onScrolled(x, y);
        }
        if (!this.awakenScrollBars()) {
            this.invalidate();
        }
    }

    protected int computeHorizontalScrollOffset() {
        return this.mLayout.canScrollHorizontally() ? this.mLayout.computeHorizontalScrollOffset(this.mState) : 0;
    }

    protected int computeHorizontalScrollExtent() {
        return this.mLayout.canScrollHorizontally() ? this.mLayout.computeHorizontalScrollExtent(this.mState) : 0;
    }

    protected int computeHorizontalScrollRange() {
        return this.mLayout.canScrollHorizontally() ? this.mLayout.computeHorizontalScrollRange(this.mState) : 0;
    }

    protected int computeVerticalScrollOffset() {
        return this.mLayout.canScrollVertically() ? this.mLayout.computeVerticalScrollOffset(this.mState) : 0;
    }

    protected int computeVerticalScrollExtent() {
        return this.mLayout.canScrollVertically() ? this.mLayout.computeVerticalScrollExtent(this.mState) : 0;
    }

    protected int computeVerticalScrollRange() {
        return this.mLayout.canScrollVertically() ? this.mLayout.computeVerticalScrollRange(this.mState) : 0;
    }

    void eatRequestLayout() {
        if (!this.mEatRequestLayout) {
            this.mEatRequestLayout = true;
            this.mLayoutRequestEaten = false;
        }
    }

    void resumeRequestLayout(boolean performLayoutChildren) {
        if (this.mEatRequestLayout) {
            if (performLayoutChildren && this.mLayoutRequestEaten && this.mLayout != null && this.mAdapter != null) {
                this.dispatchLayout();
            }
            this.mEatRequestLayout = false;
            this.mLayoutRequestEaten = false;
        }
    }

    public void smoothScrollBy(int dx, int dy) {
        if (dx != 0 || dy != 0) {
            this.mViewFlinger.smoothScrollBy(dx, dy);
        }
    }

    public boolean fling(int velocityX, int velocityY) {
        if (Math.abs(velocityX) < this.mMinFlingVelocity) {
            velocityX = 0;
        }
        if (Math.abs(velocityY) < this.mMinFlingVelocity) {
            velocityY = 0;
        }
        velocityX = Math.max(-this.mMaxFlingVelocity, Math.min(velocityX, this.mMaxFlingVelocity));
        velocityY = Math.max(-this.mMaxFlingVelocity, Math.min(velocityY, this.mMaxFlingVelocity));
        if (velocityX != 0 || velocityY != 0) {
            this.mViewFlinger.fling(velocityX, velocityY);
            return true;
        }
        return false;
    }

    public void stopScroll() {
        this.mViewFlinger.stop();
        this.mLayout.stopSmoothScroller();
    }

    private void pullGlows(int overscrollX, int overscrollY) {
        if (overscrollX < 0) {
            if (this.mLeftGlow == null) {
                this.mLeftGlow = new EdgeEffectCompat(this.getContext());
                this.mLeftGlow.setSize(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
            }
            this.mLeftGlow.onPull((float)(-overscrollX) / (float)this.getWidth());
        } else if (overscrollX > 0) {
            if (this.mRightGlow == null) {
                this.mRightGlow = new EdgeEffectCompat(this.getContext());
                this.mRightGlow.setSize(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
            }
            this.mRightGlow.onPull((float)overscrollX / (float)this.getWidth());
        }
        if (overscrollY < 0) {
            if (this.mTopGlow == null) {
                this.mTopGlow = new EdgeEffectCompat(this.getContext());
                this.mTopGlow.setSize(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
            }
            this.mTopGlow.onPull((float)(-overscrollY) / (float)this.getHeight());
        } else if (overscrollY > 0) {
            if (this.mBottomGlow == null) {
                this.mBottomGlow = new EdgeEffectCompat(this.getContext());
                this.mBottomGlow.setSize(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
            }
            this.mBottomGlow.onPull((float)overscrollY / (float)this.getHeight());
        }
        if (overscrollX != 0 || overscrollY != 0) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private void releaseGlows() {
        boolean needsInvalidate = false;
        if (this.mLeftGlow != null) {
            needsInvalidate = this.mLeftGlow.onRelease();
        }
        if (this.mTopGlow != null) {
            needsInvalidate |= this.mTopGlow.onRelease();
        }
        if (this.mRightGlow != null) {
            needsInvalidate |= this.mRightGlow.onRelease();
        }
        if (this.mBottomGlow != null) {
            needsInvalidate |= this.mBottomGlow.onRelease();
        }
        if (needsInvalidate) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    void absorbGlows(int velocityX, int velocityY) {
        if (velocityX < 0) {
            if (this.mLeftGlow == null) {
                this.mLeftGlow = new EdgeEffectCompat(this.getContext());
                this.mLeftGlow.setSize(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
            }
            this.mLeftGlow.onAbsorb(-velocityX);
        } else if (velocityX > 0) {
            if (this.mRightGlow == null) {
                this.mRightGlow = new EdgeEffectCompat(this.getContext());
                this.mRightGlow.setSize(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
            }
            this.mRightGlow.onAbsorb(velocityX);
        }
        if (velocityY < 0) {
            if (this.mTopGlow == null) {
                this.mTopGlow = new EdgeEffectCompat(this.getContext());
                this.mTopGlow.setSize(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
            }
            this.mTopGlow.onAbsorb(-velocityY);
        } else if (velocityY > 0) {
            if (this.mBottomGlow == null) {
                this.mBottomGlow = new EdgeEffectCompat(this.getContext());
                this.mBottomGlow.setSize(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
            }
            this.mBottomGlow.onAbsorb(velocityY);
        }
        if (velocityX != 0 || velocityY != 0) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public View focusSearch(View focused, int direction) {
        View result = this.mLayout.onInterceptFocusSearch(focused, direction);
        if (result != null) {
            return result;
        }
        FocusFinder ff = FocusFinder.getInstance();
        result = ff.findNextFocus((ViewGroup)this, focused, direction);
        if (result == null && this.mAdapter != null) {
            this.eatRequestLayout();
            result = this.mLayout.onFocusSearchFailed(focused, direction, this.mRecycler, this.mState);
            this.resumeRequestLayout(false);
        }
        return result != null ? result : super.focusSearch(focused, direction);
    }

    public void requestChildFocus(View child, View focused) {
        if (!this.mLayout.onRequestChildFocus(this, child, focused)) {
            this.mTempRect.set(0, 0, focused.getWidth(), focused.getHeight());
            this.offsetDescendantRectToMyCoords(focused, this.mTempRect);
            this.offsetRectIntoDescendantCoords(child, this.mTempRect);
            this.requestChildRectangleOnScreen(child, this.mTempRect, !this.mFirstLayoutComplete);
        }
        super.requestChildFocus(child, focused);
    }

    public boolean requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
        return this.mLayout.requestChildRectangleOnScreen(this, child, rect, immediate);
    }

    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        if (!this.mLayout.onAddFocusables(this, views, direction, focusableMode)) {
            super.addFocusables(views, direction, focusableMode);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsAttached = true;
        this.mFirstLayoutComplete = false;
        if (this.mLayout != null) {
            this.mLayout.onAttachedToWindow(this);
        }
        this.mPostedAnimatorRunner = false;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mFirstLayoutComplete = false;
        this.stopScroll();
        this.mIsAttached = false;
        if (this.mLayout != null) {
            this.mLayout.onDetachedFromWindow(this);
        }
        this.removeCallbacks(this.mItemAnimatorRunner);
    }

    public void addOnItemTouchListener(OnItemTouchListener listener) {
        this.mOnItemTouchListeners.add(listener);
    }

    public void removeOnItemTouchListener(OnItemTouchListener listener) {
        this.mOnItemTouchListeners.remove(listener);
        if (this.mActiveOnItemTouchListener == listener) {
            this.mActiveOnItemTouchListener = null;
        }
    }

    private boolean dispatchOnItemTouchIntercept(MotionEvent e) {
        int action = e.getAction();
        if (action == 3 || action == 0) {
            this.mActiveOnItemTouchListener = null;
        }
        int listenerCount = this.mOnItemTouchListeners.size();
        for (int i = 0; i < listenerCount; ++i) {
            OnItemTouchListener listener = this.mOnItemTouchListeners.get(i);
            if (!listener.onInterceptTouchEvent(this, e) || action == 3) continue;
            this.mActiveOnItemTouchListener = listener;
            return true;
        }
        return false;
    }

    private boolean dispatchOnItemTouch(MotionEvent e) {
        int action = e.getAction();
        if (this.mActiveOnItemTouchListener != null) {
            if (action == 0) {
                this.mActiveOnItemTouchListener = null;
            } else {
                this.mActiveOnItemTouchListener.onTouchEvent(this, e);
                if (action == 3 || action == 1) {
                    this.mActiveOnItemTouchListener = null;
                }
                return true;
            }
        }
        if (action != 0) {
            int listenerCount = this.mOnItemTouchListeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                OnItemTouchListener listener = this.mOnItemTouchListeners.get(i);
                if (!listener.onInterceptTouchEvent(this, e)) continue;
                this.mActiveOnItemTouchListener = listener;
                return true;
            }
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        if (this.dispatchOnItemTouchIntercept(e)) {
            this.cancelTouch();
            return true;
        }
        boolean canScrollHorizontally = this.mLayout.canScrollHorizontally();
        boolean canScrollVertically = this.mLayout.canScrollVertically();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(e);
        int action = MotionEventCompat.getActionMasked((MotionEvent)e);
        int actionIndex = MotionEventCompat.getActionIndex((MotionEvent)e);
        switch (action) {
            case 0: {
                this.mScrollPointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)0);
                this.mInitialTouchX = this.mLastTouchX = (int)(e.getX() + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(e.getY() + 0.5f);
                if (this.mScrollState != 2) break;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.setScrollState(1);
                break;
            }
            case 5: {
                this.mScrollPointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)actionIndex);
                this.mInitialTouchX = this.mLastTouchX = (int)(MotionEventCompat.getX((MotionEvent)e, (int)actionIndex) + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(MotionEventCompat.getY((MotionEvent)e, (int)actionIndex) + 0.5f);
                break;
            }
            case 2: {
                int index = MotionEventCompat.findPointerIndex((MotionEvent)e, (int)this.mScrollPointerId);
                if (index < 0) {
                    Log.e((String)TAG, (String)("Error processing scroll; pointer index for id " + this.mScrollPointerId + " not found. Did any MotionEvents get skipped?"));
                    return false;
                }
                int x = (int)(MotionEventCompat.getX((MotionEvent)e, (int)index) + 0.5f);
                int y = (int)(MotionEventCompat.getY((MotionEvent)e, (int)index) + 0.5f);
                if (this.mScrollState == 1) break;
                int dx = x - this.mInitialTouchX;
                int dy = y - this.mInitialTouchY;
                boolean startScroll = false;
                if (canScrollHorizontally && Math.abs(dx) > this.mTouchSlop) {
                    this.mLastTouchX = this.mInitialTouchX + this.mTouchSlop * (dx < 0 ? -1 : 1);
                    startScroll = true;
                }
                if (canScrollVertically && Math.abs(dy) > this.mTouchSlop) {
                    this.mLastTouchY = this.mInitialTouchY + this.mTouchSlop * (dy < 0 ? -1 : 1);
                    startScroll = true;
                }
                if (!startScroll) break;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.setScrollState(1);
                break;
            }
            case 6: {
                this.onPointerUp(e);
                break;
            }
            case 1: {
                this.mVelocityTracker.clear();
                break;
            }
            case 3: {
                this.cancelTouch();
            }
        }
        return this.mScrollState == 1;
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (this.dispatchOnItemTouch(e)) {
            this.cancelTouch();
            return true;
        }
        boolean canScrollHorizontally = this.mLayout.canScrollHorizontally();
        boolean canScrollVertically = this.mLayout.canScrollVertically();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(e);
        int action = MotionEventCompat.getActionMasked((MotionEvent)e);
        int actionIndex = MotionEventCompat.getActionIndex((MotionEvent)e);
        switch (action) {
            case 0: {
                this.mScrollPointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)0);
                this.mInitialTouchX = this.mLastTouchX = (int)(e.getX() + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(e.getY() + 0.5f);
                break;
            }
            case 5: {
                this.mScrollPointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)actionIndex);
                this.mInitialTouchX = this.mLastTouchX = (int)(MotionEventCompat.getX((MotionEvent)e, (int)actionIndex) + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(MotionEventCompat.getY((MotionEvent)e, (int)actionIndex) + 0.5f);
                break;
            }
            case 2: {
                int dy;
                int dx;
                int index = MotionEventCompat.findPointerIndex((MotionEvent)e, (int)this.mScrollPointerId);
                if (index < 0) {
                    Log.e((String)TAG, (String)("Error processing scroll; pointer index for id " + this.mScrollPointerId + " not found. Did any MotionEvents get skipped?"));
                    return false;
                }
                int x = (int)(MotionEventCompat.getX((MotionEvent)e, (int)index) + 0.5f);
                int y = (int)(MotionEventCompat.getY((MotionEvent)e, (int)index) + 0.5f);
                if (this.mScrollState != 1) {
                    dx = x - this.mInitialTouchX;
                    dy = y - this.mInitialTouchY;
                    boolean startScroll = false;
                    if (canScrollHorizontally && Math.abs(dx) > this.mTouchSlop) {
                        this.mLastTouchX = this.mInitialTouchX + this.mTouchSlop * (dx < 0 ? -1 : 1);
                        startScroll = true;
                    }
                    if (canScrollVertically && Math.abs(dy) > this.mTouchSlop) {
                        this.mLastTouchY = this.mInitialTouchY + this.mTouchSlop * (dy < 0 ? -1 : 1);
                        startScroll = true;
                    }
                    if (startScroll) {
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                        this.setScrollState(1);
                    }
                }
                if (this.mScrollState == 1) {
                    dx = x - this.mLastTouchX;
                    dy = y - this.mLastTouchY;
                    this.scrollByInternal(canScrollHorizontally ? -dx : 0, canScrollVertically ? -dy : 0);
                }
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                break;
            }
            case 6: {
                this.onPointerUp(e);
                break;
            }
            case 1: {
                float yvel;
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxFlingVelocity);
                float xvel = canScrollHorizontally ? -VelocityTrackerCompat.getXVelocity((VelocityTracker)this.mVelocityTracker, (int)this.mScrollPointerId) : 0.0f;
                float f = yvel = canScrollVertically ? -VelocityTrackerCompat.getYVelocity((VelocityTracker)this.mVelocityTracker, (int)this.mScrollPointerId) : 0.0f;
                if (xvel == 0.0f && yvel == 0.0f || !this.fling((int)xvel, (int)yvel)) {
                    this.setScrollState(0);
                }
                this.mVelocityTracker.clear();
                this.releaseGlows();
                break;
            }
            case 3: {
                this.cancelTouch();
            }
        }
        return true;
    }

    private void cancelTouch() {
        this.mVelocityTracker.clear();
        this.releaseGlows();
        this.setScrollState(0);
    }

    private void onPointerUp(MotionEvent e) {
        int actionIndex = MotionEventCompat.getActionIndex((MotionEvent)e);
        if (MotionEventCompat.getPointerId((MotionEvent)e, (int)actionIndex) == this.mScrollPointerId) {
            int newIndex = actionIndex == 0 ? 1 : 0;
            this.mScrollPointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)newIndex);
            this.mInitialTouchX = this.mLastTouchX = (int)(MotionEventCompat.getX((MotionEvent)e, (int)newIndex) + 0.5f);
            this.mInitialTouchY = this.mLastTouchY = (int)(MotionEventCompat.getY((MotionEvent)e, (int)newIndex) + 0.5f);
        }
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        if (this.mAdapterUpdateDuringMeasure) {
            this.eatRequestLayout();
            this.updateChildViews();
            this.mAdapterUpdateDuringMeasure = false;
            this.resumeRequestLayout(false);
        }
        this.mLayout.onMeasure(widthSpec, heightSpec);
        int widthSize = this.getMeasuredWidth();
        int heightSize = this.getMeasuredHeight();
        if (this.mLeftGlow != null) {
            this.mLeftGlow.setSize(heightSize, widthSize);
        }
        if (this.mTopGlow != null) {
            this.mTopGlow.setSize(widthSize, heightSize);
        }
        if (this.mRightGlow != null) {
            this.mRightGlow.setSize(heightSize, widthSize);
        }
        if (this.mBottomGlow != null) {
            this.mBottomGlow.setSize(widthSize, heightSize);
        }
    }

    public void setItemAnimator(ItemAnimator animator) {
        if (this.mItemAnimator != null) {
            this.mItemAnimator.setListener(null);
        }
        this.mItemAnimator = animator;
        if (this.mItemAnimator != null) {
            this.mItemAnimator.setListener(this.mItemAnimatorListener);
        }
    }

    public ItemAnimator getItemAnimator() {
        return this.mItemAnimator;
    }

    private void postAnimationRunner() {
        if (!this.mPostedAnimatorRunner && this.mIsAttached) {
            ViewCompat.postOnAnimation((View)this, (Runnable)this.mItemAnimatorRunner);
            this.mPostedAnimatorRunner = true;
        }
    }

    private boolean itemAnimationsEnabled() {
        return this.mItemAnimator != null && this.mLayout.supportsItemAnimations();
    }

    void dispatchLayout() {
        int i;
        int count;
        if (this.mAdapter == null) {
            Log.e((String)TAG, (String)"No adapter attached; skipping layout");
            return;
        }
        this.eatRequestLayout();
        boolean animateChanges = this.itemAnimationsEnabled() && this.mItemsAddedOrRemoved && !this.mItemsChanged;
        this.mItemsChanged = false;
        this.mItemsAddedOrRemoved = false;
        ArrayMap appearingViewInitialBounds = null;
        this.mState.mInPreLayout = animateChanges;
        this.mState.mItemCount = this.mAdapter.getItemCount();
        if (animateChanges) {
            this.mState.mPreLayoutHolderMap.clear();
            this.mState.mPostLayoutHolderMap.clear();
            count = this.getChildCount();
            for (i = 0; i < count; ++i) {
                ViewHolder holder = RecyclerView.getChildViewHolderInt(this.getChildAt(i));
                View view = holder.itemView;
                this.mState.mPreLayoutHolderMap.put((Object)holder, (Object)new ItemHolderInfo(holder, view.getLeft(), view.getTop(), view.getRight(), view.getBottom(), holder.mPosition));
            }
            this.mInPreLayout = true;
            boolean didStructureChange = this.mState.mStructureChanged;
            this.mState.mStructureChanged = false;
            this.mLayout.onLayoutChildren(this.mRecycler, this.mState);
            this.mState.mStructureChanged = didStructureChange;
            this.mInPreLayout = false;
            appearingViewInitialBounds = new ArrayMap();
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                boolean found = false;
                View child = this.getChildAt(i2);
                for (int j = 0; j < this.mState.mPreLayoutHolderMap.size(); ++j) {
                    ViewHolder holder = (ViewHolder)this.mState.mPreLayoutHolderMap.keyAt(j);
                    if (holder.itemView != child) continue;
                    found = true;
                }
                if (found) continue;
                appearingViewInitialBounds.put((Object)child, (Object)new Rect(child.getLeft(), child.getTop(), child.getRight(), child.getBottom()));
            }
        }
        this.clearOldPositions();
        this.dispatchLayoutUpdates();
        this.mState.mItemCount = this.mAdapter.getItemCount();
        this.mState.mInPreLayout = false;
        this.mLayout.onLayoutChildren(this.mRecycler, this.mState);
        this.mState.mStructureChanged = false;
        this.mPendingSavedState = null;
        if (animateChanges) {
            count = this.getChildCount();
            for (i = 0; i < count; ++i) {
                ViewHolder holder = RecyclerView.getChildViewHolderInt(this.getChildAt(i));
                View view = holder.itemView;
                this.mState.mPostLayoutHolderMap.put((Object)holder, (Object)new ItemHolderInfo(holder, view.getLeft(), view.getTop(), view.getRight(), view.getBottom(), holder.mPosition));
            }
            int preLayoutCount = this.mState.mPreLayoutHolderMap.size();
            for (int i3 = preLayoutCount - 1; i3 >= 0; --i3) {
                ViewHolder itemHolder = (ViewHolder)this.mState.mPreLayoutHolderMap.keyAt(i3);
                if (this.mState.mPostLayoutHolderMap.containsKey((Object)itemHolder)) continue;
                ItemHolderInfo disappearingItem = (ItemHolderInfo)this.mState.mPreLayoutHolderMap.valueAt(i3);
                this.mState.mPreLayoutHolderMap.removeAt(i3);
                View disappearingItemView = disappearingItem.holder.itemView;
                this.removeDetachedView(disappearingItemView, false);
                this.mRecycler.unscrapView(disappearingItem.holder);
                this.animateDisappearance(disappearingItem);
            }
            int postLayoutCount = this.mState.mPostLayoutHolderMap.size();
            if (postLayoutCount > 0) {
                for (int i4 = postLayoutCount - 1; i4 >= 0; --i4) {
                    ViewHolder itemHolder = (ViewHolder)this.mState.mPostLayoutHolderMap.keyAt(i4);
                    ItemHolderInfo info = (ItemHolderInfo)this.mState.mPostLayoutHolderMap.valueAt(i4);
                    if (!this.mState.mPreLayoutHolderMap.isEmpty() && this.mState.mPreLayoutHolderMap.containsKey((Object)itemHolder)) continue;
                    this.mState.mPostLayoutHolderMap.removeAt(i4);
                    this.animateAppearance(itemHolder, (Rect)appearingViewInitialBounds.get((Object)itemHolder.itemView), info.left, info.top);
                }
            }
            count = this.mState.mPostLayoutHolderMap.size();
            for (int i5 = 0; i5 < count; ++i5) {
                ViewHolder postHolder = (ViewHolder)this.mState.mPostLayoutHolderMap.keyAt(i5);
                ItemHolderInfo postInfo = (ItemHolderInfo)this.mState.mPostLayoutHolderMap.valueAt(i5);
                ItemHolderInfo preInfo = (ItemHolderInfo)this.mState.mPreLayoutHolderMap.get((Object)postHolder);
                if (preInfo == null || postInfo == null || preInfo.left == postInfo.left && preInfo.top == postInfo.top) continue;
                postHolder.setIsRecyclable(false);
                if (!this.mItemAnimator.animateMove(postHolder, preInfo.left, preInfo.top, postInfo.left, postInfo.top)) continue;
                this.postAnimationRunner();
            }
        }
        this.resumeRequestLayout(false);
        this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
        this.mState.mPreviousLayoutItemCount = this.mState.mItemCount;
        this.mState.mDeletedInvisibleItemCountSincePreviousLayout = 0;
    }

    private void animateAppearance(ViewHolder itemHolder, Rect beforeBounds, int afterLeft, int afterTop) {
        View newItemView = itemHolder.itemView;
        if (beforeBounds != null && (beforeBounds.left != afterLeft || beforeBounds.top != afterTop)) {
            itemHolder.setIsRecyclable(false);
            if (this.mItemAnimator.animateMove(itemHolder, beforeBounds.left, beforeBounds.top, afterLeft, afterTop)) {
                this.postAnimationRunner();
            }
        } else {
            itemHolder.setIsRecyclable(false);
            if (this.mItemAnimator.animateAdd(itemHolder)) {
                this.postAnimationRunner();
            }
        }
    }

    private void animateDisappearance(ItemHolderInfo disappearingItem) {
        View disappearingItemView = disappearingItem.holder.itemView;
        this.addAnimatingView(disappearingItemView);
        int oldLeft = disappearingItem.left;
        int oldTop = disappearingItem.top;
        int newLeft = disappearingItemView.getLeft();
        int newTop = disappearingItemView.getTop();
        if (oldLeft != newLeft || oldTop != newTop) {
            disappearingItem.holder.setIsRecyclable(false);
            disappearingItemView.layout(newLeft, newTop, newLeft + disappearingItemView.getWidth(), newTop + disappearingItemView.getHeight());
            if (this.mItemAnimator.animateMove(disappearingItem.holder, oldLeft, oldTop, newLeft, newTop)) {
                this.postAnimationRunner();
            }
        } else if (this.mItemAnimator.animateRemove(disappearingItem.holder)) {
            this.postAnimationRunner();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.eatRequestLayout();
        this.dispatchLayout();
        this.resumeRequestLayout(false);
        this.mFirstLayoutComplete = true;
    }

    public void requestLayout() {
        if (!this.mEatRequestLayout) {
            super.requestLayout();
        } else {
            this.mLayoutRequestEaten = true;
        }
    }

    void markItemDecorInsetsDirty() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            ((LayoutParams)child.getLayoutParams()).mInsetsDirty = true;
        }
    }

    public void draw(Canvas c) {
        int restore;
        super.draw(c);
        int count = this.mItemDecorations.size();
        for (int i = 0; i < count; ++i) {
            this.mItemDecorations.get(i).onDrawOver(c, this);
        }
        boolean needsInvalidate = false;
        if (this.mLeftGlow != null && !this.mLeftGlow.isFinished()) {
            restore = c.save();
            c.rotate(270.0f);
            c.translate((float)(-this.getHeight() + this.getPaddingTop()), 0.0f);
            needsInvalidate = this.mLeftGlow != null && this.mLeftGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (this.mTopGlow != null && !this.mTopGlow.isFinished()) {
            c.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            needsInvalidate |= this.mTopGlow != null && this.mTopGlow.draw(c);
        }
        if (this.mRightGlow != null && !this.mRightGlow.isFinished()) {
            restore = c.save();
            int width = this.getWidth();
            c.rotate(90.0f);
            c.translate((float)(-this.getPaddingTop()), (float)(-width));
            needsInvalidate |= this.mRightGlow != null && this.mRightGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (this.mBottomGlow != null && !this.mBottomGlow.isFinished()) {
            restore = c.save();
            c.rotate(180.0f);
            c.translate((float)(-this.getWidth() + this.getPaddingLeft()), (float)(-this.getHeight() + this.getPaddingTop()));
            needsInvalidate |= this.mBottomGlow != null && this.mBottomGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (needsInvalidate) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void onDraw(Canvas c) {
        super.onDraw(c);
        int count = this.mItemDecorations.size();
        for (int i = 0; i < count; ++i) {
            this.mItemDecorations.get(i).onDraw(c, this);
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && this.mLayout.checkLayoutParams((LayoutParams)p);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager");
        }
        return this.mLayout.generateDefaultLayoutParams();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager");
        }
        return this.mLayout.generateLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager");
        }
        return this.mLayout.generateLayoutParams(p);
    }

    private int findPositionOffset(int position) {
        int offset = 0;
        int count = this.mPendingLayoutUpdates.size();
        for (int i = 0; i < count; ++i) {
            UpdateOp op = this.mPendingLayoutUpdates.get(i);
            if (op.positionStart > position) continue;
            if (op.cmd == 1) {
                offset -= op.itemCount;
                continue;
            }
            if (op.cmd != 0) continue;
            offset += op.itemCount;
        }
        return position + offset;
    }

    void dispatchLayoutUpdates() {
        int opCount = this.mPendingLayoutUpdates.size();
        for (int i = 0; i < opCount; ++i) {
            UpdateOp op = this.mPendingLayoutUpdates.get(i);
            switch (op.cmd) {
                case 0: {
                    this.mLayout.onItemsAdded(this, op.positionStart, op.itemCount);
                    break;
                }
                case 1: {
                    this.mLayout.onItemsRemoved(this, op.positionStart, op.itemCount);
                    break;
                }
            }
            this.recycleUpdateOp(op);
        }
        this.mPendingLayoutUpdates.clear();
    }

    void updateChildViews() {
        int opCount = this.mPendingUpdates.size();
        for (int i = 0; i < opCount; ++i) {
            UpdateOp op = this.mPendingUpdates.get(i);
            switch (op.cmd) {
                case 0: {
                    this.offsetPositionRecordsForInsert(op.positionStart, op.itemCount);
                    this.mItemsAddedOrRemoved = true;
                    break;
                }
                case 1: {
                    for (int j = 0; j < op.itemCount; ++j) {
                        ViewHolder holder = this.findViewHolderForPosition(op.positionStart + j, true);
                        if (holder != null) {
                            holder.setIsRecyclable(false);
                            continue;
                        }
                        this.mState.mDeletedInvisibleItemCountSincePreviousLayout++;
                    }
                    this.offsetPositionRecordsForRemove(op.positionStart, op.itemCount);
                    this.mItemsAddedOrRemoved = true;
                    break;
                }
                case 2: {
                    this.viewRangeUpdate(op.positionStart, op.itemCount);
                    this.mItemsChanged = true;
                }
            }
            this.mPendingLayoutUpdates.add(op);
        }
        this.mPendingUpdates.clear();
    }

    void clearOldPositions() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.getChildAt(i));
            holder.clearOldPosition();
        }
        this.mRecycler.clearOldPositions();
    }

    void offsetPositionRecordsForInsert(int positionStart, int itemCount) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.getChildAt(i));
            if (holder == null || holder.mPosition < positionStart) continue;
            holder.offsetPosition(itemCount);
            this.mState.mStructureChanged = true;
        }
        this.mRecycler.offsetPositionRecordsForInsert(positionStart, itemCount);
        this.requestLayout();
    }

    void offsetPositionRecordsForRemove(int positionStart, int itemCount) {
        int positionEnd = positionStart + itemCount;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.getChildAt(i));
            if (holder == null) continue;
            if (holder.mPosition >= positionEnd) {
                holder.offsetPosition(-itemCount);
                this.mState.mStructureChanged = true;
                continue;
            }
            if (holder.mPosition < positionStart) continue;
            holder.addFlags(8);
            this.mState.mStructureChanged = true;
        }
        this.mRecycler.offsetPositionRecordsForRemove(positionStart, itemCount);
        this.requestLayout();
    }

    void viewRangeUpdate(int positionStart, int itemCount) {
        int childCount = this.getChildCount();
        int positionEnd = positionStart + itemCount;
        for (int i = 0; i < childCount; ++i) {
            int position;
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.getChildAt(i));
            if (holder == null || (position = holder.getPosition()) < positionStart || position >= positionEnd) continue;
            holder.addFlags(2);
            this.mAdapter.bindViewHolder(holder, holder.getPosition());
        }
        this.mRecycler.viewRangeUpdate(positionStart, itemCount);
    }

    void markKnownViewsInvalid() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.getChildAt(i));
            if (holder == null) continue;
            holder.addFlags(6);
        }
        this.mRecycler.markKnownViewsInvalid();
    }

    void postAdapterUpdate(UpdateOp op) {
        this.mPendingUpdates.add(op);
        if (this.mPendingUpdates.size() == 1) {
            if (this.mPostUpdatesOnAnimation && this.mHasFixedSize && this.mIsAttached) {
                ViewCompat.postOnAnimation((View)this, (Runnable)this.mUpdateChildViewsRunnable);
            } else {
                this.mAdapterUpdateDuringMeasure = true;
                this.requestLayout();
            }
        }
    }

    public ViewHolder getChildViewHolder(View child) {
        ViewParent parent = child.getParent();
        if (parent != null && parent != this) {
            throw new IllegalArgumentException("View " + child + " is not a direct child of " + (Object)((Object)this));
        }
        return RecyclerView.getChildViewHolderInt(child);
    }

    static ViewHolder getChildViewHolderInt(View child) {
        if (child == null) {
            return null;
        }
        return ((LayoutParams)child.getLayoutParams()).mViewHolder;
    }

    public int getChildPosition(View child) {
        ViewHolder holder = RecyclerView.getChildViewHolderInt(child);
        return holder != null ? holder.getPosition() : -1;
    }

    public long getChildItemId(View child) {
        if (this.mAdapter == null || !this.mAdapter.hasStableIds()) {
            return -1L;
        }
        ViewHolder holder = RecyclerView.getChildViewHolderInt(child);
        return holder != null ? holder.getItemId() : -1L;
    }

    public ViewHolder findViewHolderForPosition(int position) {
        return this.findViewHolderForPosition(position, false);
    }

    ViewHolder findViewHolderForPosition(int position, boolean checkNewPosition) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.getChildAt(i));
            if (holder == null || !(checkNewPosition ? holder.mPosition == position : holder.getPosition() == position)) continue;
            return holder;
        }
        return this.mRecycler.findViewHolderForPosition(position);
    }

    public ViewHolder findViewHolderForItemId(long id) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(this.getChildAt(i));
            if (holder == null || holder.getItemId() != id) continue;
            return holder;
        }
        return this.mRecycler.findViewHolderForItemId(id);
    }

    public View findChildViewUnder(float x, float y) {
        int count = this.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            float translationX = ViewCompat.getTranslationX((View)child);
            float translationY = ViewCompat.getTranslationY((View)child);
            if (!(x >= (float)child.getLeft() + translationX) || !(x <= (float)child.getRight() + translationX) || !(y >= (float)child.getTop() + translationY) || !(y <= (float)child.getBottom() + translationY)) continue;
            return child;
        }
        return null;
    }

    public void offsetChildrenVertical(int dy) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.getChildAt(i).offsetTopAndBottom(dy);
        }
    }

    public void onChildAttachedToWindow(View child) {
    }

    public void onChildDetachedFromWindow(View child) {
    }

    public void offsetChildrenHorizontal(int dx) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.getChildAt(i).offsetLeftAndRight(dx);
        }
    }

    Rect getItemDecorInsetsForChild(View child) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (!lp.mInsetsDirty) {
            return lp.mDecorInsets;
        }
        Rect insets = lp.mDecorInsets;
        insets.set(0, 0, 0, 0);
        int decorCount = this.mItemDecorations.size();
        for (int i = 0; i < decorCount; ++i) {
            this.mTempRect.set(0, 0, 0, 0);
            this.mItemDecorations.get(i).getItemOffsets(this.mTempRect, lp.getViewPosition(), this);
            insets.left += this.mTempRect.left;
            insets.top += this.mTempRect.top;
            insets.right += this.mTempRect.right;
            insets.bottom += this.mTempRect.bottom;
        }
        lp.mInsetsDirty = false;
        return insets;
    }

    UpdateOp obtainUpdateOp(int cmd, int positionStart, int itemCount) {
        UpdateOp op = (UpdateOp)this.mUpdateOpPool.acquire();
        if (op == null) {
            op = new UpdateOp(cmd, positionStart, itemCount);
        } else {
            op.cmd = cmd;
            op.positionStart = positionStart;
            op.itemCount = itemCount;
        }
        return op;
    }

    void recycleUpdateOp(UpdateOp op) {
        this.mUpdateOpPool.release((Object)op);
    }

    private static class ItemHolderInfo {
        ViewHolder holder;
        int left;
        int top;
        int right;
        int bottom;
        int position;

        ItemHolderInfo(ViewHolder holder, int left, int top, int right, int bottom, int position) {
            this.holder = holder;
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.position = position;
        }
    }

    public static abstract class ItemAnimator {
        private ItemAnimatorListener mListener = null;
        private ArrayList<ItemAnimatorFinishedListener> mFinishedListeners = new ArrayList();
        private long mAddDuration = 120L;
        private long mRemoveDuration = 120L;
        private long mMoveDuration = 250L;

        public long getMoveDuration() {
            return this.mMoveDuration;
        }

        public void setMoveDuration(long moveDuration) {
            this.mMoveDuration = moveDuration;
        }

        public long getAddDuration() {
            return this.mAddDuration;
        }

        public void setAddDuration(long addDuration) {
            this.mAddDuration = addDuration;
        }

        public long getRemoveDuration() {
            return this.mRemoveDuration;
        }

        public void setRemoveDuration(long removeDuration) {
            this.mRemoveDuration = removeDuration;
        }

        void setListener(ItemAnimatorListener listener) {
            this.mListener = listener;
        }

        public abstract void runPendingAnimations();

        public abstract boolean animateRemove(ViewHolder var1);

        public abstract boolean animateAdd(ViewHolder var1);

        public abstract boolean animateMove(ViewHolder var1, int var2, int var3, int var4, int var5);

        public final void dispatchRemoveFinished(ViewHolder item) {
            if (this.mListener != null) {
                this.mListener.onRemoveFinished(item);
            }
        }

        public final void dispatchMoveFinished(ViewHolder item) {
            if (this.mListener != null) {
                this.mListener.onMoveFinished(item);
            }
        }

        public final void dispatchAddFinished(ViewHolder item) {
            if (this.mListener != null) {
                this.mListener.onAddFinished(item);
            }
        }

        public abstract void endAnimation(ViewHolder var1);

        public abstract void endAnimations();

        public abstract boolean isRunning();

        public final boolean isRunning(ItemAnimatorFinishedListener listener) {
            boolean running = this.isRunning();
            if (listener != null) {
                if (!running) {
                    listener.onAnimationsFinished();
                } else {
                    this.mFinishedListeners.add(listener);
                }
            }
            return running;
        }

        public final void dispatchAnimationsFinished() {
            int count = this.mFinishedListeners.size();
            for (int i = 0; i < count; ++i) {
                this.mFinishedListeners.get(i).onAnimationsFinished();
            }
            this.mFinishedListeners.clear();
        }

        public static interface ItemAnimatorFinishedListener {
            public void onAnimationsFinished();
        }

        private static interface ItemAnimatorListener {
            public void onRemoveFinished(ViewHolder var1);

            public void onAddFinished(ViewHolder var1);

            public void onMoveFinished(ViewHolder var1);
        }
    }

    private class ItemAnimatorRestoreListener
    implements ItemAnimator.ItemAnimatorListener {
        private ItemAnimatorRestoreListener() {
        }

        @Override
        public void onRemoveFinished(ViewHolder item) {
            item.setIsRecyclable(true);
            RecyclerView.this.removeAnimatingView(item.itemView);
            RecyclerView.this.removeDetachedView(item.itemView, false);
        }

        @Override
        public void onAddFinished(ViewHolder item) {
            item.setIsRecyclable(true);
            RecyclerView.this.removeAnimatingView(item.itemView);
        }

        @Override
        public void onMoveFinished(ViewHolder item) {
            item.setIsRecyclable(true);
            RecyclerView.this.removeAnimatingView(item.itemView);
        }
    }

    public static class State {
        private int mTargetPosition = -1;
        private ArrayMap<ViewHolder, ItemHolderInfo> mPreLayoutHolderMap = new ArrayMap();
        private ArrayMap<ViewHolder, ItemHolderInfo> mPostLayoutHolderMap = new ArrayMap();
        private SparseArray<Object> mData;
        private int mItemCount = 0;
        private int mPreviousLayoutItemCount = 0;
        private int mDeletedInvisibleItemCountSincePreviousLayout = 0;
        private boolean mStructureChanged = false;
        private boolean mInPreLayout = false;

        State reset() {
            this.mTargetPosition = -1;
            if (this.mData != null) {
                this.mData.clear();
            }
            this.mItemCount = 0;
            this.mStructureChanged = false;
            return this;
        }

        public boolean isPreLayout() {
            return this.mInPreLayout;
        }

        public void remove(int resourceId) {
            if (this.mData == null) {
                return;
            }
            this.mData.remove(resourceId);
        }

        public <T> T get(int resourceId) {
            if (this.mData == null) {
                return null;
            }
            return (T)this.mData.get(resourceId);
        }

        public void put(int resourceId, Object data) {
            if (this.mData == null) {
                this.mData = new SparseArray();
            }
            this.mData.put(resourceId, data);
        }

        public int getTargetScrollPosition() {
            return this.mTargetPosition;
        }

        public boolean hasTargetScrollPosition() {
            return this.mTargetPosition != -1;
        }

        public boolean didStructureChange() {
            return this.mStructureChanged;
        }

        public int getItemCount() {
            return this.mInPreLayout ? this.mPreviousLayoutItemCount - this.mDeletedInvisibleItemCountSincePreviousLayout : this.mItemCount;
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        Parcelable mLayoutState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcel in) {
            super(in);
            this.mLayoutState = in.readParcelable(LayoutManager.class.getClassLoader());
        }

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.mLayoutState, 0);
        }

        private void copyFrom(SavedState other) {
            this.mLayoutState = other.mLayoutState;
        }
    }

    static class AdapterDataObservable
    extends Observable<AdapterDataObserver> {
        AdapterDataObservable() {
        }

        public boolean hasObservers() {
            return !this.mObservers.isEmpty();
        }

        public void notifyChanged() {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onChanged();
            }
        }

        public void notifyItemRangeChanged(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeChanged(positionStart, itemCount);
            }
        }

        public void notifyItemRangeInserted(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeInserted(positionStart, itemCount);
            }
        }

        public void notifyItemRangeRemoved(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeRemoved(positionStart, itemCount);
            }
        }
    }

    public static abstract class SmoothScroller {
        private int mTargetPosition = -1;
        private RecyclerView mRecyclerView;
        private LayoutManager mLayoutManager;
        private boolean mPendingInitialRun;
        private boolean mRunning;
        private View mTargetView;
        private final Action mRecyclingAction = new Action(0, 0);

        void start(RecyclerView recyclerView, LayoutManager layoutManager) {
            this.mRecyclerView = recyclerView;
            this.mLayoutManager = layoutManager;
            if (this.mTargetPosition == -1) {
                throw new IllegalArgumentException("Invalid target position");
            }
            this.mRecyclerView.mState.mTargetPosition = this.mTargetPosition;
            this.mRunning = true;
            this.mPendingInitialRun = true;
            this.mTargetView = this.findViewByPosition(this.getTargetPosition());
            this.onStart();
            this.mRecyclerView.mViewFlinger.postOnAnimation();
        }

        public void setTargetPosition(int targetPosition) {
            this.mTargetPosition = targetPosition;
        }

        public LayoutManager getLayoutManager() {
            return this.mLayoutManager;
        }

        protected final void stop() {
            if (!this.mRunning) {
                return;
            }
            this.onStop();
            this.mRecyclerView.mState.mTargetPosition = -1;
            this.mTargetView = null;
            this.mTargetPosition = -1;
            this.mPendingInitialRun = false;
            this.mRunning = false;
            this.mLayoutManager.onSmoothScrollerStopped(this);
            this.mLayoutManager = null;
            this.mRecyclerView = null;
        }

        public boolean isPendingInitialRun() {
            return this.mPendingInitialRun;
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        public int getTargetPosition() {
            return this.mTargetPosition;
        }

        private void onAnimation(int dx, int dy) {
            if (!this.mRunning || this.mTargetPosition == -1) {
                this.stop();
            }
            this.mPendingInitialRun = false;
            if (this.mTargetView != null) {
                if (this.getChildPosition(this.mTargetView) == this.mTargetPosition) {
                    this.onTargetFound(this.mTargetView, this.mRecyclerView.mState, this.mRecyclingAction);
                    this.mRecyclingAction.runInNecessary(this.mRecyclerView);
                    this.stop();
                } else {
                    Log.e((String)RecyclerView.TAG, (String)"Passed over target position while smooth scrolling.");
                    this.mTargetView = null;
                }
            }
            if (this.mRunning) {
                this.onSeekTargetStep(dx, dy, this.mRecyclerView.mState, this.mRecyclingAction);
                this.mRecyclingAction.runInNecessary(this.mRecyclerView);
            }
        }

        public int getChildPosition(View view) {
            return this.mRecyclerView.getChildPosition(view);
        }

        public int getChildCount() {
            return this.mRecyclerView.getChildCount();
        }

        public View findViewByPosition(int position) {
            return this.mRecyclerView.mLayout.findViewByPosition(position);
        }

        public void instantScrollToPosition(int position) {
            this.mRecyclerView.scrollToPosition(position);
        }

        protected void onChildAttachedToWindow(View child) {
            if (this.getChildPosition(child) == this.getTargetPosition()) {
                this.mTargetView = child;
            }
        }

        protected void normalize(PointF scrollVector) {
            double magnitute = Math.sqrt(scrollVector.x * scrollVector.x + scrollVector.y * scrollVector.y);
            scrollVector.x = (float)((double)scrollVector.x / magnitute);
            scrollVector.y = (float)((double)scrollVector.y / magnitute);
        }

        protected abstract void onStart();

        protected abstract void onStop();

        protected abstract void onSeekTargetStep(int var1, int var2, State var3, Action var4);

        protected abstract void onTargetFound(View var1, State var2, Action var3);

        public static class Action {
            public static final int UNDEFINED_DURATION = Integer.MIN_VALUE;
            private int mDx;
            private int mDy;
            private int mDuration;
            private Interpolator mInterpolator;
            private boolean changed = false;
            private int consecutiveUpdates = 0;

            public Action(int dx, int dy) {
                this(dx, dy, Integer.MIN_VALUE, null);
            }

            public Action(int dx, int dy, int duration) {
                this(dx, dy, duration, null);
            }

            public Action(int dx, int dy, int duration, Interpolator interpolator) {
                this.mDx = dx;
                this.mDy = dy;
                this.mDuration = duration;
                this.mInterpolator = interpolator;
            }

            private void runInNecessary(RecyclerView recyclerView) {
                if (this.changed) {
                    this.validate();
                    if (this.mInterpolator == null) {
                        if (this.mDuration == Integer.MIN_VALUE) {
                            recyclerView.mViewFlinger.smoothScrollBy(this.mDx, this.mDy);
                        } else {
                            recyclerView.mViewFlinger.smoothScrollBy(this.mDx, this.mDy, this.mDuration);
                        }
                    } else {
                        recyclerView.mViewFlinger.smoothScrollBy(this.mDx, this.mDy, this.mDuration, this.mInterpolator);
                    }
                    ++this.consecutiveUpdates;
                    if (this.consecutiveUpdates > 10) {
                        Log.e((String)RecyclerView.TAG, (String)"Smooth Scroll action is being updated too frequently. Make sure you are not changing it unless necessary");
                    }
                    this.changed = false;
                } else {
                    this.consecutiveUpdates = 0;
                }
            }

            private void validate() {
                if (this.mInterpolator != null && this.mDuration < 1) {
                    throw new IllegalStateException("If you provide an interpolator, you must set a positive duration");
                }
                if (this.mDuration < 1) {
                    throw new IllegalStateException("Scroll duration must be a positive number");
                }
            }

            public int getDx() {
                return this.mDx;
            }

            public void setDx(int dx) {
                this.changed = true;
                this.mDx = dx;
            }

            public int getDy() {
                return this.mDy;
            }

            public void setDy(int dy) {
                this.changed = true;
                this.mDy = dy;
            }

            public int getDuration() {
                return this.mDuration;
            }

            public void setDuration(int duration) {
                this.changed = true;
                this.mDuration = duration;
            }

            public Interpolator getInterpolator() {
                return this.mInterpolator;
            }

            public void setInterpolator(Interpolator interpolator) {
                this.changed = true;
                this.mInterpolator = interpolator;
            }

            public void update(int dx, int dy, int duration, Interpolator interpolator) {
                this.mDx = dx;
                this.mDy = dy;
                this.mDuration = duration;
                this.mInterpolator = interpolator;
                this.changed = true;
            }
        }
    }

    public static abstract class AdapterDataObserver {
        public void onChanged() {
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        ViewHolder mViewHolder;
        final Rect mDecorInsets = new Rect();
        boolean mInsetsDirty = true;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.LayoutParams)source);
        }

        public boolean viewNeedsUpdate() {
            return this.mViewHolder.needsUpdate();
        }

        public boolean isViewInvalid() {
            return this.mViewHolder.isInvalid();
        }

        public boolean isItemRemoved() {
            return this.mViewHolder.isRemoved();
        }

        public int getViewPosition() {
            return this.mViewHolder.getPosition();
        }
    }

    private static class UpdateOp {
        public static final int ADD = 0;
        public static final int REMOVE = 1;
        public static final int UPDATE = 2;
        static final int POOL_SIZE = 30;
        public int cmd;
        public int positionStart;
        public int itemCount;

        public UpdateOp(int cmd, int positionStart, int itemCount) {
            this.cmd = cmd;
            this.positionStart = positionStart;
            this.itemCount = itemCount;
        }
    }

    public static abstract class ViewHolder {
        public final View itemView;
        int mPosition = -1;
        int mOldPosition = -1;
        long mItemId = -1L;
        int mItemViewType = -1;
        static final int FLAG_BOUND = 1;
        static final int FLAG_UPDATE = 2;
        static final int FLAG_INVALID = 4;
        static final int FLAG_REMOVED = 8;
        static final int FLAG_NOT_RECYCLABLE = 16;
        private int mFlags;
        private Recycler mScrapContainer = null;

        public ViewHolder(View itemView) {
            if (itemView == null) {
                throw new IllegalArgumentException("itemView may not be null");
            }
            this.itemView = itemView;
        }

        void offsetPosition(int offset) {
            if (this.mOldPosition == -1) {
                this.mOldPosition = this.mPosition;
            }
            this.mPosition += offset;
        }

        void clearOldPosition() {
            this.mOldPosition = -1;
        }

        public final int getPosition() {
            return this.mOldPosition == -1 ? this.mPosition : this.mOldPosition;
        }

        public final long getItemId() {
            return this.mItemId;
        }

        public final int getItemViewType() {
            return this.mItemViewType;
        }

        boolean isScrap() {
            return this.mScrapContainer != null;
        }

        void unScrap() {
            this.mScrapContainer.unscrapView(this);
            this.mScrapContainer = null;
        }

        void setScrapContainer(Recycler recycler) {
            this.mScrapContainer = recycler;
        }

        boolean isInvalid() {
            return (this.mFlags & 4) != 0;
        }

        boolean needsUpdate() {
            return (this.mFlags & 2) != 0;
        }

        boolean isBound() {
            return (this.mFlags & 1) != 0;
        }

        boolean isRemoved() {
            return (this.mFlags & 8) != 0;
        }

        void setFlags(int flags, int mask) {
            this.mFlags = this.mFlags & ~mask | flags & mask;
        }

        void addFlags(int flags) {
            this.mFlags |= flags;
        }

        void clearFlagsForSharedPool() {
            this.mFlags = 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ViewHolder{" + Integer.toHexString(this.hashCode()) + " position=" + this.mPosition + " id=" + this.mItemId);
            if (this.isScrap()) {
                sb.append(" scrap");
            }
            if (this.isInvalid()) {
                sb.append(" invalid");
            }
            if (!this.isBound()) {
                sb.append(" unbound");
            }
            if (this.needsUpdate()) {
                sb.append(" update");
            }
            if (this.isRemoved()) {
                sb.append(" removed");
            }
            sb.append("}");
            return sb.toString();
        }

        public final void setIsRecyclable(boolean recyclable) {
            this.mFlags = recyclable ? (this.mFlags &= 0xFFFFFFEF) : (this.mFlags |= 0x10);
        }

        public final boolean isRecyclable() {
            return (this.mFlags & 0x10) == 0 && !ViewCompat.hasTransientState((View)this.itemView);
        }
    }

    public static interface RecyclerListener {
        public void onViewRecycled(ViewHolder var1);
    }

    public static interface OnScrollListener {
        public void onScrollStateChanged(int var1);

        public void onScrolled(int var1, int var2);
    }

    public static interface OnItemTouchListener {
        public boolean onInterceptTouchEvent(RecyclerView var1, MotionEvent var2);

        public void onTouchEvent(RecyclerView var1, MotionEvent var2);
    }

    public static abstract class ItemDecoration {
        public void onDraw(Canvas c, RecyclerView parent) {
        }

        public void onDrawOver(Canvas c, RecyclerView parent) {
        }

        public void getItemOffsets(Rect outRect, int itemPosition, RecyclerView parent) {
            outRect.set(0, 0, 0, 0);
        }
    }

    public static abstract class LayoutManager {
        RecyclerView mRecyclerView;
        @Nullable
        SmoothScroller mSmoothScroller;

        public void requestLayout() {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.requestLayout();
            }
        }

        public boolean supportsItemAnimations() {
            return false;
        }

        public void onAttachedToWindow(RecyclerView view) {
        }

        public void onDetachedFromWindow(RecyclerView view) {
        }

        public void onLayoutChildren(Recycler recycler, State state) {
            Log.e((String)RecyclerView.TAG, (String)"You must override onLayoutChildren(Recycler recycler, State state) ");
        }

        public abstract LayoutParams generateDefaultLayoutParams();

        public boolean checkLayoutParams(LayoutParams lp) {
            return lp != null;
        }

        public LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
            if (lp instanceof LayoutParams) {
                return new LayoutParams((LayoutParams)lp);
            }
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
            }
            return new LayoutParams(lp);
        }

        public LayoutParams generateLayoutParams(Context c, AttributeSet attrs) {
            return new LayoutParams(c, attrs);
        }

        public int scrollHorizontallyBy(int dx, Recycler recycler, State state) {
            return 0;
        }

        public int scrollVerticallyBy(int dy, Recycler recycler, State state) {
            return 0;
        }

        public boolean canScrollHorizontally() {
            return false;
        }

        public boolean canScrollVertically() {
            return false;
        }

        public void scrollToPosition(int position) {
        }

        public void smoothScrollToPosition(RecyclerView recyclerView, State state, int position) {
            Log.e((String)RecyclerView.TAG, (String)"You must override smoothScrollToPosition to support smooth scrolling");
        }

        public void startSmoothScroll(SmoothScroller smoothScroller) {
            if (this.mSmoothScroller != null && smoothScroller != this.mSmoothScroller && this.mSmoothScroller.isRunning()) {
                this.mSmoothScroller.stop();
            }
            this.mSmoothScroller = smoothScroller;
            this.mSmoothScroller.start(this.mRecyclerView, this);
        }

        public boolean isSmoothScrolling() {
            return this.mSmoothScroller != null && this.mSmoothScroller.isRunning();
        }

        public int getLayoutDirection() {
            return ViewCompat.getLayoutDirection((View)this.mRecyclerView);
        }

        public void addView(View child, int index) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(child);
            if (holder.isScrap()) {
                holder.unScrap();
                this.mRecyclerView.attachViewToParent(child, index, child.getLayoutParams());
            } else {
                this.mRecyclerView.addView(child, index);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                lp.mInsetsDirty = true;
                Adapter adapter = this.mRecyclerView.getAdapter();
                if (adapter != null) {
                    adapter.onViewAttachedToWindow(RecyclerView.getChildViewHolderInt(child));
                }
                this.mRecyclerView.onChildAttachedToWindow(child);
                if (this.mSmoothScroller != null && this.mSmoothScroller.isRunning()) {
                    this.mSmoothScroller.onChildAttachedToWindow(child);
                }
            }
        }

        public void addView(View child) {
            if (this.mRecyclerView.mAnimatingViewIndex >= 0) {
                this.addView(child, this.mRecyclerView.mAnimatingViewIndex);
                ++this.mRecyclerView.mAnimatingViewIndex;
            } else {
                this.addView(child, -1);
            }
        }

        public void removeView(View child) {
            Adapter adapter = this.mRecyclerView.getAdapter();
            if (adapter != null) {
                adapter.onViewDetachedFromWindow(RecyclerView.getChildViewHolderInt(child));
            }
            this.mRecyclerView.onChildDetachedFromWindow(child);
            this.mRecyclerView.removeView(child);
            if (this.mRecyclerView.mAnimatingViewIndex >= 0) {
                --this.mRecyclerView.mAnimatingViewIndex;
            }
        }

        public void removeViewAt(int index) {
            View child = this.mRecyclerView.getChildAt(index);
            if (child != null) {
                Adapter adapter = this.mRecyclerView.getAdapter();
                if (adapter != null) {
                    adapter.onViewDetachedFromWindow(RecyclerView.getChildViewHolderInt(child));
                }
                this.mRecyclerView.onChildDetachedFromWindow(child);
                this.mRecyclerView.removeViewAt(index);
                if (this.mRecyclerView.mAnimatingViewIndex >= 0) {
                    --this.mRecyclerView.mAnimatingViewIndex;
                }
            }
        }

        public void removeAllViews() {
            int i;
            Adapter adapter = this.mRecyclerView.getAdapter();
            int childCount = this.mRecyclerView.getChildCount() - this.mRecyclerView.mNumAnimatingViews;
            if (adapter != null) {
                for (i = 0; i < childCount; ++i) {
                    View child = this.mRecyclerView.getChildAt(i);
                    adapter.onViewDetachedFromWindow(RecyclerView.getChildViewHolderInt(child));
                    this.mRecyclerView.onChildDetachedFromWindow(child);
                }
            }
            for (i = childCount - 1; i >= 0; --i) {
                this.mRecyclerView.removeViewAt(i);
                if (this.mRecyclerView.mAnimatingViewIndex < 0) continue;
                --this.mRecyclerView.mAnimatingViewIndex;
            }
        }

        public int getPosition(View view) {
            return ((LayoutParams)view.getLayoutParams()).getViewPosition();
        }

        public View findViewByPosition(int position) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (this.getPosition(child) != position) continue;
                return child;
            }
            return null;
        }

        public void detachView(View child) {
            this.mRecyclerView.detachViewFromParent(child);
        }

        public void detachViewAt(int index) {
            this.mRecyclerView.detachViewFromParent(index);
            if (this.mRecyclerView.mAnimatingViewIndex >= 0) {
                --this.mRecyclerView.mAnimatingViewIndex;
            }
        }

        public void attachView(View child, int index, LayoutParams lp) {
            this.mRecyclerView.attachViewToParent(child, index, (ViewGroup.LayoutParams)lp);
            if (this.mRecyclerView.mAnimatingViewIndex >= 0) {
                ++this.mRecyclerView.mAnimatingViewIndex;
            }
        }

        public void attachView(View child, int index) {
            this.attachView(child, index, (LayoutParams)child.getLayoutParams());
        }

        public void attachView(View child) {
            this.attachView(child, -1);
        }

        public void removeDetachedView(View child) {
            this.mRecyclerView.removeDetachedView(child, false);
        }

        public void detachAndScrapView(View child, Recycler recycler) {
            this.detachView(child);
            recycler.scrapView(child);
        }

        public void detachAndScrapViewAt(int index, Recycler recycler) {
            View child = this.getChildAt(index);
            this.detachViewAt(index);
            recycler.scrapView(child);
        }

        public void removeAndRecycleView(View child, Recycler recycler) {
            this.removeView(child);
            recycler.recycleView(child);
        }

        public void removeAndRecycleViewAt(int index, Recycler recycler) {
            View view = this.getChildAt(index);
            this.removeViewAt(index);
            recycler.recycleView(view);
        }

        public int getChildCount() {
            return this.mRecyclerView != null ? this.mRecyclerView.getChildCount() - this.mRecyclerView.mNumAnimatingViews : 0;
        }

        public View getChildAt(int index) {
            return this.mRecyclerView != null ? this.mRecyclerView.getChildAt(index) : null;
        }

        public int getWidth() {
            return this.mRecyclerView != null ? this.mRecyclerView.getWidth() : 0;
        }

        public int getHeight() {
            return this.mRecyclerView != null ? this.mRecyclerView.getHeight() : 0;
        }

        public int getPaddingLeft() {
            return this.mRecyclerView != null ? this.mRecyclerView.getPaddingLeft() : 0;
        }

        public int getPaddingTop() {
            return this.mRecyclerView != null ? this.mRecyclerView.getPaddingTop() : 0;
        }

        public int getPaddingRight() {
            return this.mRecyclerView != null ? this.mRecyclerView.getPaddingRight() : 0;
        }

        public int getPaddingBottom() {
            return this.mRecyclerView != null ? this.mRecyclerView.getPaddingBottom() : 0;
        }

        public int getPaddingStart() {
            return this.mRecyclerView != null ? ViewCompat.getPaddingStart((View)this.mRecyclerView) : 0;
        }

        public int getPaddingEnd() {
            return this.mRecyclerView != null ? ViewCompat.getPaddingEnd((View)this.mRecyclerView) : 0;
        }

        public boolean isFocused() {
            return this.mRecyclerView != null && this.mRecyclerView.isFocused();
        }

        public boolean hasFocus() {
            return this.mRecyclerView != null && this.mRecyclerView.hasFocus();
        }

        public int getItemCount() {
            Adapter a = this.mRecyclerView != null ? this.mRecyclerView.getAdapter() : null;
            return a != null ? a.getItemCount() : 0;
        }

        public void offsetChildrenHorizontal(int dx) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.offsetChildrenHorizontal(dx);
            }
        }

        public void offsetChildrenVertical(int dy) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.offsetChildrenVertical(dy);
            }
        }

        public void detachAndScrapAttachedViews(Recycler recycler) {
            int childCount = this.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View v = this.getChildAt(i);
                this.detachViewAt(i);
                recycler.scrapView(v);
            }
        }

        void removeAndRecycleScrapInt(Recycler recycler) {
            int scrapCount = recycler.getScrapCount();
            for (int i = 0; i < scrapCount; ++i) {
                View scrap = recycler.getScrapViewAt(i);
                ViewHolder holder = this.mRecyclerView.getChildViewHolder(scrap);
                recycler.quickRecycleScrapView(scrap);
            }
            recycler.clearScrap();
        }

        public void measureChild(View child, int widthUsed, int heightUsed) {
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Rect insets = this.mRecyclerView.getItemDecorInsetsForChild(child);
            int widthSpec = LayoutManager.getChildMeasureSpec(this.getWidth(), this.getPaddingLeft() + this.getPaddingRight() + (widthUsed += insets.left + insets.right), lp.width, this.canScrollHorizontally());
            int heightSpec = LayoutManager.getChildMeasureSpec(this.getHeight(), this.getPaddingTop() + this.getPaddingBottom() + (heightUsed += insets.top + insets.bottom), lp.height, this.canScrollVertically());
            child.measure(widthSpec, heightSpec);
        }

        public void measureChildWithMargins(View child, int widthUsed, int heightUsed) {
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Rect insets = this.mRecyclerView.getItemDecorInsetsForChild(child);
            int widthSpec = LayoutManager.getChildMeasureSpec(this.getWidth(), this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin + (widthUsed += insets.left + insets.right), lp.width, this.canScrollHorizontally());
            int heightSpec = LayoutManager.getChildMeasureSpec(this.getHeight(), this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin + (heightUsed += insets.top + insets.bottom), lp.height, this.canScrollVertically());
            child.measure(widthSpec, heightSpec);
        }

        public static int getChildMeasureSpec(int parentSize, int padding, int childDimension, boolean canScroll) {
            int size = Math.max(0, parentSize - padding);
            int resultSize = 0;
            int resultMode = 0;
            if (canScroll) {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                } else {
                    resultSize = 0;
                    resultMode = 0;
                }
            } else if (childDimension >= 0) {
                resultSize = childDimension;
                resultMode = 0x40000000;
            } else if (childDimension == -1) {
                resultSize = size;
                resultMode = 0x40000000;
            } else if (childDimension == -2) {
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
            }
            return View.MeasureSpec.makeMeasureSpec((int)resultSize, (int)resultMode);
        }

        public int getDecoratedMeasuredWidth(View child) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            return child.getMeasuredWidth() + insets.left + insets.right;
        }

        public int getDecoratedMeasuredHeight(View child) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            return child.getMeasuredHeight() + insets.top + insets.bottom;
        }

        public void layoutDecorated(View child, int left, int top, int right, int bottom) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            child.layout(left + insets.left, top + insets.top, right - insets.right, bottom - insets.bottom);
        }

        public int getDecoratedLeft(View child) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            return child.getLeft() - insets.left;
        }

        public int getDecoratedTop(View child) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            return child.getTop() - insets.top;
        }

        public int getDecoratedRight(View child) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            return child.getRight() + insets.right;
        }

        public int getDecoratedBottom(View child) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            return child.getBottom() + insets.bottom;
        }

        public View onFocusSearchFailed(View focused, int direction, Recycler recycler, State state) {
            return null;
        }

        public View onInterceptFocusSearch(View focused, int direction) {
            return null;
        }

        public boolean requestChildRectangleOnScreen(RecyclerView parent, View child, Rect rect, boolean immediate) {
            int dy;
            int parentLeft = this.getPaddingLeft();
            int parentTop = this.getPaddingTop();
            int parentRight = this.getWidth() - this.getPaddingRight();
            int parentBottom = this.getHeight() - this.getPaddingBottom();
            int childLeft = child.getLeft() + rect.left;
            int childTop = child.getTop() + rect.top;
            int childRight = childLeft + rect.right;
            int childBottom = childTop + rect.bottom;
            int offScreenLeft = Math.min(0, childLeft - parentLeft);
            int offScreenTop = Math.min(0, childTop - parentTop);
            int offScreenRight = Math.max(0, childRight - parentRight);
            int offScreenBottom = Math.max(0, childBottom - parentBottom);
            int dx = ViewCompat.getLayoutDirection((View)parent) == 1 ? (offScreenRight != 0 ? offScreenRight : offScreenLeft) : (offScreenLeft != 0 ? offScreenLeft : offScreenRight);
            int n = dy = offScreenTop != 0 ? offScreenTop : offScreenBottom;
            if (dx != 0 || dy != 0) {
                if (immediate) {
                    parent.scrollBy(dx, dy);
                } else {
                    parent.smoothScrollBy(dx, dy);
                }
                return true;
            }
            return false;
        }

        public boolean onRequestChildFocus(RecyclerView parent, View child, View focused) {
            return false;
        }

        public void onAdapterChanged(Adapter oldAdapter, Adapter newAdapter) {
        }

        public boolean onAddFocusables(RecyclerView recyclerView, ArrayList<View> views, int direction, int focusableMode) {
            return false;
        }

        public void onItemsAdded(RecyclerView recyclerView, int positionStart, int itemCount) {
        }

        public void onItemsRemoved(RecyclerView recyclerView, int positionStart, int itemCount) {
        }

        public int computeHorizontalScrollExtent(State state) {
            return 0;
        }

        public int computeHorizontalScrollOffset(State state) {
            return 0;
        }

        public int computeHorizontalScrollRange(State state) {
            return 0;
        }

        public int computeVerticalScrollExtent(State state) {
            return 0;
        }

        public int computeVerticalScrollOffset(State state) {
            return 0;
        }

        public int computeVerticalScrollRange(State state) {
            return 0;
        }

        public void onMeasure(int widthSpec, int heightSpec) {
            int widthMode = View.MeasureSpec.getMode((int)widthSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightSpec);
            int widthSize = View.MeasureSpec.getSize((int)widthSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightSpec);
            int width = 0;
            int height = 0;
            switch (widthMode) {
                case -2147483648: 
                case 0x40000000: {
                    width = widthSize;
                    break;
                }
                default: {
                    width = this.getMinimumWidth();
                }
            }
            switch (heightMode) {
                case -2147483648: 
                case 0x40000000: {
                    height = heightSize;
                    break;
                }
                default: {
                    height = this.getMinimumHeight();
                }
            }
            this.setMeasuredDimension(width, height);
        }

        public void setMeasuredDimension(int widthSize, int heightSize) {
            this.mRecyclerView.setMeasuredDimension(widthSize, heightSize);
        }

        public int getMinimumWidth() {
            return ViewCompat.getMinimumWidth((View)this.mRecyclerView);
        }

        public int getMinimumHeight() {
            return ViewCompat.getMinimumHeight((View)this.mRecyclerView);
        }

        public Parcelable onSaveInstanceState() {
            return null;
        }

        public void onRestoreInstanceState(Parcelable state) {
        }

        void stopSmoothScroller() {
            if (this.mSmoothScroller != null) {
                this.mSmoothScroller.stop();
            }
        }

        private void onSmoothScrollerStopped(SmoothScroller smoothScroller) {
            if (this.mSmoothScroller == smoothScroller) {
                this.mSmoothScroller = null;
            }
        }
    }

    public static abstract class Adapter<VH extends ViewHolder> {
        private final AdapterDataObservable mObservable = new AdapterDataObservable();
        private boolean mHasStableIds = false;

        public abstract VH onCreateViewHolder(ViewGroup var1, int var2);

        public abstract void onBindViewHolder(VH var1, int var2);

        public final VH createViewHolder(ViewGroup parent, int viewType) {
            VH holder = this.onCreateViewHolder(parent, viewType);
            ((ViewHolder)holder).mItemViewType = viewType;
            return holder;
        }

        public final void bindViewHolder(VH holder, int position) {
            ((ViewHolder)holder).mPosition = position;
            if (this.hasStableIds()) {
                ((ViewHolder)holder).mItemId = this.getItemId(position);
            }
            this.onBindViewHolder(holder, position);
            ((ViewHolder)holder).setFlags(1, 7);
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public void setHasStableIds(boolean hasStableIds) {
            if (this.hasObservers()) {
                throw new IllegalStateException("Cannot change whether this adapter has stable IDs while the adapter has registered observers.");
            }
            this.mHasStableIds = hasStableIds;
        }

        public long getItemId(int position) {
            return -1L;
        }

        public abstract int getItemCount();

        public final boolean hasStableIds() {
            return this.mHasStableIds;
        }

        public void onViewRecycled(VH holder) {
        }

        public void onViewAttachedToWindow(VH holder) {
        }

        public void onViewDetachedFromWindow(VH holder) {
        }

        public final boolean hasObservers() {
            return this.mObservable.hasObservers();
        }

        public void registerAdapterDataObserver(AdapterDataObserver observer) {
            this.mObservable.registerObserver(observer);
        }

        public void unregisterAdapterDataObserver(AdapterDataObserver observer) {
            this.mObservable.unregisterObserver(observer);
        }

        public final void notifyDataSetChanged() {
            this.mObservable.notifyChanged();
        }

        public final void notifyItemChanged(int position) {
            this.mObservable.notifyItemRangeChanged(position, 1);
        }

        public final void notifyItemRangeChanged(int positionStart, int itemCount) {
            this.mObservable.notifyItemRangeChanged(positionStart, itemCount);
        }

        public final void notifyItemInserted(int position) {
            this.mObservable.notifyItemRangeInserted(position, 1);
        }

        public final void notifyItemRangeInserted(int positionStart, int itemCount) {
            this.mObservable.notifyItemRangeInserted(positionStart, itemCount);
        }

        public final void notifyItemRemoved(int position) {
            this.mObservable.notifyItemRangeRemoved(position, 1);
        }

        public final void notifyItemRangeRemoved(int positionStart, int itemCount) {
            this.mObservable.notifyItemRangeRemoved(positionStart, itemCount);
        }
    }

    public final class Recycler {
        private final ArrayList<ViewHolder> mAttachedScrap = new ArrayList();
        private final ArrayList<ViewHolder> mCachedViews = new ArrayList();
        private final List<ViewHolder> mUnmodifiableAttachedScrap = Collections.unmodifiableList(this.mAttachedScrap);
        private int mViewCacheMax = 2;
        private RecycledViewPool mRecyclerPool;
        private static final int DEFAULT_CACHE_SIZE = 2;

        public void clear() {
            this.mAttachedScrap.clear();
            this.mCachedViews.clear();
        }

        public void setViewCacheSize(int viewCount) {
            this.mViewCacheMax = viewCount;
            while (this.mCachedViews.size() > viewCount) {
                this.mCachedViews.remove(this.mCachedViews.size() - 1);
            }
        }

        public List<ViewHolder> getScrapList() {
            return this.mUnmodifiableAttachedScrap;
        }

        public View getViewForPosition(int position) {
            ViewGroup.LayoutParams lp;
            ViewHolder holder;
            int type = RecyclerView.this.mAdapter.getItemViewType(position);
            if (RecyclerView.this.mAdapter.hasStableIds()) {
                long id = RecyclerView.this.mAdapter.getItemId(position);
                holder = this.getScrapViewForId(id, type);
            } else {
                holder = this.getScrapViewForPosition(position, type);
            }
            if (holder == null) {
                holder = RecyclerView.this.mAdapter.createViewHolder(RecyclerView.this, type);
            }
            if (!holder.isBound() || holder.needsUpdate()) {
                int offsetPosition = RecyclerView.this.findPositionOffset(position);
                if (offsetPosition < 0 || offsetPosition >= RecyclerView.this.mAdapter.getItemCount()) {
                    return null;
                }
                RecyclerView.this.mAdapter.bindViewHolder(holder, offsetPosition);
            }
            if ((lp = holder.itemView.getLayoutParams()) == null) {
                lp = RecyclerView.this.generateDefaultLayoutParams();
                holder.itemView.setLayoutParams(lp);
            } else if (!RecyclerView.this.checkLayoutParams(lp)) {
                lp = RecyclerView.this.generateLayoutParams(lp);
                holder.itemView.setLayoutParams(lp);
            }
            ((LayoutParams)lp).mViewHolder = holder;
            return holder.itemView;
        }

        public void recycleView(View view) {
            this.recycleViewHolder(RecyclerView.getChildViewHolderInt(view));
        }

        void recycleViewHolder(ViewHolder holder) {
            if (holder.isScrap() || holder.itemView.getParent() != null) {
                throw new IllegalArgumentException("Scrapped or attached views may not be recycled.");
            }
            if (!(this.mCachedViews.size() >= this.mViewCacheMax || holder.isInvalid() || !RecyclerView.this.mInPreLayout && holder.isRemoved())) {
                if (this.mCachedViews.size() == this.mViewCacheMax && !this.mCachedViews.isEmpty()) {
                    for (int i = 0; i < this.mCachedViews.size(); ++i) {
                        ViewHolder cachedView = this.mCachedViews.get(i);
                        if (!cachedView.isRecyclable()) continue;
                        this.mCachedViews.remove(i);
                        this.getRecycledViewPool().putRecycledView(cachedView);
                        this.dispatchViewRecycled(cachedView);
                        break;
                    }
                }
                this.mCachedViews.add(holder);
            } else if (holder.isRecyclable()) {
                this.getRecycledViewPool().putRecycledView(holder);
                this.dispatchViewRecycled(holder);
            }
            RecyclerView.this.mState.mPreLayoutHolderMap.remove((Object)holder);
            RecyclerView.this.mState.mPostLayoutHolderMap.remove((Object)holder);
        }

        void quickRecycleScrapView(View view) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(view);
            holder.mScrapContainer = null;
            this.recycleViewHolder(holder);
        }

        void scrapView(View view) {
            ViewHolder holder = RecyclerView.getChildViewHolderInt(view);
            holder.setScrapContainer(this);
            this.mAttachedScrap.add(holder);
        }

        void unscrapView(ViewHolder holder) {
            this.mAttachedScrap.remove(holder);
            holder.mScrapContainer = null;
        }

        int getScrapCount() {
            return this.mAttachedScrap.size();
        }

        View getScrapViewAt(int index) {
            return this.mAttachedScrap.get((int)index).itemView;
        }

        void clearScrap() {
            this.mAttachedScrap.clear();
        }

        ViewHolder getScrapViewForPosition(int position, int type) {
            View view;
            int scrapCount = this.mAttachedScrap.size();
            for (int i = 0; i < scrapCount; ++i) {
                ViewHolder holder = this.mAttachedScrap.get(i);
                if (holder.getPosition() != position || holder.isInvalid() || !RecyclerView.this.mInPreLayout && holder.isRemoved()) continue;
                if (holder.getItemViewType() != type) {
                    Log.e((String)RecyclerView.TAG, (String)("Scrap view for position " + position + " isn't dirty but has" + " wrong view type! (found " + holder.getItemViewType() + " but expected " + type + ")"));
                    break;
                }
                this.mAttachedScrap.remove(i);
                holder.setScrapContainer(null);
                return holder;
            }
            if (RecyclerView.this.mNumAnimatingViews != 0 && (view = RecyclerView.this.getAnimatingView(position, type)) != null) {
                RecyclerView.this.mItemAnimator.endAnimation(RecyclerView.this.getChildViewHolder(view));
            }
            int cacheSize = this.mCachedViews.size();
            for (int i = 0; i < cacheSize; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder.getPosition() != position) continue;
                this.mCachedViews.remove(i);
                if (holder.isInvalid() && holder.getItemViewType() != type) {
                    if (holder.isRecyclable()) {
                        this.getRecycledViewPool().putRecycledView(holder);
                    }
                    this.dispatchViewRecycled(holder);
                    break;
                }
                return holder;
            }
            return this.getRecycledViewPool().getRecycledView(type);
        }

        ViewHolder getScrapViewForId(long id, int type) {
            int count = this.mAttachedScrap.size();
            for (int i = 0; i < count; ++i) {
                ViewHolder holder = this.mAttachedScrap.get(i);
                if (holder.getItemId() != id) continue;
                if (type != holder.getItemViewType()) break;
                this.mAttachedScrap.remove(i);
                holder.setScrapContainer(null);
                return holder;
            }
            int cacheSize = this.mCachedViews.size();
            for (int i = 0; i < cacheSize; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder.getItemId() != id) continue;
                this.mCachedViews.remove(i);
                return holder;
            }
            return this.getRecycledViewPool().getRecycledView(type);
        }

        void dispatchViewRecycled(ViewHolder holder) {
            if (RecyclerView.this.mRecyclerListener != null) {
                RecyclerView.this.mRecyclerListener.onViewRecycled(holder);
            }
            if (RecyclerView.this.mAdapter != null) {
                RecyclerView.this.mAdapter.onViewRecycled(holder);
            }
        }

        void onAdapterChanged(Adapter oldAdapter, Adapter newAdapter) {
            this.clear();
            this.getRecycledViewPool().onAdapterChanged(oldAdapter, newAdapter);
        }

        void offsetPositionRecordsForInsert(int insertedAt, int count) {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null || holder.getPosition() < insertedAt) continue;
                holder.offsetPosition(count);
            }
        }

        void offsetPositionRecordsForRemove(int removedFrom, int count) {
            int removedEnd = removedFrom + count;
            int cachedCount = this.mCachedViews.size();
            for (int i = cachedCount - 1; i >= 0; --i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null) continue;
                if (holder.getPosition() >= removedEnd) {
                    holder.offsetPosition(-count);
                    continue;
                }
                if (holder.getPosition() < removedFrom) continue;
                this.mCachedViews.remove(i);
                this.getRecycledViewPool().putRecycledView(holder);
                this.dispatchViewRecycled(holder);
            }
        }

        void setRecycledViewPool(RecycledViewPool pool) {
            if (this.mRecyclerPool != null) {
                this.mRecyclerPool.detach();
            }
            this.mRecyclerPool = pool;
            if (pool != null) {
                this.mRecyclerPool.attach(RecyclerView.this.getAdapter());
            }
        }

        RecycledViewPool getRecycledViewPool() {
            if (this.mRecyclerPool == null) {
                this.mRecyclerPool = new RecycledViewPool();
            }
            return this.mRecyclerPool;
        }

        ViewHolder findViewHolderForPosition(int position) {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null || holder.getPosition() != position) continue;
                this.mCachedViews.remove(i);
                return holder;
            }
            return null;
        }

        ViewHolder findViewHolderForItemId(long id) {
            if (!RecyclerView.this.mAdapter.hasStableIds()) {
                return null;
            }
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null || holder.getItemId() != id) continue;
                this.mCachedViews.remove(i);
                return holder;
            }
            return null;
        }

        void viewRangeUpdate(int positionStart, int itemCount) {
            int positionEnd = positionStart + itemCount;
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                int pos;
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null || (pos = holder.getPosition()) < positionStart || pos >= positionEnd) continue;
                holder.addFlags(2);
            }
        }

        void markKnownViewsInvalid() {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null) continue;
                holder.addFlags(6);
            }
        }

        void clearOldPositions() {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                holder.clearOldPosition();
            }
        }
    }

    public static class RecycledViewPool {
        private SparseArray<ArrayList<ViewHolder>> mScrap = new SparseArray();
        private SparseIntArray mMaxScrap = new SparseIntArray();
        private int mAttachCount = 0;
        private static final int DEFAULT_MAX_SCRAP = 5;

        public void clear() {
            this.mScrap.clear();
        }

        public void setMaxRecycledViews(int viewType, int max) {
            this.mMaxScrap.put(viewType, max);
            ArrayList scrapHeap = (ArrayList)this.mScrap.get(viewType);
            if (scrapHeap != null) {
                while (scrapHeap.size() > max) {
                    scrapHeap.remove(scrapHeap.size() - 1);
                }
            }
        }

        public ViewHolder getRecycledView(int viewType) {
            ArrayList scrapHeap = (ArrayList)this.mScrap.get(viewType);
            if (scrapHeap != null && !scrapHeap.isEmpty()) {
                int index = scrapHeap.size() - 1;
                ViewHolder scrap = (ViewHolder)scrapHeap.get(index);
                scrapHeap.remove(index);
                return scrap;
            }
            return null;
        }

        public void putRecycledView(ViewHolder scrap) {
            int viewType = scrap.getItemViewType();
            ArrayList<ViewHolder> scrapHeap = this.getScrapHeapForType(viewType);
            if (this.mMaxScrap.get(viewType) <= scrapHeap.size()) {
                return;
            }
            scrap.mPosition = -1;
            scrap.mOldPosition = -1;
            scrap.mItemId = -1L;
            scrap.clearFlagsForSharedPool();
            scrapHeap.add(scrap);
        }

        void attach(Adapter adapter) {
            ++this.mAttachCount;
        }

        void detach() {
            --this.mAttachCount;
        }

        void onAdapterChanged(Adapter oldAdapter, Adapter newAdapter) {
            if (this.mAttachCount == 1) {
                this.clear();
            }
        }

        private ArrayList<ViewHolder> getScrapHeapForType(int viewType) {
            ArrayList scrap = (ArrayList)this.mScrap.get(viewType);
            if (scrap == null) {
                scrap = new ArrayList();
                this.mScrap.put(viewType, scrap);
                if (this.mMaxScrap.indexOfKey(viewType) < 0) {
                    this.mMaxScrap.put(viewType, 5);
                }
            }
            return scrap;
        }
    }

    private class RecyclerViewDataObserver
    extends AdapterDataObserver {
        private RecyclerViewDataObserver() {
        }

        @Override
        public void onChanged() {
            if (RecyclerView.this.mAdapter.hasStableIds()) {
                RecyclerView.this.markKnownViewsInvalid();
                RecyclerView.this.mState.mStructureChanged = true;
                RecyclerView.this.requestLayout();
            } else {
                RecyclerView.this.markKnownViewsInvalid();
                RecyclerView.this.mState.mStructureChanged = true;
                RecyclerView.this.requestLayout();
            }
        }

        @Override
        public void onItemRangeChanged(int positionStart, int itemCount) {
            RecyclerView.this.postAdapterUpdate(RecyclerView.this.obtainUpdateOp(2, positionStart, itemCount));
        }

        @Override
        public void onItemRangeInserted(int positionStart, int itemCount) {
            RecyclerView.this.postAdapterUpdate(RecyclerView.this.obtainUpdateOp(0, positionStart, itemCount));
        }

        @Override
        public void onItemRangeRemoved(int positionStart, int itemCount) {
            RecyclerView.this.postAdapterUpdate(RecyclerView.this.obtainUpdateOp(1, positionStart, itemCount));
        }
    }

    private class ViewFlinger
    implements Runnable {
        private int mLastFlingX;
        private int mLastFlingY;
        private ScrollerCompat mScroller;
        private Interpolator mInterpolator = RecyclerView.access$1100();
        private boolean mEatRunOnAnimationRequest = false;
        private boolean mReSchedulePostAnimationCallback = false;

        public ViewFlinger() {
            this.mScroller = ScrollerCompat.create((Context)RecyclerView.this.getContext(), (Interpolator)sQuinticInterpolator);
        }

        @Override
        public void run() {
            this.disableRunOnAnimationRequests();
            ScrollerCompat scroller = this.mScroller;
            SmoothScroller smoothScroller = ((RecyclerView)RecyclerView.this).mLayout.mSmoothScroller;
            if (scroller.computeScrollOffset()) {
                int x = scroller.getCurrX();
                int y = scroller.getCurrY();
                int dx = x - this.mLastFlingX;
                int dy = y - this.mLastFlingY;
                this.mLastFlingX = x;
                this.mLastFlingY = y;
                int overscrollX = 0;
                int overscrollY = 0;
                if (RecyclerView.this.mAdapter != null) {
                    RecyclerView.this.eatRequestLayout();
                    if (dx != 0) {
                        int hresult = RecyclerView.this.mLayout.scrollHorizontallyBy(dx, RecyclerView.this.mRecycler, RecyclerView.this.mState);
                        overscrollX = dx - hresult;
                    }
                    if (dy != 0) {
                        int vresult = RecyclerView.this.mLayout.scrollVerticallyBy(dy, RecyclerView.this.mRecycler, RecyclerView.this.mState);
                        overscrollY = dy - vresult;
                    }
                    if (smoothScroller != null && !smoothScroller.isPendingInitialRun() && smoothScroller.isRunning()) {
                        smoothScroller.onAnimation(dx - overscrollX, dy - overscrollY);
                    }
                    RecyclerView.this.resumeRequestLayout(false);
                }
                if (!RecyclerView.this.mItemDecorations.isEmpty()) {
                    RecyclerView.this.invalidate();
                }
                if (overscrollX != 0 || overscrollY != 0) {
                    int vel = (int)scroller.getCurrVelocity();
                    int velX = 0;
                    if (overscrollX != x) {
                        velX = overscrollX < 0 ? -vel : (overscrollX > 0 ? vel : 0);
                    }
                    int velY = 0;
                    if (overscrollY != y) {
                        int n = overscrollY < 0 ? -vel : (velY = overscrollY > 0 ? vel : 0);
                    }
                    if (ViewCompat.getOverScrollMode((View)RecyclerView.this) != 2) {
                        RecyclerView.this.absorbGlows(velX, velY);
                    }
                    if (!(velX == 0 && overscrollX != x && scroller.getFinalX() != 0 || velY == 0 && overscrollY != y && scroller.getFinalY() != 0)) {
                        scroller.abortAnimation();
                    }
                }
                if (RecyclerView.this.mScrollListener != null && (x != 0 || y != 0)) {
                    RecyclerView.this.mScrollListener.onScrolled(dx, dy);
                }
                if (!RecyclerView.this.awakenScrollBars()) {
                    RecyclerView.this.invalidate();
                }
                if (scroller.isFinished()) {
                    RecyclerView.this.setScrollState(0);
                } else {
                    this.postOnAnimation();
                }
            }
            if (smoothScroller != null && smoothScroller.isPendingInitialRun()) {
                smoothScroller.onAnimation(0, 0);
            }
            this.enableRunOnAnimationRequests();
        }

        private void disableRunOnAnimationRequests() {
            this.mReSchedulePostAnimationCallback = false;
            this.mEatRunOnAnimationRequest = true;
        }

        private void enableRunOnAnimationRequests() {
            this.mEatRunOnAnimationRequest = false;
            if (this.mReSchedulePostAnimationCallback) {
                this.postOnAnimation();
            }
        }

        void postOnAnimation() {
            if (this.mEatRunOnAnimationRequest) {
                this.mReSchedulePostAnimationCallback = true;
            } else {
                ViewCompat.postOnAnimation((View)RecyclerView.this, (Runnable)this);
            }
        }

        public void fling(int velocityX, int velocityY) {
            RecyclerView.this.setScrollState(2);
            this.mLastFlingY = 0;
            this.mLastFlingX = 0;
            this.mScroller.fling(0, 0, velocityX, velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.postOnAnimation();
        }

        public void smoothScrollBy(int dx, int dy) {
            this.smoothScrollBy(dx, dy, 0, 0);
        }

        public void smoothScrollBy(int dx, int dy, int vx, int vy) {
            this.smoothScrollBy(dx, dy, this.computeScrollDuration(dx, dy, vx, vy));
        }

        private float distanceInfluenceForSnapDuration(float f) {
            f -= 0.5f;
            f = (float)((double)f * 0.4712389167638204);
            return (float)Math.sin(f);
        }

        private int computeScrollDuration(int dx, int dy, int vx, int vy) {
            int duration;
            int absDy;
            int absDx = Math.abs(dx);
            boolean horizontal = absDx > (absDy = Math.abs(dy));
            int velocity = (int)Math.sqrt(vx * vx + vy * vy);
            int delta = (int)Math.sqrt(dx * dx + dy * dy);
            int containerSize = horizontal ? RecyclerView.this.getWidth() : RecyclerView.this.getHeight();
            int halfContainerSize = containerSize / 2;
            float distanceRatio = Math.min(1.0f, 1.0f * (float)delta / (float)containerSize);
            float distance = (float)halfContainerSize + (float)halfContainerSize * this.distanceInfluenceForSnapDuration(distanceRatio);
            if (velocity > 0) {
                duration = 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity));
            } else {
                float absDelta = horizontal ? absDx : absDy;
                duration = (int)((absDelta / (float)containerSize + 1.0f) * 300.0f);
            }
            return Math.min(duration, 2000);
        }

        public void smoothScrollBy(int dx, int dy, int duration) {
            this.smoothScrollBy(dx, dy, duration, sQuinticInterpolator);
        }

        public void smoothScrollBy(int dx, int dy, int duration, Interpolator interpolator) {
            if (this.mInterpolator != interpolator) {
                this.mInterpolator = interpolator;
                this.mScroller = ScrollerCompat.create((Context)RecyclerView.this.getContext(), (Interpolator)interpolator);
            }
            RecyclerView.this.setScrollState(2);
            this.mLastFlingY = 0;
            this.mLastFlingX = 0;
            this.mScroller.startScroll(0, 0, dx, dy, duration);
            this.postOnAnimation();
        }

        public void stop() {
            RecyclerView.this.removeCallbacks(this);
            this.mScroller.abortAnimation();
        }
    }
}

