/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import java.util.List;

public class LinearLayoutManager
extends RecyclerView.LayoutManager {
    private static final String TAG = "LinearLayoutManager";
    private static final boolean DEBUG = false;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int INVALID_OFFSET = Integer.MIN_VALUE;
    private static final float MAX_SCROLL_FACTOR = 0.33f;
    private int mOrientation;
    private RenderState mRenderState;
    private OrientationHelper mOrientationHelper;
    private boolean mLastStackFromEnd;
    private boolean mReverseLayout = false;
    private boolean mShouldReverseLayout = false;
    private boolean mStackFromEnd = false;
    private int mPendingScrollPosition = -1;
    private int mPendingScrollPositionOffset = Integer.MIN_VALUE;
    private SavedState mPendingSavedState = null;

    public LinearLayoutManager(Context context) {
        this(context, 1, false);
    }

    public LinearLayoutManager(Context context, int orientation, boolean reverseLayout) {
        this.setOrientation(orientation);
        this.setReverseLayout(reverseLayout);
    }

    @Override
    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        if (this.mPendingSavedState != null) {
            return new SavedState(this.mPendingSavedState);
        }
        SavedState state = new SavedState();
        if (this.getChildCount() > 0) {
            boolean didLayoutFromEnd = this.mLastStackFromEnd ^ this.mShouldReverseLayout;
            state.mOrientation = this.mOrientation;
            state.mAnchorLayoutFromEnd = didLayoutFromEnd;
            if (didLayoutFromEnd) {
                View refChild = this.getChildClosestToEnd();
                state.mAnchorOffset = this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(refChild);
                state.mAnchorPosition = this.getPosition(refChild);
            } else {
                View refChild = this.getChildClosestToStart();
                state.mAnchorPosition = this.getPosition(refChild);
                state.mAnchorOffset = this.mOrientationHelper.getDecoratedStart(refChild) - this.mOrientationHelper.getStartAfterPadding();
            }
        } else {
            state.mAnchorPosition = 0;
            state.mAnchorOffset = 0;
        }
        state.mStackFromEnd = this.mStackFromEnd;
        state.mReverseLayout = this.mReverseLayout;
        return state;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            this.mPendingSavedState = (SavedState)state;
            this.requestLayout();
        }
    }

    @Override
    public boolean canScrollHorizontally() {
        return this.mOrientation == 0;
    }

    @Override
    public boolean canScrollVertically() {
        return this.mOrientation == 1;
    }

    public void setStackFromEnd(boolean stackFromEnd) {
        this.mStackFromEnd = stackFromEnd;
        this.requestLayout();
    }

    public boolean getStackFromEnd() {
        return this.mStackFromEnd;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("invalid orientation.");
        }
        if (orientation == this.mOrientation) {
            return;
        }
        this.mOrientation = orientation;
        this.mOrientationHelper = null;
        this.requestLayout();
    }

    private void resolveShouldLayoutReverse() {
        this.mShouldReverseLayout = this.mOrientation == 1 || !this.isLayoutRTL() ? this.mReverseLayout : !this.mReverseLayout;
    }

    public boolean getReverseLayout() {
        return this.mReverseLayout;
    }

    public void setReverseLayout(boolean reverseLayout) {
        if (reverseLayout == this.mReverseLayout) {
            return;
        }
        this.mReverseLayout = reverseLayout;
        this.requestLayout();
    }

    @Override
    public View findViewByPosition(int position) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return null;
        }
        int firstChild = this.getPosition(this.getChildAt(0));
        int viewPosition = position - firstChild;
        if (viewPosition >= 0 && viewPosition < childCount) {
            return this.getChildAt(viewPosition);
        }
        return null;
    }

    protected int getExtraLayoutSpace(RecyclerView.State state) {
        if (state.hasTargetScrollPosition()) {
            return this.mOrientationHelper.getTotalSpace();
        }
        return 0;
    }

    @Override
    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        LinearSmoothScroller linearSmoothScroller = new LinearSmoothScroller(recyclerView.getContext()){

            @Override
            public PointF computeScrollVectorForPosition(int targetPosition) {
                return LinearLayoutManager.this.computeScrollVectorForPosition(targetPosition);
            }
        };
        linearSmoothScroller.setTargetPosition(position);
        this.startSmoothScroll(linearSmoothScroller);
    }

    public PointF computeScrollVectorForPosition(int targetPosition) {
        int direction;
        if (this.getChildCount() == 0) {
            return null;
        }
        int firstChildPos = this.getPosition(this.getChildAt(0));
        int n = direction = targetPosition < firstChildPos != this.mShouldReverseLayout ? -1 : 1;
        if (this.mOrientation == 0) {
            return new PointF((float)direction, 0.0f);
        }
        return new PointF(0.0f, (float)direction);
    }

    @Override
    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        int extraForStart;
        int extraForEnd;
        boolean before;
        int anchorCoordinate;
        int anchorItemPosition;
        boolean stackFromEndChanged;
        if (this.mPendingSavedState != null) {
            this.setOrientation(this.mPendingSavedState.mOrientation);
            this.setReverseLayout(this.mPendingSavedState.mReverseLayout);
            this.setStackFromEnd(this.mPendingSavedState.mStackFromEnd);
            this.mPendingScrollPosition = this.mPendingSavedState.mAnchorPosition;
        }
        this.ensureRenderState();
        this.resolveShouldLayoutReverse();
        if (this.mPendingScrollPosition != -1 && (this.mPendingScrollPosition < 0 || this.mPendingScrollPosition >= state.getItemCount())) {
            this.mPendingScrollPosition = -1;
            this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        }
        boolean layoutFromEnd = this.mShouldReverseLayout ^ this.mStackFromEnd;
        boolean bl = stackFromEndChanged = this.mLastStackFromEnd != this.mStackFromEnd;
        if (this.mPendingScrollPosition != -1) {
            anchorItemPosition = this.mPendingScrollPosition;
            if (this.mPendingSavedState != null) {
                layoutFromEnd = this.mPendingSavedState.mAnchorLayoutFromEnd;
                anchorCoordinate = layoutFromEnd ? this.mOrientationHelper.getEndAfterPadding() - this.mPendingSavedState.mAnchorOffset : this.mOrientationHelper.getStartAfterPadding() + this.mPendingSavedState.mAnchorOffset;
            } else if (this.mPendingScrollPositionOffset == Integer.MIN_VALUE) {
                View child = this.findViewByPosition(this.mPendingScrollPosition);
                if (child != null) {
                    int startGap = this.mOrientationHelper.getDecoratedStart(child) - this.mOrientationHelper.getStartAfterPadding();
                    int endGap = this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(child);
                    int childSize = this.mOrientationHelper.getDecoratedMeasurement(child);
                    if (childSize > this.mOrientationHelper.getTotalSpace()) {
                        anchorCoordinate = layoutFromEnd ? this.mOrientationHelper.getEndAfterPadding() : this.mOrientationHelper.getStartAfterPadding();
                    } else if (startGap < 0) {
                        anchorCoordinate = this.mOrientationHelper.getStartAfterPadding();
                        layoutFromEnd = false;
                    } else if (endGap < 0) {
                        anchorCoordinate = this.mOrientationHelper.getEndAfterPadding();
                        layoutFromEnd = true;
                    } else {
                        anchorCoordinate = layoutFromEnd ? this.mOrientationHelper.getDecoratedEnd(child) : this.mOrientationHelper.getDecoratedStart(child);
                    }
                } else if (this.getChildCount() > 0) {
                    int pos = this.getPosition(this.getChildAt(0));
                    if (this.mPendingScrollPosition < pos == this.mShouldReverseLayout) {
                        anchorCoordinate = this.mOrientationHelper.getEndAfterPadding();
                        layoutFromEnd = true;
                    } else {
                        anchorCoordinate = this.mOrientationHelper.getStartAfterPadding();
                        layoutFromEnd = false;
                    }
                } else {
                    anchorCoordinate = layoutFromEnd ? this.mOrientationHelper.getEndAfterPadding() : this.mOrientationHelper.getStartAfterPadding();
                }
            } else if (this.mShouldReverseLayout) {
                anchorCoordinate = this.mOrientationHelper.getEndAfterPadding() - this.mPendingScrollPositionOffset;
                layoutFromEnd = true;
            } else {
                anchorCoordinate = this.mOrientationHelper.getStartAfterPadding() + this.mPendingScrollPositionOffset;
                layoutFromEnd = false;
            }
        } else if (this.getChildCount() > 0 && !stackFromEndChanged) {
            View referenceChild;
            if (layoutFromEnd) {
                referenceChild = this.getChildClosestToEnd();
                anchorCoordinate = this.mOrientationHelper.getDecoratedEnd(referenceChild);
                anchorItemPosition = this.getPosition(referenceChild);
            } else {
                referenceChild = this.getChildClosestToStart();
                anchorCoordinate = this.mOrientationHelper.getDecoratedStart(referenceChild);
                anchorItemPosition = this.getPosition(referenceChild);
            }
        } else {
            anchorCoordinate = layoutFromEnd ? this.mOrientationHelper.getEndAfterPadding() : this.mOrientationHelper.getStartAfterPadding();
            anchorItemPosition = this.mStackFromEnd ? state.getItemCount() - 1 : 0;
        }
        this.detachAndScrapAttachedViews(recycler);
        int extra = this.getExtraLayoutSpace(state);
        boolean bl2 = before = state.getTargetScrollPosition() < anchorItemPosition;
        if (before == this.mShouldReverseLayout) {
            extraForEnd = extra;
            extraForStart = 0;
        } else {
            extraForStart = extra;
            extraForEnd = 0;
        }
        this.updateRenderStateToFillStart(anchorItemPosition, anchorCoordinate);
        this.mRenderState.mExtra = extraForStart;
        if (!layoutFromEnd) {
            this.mRenderState.mCurrentPosition += this.mRenderState.mItemDirection;
        }
        this.fill(recycler, this.mRenderState, state, false);
        int startOffset = this.mRenderState.mOffset;
        this.updateRenderStateToFillEnd(anchorItemPosition, anchorCoordinate);
        this.mRenderState.mExtra = extraForEnd;
        if (layoutFromEnd) {
            this.mRenderState.mCurrentPosition += this.mRenderState.mItemDirection;
        }
        this.fill(recycler, this.mRenderState, state, false);
        int endOffset = this.mRenderState.mOffset;
        if (this.getChildCount() > 0) {
            int fixOffset;
            if (this.mShouldReverseLayout ^ this.mStackFromEnd) {
                fixOffset = this.fixLayoutEndGap(endOffset, recycler, state, true);
                startOffset += fixOffset;
                endOffset += fixOffset;
                fixOffset = this.fixLayoutStartGap(startOffset, recycler, state, false);
                startOffset += fixOffset;
                endOffset += fixOffset;
            } else {
                fixOffset = this.fixLayoutStartGap(startOffset, recycler, state, true);
                startOffset += fixOffset;
                endOffset += fixOffset;
                fixOffset = this.fixLayoutEndGap(endOffset, recycler, state, false);
                startOffset += fixOffset;
                endOffset += fixOffset;
            }
        }
        if (this.getChildCount() > 0 && !state.isPreLayout() && this.supportsItemAnimations()) {
            int scrapExtraStart = 0;
            int scrapExtraEnd = 0;
            List<RecyclerView.ViewHolder> scrapList = recycler.getScrapList();
            int scrapSize = scrapList.size();
            int firstChildPos = this.getPosition(this.getChildAt(0));
            for (int i = 0; i < scrapSize; ++i) {
                int direction;
                RecyclerView.ViewHolder scrap = scrapList.get(i);
                int position = scrap.getPosition();
                int n = direction = position < firstChildPos != this.mShouldReverseLayout ? -1 : 1;
                if (direction == -1) {
                    scrapExtraStart += this.mOrientationHelper.getDecoratedMeasurement(scrap.itemView);
                    continue;
                }
                scrapExtraEnd += this.mOrientationHelper.getDecoratedMeasurement(scrap.itemView);
            }
            this.mRenderState.mScrapList = scrapList;
            if (scrapExtraStart > 0) {
                View anchor = this.getChildClosestToStart();
                this.updateRenderStateToFillStart(this.getPosition(anchor), startOffset);
                this.mRenderState.mExtra = scrapExtraStart;
                this.mRenderState.mAvailable = 0;
                this.mRenderState.mCurrentPosition = this.mRenderState.mCurrentPosition + (this.mShouldReverseLayout ? 1 : -1);
                this.fill(recycler, this.mRenderState, state, false);
            }
            if (scrapExtraEnd > 0) {
                View anchor = this.getChildClosestToEnd();
                this.updateRenderStateToFillEnd(this.getPosition(anchor), endOffset);
                this.mRenderState.mExtra = scrapExtraEnd;
                this.mRenderState.mAvailable = 0;
                this.mRenderState.mCurrentPosition = this.mRenderState.mCurrentPosition + (this.mShouldReverseLayout ? -1 : 1);
                this.fill(recycler, this.mRenderState, state, false);
            }
            this.mRenderState.mScrapList = null;
        }
        this.mPendingScrollPosition = -1;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        this.mLastStackFromEnd = this.mStackFromEnd;
        this.mPendingSavedState = null;
    }

    private int fixLayoutEndGap(int endOffset, RecyclerView.Recycler recycler, RecyclerView.State state, boolean canOffsetChildren) {
        int gap = this.mOrientationHelper.getEndAfterPadding() - endOffset;
        int fixOffset = 0;
        if (gap <= 0) {
            return 0;
        }
        fixOffset = -this.scrollBy(-gap, recycler, state);
        if (canOffsetChildren && (gap = this.mOrientationHelper.getEndAfterPadding() - (endOffset += fixOffset)) > 0) {
            this.mOrientationHelper.offsetChildren(gap);
            return gap + fixOffset;
        }
        return fixOffset;
    }

    private int fixLayoutStartGap(int startOffset, RecyclerView.Recycler recycler, RecyclerView.State state, boolean canOffsetChildren) {
        int gap = startOffset - this.mOrientationHelper.getStartAfterPadding();
        int fixOffset = 0;
        if (gap <= 0) {
            return 0;
        }
        fixOffset = -this.scrollBy(gap, recycler, state);
        if (canOffsetChildren && (gap = (startOffset += fixOffset) - this.mOrientationHelper.getStartAfterPadding()) > 0) {
            this.mOrientationHelper.offsetChildren(-gap);
            return fixOffset - gap;
        }
        return fixOffset;
    }

    private void updateRenderStateToFillEnd(int itemPosition, int offset) {
        this.mRenderState.mAvailable = this.mOrientationHelper.getEndAfterPadding() - offset;
        this.mRenderState.mItemDirection = this.mShouldReverseLayout ? -1 : 1;
        this.mRenderState.mCurrentPosition = itemPosition;
        this.mRenderState.mLayoutDirection = 1;
        this.mRenderState.mOffset = offset;
        this.mRenderState.mScrollingOffset = Integer.MIN_VALUE;
    }

    private void updateRenderStateToFillStart(int itemPosition, int offset) {
        this.mRenderState.mAvailable = offset - this.mOrientationHelper.getStartAfterPadding();
        this.mRenderState.mCurrentPosition = itemPosition;
        this.mRenderState.mItemDirection = this.mShouldReverseLayout ? 1 : -1;
        this.mRenderState.mLayoutDirection = -1;
        this.mRenderState.mOffset = offset;
        this.mRenderState.mScrollingOffset = Integer.MIN_VALUE;
    }

    private boolean isLayoutRTL() {
        return this.getLayoutDirection() == 1;
    }

    private void ensureRenderState() {
        if (this.mRenderState == null) {
            this.mRenderState = new RenderState();
        }
        if (this.mOrientationHelper == null) {
            this.mOrientationHelper = this.mOrientation == 0 ? this.createHorizontalOrientationHelper() : this.createVerticalOrientationHelper();
        }
    }

    @Override
    public void scrollToPosition(int position) {
        this.mPendingScrollPosition = position;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        this.requestLayout();
    }

    public void scrollToPositionWithOffset(int position, int offset) {
        this.mPendingScrollPosition = position;
        this.mPendingScrollPositionOffset = offset;
        this.requestLayout();
    }

    @Override
    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 1) {
            return 0;
        }
        return this.scrollBy(dx, recycler, state);
    }

    @Override
    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 0) {
            return 0;
        }
        return this.scrollBy(dy, recycler, state);
    }

    @Override
    public int computeHorizontalScrollOffset(RecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        int topPosition = this.getPosition(this.getChildClosestToStart());
        return this.mShouldReverseLayout ? state.getItemCount() - 1 - topPosition : topPosition;
    }

    @Override
    public int computeVerticalScrollOffset(RecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        int topPosition = this.getPosition(this.getChildClosestToStart());
        return this.mShouldReverseLayout ? state.getItemCount() - 1 - topPosition : topPosition;
    }

    @Override
    public int computeHorizontalScrollExtent(RecyclerView.State state) {
        return this.getChildCount();
    }

    @Override
    public int computeVerticalScrollExtent(RecyclerView.State state) {
        return this.getChildCount();
    }

    @Override
    public int computeHorizontalScrollRange(RecyclerView.State state) {
        return state.getItemCount();
    }

    @Override
    public int computeVerticalScrollRange(RecyclerView.State state) {
        return state.getItemCount();
    }

    private void updateRenderState(int layoutDirection, int requiredSpace, boolean canUseExistingSpace, RecyclerView.State state) {
        int fastScrollSpace;
        this.mRenderState.mExtra = this.getExtraLayoutSpace(state);
        this.mRenderState.mLayoutDirection = layoutDirection;
        if (layoutDirection == 1) {
            View child = this.getChildClosestToEnd();
            this.mRenderState.mItemDirection = this.mShouldReverseLayout ? -1 : 1;
            this.mRenderState.mCurrentPosition = this.getPosition(child) + this.mRenderState.mItemDirection;
            this.mRenderState.mOffset = this.mOrientationHelper.getDecoratedEnd(child);
            fastScrollSpace = this.mOrientationHelper.getDecoratedEnd(child) - this.mOrientationHelper.getEndAfterPadding();
        } else {
            View child = this.getChildClosestToStart();
            this.mRenderState.mItemDirection = this.mShouldReverseLayout ? 1 : -1;
            this.mRenderState.mCurrentPosition = this.getPosition(child) + this.mRenderState.mItemDirection;
            this.mRenderState.mOffset = this.mOrientationHelper.getDecoratedStart(child);
            fastScrollSpace = -this.mOrientationHelper.getDecoratedStart(child) + this.mOrientationHelper.getStartAfterPadding();
        }
        this.mRenderState.mAvailable = requiredSpace;
        if (canUseExistingSpace) {
            this.mRenderState.mAvailable -= fastScrollSpace;
        }
        this.mRenderState.mScrollingOffset = fastScrollSpace;
    }

    private int scrollBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || dy == 0) {
            return 0;
        }
        this.ensureRenderState();
        int layoutDirection = dy > 0 ? 1 : -1;
        int absDy = Math.abs(dy);
        this.updateRenderState(layoutDirection, absDy, true, state);
        int freeScroll = this.mRenderState.mScrollingOffset;
        int consumed = freeScroll + this.fill(recycler, this.mRenderState, state, false);
        if (consumed < 0) {
            return 0;
        }
        int scrolled = absDy > consumed ? layoutDirection * consumed : dy;
        this.mOrientationHelper.offsetChildren(-scrolled);
        return scrolled;
    }

    private void recycleChildren(RecyclerView.Recycler recycler, int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            return;
        }
        if (endIndex > startIndex) {
            for (int i = endIndex - 1; i >= startIndex; --i) {
                this.removeAndRecycleViewAt(i, recycler);
            }
        } else {
            for (int i = startIndex; i > endIndex; --i) {
                this.removeAndRecycleViewAt(i, recycler);
            }
        }
    }

    private void recycleViewsFromStart(RecyclerView.Recycler recycler, int dt) {
        if (dt < 0) {
            return;
        }
        int limit = this.mOrientationHelper.getStartAfterPadding() + dt;
        int childCount = this.getChildCount();
        if (this.mShouldReverseLayout) {
            for (int i = childCount - 1; i >= 0; --i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedEnd(child) <= limit) continue;
                this.recycleChildren(recycler, childCount - 1, i);
                return;
            }
        } else {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedEnd(child) <= limit) continue;
                this.recycleChildren(recycler, 0, i);
                return;
            }
        }
    }

    private void recycleViewsFromEnd(RecyclerView.Recycler recycler, int dt) {
        int childCount = this.getChildCount();
        if (dt < 0) {
            return;
        }
        int limit = this.mOrientationHelper.getEndAfterPadding() - dt;
        if (this.mShouldReverseLayout) {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedStart(child) >= limit) continue;
                this.recycleChildren(recycler, 0, i);
                return;
            }
        } else {
            for (int i = childCount - 1; i >= 0; --i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedStart(child) >= limit) continue;
                this.recycleChildren(recycler, childCount - 1, i);
                return;
            }
        }
    }

    private void recycleByRenderState(RecyclerView.Recycler recycler, RenderState renderState) {
        if (renderState.mLayoutDirection == -1) {
            this.recycleViewsFromEnd(recycler, renderState.mScrollingOffset);
        } else {
            this.recycleViewsFromStart(recycler, renderState.mScrollingOffset);
        }
    }

    private int fill(RecyclerView.Recycler recycler, RenderState renderState, RecyclerView.State state, boolean stopOnFocusable) {
        View view;
        int start = renderState.mAvailable;
        if (renderState.mScrollingOffset != Integer.MIN_VALUE) {
            if (renderState.mAvailable < 0) {
                renderState.mScrollingOffset += renderState.mAvailable;
            }
            this.recycleByRenderState(recycler, renderState);
        }
        int remainingSpace = renderState.mAvailable + renderState.mExtra;
        while (remainingSpace > 0 && renderState.hasMore(state) && (view = renderState.next(recycler)) != null) {
            int top;
            int bottom;
            int left;
            int right;
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
            if (!params.isItemRemoved() && this.mRenderState.mScrapList == null) {
                if (this.mShouldReverseLayout == (renderState.mLayoutDirection == -1)) {
                    this.addView(view);
                } else {
                    this.addView(view, 0);
                }
            }
            this.measureChildWithMargins(view, 0, 0);
            int consumed = this.mOrientationHelper.getDecoratedMeasurement(view);
            if (this.mOrientation == 1) {
                if (this.isLayoutRTL()) {
                    right = this.getWidth() - this.getPaddingRight();
                    left = right - this.mOrientationHelper.getDecoratedMeasurementInOther(view);
                } else {
                    left = this.getPaddingLeft();
                    right = left + this.mOrientationHelper.getDecoratedMeasurementInOther(view);
                }
                if (renderState.mLayoutDirection == -1) {
                    bottom = renderState.mOffset;
                    top = renderState.mOffset - consumed;
                } else {
                    top = renderState.mOffset;
                    bottom = renderState.mOffset + consumed;
                }
            } else {
                top = this.getPaddingTop();
                bottom = top + this.mOrientationHelper.getDecoratedMeasurementInOther(view);
                if (renderState.mLayoutDirection == -1) {
                    right = renderState.mOffset;
                    left = renderState.mOffset - consumed;
                } else {
                    left = renderState.mOffset;
                    right = renderState.mOffset + consumed;
                }
            }
            this.layoutDecorated(view, left + params.leftMargin, top + params.topMargin, right - params.rightMargin, bottom - params.bottomMargin);
            renderState.mOffset += consumed * renderState.mLayoutDirection;
            if (!params.isItemRemoved()) {
                renderState.mAvailable -= consumed;
                remainingSpace -= consumed;
            }
            if (renderState.mScrollingOffset != Integer.MIN_VALUE) {
                renderState.mScrollingOffset += consumed;
                if (renderState.mAvailable < 0) {
                    renderState.mScrollingOffset += renderState.mAvailable;
                }
                this.recycleByRenderState(recycler, renderState);
            }
            if ((!stopOnFocusable || !view.isFocusable()) && (state == null || state.getTargetScrollPosition() != this.getPosition(view))) continue;
            break;
        }
        return start - renderState.mAvailable;
    }

    private int convertFocusDirectionToLayoutDirection(int focusDirection) {
        switch (focusDirection) {
            case 1: {
                return -1;
            }
            case 2: {
                return 1;
            }
            case 33: {
                return this.mOrientation == 1 ? -1 : Integer.MIN_VALUE;
            }
            case 130: {
                return this.mOrientation == 1 ? 1 : Integer.MIN_VALUE;
            }
            case 17: {
                return this.mOrientation == 0 ? -1 : Integer.MIN_VALUE;
            }
            case 66: {
                return this.mOrientation == 0 ? 1 : Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    private View getChildClosestToStart() {
        return this.getChildAt(this.mShouldReverseLayout ? this.getChildCount() - 1 : 0);
    }

    private View getChildClosestToEnd() {
        return this.getChildAt(this.mShouldReverseLayout ? 0 : this.getChildCount() - 1);
    }

    @Override
    public View onFocusSearchFailed(View focused, int focusDirection, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.resolveShouldLayoutReverse();
        if (this.getChildCount() == 0) {
            return null;
        }
        int layoutDir = this.convertFocusDirectionToLayoutDirection(focusDirection);
        if (layoutDir == Integer.MIN_VALUE) {
            return null;
        }
        View referenceChild = layoutDir == -1 ? this.getChildClosestToStart() : this.getChildClosestToEnd();
        this.ensureRenderState();
        int maxScroll = (int)(0.33f * (float)(this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getStartAfterPadding()));
        this.updateRenderState(layoutDir, maxScroll, false, state);
        this.mRenderState.mScrollingOffset = Integer.MIN_VALUE;
        this.fill(recycler, this.mRenderState, state, true);
        View nextFocus = layoutDir == -1 ? this.getChildClosestToStart() : this.getChildClosestToEnd();
        if (nextFocus == referenceChild || !nextFocus.isFocusable()) {
            return null;
        }
        return nextFocus;
    }

    private void logChildren() {
        Log.d((String)TAG, (String)"internal representation of views on the screen");
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            Log.d((String)TAG, (String)("item " + this.getPosition(child) + ", coord:" + this.mOrientationHelper.getDecoratedStart(child)));
        }
        Log.d((String)TAG, (String)"==============");
    }

    private void validateChildOrder() {
        Log.d((String)TAG, (String)("validating child count " + this.getChildCount()));
        if (this.getChildCount() < 1) {
            return;
        }
        int lastPos = this.getPosition(this.getChildAt(0));
        int lastScreenLoc = this.mOrientationHelper.getDecoratedStart(this.getChildAt(0));
        if (this.mShouldReverseLayout) {
            for (int i = 1; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                int pos = this.getPosition(child);
                int screenLoc = this.mOrientationHelper.getDecoratedStart(child);
                if (pos < lastPos) {
                    this.logChildren();
                    throw new RuntimeException("detected invalid position. loc invalid? " + (screenLoc < lastScreenLoc));
                }
                if (screenLoc <= lastScreenLoc) continue;
                this.logChildren();
                throw new RuntimeException("detected invalid location");
            }
        } else {
            for (int i = 1; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                int pos = this.getPosition(child);
                int screenLoc = this.mOrientationHelper.getDecoratedStart(child);
                if (pos < lastPos) {
                    this.logChildren();
                    throw new RuntimeException("detected invalid position. loc invalid? " + (screenLoc < lastScreenLoc));
                }
                if (screenLoc >= lastScreenLoc) continue;
                this.logChildren();
                throw new RuntimeException("detected invalid location");
            }
        }
    }

    @Override
    public boolean supportsItemAnimations() {
        return true;
    }

    private OrientationHelper createVerticalOrientationHelper() {
        return new OrientationHelper(){

            @Override
            public int getEndAfterPadding() {
                return LinearLayoutManager.this.getHeight() - LinearLayoutManager.this.getPaddingBottom();
            }

            @Override
            public void offsetChildren(int amount) {
                LinearLayoutManager.this.offsetChildrenVertical(amount);
            }

            @Override
            public int getStartAfterPadding() {
                return LinearLayoutManager.this.getPaddingTop();
            }

            @Override
            public int getDecoratedMeasurement(View view) {
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
                return LinearLayoutManager.this.getDecoratedMeasuredHeight(view) + params.topMargin + params.bottomMargin;
            }

            @Override
            public int getDecoratedMeasurementInOther(View view) {
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
                return LinearLayoutManager.this.getDecoratedMeasuredWidth(view) + params.leftMargin + params.rightMargin;
            }

            @Override
            public int getDecoratedEnd(View view) {
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
                return LinearLayoutManager.this.getDecoratedBottom(view) + params.bottomMargin;
            }

            @Override
            public int getDecoratedStart(View view) {
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
                return LinearLayoutManager.this.getDecoratedTop(view) - params.topMargin;
            }

            @Override
            public int getTotalSpace() {
                return LinearLayoutManager.this.getHeight() - LinearLayoutManager.this.getPaddingTop() - LinearLayoutManager.this.getPaddingBottom();
            }
        };
    }

    private OrientationHelper createHorizontalOrientationHelper() {
        return new OrientationHelper(){

            @Override
            public int getEndAfterPadding() {
                return LinearLayoutManager.this.getWidth() - LinearLayoutManager.this.getPaddingRight();
            }

            @Override
            public void offsetChildren(int amount) {
                LinearLayoutManager.this.offsetChildrenHorizontal(amount);
            }

            @Override
            public int getStartAfterPadding() {
                return LinearLayoutManager.this.getPaddingLeft();
            }

            @Override
            public int getDecoratedMeasurement(View view) {
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
                return LinearLayoutManager.this.getDecoratedMeasuredWidth(view) + params.leftMargin + params.rightMargin;
            }

            @Override
            public int getDecoratedMeasurementInOther(View view) {
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
                return LinearLayoutManager.this.getDecoratedMeasuredHeight(view) + params.topMargin + params.bottomMargin;
            }

            @Override
            public int getDecoratedEnd(View view) {
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
                return LinearLayoutManager.this.getDecoratedRight(view) + params.rightMargin;
            }

            @Override
            public int getDecoratedStart(View view) {
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
                return LinearLayoutManager.this.getDecoratedLeft(view) - params.leftMargin;
            }

            @Override
            public int getTotalSpace() {
                return LinearLayoutManager.this.getWidth() - LinearLayoutManager.this.getPaddingLeft() - LinearLayoutManager.this.getPaddingRight();
            }
        };
    }

    static class SavedState
    implements Parcelable {
        int mOrientation;
        int mAnchorPosition;
        int mAnchorOffset;
        boolean mReverseLayout;
        boolean mStackFromEnd;
        boolean mAnchorLayoutFromEnd;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState() {
        }

        SavedState(Parcel in) {
            this.mOrientation = in.readInt();
            this.mAnchorPosition = in.readInt();
            this.mAnchorOffset = in.readInt();
            this.mReverseLayout = in.readInt() == 1;
            this.mStackFromEnd = in.readInt() == 1;
            this.mAnchorLayoutFromEnd = in.readInt() == 1;
        }

        public SavedState(SavedState other) {
            this.mOrientation = other.mOrientation;
            this.mAnchorPosition = other.mAnchorPosition;
            this.mAnchorOffset = other.mAnchorOffset;
            this.mReverseLayout = other.mReverseLayout;
            this.mStackFromEnd = other.mStackFromEnd;
            this.mAnchorLayoutFromEnd = other.mAnchorLayoutFromEnd;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mOrientation);
            dest.writeInt(this.mAnchorPosition);
            dest.writeInt(this.mAnchorOffset);
            dest.writeInt(this.mReverseLayout ? 1 : 0);
            dest.writeInt(this.mStackFromEnd ? 1 : 0);
            dest.writeInt(this.mAnchorLayoutFromEnd ? 1 : 0);
        }
    }

    private static interface OrientationHelper {
        public int getDecoratedStart(View var1);

        public int getDecoratedEnd(View var1);

        public int getDecoratedMeasurement(View var1);

        public int getDecoratedMeasurementInOther(View var1);

        public int getStartAfterPadding();

        public int getEndAfterPadding();

        public void offsetChildren(int var1);

        public int getTotalSpace();
    }

    private static class RenderState {
        static final String TAG = "LinearLayoutManager#RenderState";
        static final int LAYOUT_START = -1;
        static final int LAYOUT_END = 1;
        static final int INVALID_LAYOUT = Integer.MIN_VALUE;
        static final int ITEM_DIRECTION_HEAD = -1;
        static final int ITEM_DIRECTION_TAIL = 1;
        static final int SCOLLING_OFFSET_NaN = Integer.MIN_VALUE;
        int mOffset;
        int mAvailable;
        int mCurrentPosition;
        int mItemDirection;
        int mLayoutDirection;
        int mScrollingOffset;
        int mExtra = 0;
        List<RecyclerView.ViewHolder> mScrapList = null;

        private RenderState() {
        }

        boolean hasMore(RecyclerView.State state) {
            return this.mCurrentPosition >= 0 && this.mCurrentPosition < state.getItemCount();
        }

        View next(RecyclerView.Recycler recycler) {
            if (this.mScrapList != null) {
                return this.nextFromLimitedList();
            }
            View view = recycler.getViewForPosition(this.mCurrentPosition);
            this.mCurrentPosition += this.mItemDirection;
            return view;
        }

        private View nextFromLimitedList() {
            int size = this.mScrapList.size();
            RecyclerView.ViewHolder closest = null;
            int closestDistance = Integer.MAX_VALUE;
            for (int i = 0; i < size; ++i) {
                RecyclerView.ViewHolder viewHolder = this.mScrapList.get(i);
                int distance = (viewHolder.getPosition() - this.mCurrentPosition) * this.mItemDirection;
                if (distance < 0 || distance >= closestDistance) continue;
                closest = viewHolder;
                closestDistance = distance;
                if (distance == 0) break;
            }
            if (closest != null) {
                this.mCurrentPosition = closest.getPosition() + this.mItemDirection;
                return closest.itemView;
            }
            return null;
        }

        void log() {
            Log.d((String)TAG, (String)("avail:" + this.mAvailable + ", ind:" + this.mCurrentPosition + ", dir:" + this.mItemDirection + ", offset:" + this.mOffset + ", layoutDir:" + this.mLayoutDirection));
        }
    }
}

