/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import java.util.ArrayList;

public class DefaultItemAnimator
extends RecyclerView.ItemAnimator {
    private ArrayList<RecyclerView.ViewHolder> mPendingRemovals = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mPendingAdditions = new ArrayList();
    private ArrayList<MoveInfo> mPendingMoves = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mAdditions = new ArrayList();
    private ArrayList<MoveInfo> mMoves = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mAddAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mMoveAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mRemoveAnimations = new ArrayList();

    @Override
    public void runPendingAnimations() {
        View view;
        boolean additionsPending;
        boolean removalsPending = !this.mPendingRemovals.isEmpty();
        boolean movesPending = !this.mPendingMoves.isEmpty();
        boolean bl = additionsPending = !this.mPendingAdditions.isEmpty();
        if (!(removalsPending || movesPending || additionsPending)) {
            return;
        }
        for (RecyclerView.ViewHolder holder : this.mPendingRemovals) {
            this.animateRemoveImpl(holder);
        }
        this.mPendingRemovals.clear();
        if (movesPending) {
            this.mMoves.addAll(this.mPendingMoves);
            this.mPendingMoves.clear();
            Runnable mover = new Runnable(){

                @Override
                public void run() {
                    for (MoveInfo moveInfo : DefaultItemAnimator.this.mMoves) {
                        DefaultItemAnimator.this.animateMoveImpl(moveInfo.holder, moveInfo.fromX, moveInfo.fromY, moveInfo.toX, moveInfo.toY);
                    }
                    DefaultItemAnimator.this.mMoves.clear();
                }
            };
            if (removalsPending) {
                view = this.mMoves.get((int)0).holder.itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)mover, (long)this.getRemoveDuration());
            } else {
                mover.run();
            }
        }
        if (additionsPending) {
            this.mAdditions.addAll(this.mPendingAdditions);
            this.mPendingAdditions.clear();
            Runnable adder = new Runnable(){

                @Override
                public void run() {
                    for (RecyclerView.ViewHolder holder : DefaultItemAnimator.this.mAdditions) {
                        DefaultItemAnimator.this.animateAddImpl(holder);
                    }
                    DefaultItemAnimator.this.mAdditions.clear();
                }
            };
            if (removalsPending || movesPending) {
                view = this.mAdditions.get((int)0).itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)adder, (long)((removalsPending ? this.getRemoveDuration() : 0L) + (movesPending ? this.getMoveDuration() : 0L)));
            } else {
                adder.run();
            }
        }
    }

    @Override
    public boolean animateRemove(RecyclerView.ViewHolder holder) {
        this.mPendingRemovals.add(holder);
        return true;
    }

    private void animateRemoveImpl(final RecyclerView.ViewHolder holder) {
        View view = holder.itemView;
        ViewCompat.animate((View)view).cancel();
        ViewCompat.animate((View)view).setDuration(this.getRemoveDuration()).alpha(0.0f).setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

            @Override
            public void onAnimationEnd(View view) {
                ViewCompat.setAlpha((View)view, (float)1.0f);
                DefaultItemAnimator.this.dispatchRemoveFinished(holder);
                DefaultItemAnimator.this.mRemoveAnimations.remove(holder);
                DefaultItemAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
        this.mRemoveAnimations.add(holder);
    }

    @Override
    public boolean animateAdd(RecyclerView.ViewHolder holder) {
        ViewCompat.setAlpha((View)holder.itemView, (float)0.0f);
        this.mPendingAdditions.add(holder);
        return true;
    }

    private void animateAddImpl(final RecyclerView.ViewHolder holder) {
        View view = holder.itemView;
        ViewCompat.animate((View)view).cancel();
        ViewCompat.animate((View)view).alpha(1.0f).setDuration(this.getAddDuration()).setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

            @Override
            public void onAnimationCancel(View view) {
                ViewCompat.setAlpha((View)view, (float)1.0f);
            }

            @Override
            public void onAnimationEnd(View view) {
                DefaultItemAnimator.this.dispatchAddFinished(holder);
                DefaultItemAnimator.this.mAddAnimations.remove(holder);
                DefaultItemAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
        this.mAddAnimations.add(holder);
    }

    @Override
    public boolean animateMove(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        View view = holder.itemView;
        int deltaX = toX - fromX;
        int deltaY = toY - fromY;
        if (deltaX == 0 && deltaY == 0) {
            this.dispatchMoveFinished(holder);
            return false;
        }
        if (deltaX != 0) {
            ViewCompat.setTranslationX((View)view, (float)(-deltaX));
        }
        if (deltaY != 0) {
            ViewCompat.setTranslationY((View)view, (float)(-deltaY));
        }
        this.mPendingMoves.add(new MoveInfo(holder, fromX, fromY, toX, toY));
        return true;
    }

    private void animateMoveImpl(final RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        View view = holder.itemView;
        final int deltaX = toX - fromX;
        final int deltaY = toY - fromY;
        ViewCompat.animate((View)view).cancel();
        if (deltaX != 0) {
            ViewCompat.animate((View)view).translationX(0.0f);
        }
        if (deltaY != 0) {
            ViewCompat.animate((View)view).translationY(0.0f);
        }
        ViewCompat.animate((View)view).setDuration(this.getMoveDuration()).setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

            @Override
            public void onAnimationCancel(View view) {
                if (deltaX != 0) {
                    ViewCompat.setTranslationX((View)view, (float)0.0f);
                }
                if (deltaY != 0) {
                    ViewCompat.setTranslationY((View)view, (float)0.0f);
                }
            }

            @Override
            public void onAnimationEnd(View view) {
                DefaultItemAnimator.this.dispatchMoveFinished(holder);
                DefaultItemAnimator.this.mMoveAnimations.remove(holder);
                DefaultItemAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
        this.mMoveAnimations.add(holder);
    }

    @Override
    public void endAnimation(RecyclerView.ViewHolder item) {
        View view = item.itemView;
        ViewCompat.animate((View)view).cancel();
        if (this.mMoveAnimations.contains(item)) {
            ViewCompat.setTranslationY((View)view, (float)0.0f);
            ViewCompat.setTranslationX((View)view, (float)0.0f);
            this.dispatchMoveFinished(item);
            this.mMoveAnimations.remove(item);
        }
        if (this.mRemoveAnimations.contains(item)) {
            ViewCompat.setAlpha((View)view, (float)1.0f);
            this.dispatchRemoveFinished(item);
            this.mRemoveAnimations.remove(item);
        }
        if (this.mAddAnimations.contains(item)) {
            ViewCompat.setAlpha((View)view, (float)1.0f);
            this.dispatchAddFinished(item);
            this.mAddAnimations.remove(item);
        }
        this.dispatchFinishedWhenDone();
    }

    @Override
    public boolean isRunning() {
        return !this.mMoveAnimations.isEmpty() || !this.mRemoveAnimations.isEmpty() || !this.mAddAnimations.isEmpty() || !this.mMoves.isEmpty() || !this.mAdditions.isEmpty();
    }

    private void dispatchFinishedWhenDone() {
        if (!this.isRunning()) {
            this.dispatchAnimationsFinished();
        }
    }

    @Override
    public void endAnimations() {
        View view;
        RecyclerView.ViewHolder item;
        int i;
        if (!this.isRunning()) {
            return;
        }
        int count = this.mMoveAnimations.size();
        for (i = count - 1; i >= 0; --i) {
            item = this.mMoveAnimations.get(i);
            view = item.itemView;
            ViewCompat.animate((View)view).cancel();
            ViewCompat.setTranslationY((View)view, (float)0.0f);
            ViewCompat.setTranslationX((View)view, (float)0.0f);
            this.dispatchMoveFinished(item);
            this.mMoveAnimations.remove(item);
        }
        count = this.mRemoveAnimations.size();
        for (i = count - 1; i >= 0; --i) {
            item = this.mRemoveAnimations.get(i);
            view = item.itemView;
            ViewCompat.animate((View)view).cancel();
            ViewCompat.setAlpha((View)view, (float)1.0f);
            this.dispatchRemoveFinished(item);
            this.mRemoveAnimations.remove(item);
        }
        count = this.mAddAnimations.size();
        for (i = count - 1; i >= 0; --i) {
            item = this.mAddAnimations.get(i);
            view = item.itemView;
            ViewCompat.animate((View)view).cancel();
            ViewCompat.setAlpha((View)view, (float)1.0f);
            this.dispatchAddFinished(item);
            this.mAddAnimations.remove(item);
        }
        this.mMoves.clear();
        this.mAdditions.clear();
        this.dispatchAnimationsFinished();
    }

    private static class VpaListenerAdapter
    implements ViewPropertyAnimatorListener {
        private VpaListenerAdapter() {
        }

        public void onAnimationStart(View view) {
        }

        public void onAnimationEnd(View view) {
        }

        public void onAnimationCancel(View view) {
        }
    }

    private static class MoveInfo {
        public RecyclerView.ViewHolder holder;
        public int fromX;
        public int fromY;
        public int toX;
        public int toY;

        private MoveInfo(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
            this.holder = holder;
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
        }
    }
}

