/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.jl;
import com.google.android.gms.internal.jt;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.ad;
import com.google.android.gms.wearable.internal.af;
import com.google.android.gms.wearable.internal.ag;
import com.google.android.gms.wearable.internal.az;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class ba
extends jl<af> {
    private final ExecutorService asJ = Executors.newCachedThreadPool();
    private final ag<DataApi.DataListener> ayg = new ag.b();
    private final ag<MessageApi.MessageListener> ayh = new ag.c();
    private final ag<NodeApi.NodeListener> ayi = new ag.d();

    public ba(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, new String[0]);
    }

    @Override
    protected String bK() {
        return "com.google.android.gms.wearable.BIND";
    }

    @Override
    protected String bL() {
        return "com.google.android.gms.wearable.internal.IWearableService";
    }

    protected af cb(IBinder iBinder) {
        return af.a.bZ(iBinder);
    }

    @Override
    protected void a(jt jt2, jl.e e2) throws RemoteException {
        jt2.e(e2, 6587000, this.getContext().getPackageName());
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (Log.isLoggable((String)"WearableClient", (int)2)) {
            Log.d((String)"WearableClient", (String)("onPostInitHandler: statusCode " + n2));
        }
        if (n2 == 0) {
            this.ayg.ca(iBinder);
            this.ayh.ca(iBinder);
            this.ayi.ca(iBinder);
        }
        super.a(n2, iBinder, bundle);
    }

    @Override
    public void disconnect() {
        this.ayg.b(this);
        this.ayh.b(this);
        this.ayi.b(this);
        super.disconnect();
    }

    public void a(BaseImplementation.b<DataApi.DataItemResult> b2, PutDataRequest putDataRequest) throws RemoteException {
        Map.Entry<String, Asset> entry22;
        for (Map.Entry<String, Asset> entry22 : putDataRequest.getAssets().entrySet()) {
            Asset asset = entry22.getValue();
            if (asset.getData() != null || asset.getDigest() != null || asset.getFd() != null || asset.getUri() != null) continue;
            throw new IllegalArgumentException("Put for " + putDataRequest.getUri() + " contains invalid asset: " + asset);
        }
        PutDataRequest putDataRequest2 = PutDataRequest.k(putDataRequest.getUri());
        putDataRequest2.setData(putDataRequest.getData());
        entry22 = new ArrayList();
        for (Map.Entry entry3 : putDataRequest.getAssets().entrySet()) {
            ParcelFileDescriptor[] parcelFileDescriptorArray;
            Asset asset = (Asset)entry3.getValue();
            if (asset.getData() == null) {
                putDataRequest2.putAsset((String)entry3.getKey(), (Asset)entry3.getValue());
                continue;
            }
            try {
                parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to create ParcelFileDescriptor for asset in request: " + putDataRequest, iOException);
            }
            if (Log.isLoggable((String)"WearableClient", (int)3)) {
                Log.d((String)"WearableClient", (String)("processAssets: replacing data with FD in asset: " + asset + " read:" + parcelFileDescriptorArray[0] + " write:" + parcelFileDescriptorArray[1]));
            }
            putDataRequest2.putAsset((String)entry3.getKey(), Asset.createFromFd(parcelFileDescriptorArray[0]));
            FutureTask<Boolean> futureTask = this.a(parcelFileDescriptorArray[1], asset.getData());
            entry22.add(futureTask);
            this.asJ.submit(futureTask);
        }
        try {
            ((af)this.hw()).a((ad)new az.i(b2, (List<FutureTask<Boolean>>)((Object)entry22)), putDataRequest2);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Unable to putDataItem: " + putDataRequest, nullPointerException);
        }
    }

    private FutureTask<Boolean> a(final ParcelFileDescriptor parcelFileDescriptor, final byte[] byArray) {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean rr() {
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    Log.d((String)"WearableClient", (String)("processAssets: writing data to FD : " + parcelFileDescriptor));
                }
                ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
                try {
                    autoCloseOutputStream.write(byArray);
                    autoCloseOutputStream.flush();
                    if (Log.isLoggable((String)"WearableClient", (int)3)) {
                        Log.d((String)"WearableClient", (String)("processAssets: wrote data: " + parcelFileDescriptor));
                    }
                    Boolean bl2 = true;
                    return bl2;
                }
                catch (IOException iOException) {
                    Log.w((String)"WearableClient", (String)("processAssets: writing data failed: " + parcelFileDescriptor));
                }
                finally {
                    try {
                        if (Log.isLoggable((String)"WearableClient", (int)3)) {
                            Log.d((String)"WearableClient", (String)("processAssets: closing: " + parcelFileDescriptor));
                        }
                        autoCloseOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.rr();
            }
        });
    }

    public void a(BaseImplementation.b<DataApi.DataItemResult> b2, Uri uri) throws RemoteException {
        ((af)this.hw()).a((ad)new az.d(b2), uri);
    }

    public void n(BaseImplementation.b<DataItemBuffer> b2) throws RemoteException {
        ((af)this.hw()).b(new az.e(b2));
    }

    public void b(BaseImplementation.b<DataItemBuffer> b2, Uri uri) throws RemoteException {
        ((af)this.hw()).b((ad)new az.e(b2), uri);
    }

    public void c(BaseImplementation.b<DataApi.DeleteDataItemsResult> b2, Uri uri) throws RemoteException {
        ((af)this.hw()).c((ad)new az.b(b2), uri);
    }

    public void a(BaseImplementation.b<MessageApi.SendMessageResult> b2, String string2, String string3, byte[] byArray) throws RemoteException {
        ((af)this.hw()).a(new az.j(b2), string2, string3, byArray);
    }

    public void a(BaseImplementation.b<DataApi.GetFdForAssetResult> b2, Asset asset) throws RemoteException {
        ((af)this.hw()).a((ad)new az.f(b2), asset);
    }

    public void a(BaseImplementation.b<DataApi.GetFdForAssetResult> b2, DataItemAsset dataItemAsset) throws RemoteException {
        this.a(b2, Asset.createFromRef(dataItemAsset.getId()));
    }

    public void o(BaseImplementation.b<NodeApi.GetLocalNodeResult> b2) throws RemoteException {
        ((af)this.hw()).c(new az.g(b2));
    }

    public void p(BaseImplementation.b<NodeApi.GetConnectedNodesResult> b2) throws RemoteException {
        ((af)this.hw()).d(new az.c(b2));
    }

    public void a(BaseImplementation.b<Status> b2, DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) throws RemoteException {
        this.ayg.a(this, b2, dataListener, intentFilterArray);
    }

    public void a(BaseImplementation.b<Status> b2, MessageApi.MessageListener messageListener, IntentFilter[] intentFilterArray) throws RemoteException {
        this.ayh.a(this, b2, messageListener, intentFilterArray);
    }

    public void a(BaseImplementation.b<Status> b2, NodeApi.NodeListener nodeListener) throws RemoteException, RemoteException {
        this.ayi.a(this, b2, nodeListener, null);
    }

    public void a(BaseImplementation.b<Status> b2, DataApi.DataListener dataListener) throws RemoteException {
        this.ayg.a(this, b2, dataListener);
    }

    public void a(BaseImplementation.b<Status> b2, MessageApi.MessageListener messageListener) throws RemoteException {
        this.ayh.a(this, b2, messageListener);
    }

    public void b(BaseImplementation.b<Status> b2, NodeApi.NodeListener nodeListener) throws RemoteException {
        this.ayi.a(this, b2, nodeListener);
    }

    @Override
    protected /* synthetic */ IInterface l(IBinder iBinder) {
        return this.cb(iBinder);
    }
}

