/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.dynamic.e;
import com.google.android.gms.dynamic.f;
import com.google.android.gms.internal.qa;
import com.google.android.gms.internal.qb;
import com.google.android.gms.internal.qi;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class WalletFragment
extends Fragment {
    private b awn;
    private boolean mCreated = false;
    private final com.google.android.gms.dynamic.b awo = com.google.android.gms.dynamic.b.a(this);
    private final c awp = new c();
    private a awq = new a(this);
    private final Fragment TG = this;
    private WalletFragmentOptions awe;
    private WalletFragmentInitParams awf;
    private MaskedWalletRequest awg;
    private MaskedWallet awh;
    private Boolean awi;

    public static WalletFragment newInstance(WalletFragmentOptions options) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        walletFragment.TG.setArguments(bundle);
        return walletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.awn != null) {
            this.awn.initialize(initParams);
            this.awf = null;
        } else if (this.awf == null) {
            this.awf = initParams;
            if (this.awg != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.awh != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.awn != null) {
            this.awn.updateMaskedWalletRequest(request);
            this.awg = null;
        } else {
            this.awg = request;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.awn != null) {
            this.awn.updateMaskedWallet(maskedWallet);
            this.awh = null;
        } else {
            this.awh = maskedWallet;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.awn != null) {
            this.awn.setEnabled(enabled);
            this.awi = null;
        } else {
            this.awi = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.awq.a(listener);
    }

    public int getState() {
        return this.awn != null ? this.awn.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.awe == null) {
            this.awe = WalletFragmentOptions.a((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.awe);
        this.awp.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.awf != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.awf = walletFragmentInitParams;
            }
            if (this.awg == null) {
                this.awg = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (this.awh == null) {
                this.awh = (MaskedWallet)savedInstanceState.getParcelable("maskedWallet");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.awe = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.awi = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.TG.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.TG.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.ab((Context)this.TG.getActivity());
            this.awe = walletFragmentOptions;
        }
        this.mCreated = true;
        this.awp.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.awp.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.awp.onStart();
    }

    public void onResume() {
        super.onResume();
        this.awp.onResume();
        FragmentManager fragmentManager = this.TG.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.TG.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment(n2, this.TG.getActivity(), -1);
        }
    }

    public void onPause() {
        super.onPause();
        this.awp.onPause();
    }

    public void onStop() {
        super.onStop();
        this.awp.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.awp.onSaveInstanceState(outState);
        if (this.awf != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.awf);
            this.awf = null;
        }
        if (this.awg != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.awg);
            this.awg = null;
        }
        if (this.awh != null) {
            outState.putParcelable("maskedWallet", (Parcelable)this.awh);
            this.awh = null;
        }
        if (this.awe != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.awe);
            this.awe = null;
        }
        if (this.awi != null) {
            outState.putBoolean("enabled", this.awi.booleanValue());
            this.awi = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.awn != null) {
            this.awn.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class a
    extends qb.a {
        private OnStateChangedListener awr;
        private final WalletFragment aws;

        a(WalletFragment walletFragment) {
            this.aws = walletFragment;
        }

        @Override
        public void a(int n2, int n3, Bundle bundle) {
            if (this.awr != null) {
                this.awr.onStateChanged(this.aws, n2, n3, bundle);
            }
        }

        public void a(OnStateChangedListener onStateChangedListener) {
            this.awr = onStateChangedListener;
        }
    }

    private static class b
    implements LifecycleDelegate {
        private final qa awl;

        private b(qa qa2) {
            this.awl = qa2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.awl.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.awl.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.awl.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.awl.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.awl.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.awl.a(e.k(activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onCreate(Bundle savedInstanceState) {
            try {
                this.awl.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                d d2 = this.awl.onCreateView(e.k(inflater), e.k(container), savedInstanceState);
                return (View)e.f(d2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onStart() {
            try {
                this.awl.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onResume() {
            try {
                this.awl.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onPause() {
            try {
                this.awl.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onStop() {
            try {
                this.awl.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onDestroyView() {
        }

        @Override
        public void onDestroy() {
        }

        @Override
        public void onLowMemory() {
        }

        @Override
        public void onSaveInstanceState(Bundle outState) {
            try {
                this.awl.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.awl.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class c
    extends com.google.android.gms.dynamic.a<b>
    implements View.OnClickListener {
        private c() {
        }

        @Override
        protected void a(f<b> f2) {
            Activity activity = WalletFragment.this.TG.getActivity();
            if (WalletFragment.this.awn == null && WalletFragment.this.mCreated && activity != null) {
                try {
                    qa qa2 = qi.a(activity, WalletFragment.this.awo, WalletFragment.this.awe, WalletFragment.this.awq);
                    WalletFragment.this.awn = new b(qa2);
                    WalletFragment.this.awe = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                f2.a(WalletFragment.this.awn);
                if (WalletFragment.this.awf != null) {
                    WalletFragment.this.awn.initialize(WalletFragment.this.awf);
                    WalletFragment.this.awf = null;
                }
                if (WalletFragment.this.awg != null) {
                    WalletFragment.this.awn.updateMaskedWalletRequest(WalletFragment.this.awg);
                    WalletFragment.this.awg = null;
                }
                if (WalletFragment.this.awh != null) {
                    WalletFragment.this.awn.updateMaskedWallet(WalletFragment.this.awh);
                    WalletFragment.this.awh = null;
                }
                if (WalletFragment.this.awi != null) {
                    WalletFragment.this.awn.setEnabled(WalletFragment.this.awi);
                    WalletFragment.this.awi = null;
                }
            }
        }

        @Override
        protected void a(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)WalletFragment.this.TG.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n2 = -1;
            int n3 = -2;
            if (WalletFragment.this.awe != null && (walletFragmentStyle = WalletFragment.this.awe.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = WalletFragment.this.TG.getResources().getDisplayMetrics();
                n2 = walletFragmentStyle.a("buyButtonWidth", displayMetrics, n2);
                n3 = walletFragmentStyle.a("buyButtonHeight", displayMetrics, n3);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n2, n3));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            Activity activity = WalletFragment.this.TG.getActivity();
            int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
            GooglePlayServicesUtil.showErrorDialogFragment(n2, activity, -1);
        }
    }
}

