/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Bitmap;
import android.location.Location;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.dynamic.e;
import com.google.android.gms.internal.jx;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.LocationSource;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.UiSettings;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.ILocationSourceDelegate;
import com.google.android.gms.maps.internal.b;
import com.google.android.gms.maps.internal.d;
import com.google.android.gms.maps.internal.f;
import com.google.android.gms.maps.internal.g;
import com.google.android.gms.maps.internal.h;
import com.google.android.gms.maps.internal.i;
import com.google.android.gms.maps.internal.j;
import com.google.android.gms.maps.internal.k;
import com.google.android.gms.maps.internal.l;
import com.google.android.gms.maps.internal.n;
import com.google.android.gms.maps.internal.o;
import com.google.android.gms.maps.internal.p;
import com.google.android.gms.maps.internal.q;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.IndoorBuilding;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.TileOverlay;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.internal.j;
import com.google.android.gms.maps.model.internal.l;
import com.google.android.gms.maps.model.internal.n;

public final class GoogleMap {
    public static final int MAP_TYPE_NONE = 0;
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_TERRAIN = 3;
    public static final int MAP_TYPE_HYBRID = 4;
    private final IGoogleMapDelegate akm;
    private UiSettings akn;

    protected GoogleMap(IGoogleMapDelegate map) {
        this.akm = jx.i(map);
    }

    IGoogleMapDelegate nC() {
        return this.akm;
    }

    public final CameraPosition getCameraPosition() {
        try {
            return this.akm.getCameraPosition();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getMaxZoomLevel() {
        try {
            return this.akm.getMaxZoomLevel();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getMinZoomLevel() {
        try {
            return this.akm.getMinZoomLevel();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void moveCamera(CameraUpdate update) {
        try {
            this.akm.moveCamera(update.nA());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate update) {
        try {
            this.akm.animateCamera(update.nA());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate update, CancelableCallback callback) {
        try {
            this.akm.animateCameraWithCallback(update.nA(), callback == null ? null : new a(callback));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate update, int durationMs, CancelableCallback callback) {
        try {
            this.akm.animateCameraWithDurationAndCallback(update.nA(), durationMs, callback == null ? null : new a(callback));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void stopAnimation() {
        try {
            this.akm.stopAnimation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Polyline addPolyline(PolylineOptions options) {
        try {
            return new Polyline(this.akm.addPolyline(options));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Polygon addPolygon(PolygonOptions options) {
        try {
            return new Polygon(this.akm.addPolygon(options));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Circle addCircle(CircleOptions options) {
        try {
            return new Circle(this.akm.addCircle(options));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Marker addMarker(MarkerOptions options) {
        try {
            l l2 = this.akm.addMarker(options);
            if (l2 != null) {
                return new Marker(l2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final GroundOverlay addGroundOverlay(GroundOverlayOptions options) {
        try {
            com.google.android.gms.maps.model.internal.i i2 = this.akm.addGroundOverlay(options);
            if (i2 != null) {
                return new GroundOverlay(i2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final TileOverlay addTileOverlay(TileOverlayOptions options) {
        try {
            n n2 = this.akm.addTileOverlay(options);
            if (n2 != null) {
                return new TileOverlay(n2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void clear() {
        try {
            this.akm.clear();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public IndoorBuilding getFocusedBuilding() {
        try {
            j j2 = this.akm.getFocusedBuilding();
            if (j2 != null) {
                return new IndoorBuilding(j2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnIndoorStateChangeListener(final OnIndoorStateChangeListener listener) {
        try {
            if (listener == null) {
                this.akm.setOnIndoorStateChangeListener(null);
            } else {
                this.akm.setOnIndoorStateChangeListener(new g.a(){

                    @Override
                    public void onIndoorBuildingFocused() {
                        listener.onIndoorBuildingFocused();
                    }

                    @Override
                    public void a(j j2) {
                        listener.onIndoorLevelActivated(new IndoorBuilding(j2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int getMapType() {
        try {
            return this.akm.getMapType();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setMapType(int type) {
        try {
            this.akm.setMapType(type);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isTrafficEnabled() {
        try {
            return this.akm.isTrafficEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setTrafficEnabled(boolean enabled) {
        try {
            this.akm.setTrafficEnabled(enabled);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isIndoorEnabled() {
        try {
            return this.akm.isIndoorEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean setIndoorEnabled(boolean enabled) {
        try {
            return this.akm.setIndoorEnabled(enabled);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isBuildingsEnabled() {
        try {
            return this.akm.isBuildingsEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setBuildingsEnabled(boolean enabled) {
        try {
            this.akm.setBuildingsEnabled(enabled);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isMyLocationEnabled() {
        try {
            return this.akm.isMyLocationEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setMyLocationEnabled(boolean enabled) {
        try {
            this.akm.setMyLocationEnabled(enabled);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final Location getMyLocation() {
        try {
            return this.akm.getMyLocation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setLocationSource(final LocationSource source) {
        try {
            if (source == null) {
                this.akm.setLocationSource(null);
            } else {
                this.akm.setLocationSource(new ILocationSourceDelegate.a(){

                    @Override
                    public void activate(final i listener) {
                        source.activate(new LocationSource.OnLocationChangedListener(){

                            @Override
                            public void onLocationChanged(Location location) {
                                try {
                                    listener.d(location);
                                }
                                catch (RemoteException remoteException) {
                                    throw new RuntimeRemoteException(remoteException);
                                }
                            }
                        });
                    }

                    @Override
                    public void deactivate() {
                        source.deactivate();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final UiSettings getUiSettings() {
        try {
            if (this.akn == null) {
                this.akn = new UiSettings(this.akm.getUiSettings());
            }
            return this.akn;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Projection getProjection() {
        try {
            return new Projection(this.akm.getProjection());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraChangeListener(final OnCameraChangeListener listener) {
        try {
            if (listener == null) {
                this.akm.setOnCameraChangeListener(null);
            } else {
                this.akm.setOnCameraChangeListener(new f.a(){

                    @Override
                    public void onCameraChange(CameraPosition position) {
                        listener.onCameraChange(position);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMapClickListener(final OnMapClickListener listener) {
        try {
            if (listener == null) {
                this.akm.setOnMapClickListener(null);
            } else {
                this.akm.setOnMapClickListener(new j.a(){

                    @Override
                    public void onMapClick(LatLng point) {
                        listener.onMapClick(point);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMapLongClickListener(final OnMapLongClickListener listener) {
        try {
            if (listener == null) {
                this.akm.setOnMapLongClickListener(null);
            } else {
                this.akm.setOnMapLongClickListener(new l.a(){

                    @Override
                    public void onMapLongClick(LatLng point) {
                        listener.onMapLongClick(point);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMarkerClickListener(final OnMarkerClickListener listener) {
        try {
            if (listener == null) {
                this.akm.setOnMarkerClickListener(null);
            } else {
                this.akm.setOnMarkerClickListener(new n.a(){

                    @Override
                    public boolean a(l l2) {
                        return listener.onMarkerClick(new Marker(l2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMarkerDragListener(final OnMarkerDragListener listener) {
        try {
            if (listener == null) {
                this.akm.setOnMarkerDragListener(null);
            } else {
                this.akm.setOnMarkerDragListener(new o.a(){

                    @Override
                    public void b(l l2) {
                        listener.onMarkerDragStart(new Marker(l2));
                    }

                    @Override
                    public void c(l l2) {
                        listener.onMarkerDragEnd(new Marker(l2));
                    }

                    @Override
                    public void d(l l2) {
                        listener.onMarkerDrag(new Marker(l2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowClickListener(final OnInfoWindowClickListener listener) {
        try {
            if (listener == null) {
                this.akm.setOnInfoWindowClickListener(null);
            } else {
                this.akm.setOnInfoWindowClickListener(new h.a(){

                    @Override
                    public void e(l l2) {
                        listener.onInfoWindowClick(new Marker(l2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setInfoWindowAdapter(final InfoWindowAdapter adapter) {
        try {
            if (adapter == null) {
                this.akm.setInfoWindowAdapter(null);
            } else {
                this.akm.setInfoWindowAdapter(new d.a(){

                    @Override
                    public d f(l l2) {
                        return e.k(adapter.getInfoWindow(new Marker(l2)));
                    }

                    @Override
                    public d g(l l2) {
                        return e.k(adapter.getInfoContents(new Marker(l2)));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final void setOnMyLocationChangeListener(final OnMyLocationChangeListener listener) {
        try {
            if (listener == null) {
                this.akm.setOnMyLocationChangeListener(null);
            } else {
                this.akm.setOnMyLocationChangeListener(new q.a(){

                    @Override
                    public void g(d d2) {
                        listener.onMyLocationChange((Location)e.f(d2));
                    }

                    @Override
                    public void c(Location location) {
                        listener.onMyLocationChange(location);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMyLocationButtonClickListener(final OnMyLocationButtonClickListener listener) {
        try {
            if (listener == null) {
                this.akm.setOnMyLocationButtonClickListener(null);
            } else {
                this.akm.setOnMyLocationButtonClickListener(new p.a(){

                    @Override
                    public boolean onMyLocationButtonClick() throws RemoteException {
                        return listener.onMyLocationButtonClick();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setOnMapLoadedCallback(final OnMapLoadedCallback callback) {
        try {
            if (callback == null) {
                this.akm.setOnMapLoadedCallback(null);
            } else {
                this.akm.setOnMapLoadedCallback(new k.a(){

                    @Override
                    public void onMapLoaded() throws RemoteException {
                        callback.onMapLoaded();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void snapshot(SnapshotReadyCallback callback) {
        this.snapshot(callback, null);
    }

    public final void snapshot(final SnapshotReadyCallback callback, Bitmap bitmap) {
        e e2 = (e)(bitmap != null ? e.k(bitmap) : null);
        try {
            this.akm.snapshot(new v.a(){

                @Override
                public void onSnapshotReady(Bitmap snapshot) throws RemoteException {
                    callback.onSnapshotReady(snapshot);
                }

                @Override
                public void h(d d2) throws RemoteException {
                    callback.onSnapshotReady((Bitmap)e.f(d2));
                }
            }, e2);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setPadding(int left, int top, int right, int bottom) {
        try {
            this.akm.setPadding(left, top, right, bottom);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setContentDescription(String description) {
        try {
            this.akm.setContentDescription(description);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    private static final class a
    extends b.a {
        private final CancelableCallback akE;

        a(CancelableCallback cancelableCallback) {
            this.akE = cancelableCallback;
        }

        @Override
        public void onFinish() {
            this.akE.onFinish();
        }

        @Override
        public void onCancel() {
            this.akE.onCancel();
        }
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMyLocationButtonClickListener {
        public boolean onMyLocationButtonClick();
    }

    @Deprecated
    public static interface OnMyLocationChangeListener {
        public void onMyLocationChange(Location var1);
    }

    public static interface InfoWindowAdapter {
        public View getInfoWindow(Marker var1);

        public View getInfoContents(Marker var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface CancelableCallback {
        public void onFinish();

        public void onCancel();
    }

    public static interface OnInfoWindowClickListener {
        public void onInfoWindowClick(Marker var1);
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDragStart(Marker var1);

        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnCameraChangeListener {
        public void onCameraChange(CameraPosition var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);
    }

    public static interface OnIndoorStateChangeListener {
        public void onIndoorBuildingFocused();

        public void onIndoorLevelActivated(IndoorBuilding var1);
    }
}

