/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.jx;
import com.google.android.gms.internal.nn;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.a;
import java.util.ArrayList;
import java.util.List;

public class GeofencingRequest
implements SafeParcelable {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new a();
    private final int CK;
    private final List<nn> ago;
    private final int agp;

    GeofencingRequest(int version, List<nn> geofences, int initialTrigger) {
        this.CK = version;
        this.ago = geofences;
        this.agp = initialTrigger;
    }

    private GeofencingRequest(List<nn> geofences, int initialTrigger) {
        this(1, geofences, initialTrigger);
    }

    public int getVersionCode() {
        return this.CK;
    }

    public List<nn> ng() {
        return this.ago;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.ago);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.agp;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        a.a(this, dest, flags);
    }

    public static final class Builder {
        private final List<nn> ago = new ArrayList<nn>();
        private int agp = 5;

        public Builder addGeofence(Geofence geofence) {
            jx.b(geofence, (Object)"geofence can't be null.");
            jx.b(geofence instanceof nn, (Object)"Geofence must be created using Geofence.Builder.");
            this.ago.add((nn)geofence);
            return this;
        }

        public Builder addGeofences(List<Geofence> geofences) {
            if (geofences == null || geofences.isEmpty()) {
                return this;
            }
            for (Geofence geofence : geofences) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public Builder setInitialTrigger(int initialTrigger) {
            this.agp = Builder.ew(initialTrigger);
            return this;
        }

        public static int ew(int n2) {
            return n2 & 7;
        }

        public GeofencingRequest build() {
            jx.b(!this.ago.isEmpty(), (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.ago, this.agp);
        }
    }
}

