/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.internal.il;
import com.google.android.gms.internal.in;
import com.google.android.gms.internal.iv;
import com.google.android.gms.internal.iw;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class it
extends il {
    private static final String NAMESPACE = in.aG("com.google.cast.media");
    private static final long HR = TimeUnit.HOURS.toMillis(24L);
    private static final long HS = TimeUnit.HOURS.toMillis(24L);
    private static final long HT = TimeUnit.HOURS.toMillis(24L);
    private static final long HU = TimeUnit.SECONDS.toMillis(1L);
    private long HV;
    private MediaStatus HW;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final iw HX;
    private final iw HY;
    private final iw HZ;
    private final iw Ia;
    private final iw Ib;
    private final iw Ic;
    private final iw Id;
    private final iw Ie;
    private final iw If;
    private final iw Ig;
    private final List<iw> Ih;
    private final Runnable Ii = new a();
    private boolean Ij;

    public it() {
        this(null);
    }

    public it(String string2) {
        super(NAMESPACE, "MediaControlChannel", string2);
        this.Ih = new ArrayList<iw>();
        this.HX = new iw(HS);
        this.Ih.add(this.HX);
        this.HY = new iw(HR);
        this.Ih.add(this.HY);
        this.HZ = new iw(HR);
        this.Ih.add(this.HZ);
        this.Ia = new iw(HR);
        this.Ih.add(this.Ia);
        this.Ib = new iw(HT);
        this.Ih.add(this.Ib);
        this.Ic = new iw(HR);
        this.Ih.add(this.Ic);
        this.Id = new iw(HR);
        this.Ih.add(this.Id);
        this.Ie = new iw(HR);
        this.Ih.add(this.Ie);
        this.If = new iw(HR);
        this.Ih.add(this.If);
        this.Ig = new iw(HR);
        this.Ih.add(this.Ig);
        this.gp();
    }

    public long a(iv iv2, MediaInfo mediaInfo, boolean bl2, long l2, long[] lArray, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.fU();
        this.HX.a(l3, iv2);
        this.J(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.toJson());
            jSONObject2.put("autoplay", bl2);
            jSONObject2.put("currentTime", in.o(l2));
            if (lArray != null && lArray.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i2 = 0; i2 < lArray.length; ++i2) {
                    jSONArray.put(i2, lArray[i2]);
                }
                jSONObject2.put("activeTrackIds", (Object)jSONArray);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long a(iv iv2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.fU();
        this.HY.a(l2, iv2);
        this.J(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.fR());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long b(iv iv2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.fU();
        this.Ia.a(l2, iv2);
        this.J(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.fR());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long c(iv iv2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.fU();
        this.HZ.a(l2, iv2);
        this.J(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.fR());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(iv iv2, long l2, int n2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.fU();
        this.Ib.a(l3, iv2);
        this.J(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.fR());
            jSONObject2.put("currentTime", in.o(l2));
            if (n2 == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n2 == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long a(iv iv2, double d2, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Volume cannot be " + d2);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.fU();
        this.Ic.a(l2, iv2);
        this.J(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.fR());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d2);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(iv iv2, boolean bl2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.fU();
        this.Id.a(l2, iv2);
        this.J(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.fR());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl2);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(iv iv2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.fU();
        this.Ie.a(l2, iv2);
        this.J(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.HW != null) {
                jSONObject.put("mediaSessionId", this.HW.fR());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long a(iv iv2, long[] lArray) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.fU();
        this.If.a(l2, iv2);
        this.J(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.fR());
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                jSONArray.put(i2, lArray[i2]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long a(iv iv2, TextTrackStyle textTrackStyle) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.fU();
        this.Ig.a(l2, iv2);
        this.J(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.toJson());
            }
            jSONObject.put("mediaSessionId", this.fR());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.HV == 0L) {
            return 0L;
        }
        double d2 = this.HW.getPlaybackRate();
        long l2 = this.HW.getStreamPosition();
        int n2 = this.HW.getPlayerState();
        if (d2 == 0.0 || n2 != 2) {
            return l2;
        }
        long l3 = SystemClock.elapsedRealtime() - this.HV;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l2;
        }
        long l4 = mediaInfo.getStreamDuration();
        long l5 = l2 + (long)((double)l3 * d2);
        if (l4 > 0L && l5 > l4) {
            l5 = l4;
        } else if (l5 < 0L) {
            l5 = 0L;
        }
        return l5;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.HW;
    }

    public MediaInfo getMediaInfo() {
        return this.HW == null ? null : this.HW.getMediaInfo();
    }

    @Override
    public final void aD(String string2) {
        this.He.b("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l2 = jSONObject.optLong("requestId", -1L);
            if (string3.equals("MEDIA_STATUS")) {
                JSONArray jSONArray = jSONObject.getJSONArray("status");
                if (jSONArray.length() > 0) {
                    this.a(l2, jSONArray.getJSONObject(0));
                } else {
                    this.HW = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.Ie.d(l2, 0);
                }
            } else if (string3.equals("INVALID_PLAYER_STATE")) {
                this.He.d("received unexpected error: Invalid Player State.", new Object[0]);
                JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                for (iw iw2 : this.Ih) {
                    iw2.b(l2, 2100, jSONObject2);
                }
            } else if (string3.equals("LOAD_FAILED")) {
                JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                this.HX.b(l2, 2100, jSONObject3);
            } else if (string3.equals("LOAD_CANCELLED")) {
                JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                this.HX.b(l2, 2101, jSONObject4);
            } else if (string3.equals("INVALID_REQUEST")) {
                this.He.d("received unexpected error: Invalid Request.", new Object[0]);
                JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                for (iw iw3 : this.Ih) {
                    iw3.b(l2, 2100, jSONObject5);
                }
            }
        }
        catch (JSONException jSONException) {
            this.He.d("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
        }
    }

    @Override
    public void b(long l2, int n2) {
        for (iw iw2 : this.Ih) {
            iw2.d(l2, n2);
        }
    }

    private void a(long l2, JSONObject jSONObject) throws JSONException {
        boolean bl2 = this.HX.p(l2);
        boolean bl3 = this.Ib.gr() && !this.Ib.p(l2);
        boolean bl4 = this.Ic.gr() && !this.Ic.p(l2) || this.Id.gr() && !this.Id.p(l2);
        int n2 = 0;
        if (bl3) {
            n2 |= 2;
        }
        if (bl4) {
            n2 |= 1;
        }
        int n3 = 0;
        if (bl2 || this.HW == null) {
            this.HW = new MediaStatus(jSONObject);
            this.HV = SystemClock.elapsedRealtime();
            n3 = 7;
        } else {
            n3 = this.HW.a(jSONObject, n2);
        }
        if ((n3 & 1) != 0) {
            this.HV = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n3 & 2) != 0) {
            this.HV = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n3 & 4) != 0) {
            this.onMetadataUpdated();
        }
        for (iw iw2 : this.Ih) {
            iw2.d(l2, 0);
        }
    }

    public long fR() throws IllegalStateException {
        if (this.HW == null) {
            throw new IllegalStateException("No current media session");
        }
        return this.HW.fR();
    }

    protected void onStatusUpdated() {
    }

    protected void onMetadataUpdated() {
    }

    private void gp() {
        this.J(false);
        this.HV = 0L;
        this.HW = null;
        this.HX.clear();
        this.Ib.clear();
        this.Ic.clear();
    }

    @Override
    public void fV() {
        this.gp();
    }

    private void J(boolean bl2) {
        if (this.Ij != bl2) {
            this.Ij = bl2;
            if (bl2) {
                this.mHandler.postDelayed(this.Ii, HU);
            } else {
                this.mHandler.removeCallbacks(this.Ii);
            }
        }
    }

    private class a
    implements Runnable {
        private a() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object2;
            it.this.Ij = false;
            long l2 = SystemClock.elapsedRealtime();
            for (Object object2 : it.this.Ih) {
                ((iw)object2).e(l2, 2102);
            }
            boolean bl2 = false;
            object2 = iw.Ip;
            synchronized (object2) {
                for (iw iw2 : it.this.Ih) {
                    if (!iw2.gr()) continue;
                    bl2 = true;
                }
            }
            it.this.J(bl2);
        }
    }
}

