/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.internal.ey;
import com.google.android.gms.internal.gi;
import com.google.android.gms.internal.gq;
import java.util.Locale;

@ey
public final class fv {
    public final int vg;
    public final boolean vh;
    public final boolean vi;
    public final String vj;
    public final String vk;
    public final boolean vl;
    public final boolean vm;
    public final boolean vn;
    public final String vo;
    public final String vp;
    public final int vq;
    public final int vr;
    public final int vs;
    public final int vt;
    public final int vu;
    public final int vv;
    public final float vw;
    public final int vx;
    public final int vy;
    public final double vz;
    public final boolean vA;
    public final boolean vB;
    public final int vC;

    public fv(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Locale locale = Locale.getDefault();
        PackageManager packageManager = context.getPackageManager();
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        this.vg = audioManager.getMode();
        this.vh = fv.a(packageManager, "geo:0,0?q=donuts") != null;
        this.vi = fv.a(packageManager, "http://www.google.com") != null;
        this.vj = telephonyManager.getNetworkOperator();
        this.vk = locale.getCountry();
        this.vl = gq.dA();
        this.vm = audioManager.isMusicActive();
        this.vn = audioManager.isSpeakerphoneOn();
        this.vo = locale.getLanguage();
        this.vp = fv.a(packageManager);
        this.vq = audioManager.getStreamVolume(3);
        this.vr = fv.a(context, connectivityManager, packageManager);
        this.vs = telephonyManager.getNetworkType();
        this.vt = telephonyManager.getPhoneType();
        this.vu = audioManager.getRingerMode();
        this.vv = audioManager.getStreamVolume(2);
        this.vw = displayMetrics.density;
        this.vx = displayMetrics.widthPixels;
        this.vy = displayMetrics.heightPixels;
        if (intent != null) {
            int n2 = intent.getIntExtra("status", -1);
            int n3 = intent.getIntExtra("level", -1);
            int n4 = intent.getIntExtra("scale", -1);
            this.vz = (float)n3 / (float)n4;
            this.vA = n2 == 2 || n2 == 5;
        } else {
            this.vz = -1.0;
            this.vA = false;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.vB = connectivityManager.isActiveNetworkMetered();
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            this.vC = networkInfo != null ? connectivityManager.getActiveNetworkInfo().getDetailedState().ordinal() : -1;
        } else {
            this.vB = false;
            this.vC = -1;
        }
    }

    private static String a(PackageManager packageManager) {
        ResolveInfo resolveInfo = fv.a(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
            return packageInfo != null ? packageInfo.versionCode + "." + activityInfo.packageName : null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static int a(Context context, ConnectivityManager connectivityManager, PackageManager packageManager) {
        int n2 = -2;
        if (gi.a(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            n2 = networkInfo != null ? networkInfo.getType() : -1;
        }
        return n2;
    }

    private static ResolveInfo a(PackageManager packageManager, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        return packageManager.resolveActivity(intent, 65536);
    }
}

