/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.d;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;

public final class SnapshotMetadataRef
extends d
implements SnapshotMetadata {
    private final Game adq;
    private final Player afn;

    public SnapshotMetadataRef(DataHolder holder, int dataRow) {
        super(holder, dataRow);
        this.adq = new GameRef(holder, dataRow);
        this.afn = new PlayerRef(holder, dataRow);
    }

    @Override
    public Game getGame() {
        return this.adq;
    }

    @Override
    public Player getOwner() {
        return this.afn;
    }

    @Override
    public String getSnapshotId() {
        return this.getString("external_snapshot_id");
    }

    @Override
    public Uri getCoverImageUri() {
        return this.aR("cover_icon_image_uri");
    }

    @Override
    public String getCoverImageUrl() {
        return this.getString("cover_icon_image_url");
    }

    @Override
    public float getCoverImageAspectRatio() {
        float f2 = this.getFloat("cover_icon_image_height");
        float f3 = this.getFloat("cover_icon_image_width");
        if (f2 == 0.0f) {
            return 0.0f;
        }
        return f3 / f2;
    }

    @Override
    public String getUniqueName() {
        return this.getString("unique_name");
    }

    @Override
    public String getTitle() {
        return this.getString("title");
    }

    @Override
    public String getDescription() {
        return this.getString("description");
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        this.a("description", dataOut);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.getLong("last_modified_timestamp");
    }

    @Override
    public long getPlayedTime() {
        return this.getLong("duration");
    }

    @Override
    public boolean hasChangePending() {
        return this.getInteger("pending_change_count") > 0;
    }

    @Override
    public SnapshotMetadata freeze() {
        return new SnapshotMetadataEntity(this);
    }

    @Override
    public int hashCode() {
        return SnapshotMetadataEntity.a(this);
    }

    @Override
    public boolean equals(Object obj) {
        return SnapshotMetadataEntity.a(this, obj);
    }

    public String toString() {
        return SnapshotMetadataEntity.b(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        SnapshotMetadataEntity snapshotMetadataEntity = (SnapshotMetadataEntity)this.freeze();
        snapshotMetadataEntity.writeToParcel(dest, flags);
    }
}

