/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.le;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
implements SafeParcelable,
Quest {
    public static final QuestEntityCreator CREATOR = new QuestEntityCreator();
    private final int CK;
    private final GameEntity acs;
    private final String aeK;
    private final long aeL;
    private final Uri aeM;
    private final String aeN;
    private final String UO;
    private final long aeO;
    private final long XH;
    private final Uri aeP;
    private final String aeQ;
    private final String mName;
    private final long aeR;
    private final long aeS;
    private final int mState;
    private final int Gt;
    private final ArrayList<MilestoneEntity> aeT;

    public QuestEntity(Quest quest) {
        this.CK = 2;
        this.acs = new GameEntity(quest.getGame());
        this.aeK = quest.getQuestId();
        this.aeL = quest.getAcceptedTimestamp();
        this.UO = quest.getDescription();
        this.aeM = quest.getBannerImageUri();
        this.aeN = quest.getBannerImageUrl();
        this.aeO = quest.getEndTimestamp();
        this.aeP = quest.getIconImageUri();
        this.aeQ = quest.getIconImageUrl();
        this.XH = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.aeR = quest.mR();
        this.aeS = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.Gt = quest.getType();
        List<Milestone> list = quest.mQ();
        int n2 = list.size();
        this.aeT = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.aeT.add((MilestoneEntity)list.get(i2).freeze());
        }
    }

    QuestEntity(int versionCode, GameEntity game, String questId, long acceptedTimestamp, Uri bannerImageUri, String bannerImageUrl, String description, long endTimestamp, long lastUpdatedTimestamp, Uri iconImageUri, String iconImageUrl, String name, long notifyTimestamp, long startTimestamp, int state, int type, ArrayList<MilestoneEntity> milestones) {
        this.CK = versionCode;
        this.acs = game;
        this.aeK = questId;
        this.aeL = acceptedTimestamp;
        this.aeM = bannerImageUri;
        this.aeN = bannerImageUrl;
        this.UO = description;
        this.aeO = endTimestamp;
        this.XH = lastUpdatedTimestamp;
        this.aeP = iconImageUri;
        this.aeQ = iconImageUrl;
        this.mName = name;
        this.aeR = notifyTimestamp;
        this.aeS = startTimestamp;
        this.mState = state;
        this.Gt = type;
        this.aeT = milestones;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public String getQuestId() {
        return this.aeK;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        le.b(this.mName, dataOut);
    }

    @Override
    public String getDescription() {
        return this.UO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        le.b(this.UO, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.aeP;
    }

    @Override
    public String getIconImageUrl() {
        return this.aeQ;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.aeM;
    }

    @Override
    public String getBannerImageUrl() {
        return this.aeN;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.mQ().get(0);
    }

    @Override
    public List<Milestone> mQ() {
        return new ArrayList<Milestone>(this.aeT);
    }

    @Override
    public Game getGame() {
        return this.acs;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.Gt;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.aeL;
    }

    @Override
    public long getEndTimestamp() {
        return this.aeO;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.XH;
    }

    @Override
    public long mR() {
        return this.aeR;
    }

    @Override
    public long getStartTimestamp() {
        return this.aeS;
    }

    @Override
    public boolean isEndingSoon() {
        return this.aeR <= System.currentTimeMillis() + 1800000L;
    }

    @Override
    public Quest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.a(this);
    }

    static int a(Quest quest) {
        return jv.hashCode(quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.mQ(), quest.getName(), quest.mR(), quest.getStartTimestamp(), quest.getState());
    }

    public boolean equals(Object obj) {
        return QuestEntity.a(this, obj);
    }

    static boolean a(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return jv.equal(quest2.getGame(), quest.getGame()) && jv.equal(quest2.getQuestId(), quest.getQuestId()) && jv.equal(quest2.getAcceptedTimestamp(), quest.getAcceptedTimestamp()) && jv.equal(quest2.getBannerImageUri(), quest.getBannerImageUri()) && jv.equal(quest2.getDescription(), quest.getDescription()) && jv.equal(quest2.getEndTimestamp(), quest.getEndTimestamp()) && jv.equal(quest2.getIconImageUri(), quest.getIconImageUri()) && jv.equal(quest2.getLastUpdatedTimestamp(), quest.getLastUpdatedTimestamp()) && jv.equal(quest2.mQ(), quest.mQ()) && jv.equal(quest2.getName(), quest.getName()) && jv.equal(quest2.mR(), quest.mR()) && jv.equal(quest2.getStartTimestamp(), quest.getStartTimestamp()) && jv.equal(quest2.getState(), quest.getState());
    }

    public String toString() {
        return QuestEntity.b(this);
    }

    static String b(Quest quest) {
        return jv.h(quest).a("Game", quest.getGame()).a("QuestId", quest.getQuestId()).a("AcceptedTimestamp", quest.getAcceptedTimestamp()).a("BannerImageUri", quest.getBannerImageUri()).a("BannerImageUrl", quest.getBannerImageUrl()).a("Description", quest.getDescription()).a("EndTimestamp", quest.getEndTimestamp()).a("IconImageUri", quest.getIconImageUri()).a("IconImageUrl", quest.getIconImageUrl()).a("LastUpdatedTimestamp", quest.getLastUpdatedTimestamp()).a("Milestones", quest.mQ()).a("Name", quest.getName()).a("NotifyTimestamp", quest.mR()).a("StartTimestamp", quest.getStartTimestamp()).a("State", quest.getState()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        QuestEntityCreator.a(this, out, flags);
    }
}

