/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntityCreator;
import com.google.android.gms.internal.jv;

public final class MilestoneEntity
implements SafeParcelable,
Milestone {
    public static final MilestoneEntityCreator CREATOR = new MilestoneEntityCreator();
    private final int CK;
    private final String Zn;
    private final long aeH;
    private final long aeI;
    private final byte[] aeJ;
    private final int mState;
    private final String Ye;

    public MilestoneEntity(Milestone milestone) {
        this.CK = 4;
        this.Zn = milestone.getMilestoneId();
        this.aeH = milestone.getCurrentProgress();
        this.aeI = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.Ye = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.aeJ = null;
        } else {
            this.aeJ = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.aeJ, 0, byArray.length);
        }
    }

    MilestoneEntity(int versionCode, String milestoneId, long currentProgress, long targetProgress, byte[] completionBlob, int state, String eventId) {
        this.CK = versionCode;
        this.Zn = milestoneId;
        this.aeH = currentProgress;
        this.aeI = targetProgress;
        this.aeJ = completionBlob;
        this.mState = state;
        this.Ye = eventId;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public String getEventId() {
        return this.Ye;
    }

    @Override
    public String getMilestoneId() {
        return this.Zn;
    }

    @Override
    public long getCurrentProgress() {
        return this.aeH;
    }

    @Override
    public long getTargetProgress() {
        return this.aeI;
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.aeJ;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public Milestone freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return MilestoneEntity.a(this);
    }

    static int a(Milestone milestone) {
        return jv.hashCode(milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId());
    }

    public boolean equals(Object obj) {
        return MilestoneEntity.a(this, obj);
    }

    static boolean a(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return jv.equal(milestone2.getMilestoneId(), milestone.getMilestoneId()) && jv.equal(milestone2.getCurrentProgress(), milestone.getCurrentProgress()) && jv.equal(milestone2.getTargetProgress(), milestone.getTargetProgress()) && jv.equal(milestone2.getState(), milestone.getState()) && jv.equal(milestone2.getEventId(), milestone.getEventId());
    }

    public String toString() {
        return MilestoneEntity.b(this);
    }

    static String b(Milestone milestone) {
        return jv.h(milestone).a("MilestoneId", milestone.getMilestoneId()).a("CurrentProgress", milestone.getCurrentProgress()).a("TargetProgress", milestone.getTargetProgress()).a("State", milestone.getState()).a("CompletionRewardData", milestone.getCompletionRewardData()).a("EventId", milestone.getEventId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        MilestoneEntityCreator.a(this, out, flags);
    }
}

