/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfigImpl;
import com.google.android.gms.internal.jx;
import java.util.ArrayList;

public abstract class TurnBasedMatchConfig {
    protected TurnBasedMatchConfig() {
    }

    public abstract int getVariant();

    public abstract int mO();

    public abstract String[] getInvitedPlayerIds();

    public abstract Bundle getAutoMatchCriteria();

    public static Builder builder() {
        return new Builder();
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        int adW = -1;
        ArrayList<String> ael = new ArrayList();
        Bundle aem = null;
        int aew = 2;

        private Builder() {
        }

        public Builder addInvitedPlayer(String playerId) {
            jx.i(playerId);
            this.ael.add(playerId);
            return this;
        }

        public Builder addInvitedPlayers(ArrayList<String> playerIds) {
            jx.i(playerIds);
            this.ael.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            jx.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or TurnBasedMatch.MATCH_VARIANT_ANY");
            this.adW = variant;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.aem = autoMatchCriteria;
            return this;
        }

        public TurnBasedMatchConfig build() {
            return new TurnBasedMatchConfigImpl(this);
        }
    }
}

