/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomEntityCreator;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.le;
import java.util.ArrayList;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new RoomEntityCreatorCompat();
    private final int CK;
    private final String YI;
    private final String aep;
    private final long adS;
    private final int aeq;
    private final String UO;
    private final int adW;
    private final Bundle aem;
    private final ArrayList<ParticipantEntity> adV;
    private final int aer;

    public RoomEntity(Room room) {
        this.CK = 2;
        this.YI = room.getRoomId();
        this.aep = room.getCreatorId();
        this.adS = room.getCreationTimestamp();
        this.aeq = room.getStatus();
        this.UO = room.getDescription();
        this.adW = room.getVariant();
        this.aem = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        this.adV = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.adV.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
        this.aer = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants, int autoMatchWaitEstimateSeconds) {
        this.CK = versionCode;
        this.YI = roomId;
        this.aep = creatorId;
        this.adS = creationTimestamp;
        this.aeq = roomStatus;
        this.UO = description;
        this.adW = variant;
        this.aem = autoMatchCriteria;
        this.adV = participants;
        this.aer = autoMatchWaitEstimateSeconds;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public String getRoomId() {
        return this.YI;
    }

    @Override
    public String getCreatorId() {
        return this.aep;
    }

    @Override
    public long getCreationTimestamp() {
        return this.adS;
    }

    @Override
    public int getStatus() {
        return this.aeq;
    }

    @Override
    public String getDescription() {
        return this.UO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        le.b(this.UO, dataOut);
    }

    @Override
    public int getVariant() {
        return this.adW;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.aem;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.adV);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.aer;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return RoomEntity.a((Room)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return RoomEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return RoomEntity.c(this, participantId);
    }

    @Override
    public Room freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.a(this);
    }

    static int a(Room room) {
        return jv.hashCode(room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds());
    }

    public boolean equals(Object obj) {
        return RoomEntity.a((Room)this, obj);
    }

    static boolean a(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return jv.equal(room2.getRoomId(), room.getRoomId()) && jv.equal(room2.getCreatorId(), room.getCreatorId()) && jv.equal(room2.getCreationTimestamp(), room.getCreationTimestamp()) && jv.equal(room2.getStatus(), room.getStatus()) && jv.equal(room2.getDescription(), room.getDescription()) && jv.equal(room2.getVariant(), room.getVariant()) && jv.equal(room2.getAutoMatchCriteria(), room.getAutoMatchCriteria()) && jv.equal(room2.getParticipants(), room.getParticipants()) && jv.equal(room2.getAutoMatchWaitEstimateSeconds(), room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.b(this);
    }

    static String b(Room room) {
        return jv.h(room).a("RoomId", room.getRoomId()).a("CreatorId", room.getCreatorId()).a("CreationTimestamp", room.getCreationTimestamp()).a("RoomStatus", room.getStatus()).a("Description", room.getDescription()).a("Variant", room.getVariant()).a("AutoMatchCriteria", room.getAutoMatchCriteria()).a("Participants", room.getParticipants()).a("AutoMatchWaitEstimateSeconds", room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.hu()) {
            RoomEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.YI);
            dest.writeString(this.aep);
            dest.writeLong(this.adS);
            dest.writeInt(this.aeq);
            dest.writeString(this.UO);
            dest.writeInt(this.adW);
            dest.writeBundle(this.aem);
            int n2 = this.adV.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.adV.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static int a(Room room, String string2) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string2 + " is not in room " + room.getRoomId());
    }

    static ArrayList<String> c(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(Room room, String string2) {
        String string3 = null;
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string2)) continue;
            string3 = participant.getParticipantId();
            break;
        }
        return string3;
    }

    static Participant c(Room room, String string2) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + room.getRoomId());
    }

    static final class RoomEntityCreatorCompat
    extends RoomEntityCreator {
        RoomEntityCreatorCompat() {
        }

        @Override
        public RoomEntity cC(Parcel parcel) {
            int n2;
            boolean bl2 = RoomEntity.c(RoomEntity.ht());
            if (bl2 || RoomEntity.aW(RoomEntity.class.getCanonicalName())) {
                return super.cC(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            String string4 = parcel.readString();
            int n4 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n5 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n5);
            for (n2 = 0; n2 < n5; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            return new RoomEntity(2, string2, string3, l2, n3, string4, n4, bundle, arrayList, n2);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cC(x0);
        }
    }
}

