/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.le;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int CK;
    private final String Zk;
    private final String OS;
    private final Uri WD;
    private final Uri WE;
    private final int FP;
    private final String Yi;
    private final boolean adZ;
    private final PlayerEntity XE;
    private final int FO;
    private final ParticipantResult aea;
    private final String WO;
    private final String WP;

    public ParticipantEntity(Participant participant) {
        this.CK = 3;
        this.Zk = participant.getParticipantId();
        this.OS = participant.getDisplayName();
        this.WD = participant.getIconImageUri();
        this.WE = participant.getHiResImageUri();
        this.FP = participant.getStatus();
        this.Yi = participant.le();
        this.adZ = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.XE = player == null ? null : new PlayerEntity(player);
        this.FO = participant.getCapabilities();
        this.aea = participant.getResult();
        this.WO = participant.getIconImageUrl();
        this.WP = participant.getHiResImageUrl();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result, String iconImageUrl, String hiResImageUrl) {
        this.CK = versionCode;
        this.Zk = participantId;
        this.OS = displayName;
        this.WD = iconImageUri;
        this.WE = hiResImageUri;
        this.FP = status;
        this.Yi = clientAddress;
        this.adZ = connectedToRoom;
        this.XE = player;
        this.FO = capabilities;
        this.aea = result;
        this.WO = iconImageUrl;
        this.WP = hiResImageUrl;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public int getStatus() {
        return this.FP;
    }

    @Override
    public String le() {
        return this.Yi;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.adZ;
    }

    @Override
    public String getDisplayName() {
        if (this.XE == null) {
            return this.OS;
        }
        return this.XE.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.XE == null) {
            le.b(this.OS, dataOut);
            return;
        }
        this.XE.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.XE == null) {
            return this.WD;
        }
        return this.XE.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.XE == null) {
            return this.WO;
        }
        return this.XE.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.XE == null) {
            return this.WE;
        }
        return this.XE.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.XE == null) {
            return this.WP;
        }
        return this.XE.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.Zk;
    }

    @Override
    public Player getPlayer() {
        return this.XE;
    }

    @Override
    public ParticipantResult getResult() {
        return this.aea;
    }

    @Override
    public int getCapabilities() {
        return this.FO;
    }

    @Override
    public Participant freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    static int a(Participant participant) {
        return jv.hashCode(participant.getPlayer(), participant.getStatus(), participant.le(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    static boolean a(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return jv.equal(participant2.getPlayer(), participant.getPlayer()) && jv.equal(participant2.getStatus(), participant.getStatus()) && jv.equal(participant2.le(), participant.le()) && jv.equal(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && jv.equal(participant2.getDisplayName(), participant.getDisplayName()) && jv.equal(participant2.getIconImageUri(), participant.getIconImageUri()) && jv.equal(participant2.getHiResImageUri(), participant.getHiResImageUri()) && jv.equal(participant2.getCapabilities(), participant.getCapabilities()) && jv.equal(participant2.getResult(), participant.getResult()) && jv.equal(participant2.getParticipantId(), participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    static String b(Participant participant) {
        return jv.h(participant).a("ParticipantId", participant.getParticipantId()).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.le()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("IconImageUrl", participant.getIconImageUrl()).a("HiResImage", participant.getHiResImageUri()).a("HiResImageUrl", participant.getHiResImageUrl()).a("Capabilities", participant.getCapabilities()).a("Result", participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.hu()) {
            ParticipantEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.Zk);
            dest.writeString(this.OS);
            dest.writeString(this.WD == null ? null : this.WD.toString());
            dest.writeString(this.WE == null ? null : this.WE.toString());
            dest.writeInt(this.FP);
            dest.writeString(this.Yi);
            dest.writeInt(this.adZ ? 1 : 0);
            dest.writeInt(this.XE == null ? 0 : 1);
            if (this.XE != null) {
                this.XE.writeToParcel(dest, flags);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity cA(Parcel parcel) {
            boolean bl2 = ParticipantEntity.c(ParticipantEntity.ht());
            if (bl2 || ParticipantEntity.aW(ParticipantEntity.class.getCanonicalName())) {
                return super.cA(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            String string5 = parcel.readString();
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            int n2 = parcel.readInt();
            String string6 = parcel.readString();
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            int n3 = 7;
            ParticipantResult participantResult = null;
            String string7 = null;
            String string8 = null;
            PlayerEntity playerEntity = bl4 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string2, string3, uri, uri2, n2, string6, bl3, playerEntity, n3, participantResult, string7, string8);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cA(x0);
        }
    }
}

