/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int CK;
    private final GameEntity acs;
    private final String YG;
    private final long adS;
    private final int adT;
    private final ParticipantEntity adU;
    private final ArrayList<ParticipantEntity> adV;
    private final int adW;
    private final int adX;

    InvitationEntity(Invitation invitation) {
        this.CK = 2;
        this.acs = new GameEntity(invitation.getGame());
        this.YG = invitation.getInvitationId();
        this.adS = invitation.getCreationTimestamp();
        this.adT = invitation.getInvitationType();
        this.adW = invitation.getVariant();
        this.adX = invitation.getAvailableAutoMatchSlots();
        String string2 = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n2 = arrayList.size();
        this.adV = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant2 = (Participant)arrayList.get(i2);
            if (participant2.getParticipantId().equals(string2)) {
                participant = participant2;
            }
            this.adV.add((ParticipantEntity)participant2.freeze());
        }
        jx.b(participant, (Object)"Must have a valid inviter!");
        this.adU = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant, int availableAutoMatchSlots) {
        this.CK = versionCode;
        this.acs = game;
        this.YG = invitationId;
        this.adS = creationTimestamp;
        this.adT = invitationType;
        this.adU = inviter;
        this.adV = participants;
        this.adW = variant;
        this.adX = availableAutoMatchSlots;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public Game getGame() {
        return this.acs;
    }

    @Override
    public String getInvitationId() {
        return this.YG;
    }

    @Override
    public Participant getInviter() {
        return this.adU;
    }

    @Override
    public long getCreationTimestamp() {
        return this.adS;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.adV);
    }

    @Override
    public int getInvitationType() {
        return this.adT;
    }

    @Override
    public int getVariant() {
        return this.adW;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.adX;
    }

    @Override
    public Invitation freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.a(this);
    }

    static int a(Invitation invitation) {
        return jv.hashCode(invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots());
    }

    public boolean equals(Object obj) {
        return InvitationEntity.a(this, obj);
    }

    static boolean a(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return jv.equal(invitation2.getGame(), invitation.getGame()) && jv.equal(invitation2.getInvitationId(), invitation.getInvitationId()) && jv.equal(invitation2.getCreationTimestamp(), invitation.getCreationTimestamp()) && jv.equal(invitation2.getInvitationType(), invitation.getInvitationType()) && jv.equal(invitation2.getInviter(), invitation.getInviter()) && jv.equal(invitation2.getParticipants(), invitation.getParticipants()) && jv.equal(invitation2.getVariant(), invitation.getVariant()) && jv.equal(invitation2.getAvailableAutoMatchSlots(), invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.b(this);
    }

    static String b(Invitation invitation) {
        return jv.h(invitation).a("Game", invitation.getGame()).a("InvitationId", invitation.getInvitationId()).a("CreationTimestamp", invitation.getCreationTimestamp()).a("InvitationType", invitation.getInvitationType()).a("Inviter", invitation.getInviter()).a("Participants", invitation.getParticipants()).a("Variant", invitation.getVariant()).a("AvailableAutoMatchSlots", invitation.getAvailableAutoMatchSlots()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.hu()) {
            InvitationEntityCreator.a(this, dest, flags);
        } else {
            this.acs.writeToParcel(dest, flags);
            dest.writeString(this.YG);
            dest.writeLong(this.adS);
            dest.writeInt(this.adT);
            this.adU.writeToParcel(dest, flags);
            int n2 = this.adV.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.adV.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity cz(Parcel parcel) {
            int n2;
            boolean bl2 = InvitationEntity.c(InvitationEntity.ht());
            if (bl2 || InvitationEntity.aW(InvitationEntity.class.getCanonicalName())) {
                return super.cz(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string2 = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            int n5 = 0;
            return new InvitationEntity(2, gameEntity, string2, l2, n3, participantEntity, arrayList, n2, n5);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cz(x0);
        }
    }
}

