/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import com.google.android.gms.internal.le;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long ads;
    private final String adt;
    private final String adu;
    private final long adv;
    private final long adw;
    private final String adx;
    private final Uri ady;
    private final Uri adz;
    private final PlayerEntity adA;
    private final String adB;
    private final String adC;
    private final String adD;

    public LeaderboardScoreEntity(LeaderboardScore score) {
        this.ads = score.getRank();
        this.adt = jx.i(score.getDisplayRank());
        this.adu = jx.i(score.getDisplayScore());
        this.adv = score.getRawScore();
        this.adw = score.getTimestampMillis();
        this.adx = score.getScoreHolderDisplayName();
        this.ady = score.getScoreHolderIconImageUri();
        this.adz = score.getScoreHolderHiResImageUri();
        Player player = score.getScoreHolder();
        this.adA = player == null ? null : (PlayerEntity)player.freeze();
        this.adB = score.getScoreTag();
        this.adC = score.getScoreHolderIconImageUrl();
        this.adD = score.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.ads;
    }

    @Override
    public String getDisplayRank() {
        return this.adt;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        le.b(this.adt, dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.adu;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        le.b(this.adu, dataOut);
    }

    @Override
    public long getRawScore() {
        return this.adv;
    }

    @Override
    public long getTimestampMillis() {
        return this.adw;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.adA == null) {
            return this.adx;
        }
        return this.adA.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.adA == null) {
            le.b(this.adx, dataOut);
            return;
        }
        this.adA.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.adA == null) {
            return this.ady;
        }
        return this.adA.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.adA == null) {
            return this.adC;
        }
        return this.adA.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.adA == null) {
            return this.adz;
        }
        return this.adA.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.adA == null) {
            return this.adD;
        }
        return this.adA.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.adA;
    }

    @Override
    public String getScoreTag() {
        return this.adB;
    }

    public LeaderboardScore mJ() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.a(this);
    }

    static int a(LeaderboardScore leaderboardScore) {
        return jv.hashCode(leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder());
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.a(this, obj);
    }

    static boolean a(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return jv.equal(leaderboardScore2.getRank(), leaderboardScore.getRank()) && jv.equal(leaderboardScore2.getDisplayRank(), leaderboardScore.getDisplayRank()) && jv.equal(leaderboardScore2.getRawScore(), leaderboardScore.getRawScore()) && jv.equal(leaderboardScore2.getDisplayScore(), leaderboardScore.getDisplayScore()) && jv.equal(leaderboardScore2.getTimestampMillis(), leaderboardScore.getTimestampMillis()) && jv.equal(leaderboardScore2.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderDisplayName()) && jv.equal(leaderboardScore2.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderIconImageUri()) && jv.equal(leaderboardScore2.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolderHiResImageUri()) && jv.equal(leaderboardScore2.getScoreHolder(), leaderboardScore.getScoreHolder()) && jv.equal(leaderboardScore2.getScoreTag(), leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.b(this);
    }

    static String b(LeaderboardScore leaderboardScore) {
        return jv.h(leaderboardScore).a("Rank", leaderboardScore.getRank()).a("DisplayRank", leaderboardScore.getDisplayRank()).a("Score", leaderboardScore.getRawScore()).a("DisplayScore", leaderboardScore.getDisplayScore()).a("Timestamp", leaderboardScore.getTimestampMillis()).a("DisplayName", leaderboardScore.getScoreHolderDisplayName()).a("IconImageUri", leaderboardScore.getScoreHolderIconImageUri()).a("IconImageUrl", leaderboardScore.getScoreHolderIconImageUrl()).a("HiResImageUri", leaderboardScore.getScoreHolderHiResImageUri()).a("HiResImageUrl", leaderboardScore.getScoreHolderHiResImageUrl()).a("Player", leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder()).a("ScoreTag", leaderboardScore.getScoreTag()).toString();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.mJ();
    }
}

