/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.d;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import java.util.List;

public final class TurnBasedMultiplayerImpl
implements TurnBasedMultiplayer {
    @Override
    public Intent getInboxIntent(GoogleApiClient apiClient) {
        return Games.d(apiClient).ln();
    }

    @Override
    public void registerMatchUpdateListener(GoogleApiClient apiClient, OnTurnBasedMatchUpdateReceivedListener listener) {
        d<OnTurnBasedMatchUpdateReceivedListener> d2 = apiClient.d(listener);
        Games.d(apiClient).b(d2);
    }

    @Override
    public void unregisterMatchUpdateListener(GoogleApiClient apiClient) {
        Games.d(apiClient).lq();
    }

    @Override
    public Intent getSelectOpponentsIntent(GoogleApiClient apiClient, int minPlayers, int maxPlayers) {
        return Games.d(apiClient).a(minPlayers, maxPlayers, true);
    }

    @Override
    public Intent getSelectOpponentsIntent(GoogleApiClient apiClient, int minPlayers, int maxPlayers, boolean allowAutomatch) {
        return Games.d(apiClient).a(minPlayers, maxPlayers, allowAutomatch);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.InitiateMatchResult> createMatch(GoogleApiClient apiClient, final TurnBasedMatchConfig config) {
        return apiClient.b(new InitiateMatchImpl(apiClient){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a(this, config);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.InitiateMatchResult> rematch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.b(new InitiateMatchImpl(apiClient){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.c(this, matchId);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.InitiateMatchResult> acceptInvitation(GoogleApiClient apiClient, final String invitationId) {
        return apiClient.b(new InitiateMatchImpl(apiClient){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.d(this, invitationId);
            }
        });
    }

    @Override
    public void declineInvitation(GoogleApiClient apiClient, String invitationId) {
        Games.d(apiClient).q(invitationId, 1);
    }

    @Override
    public void dismissInvitation(GoogleApiClient apiClient, String invitationId) {
        Games.d(apiClient).p(invitationId, 1);
    }

    @Override
    public int getMaxMatchDataSize(GoogleApiClient apiClient) {
        return Games.d(apiClient).lx();
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> takeTurn(GoogleApiClient apiClient, String matchId, byte[] matchData, String pendingParticipantId) {
        return this.takeTurn(apiClient, matchId, matchData, pendingParticipantId, (ParticipantResult[])null);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> takeTurn(GoogleApiClient apiClient, final String matchId, final byte[] matchData, final String pendingParticipantId, final ParticipantResult ... results) {
        return apiClient.b(new UpdateMatchImpl(apiClient){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a(this, matchId, matchData, pendingParticipantId, results);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> takeTurn(GoogleApiClient apiClient, String matchId, byte[] matchData, String pendingParticipantId, List<ParticipantResult> results) {
        ParticipantResult[] participantResultArray = results == null ? null : results.toArray(new ParticipantResult[results.size()]);
        return this.takeTurn(apiClient, matchId, matchData, pendingParticipantId, participantResultArray);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> finishMatch(GoogleApiClient apiClient, String matchId) {
        return this.finishMatch(apiClient, matchId, null, (ParticipantResult[])null);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> finishMatch(GoogleApiClient apiClient, final String matchId, final byte[] matchData, final ParticipantResult ... results) {
        return apiClient.b(new UpdateMatchImpl(apiClient){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a(this, matchId, matchData, results);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> finishMatch(GoogleApiClient apiClient, String matchId, byte[] matchData, List<ParticipantResult> results) {
        ParticipantResult[] participantResultArray = results == null ? null : results.toArray(new ParticipantResult[results.size()]);
        return this.finishMatch(apiClient, matchId, matchData, participantResultArray);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LeaveMatchResult> leaveMatch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.b(new LeaveMatchImpl(apiClient){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.e(this, matchId);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LeaveMatchResult> leaveMatchDuringTurn(GoogleApiClient apiClient, final String matchId, final String pendingParticipantId) {
        return apiClient.b(new LeaveMatchImpl(apiClient){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a(this, matchId, pendingParticipantId);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.CancelMatchResult> cancelMatch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.b(new CancelMatchImpl(matchId, apiClient){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.f(this, matchId);
            }
        });
    }

    @Override
    public void dismissMatch(GoogleApiClient apiClient, String matchId) {
        Games.d(apiClient).bA(matchId);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LoadMatchesResult> loadMatchesByStatus(GoogleApiClient apiClient, int[] matchTurnStatuses) {
        return this.loadMatchesByStatus(apiClient, 0, matchTurnStatuses);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LoadMatchesResult> loadMatchesByStatus(GoogleApiClient apiClient, final int invitationSortOrder, final int[] matchTurnStatuses) {
        return apiClient.a(new LoadMatchesImpl(apiClient){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a(this, invitationSortOrder, matchTurnStatuses);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LoadMatchResult> loadMatch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.a(new LoadMatchImpl(apiClient){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.g(this, matchId);
            }
        });
    }

    private static abstract class LoadMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.LoadMatchResult> {
        private LoadMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.LoadMatchResult av(final Status status) {
            return new TurnBasedMultiplayer.LoadMatchResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.av(status);
        }
    }

    private static abstract class LoadMatchesImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.LoadMatchesResult> {
        private LoadMatchesImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.LoadMatchesResult aw(final Status status) {
            return new TurnBasedMultiplayer.LoadMatchesResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public void release() {
                }

                @Override
                public LoadMatchesResponse getMatches() {
                    return new LoadMatchesResponse(new Bundle());
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.aw(status);
        }
    }

    private static abstract class CancelMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.CancelMatchResult> {
        private final String CE;

        public CancelMatchImpl(String id2, GoogleApiClient googleApiClient) {
            super(googleApiClient);
            this.CE = id2;
        }

        public TurnBasedMultiplayer.CancelMatchResult as(final Status status) {
            return new TurnBasedMultiplayer.CancelMatchResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public String getMatchId() {
                    return CancelMatchImpl.this.CE;
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.as(status);
        }
    }

    private static abstract class LeaveMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.LeaveMatchResult> {
        private LeaveMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.LeaveMatchResult au(final Status status) {
            return new TurnBasedMultiplayer.LeaveMatchResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.au(status);
        }
    }

    private static abstract class UpdateMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.UpdateMatchResult> {
        private UpdateMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.UpdateMatchResult ax(final Status status) {
            return new TurnBasedMultiplayer.UpdateMatchResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.ax(status);
        }
    }

    private static abstract class InitiateMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.InitiateMatchResult> {
        private InitiateMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.InitiateMatchResult at(final Status status) {
            return new TurnBasedMultiplayer.InitiateMatchResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.at(status);
        }
    }
}

