/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.d;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class RequestsImpl
implements Requests {
    @Override
    public void registerRequestListener(GoogleApiClient apiClient, OnRequestReceivedListener listener) {
        d<OnRequestReceivedListener> d2 = apiClient.d(listener);
        Games.d(apiClient).d(d2);
    }

    @Override
    public void unregisterRequestListener(GoogleApiClient apiClient) {
        Games.d(apiClient).ls();
    }

    @Override
    public Intent getInboxIntent(GoogleApiClient apiClient) {
        return Games.d(apiClient).ly();
    }

    @Override
    public Intent getSendIntent(GoogleApiClient apiClient, int type, byte[] payload, int requestLifetimeDays, Bitmap icon, String description) {
        return Games.d(apiClient).a(type, payload, requestLifetimeDays, icon, description);
    }

    @Override
    public int getMaxPayloadSize(GoogleApiClient apiClient) {
        return Games.d(apiClient).lz();
    }

    @Override
    public int getMaxLifetimeDays(GoogleApiClient apiClient) {
        return Games.d(apiClient).lA();
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> acceptRequest(GoogleApiClient apiClient, String requestId) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(requestId);
        return this.acceptRequests(apiClient, arrayList);
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> acceptRequests(GoogleApiClient apiClient, List<String> requestIds) {
        final String[] stringArray = requestIds == null ? null : requestIds.toArray(new String[requestIds.size()]);
        return apiClient.b(new UpdateRequestsImpl(apiClient){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.b(this, stringArray);
            }
        });
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> dismissRequest(GoogleApiClient apiClient, String requestId) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(requestId);
        return this.dismissRequests(apiClient, arrayList);
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> dismissRequests(GoogleApiClient apiClient, List<String> requestIds) {
        final String[] stringArray = requestIds == null ? null : requestIds.toArray(new String[requestIds.size()]);
        return apiClient.b(new UpdateRequestsImpl(apiClient){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.c(this, stringArray);
            }
        });
    }

    @Override
    public PendingResult<Requests.LoadRequestsResult> loadRequests(GoogleApiClient apiClient, final int requestDirection, final int types, final int sortOrder) {
        return apiClient.a(new LoadRequestsImpl(apiClient){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a(this, requestDirection, types, sortOrder);
            }
        });
    }

    @Override
    public ArrayList<GameRequest> getGameRequestsFromInboxResponse(Intent response) {
        if (response == null) {
            return new ArrayList<GameRequest>();
        }
        return this.getGameRequestsFromBundle(response.getExtras());
    }

    @Override
    public ArrayList<GameRequest> getGameRequestsFromBundle(Bundle extras) {
        if (extras == null || !extras.containsKey("requests")) {
            return new ArrayList<GameRequest>();
        }
        ArrayList arrayList = (ArrayList)extras.get("requests");
        ArrayList<GameRequest> arrayList2 = new ArrayList<GameRequest>();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList2.add((GameRequest)arrayList.get(i2));
        }
        return arrayList2;
    }

    private static abstract class LoadRequestSummariesImpl
    extends Games.BaseGamesApiMethodImpl<Requests.LoadRequestSummariesResult> {
        public Requests.LoadRequestSummariesResult ak(final Status status) {
            return new Requests.LoadRequestSummariesResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public void release() {
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.ak(status);
        }
    }

    private static abstract class SendRequestImpl
    extends Games.BaseGamesApiMethodImpl<Requests.SendRequestResult> {
        public Requests.SendRequestResult am(final Status status) {
            return new Requests.SendRequestResult(){

                @Override
                public Status getStatus() {
                    return status;
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.am(status);
        }
    }

    private static abstract class UpdateRequestsImpl
    extends Games.BaseGamesApiMethodImpl<Requests.UpdateRequestsResult> {
        private UpdateRequestsImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Requests.UpdateRequestsResult an(final Status status) {
            return new Requests.UpdateRequestsResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public void release() {
                }

                @Override
                public int getRequestOutcome(String requestId) {
                    throw new IllegalArgumentException("Unknown request ID " + requestId);
                }

                @Override
                public Set<String> getRequestIds() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.an(status);
        }
    }

    private static abstract class LoadRequestsImpl
    extends Games.BaseGamesApiMethodImpl<Requests.LoadRequestsResult> {
        private LoadRequestsImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Requests.LoadRequestsResult al(final Status status) {
            return new Requests.LoadRequestsResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public void release() {
                }

                @Override
                public GameRequestBuffer getRequests(int type) {
                    int n2 = status.getStatusCode();
                    return new GameRequestBuffer(DataHolder.av(n2));
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.al(status);
        }
    }
}

