/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.d;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import java.util.List;

public final class RealTimeMultiplayerImpl
implements RealTimeMultiplayer {
    @Override
    public Intent getWaitingRoomIntent(GoogleApiClient apiClient, Room room, int minParticipantsToStart) {
        return Games.d(apiClient).a(room, minParticipantsToStart);
    }

    @Override
    public Intent getSelectOpponentsIntent(GoogleApiClient apiClient, int minPlayers, int maxPlayers) {
        return Games.d(apiClient).b(minPlayers, maxPlayers, true);
    }

    @Override
    public Intent getSelectOpponentsIntent(GoogleApiClient apiClient, int minPlayers, int maxPlayers, boolean allowAutomatch) {
        return Games.d(apiClient).b(minPlayers, maxPlayers, allowAutomatch);
    }

    @Override
    public void create(GoogleApiClient apiClient, RoomConfig config) {
        d<RoomUpdateListener> d2 = apiClient.d(config.getRoomUpdateListener());
        d<RoomStatusUpdateListener> d3 = RealTimeMultiplayerImpl.a(apiClient, config.getRoomStatusUpdateListener());
        d<RealTimeMessageReceivedListener> d4 = RealTimeMultiplayerImpl.a(apiClient, config.getMessageReceivedListener());
        Games.d(apiClient).a(d2, d3, d4, config);
    }

    @Override
    public void join(GoogleApiClient apiClient, RoomConfig config) {
        d<RoomUpdateListener> d2 = apiClient.d(config.getRoomUpdateListener());
        d<RoomStatusUpdateListener> d3 = RealTimeMultiplayerImpl.a(apiClient, config.getRoomStatusUpdateListener());
        d<RealTimeMessageReceivedListener> d4 = RealTimeMultiplayerImpl.a(apiClient, config.getMessageReceivedListener());
        Games.d(apiClient).b(d2, d3, d4, config);
    }

    @Override
    public void leave(GoogleApiClient apiClient, RoomUpdateListener listener, String roomId) {
        d<RoomUpdateListener> d2 = apiClient.d(listener);
        Games.d(apiClient).a(d2, roomId);
    }

    @Override
    public int sendReliableMessage(GoogleApiClient apiClient, RealTimeMultiplayer.ReliableMessageSentCallback callback, byte[] messageData, String roomId, String recipientParticipantId) {
        d<RealTimeMultiplayer.ReliableMessageSentCallback> d2 = RealTimeMultiplayerImpl.a(apiClient, callback);
        return Games.d(apiClient).a(d2, messageData, roomId, recipientParticipantId);
    }

    @Override
    public int sendUnreliableMessage(GoogleApiClient apiClient, byte[] messageData, String roomId, String recipientParticipantId) {
        return Games.d(apiClient).a(messageData, roomId, new String[]{recipientParticipantId});
    }

    @Override
    public int sendUnreliableMessage(GoogleApiClient apiClient, byte[] messageData, String roomId, List<String> recipientParticipantIds) {
        String[] stringArray = recipientParticipantIds.toArray(new String[recipientParticipantIds.size()]);
        return Games.d(apiClient).a(messageData, roomId, stringArray);
    }

    @Override
    public int sendUnreliableMessageToOthers(GoogleApiClient apiClient, byte[] messageData, String roomId) {
        return Games.d(apiClient).d(messageData, roomId);
    }

    @Override
    public RealTimeSocket getSocketForParticipant(GoogleApiClient apiClient, String roomId, String participantId) {
        return Games.d(apiClient).s(roomId, participantId);
    }

    @Override
    public void declineInvitation(GoogleApiClient apiClient, String invitationId) {
        Games.d(apiClient).q(invitationId, 0);
    }

    @Override
    public void dismissInvitation(GoogleApiClient apiClient, String invitationId) {
        Games.d(apiClient).p(invitationId, 0);
    }

    private static <L> d<L> a(GoogleApiClient googleApiClient, L l2) {
        if (l2 == null) {
            return null;
        }
        return googleApiClient.d(l2);
    }
}

