/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.internal.ll;
import java.lang.ref.WeakReference;

public class PopupManager {
    protected GamesClientImpl ZQ;
    protected PopupLocationInfo ZR;

    public static PopupManager a(GamesClientImpl gamesClientImpl, int n2) {
        if (ll.ih()) {
            return new PopupManagerHCMR1(gamesClientImpl, n2);
        }
        return new PopupManager(gamesClientImpl, n2);
    }

    private PopupManager(GamesClientImpl gamesClientImpl, int gravity) {
        this.ZQ = gamesClientImpl;
        this.dY(gravity);
    }

    protected void dY(int n2) {
        this.ZR = new PopupLocationInfo(n2, (IBinder)new Binder());
    }

    public void setGravity(int gravity) {
        this.ZR.gravity = gravity;
    }

    public void l(View view) {
    }

    public void lT() {
        this.ZQ.a(this.ZR.ZS, this.ZR.lW());
    }

    public Bundle lU() {
        return this.ZR.lW();
    }

    public IBinder lV() {
        return this.ZR.ZS;
    }

    public static final class PopupLocationInfo {
        public IBinder ZS;
        public int gravity;
        public int ZT = -1;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        private PopupLocationInfo(int gravity, IBinder windowToken) {
            this.gravity = gravity;
            this.ZS = windowToken;
        }

        public Bundle lW() {
            Bundle bundle = new Bundle();
            bundle.putInt("popupLocationInfo.gravity", this.gravity);
            bundle.putInt("popupLocationInfo.displayId", this.ZT);
            bundle.putInt("popupLocationInfo.left", this.left);
            bundle.putInt("popupLocationInfo.top", this.top);
            bundle.putInt("popupLocationInfo.right", this.right);
            bundle.putInt("popupLocationInfo.bottom", this.bottom);
            return bundle;
        }
    }

    private static final class PopupManagerHCMR1
    extends PopupManager
    implements View.OnAttachStateChangeListener,
    ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<View> ZU;
        private boolean Yq = false;

        protected PopupManagerHCMR1(GamesClientImpl gamesClientImpl, int gravity) {
            super(gamesClientImpl, gravity);
        }

        @Override
        protected void dY(int n2) {
            this.ZR = new PopupLocationInfo(n2, null);
        }

        @Override
        public void l(View view) {
            Context context;
            View view2;
            this.ZQ.lE();
            if (this.ZU != null) {
                view2 = (View)this.ZU.get();
                context = this.ZQ.getContext();
                if (view2 == null && context instanceof Activity) {
                    view2 = ((Activity)context).getWindow().getDecorView();
                }
                if (view2 != null) {
                    view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewTreeObserver viewTreeObserver = view2.getViewTreeObserver();
                    if (ll.ik()) {
                        viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            }
            this.ZU = null;
            view2 = this.ZQ.getContext();
            if (view == null && view2 instanceof Activity) {
                context = (Activity)view2;
                view = context.findViewById(0x1020002);
                if (view == null) {
                    view = ((Activity)view2).getWindow().getDecorView();
                }
                GamesLog.o("PopupManager", "You have not specified a View to use as content view for popups. Falling back to the Activity content view which may not work properly in future versions of the API. Use setViewForPopups() to set your content view.");
            }
            if (view != null) {
                this.m(view);
                this.ZU = new WeakReference<View>(view);
                view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                context = view.getViewTreeObserver();
                context.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                GamesLog.p("PopupManager", "No content view usable to display popups. Popups will not be displayed in response to this client's calls. Use setViewForPopups() to set your content view.");
            }
        }

        @Override
        public void lT() {
            if (this.ZR.ZS != null) {
                super.lT();
                return;
            }
            this.Yq = this.ZU != null;
        }

        public void onViewAttachedToWindow(View v2) {
            this.m(v2);
        }

        public void onViewDetachedFromWindow(View v2) {
            this.ZQ.lE();
            v2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onGlobalLayout() {
            if (this.ZU == null) {
                return;
            }
            View view = (View)this.ZU.get();
            if (view == null) {
                return;
            }
            this.m(view);
        }

        private void m(View view) {
            Display display;
            int n2 = -1;
            if (ll.il()) {
                display = view.getDisplay();
                n2 = display != null ? display.getDisplayId() : -1;
            }
            display = view.getWindowToken();
            int[] nArray = new int[2];
            view.getLocationInWindow(nArray);
            int n3 = view.getWidth();
            int n4 = view.getHeight();
            this.ZR.ZT = n2;
            this.ZR.ZS = display;
            this.ZR.left = nArray[0];
            this.ZR.top = nArray[1];
            this.ZR.right = nArray[0] + n3;
            this.ZR.bottom = nArray[1] + n4;
            if (this.Yq) {
                this.lT();
                this.Yq = false;
            }
        }
    }
}

