/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.b;
import com.google.android.gms.common.api.d;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.a;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.LibjingleNativeSocket;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.RealTimeSocketImpl;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.internal.game.ExtendedGameBuffer;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.game.GameSearchSuggestionBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.ParticipantUtils;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.internal.je;
import com.google.android.gms.internal.jl;
import com.google.android.gms.internal.jt;
import com.google.android.gms.internal.jx;
import com.google.android.gms.internal.ll;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GamesClientImpl
extends jl<IGamesService>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    EventIncrementManager Yk = new EventIncrementManager(){

        @Override
        public EventIncrementCache lF() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String Yl;
    private final String DZ;
    private final Map<String, RealTimeSocket> Ym;
    private PlayerEntity Yn;
    private GameEntity Yo;
    private final PopupManager Yp;
    private boolean Yq = false;
    private final Binder Yr;
    private final long Ys;
    private final Games.GamesOptions Yt;

    public GamesClientImpl(Context context, Looper looper, String gamePackageName, String accountName, GoogleApiClient.ConnectionCallbacks connectedListener, GoogleApiClient.OnConnectionFailedListener connectionFailedListener, String[] scopes, int gravity, View gamesContentView, Games.GamesOptions options) {
        super(context, looper, connectedListener, connectionFailedListener, scopes);
        this.Yl = gamePackageName;
        this.DZ = jx.i(accountName);
        this.Yr = new Binder();
        this.Ym = new HashMap<String, RealTimeSocket>();
        this.Yp = PopupManager.a(this, gravity);
        this.k(gamesContentView);
        this.Ys = this.hashCode();
        this.Yt = options;
        this.registerConnectionCallbacks(this);
        this.registerConnectionFailedListener(this);
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (this.Yq) {
            this.Yp.lT();
            this.Yq = false;
        }
    }

    @Override
    public void onConnectionSuspended(int cause) {
    }

    @Override
    public void onConnectionFailed(ConnectionResult result) {
        this.Yq = false;
    }

    public void dS(int n2) {
        this.Yp.setGravity(n2);
    }

    public void k(View view) {
        this.Yp.l(view);
    }

    @Override
    protected void c(String ... stringArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (string2.equals("https://www.googleapis.com/auth/games")) {
                bl2 = true;
                continue;
            }
            if (!string2.equals("https://www.googleapis.com/auth/games.firstparty")) continue;
            bl3 = true;
        }
        if (bl3) {
            jx.a(!bl2, "Cannot have both %s and %s!", "https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty");
        } else {
            jx.a(bl2, "Games APIs requires %s to function.", "https://www.googleapis.com/auth/games");
        }
    }

    @Override
    public void connect() {
        this.lg();
        super.connect();
    }

    @Override
    public void disconnect() {
        this.Yq = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.hw();
                iGamesService.lE();
                this.Yk.flush();
                iGamesService.q(this.Ys);
            }
            catch (RemoteException remoteException) {
                GamesLog.o("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        this.lD();
        super.disconnect();
    }

    @Override
    protected String bK() {
        return "com.google.android.gms.games.service.START";
    }

    @Override
    protected String bL() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService aC(IBinder iBinder) {
        return IGamesService.Stub.aE(iBinder);
    }

    @Override
    public Bundle fX() {
        try {
            Bundle bundle = ((IGamesService)this.hw()).fX();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            return null;
        }
    }

    private void lg() {
        this.Yn = null;
    }

    @Override
    protected void a(jt jt2, jl.e e2) throws RemoteException {
        String string2 = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.Yt.Xa);
        bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.Yt.Xb);
        bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.Yt.Xc);
        bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.Yt.Xd);
        bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.Yt.Xe);
        bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", this.Yt.Xf);
        bundle.putStringArrayList("com.google.android.gms.games.key.proxyApis", this.Yt.Xg);
        jt2.a(e2, 6587000, this.getContext().getPackageName(), this.DZ, this.hv(), this.Yl, this.Yp.lV(), string2, bundle);
    }

    public String lh() {
        try {
            return ((IGamesService)this.hw()).lh();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            return null;
        }
    }

    public String li() {
        try {
            return ((IGamesService)this.hw()).li();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player lj() {
        this.dS();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.Yn == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.hw()).lG());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.Yn = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesLog.o("GamesClientImpl", "service died");
                }
            }
        }
        return this.Yn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game lk() {
        this.dS();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.Yo == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.hw()).lI());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.Yo = (GameEntity)gameBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesLog.o("GamesClientImpl", "service died");
                }
            }
        }
        return this.Yo;
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.hw()).f((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, String[] stringArray) {
        try {
            ((IGamesService)this.hw()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, String string2, int n2, boolean bl2, boolean bl3) {
        switch (string2) {
            case "played_with": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string2);
            }
        }
        try {
            ((IGamesService)this.hw()).d(new PlayersLoadedBinderCallback(b2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, String string2, String string3, int n2, boolean bl2, boolean bl3) {
        switch (string2) {
            case "circled": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string2);
            }
        }
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), string2, string3, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.hw()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public Intent ll() {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).ll();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent n(String string2, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).u(string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void b(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.hw()).b((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> b2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.hw()).c((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(b2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LoadPlayerScoreResult> b2, String string2, String string3, int n2, int n3) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(b2), string2, string3, n2, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, String string2, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(b2), string2, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, String string2, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.hw()).b((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(b2), string2, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n2, int n3) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(b2), leaderboardScoreBuffer.mH().mI(), n2, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.SubmitScoreResult> b2, String string2, long l2, String string3) {
        try {
            SubmitScoreBinderCallbacks submitScoreBinderCallbacks = b2 == null ? null : new SubmitScoreBinderCallbacks(b2);
            ((IGamesService)this.hw()).a((IGamesCallbacks)submitScoreBinderCallbacks, string2, l2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public Intent lm() {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).lm();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void c(BaseImplementation.b<Achievements.LoadAchievementsResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new AchievementsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Achievements.UpdateAchievementResult> b2, String string2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = b2 == null ? null : new AchievementUpdatedBinderCallback(b2);
            ((IGamesService)this.hw()).a((IGamesCallbacks)achievementUpdatedBinderCallback, string2, this.Yp.lV(), this.Yp.lU());
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Achievements.UpdateAchievementResult> b2, String string2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = b2 == null ? null : new AchievementUpdatedBinderCallback(b2);
            ((IGamesService)this.hw()).b((IGamesCallbacks)achievementUpdatedBinderCallback, string2, this.Yp.lV(), this.Yp.lU());
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Achievements.UpdateAchievementResult> b2, String string2, int n2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = b2 == null ? null : new AchievementUpdatedBinderCallback(b2);
            ((IGamesService)this.hw()).a((IGamesCallbacks)achievementUpdatedBinderCallback, string2, n2, this.Yp.lV(), this.Yp.lU());
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Achievements.UpdateAchievementResult> b2, String string2, int n2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = b2 == null ? null : new AchievementUpdatedBinderCallback(b2);
            ((IGamesService)this.hw()).b((IGamesCallbacks)achievementUpdatedBinderCallback, string2, n2, this.Yp.lV(), this.Yp.lU());
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<Events.LoadEventsResult> b2, boolean bl2) {
        try {
            this.Yk.flush();
            ((IGamesService)this.hw()).f((IGamesCallbacks)new EventsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Events.LoadEventsResult> b2, boolean bl2, String ... stringArray) {
        try {
            this.Yk.flush();
            ((IGamesService)this.hw()).a((IGamesCallbacks)new EventsLoadedBinderCallback(b2), bl2, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void o(String string2, int n2) {
        this.Yk.o(string2, n2);
    }

    public Intent ln() {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).ln();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent lo() {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).lo();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    @Override
    public void a(d<OnInvitationReceivedListener> d2) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(d2);
            ((IGamesService)this.hw()).a((IGamesCallbacks)invitationReceivedBinderCallback, this.Ys);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void lp() {
        try {
            ((IGamesService)this.hw()).r(this.Ys);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void b(d<OnTurnBasedMatchUpdateReceivedListener> d2) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(d2);
            ((IGamesService)this.hw()).b((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.Ys);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void lq() {
        try {
            ((IGamesService)this.hw()).s(this.Ys);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void c(d<QuestUpdateListener> d2) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(d2);
            ((IGamesService)this.hw()).d((IGamesCallbacks)questUpdateBinderCallback, this.Ys);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void lr() {
        try {
            ((IGamesService)this.hw()).u(this.Ys);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void d(d<OnRequestReceivedListener> d2) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(d2);
            ((IGamesService)this.hw()).c((IGamesCallbacks)requestReceivedBinderCallback, this.Ys);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void ls() {
        try {
            ((IGamesService)this.hw()).t(this.Ys);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public Intent lt() {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).lt();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent a(Room room, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).a((RoomEntity)room.freeze(), n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent lu() {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).lu();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void f(BaseImplementation.b<GamesMetadata.LoadGamesResult> b2) {
        try {
            ((IGamesService)this.hw()).d(new GamesLoadedBinderCallback(b2));
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Status> b2) {
        try {
            this.Yk.flush();
            ((IGamesService)this.hw()).a(new SignOutCompleteBinderCallbacks(b2));
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public int lv() {
        int n2 = 4368;
        try {
            n2 = ((IGamesService)this.hw()).lv();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
        return n2;
    }

    public String lw() {
        try {
            return ((IGamesService)this.hw()).lw();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            return null;
        }
    }

    public void c(BaseImplementation.b<Invitations.LoadInvitationsResult> b2, int n2) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new InvitationsLoadedBinderCallback(b2), n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void p(String string2, int n2) {
        try {
            ((IGamesService)this.hw()).p(string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void q(String string2, int n2) {
        try {
            ((IGamesService)this.hw()).q(string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public Intent a(int n2, int n3, boolean bl2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).a(n2, n3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, TurnBasedMatchConfig turnBasedMatchConfig) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(b2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.mO(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, String string2) {
        try {
            ((IGamesService)this.hw()).l(new TurnBasedMatchInitiatedBinderCallbacks(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, String string2) {
        try {
            ((IGamesService)this.hw()).m(new TurnBasedMatchInitiatedBinderCallbacks(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public int lx() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.hw()).lx();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.UpdateMatchResult> b2, String string2, byte[] byArray, String string3, ParticipantResult[] participantResultArray) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(b2), string2, byArray, string3, participantResultArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.UpdateMatchResult> b2, String string2, byte[] byArray, ParticipantResult[] participantResultArray) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(b2), string2, byArray, participantResultArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void e(BaseImplementation.b<TurnBasedMultiplayer.LeaveMatchResult> b2, String string2) {
        try {
            ((IGamesService)this.hw()).o(new TurnBasedMatchLeftBinderCallbacks(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.LeaveMatchResult> b2, String string2, String string3) {
        try {
            ((IGamesService)this.hw()).c((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(b2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void f(BaseImplementation.b<TurnBasedMultiplayer.CancelMatchResult> b2, String string2) {
        try {
            ((IGamesService)this.hw()).n(new TurnBasedMatchCanceledBinderCallbacks(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void bA(String string2) {
        try {
            ((IGamesService)this.hw()).bL(string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchesResult> b2, int n2, int[] nArray) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(b2), n2, nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void g(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchResult> b2, String string2) {
        try {
            ((IGamesService)this.hw()).p(new TurnBasedMatchLoadedBinderCallbacks(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public Intent b(int n2, int n3, boolean bl2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).b(n2, n3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(d<RoomUpdateListener> d2, d<RoomStatusUpdateListener> d3, d<RealTimeMessageReceivedListener> d4, RoomConfig roomConfig) {
        this.lD();
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(d2, d3, d4);
            ((IGamesService)this.hw()).a((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.Yr, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), roomConfig.isSocketEnabled(), this.Ys);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void b(d<RoomUpdateListener> d2, d<RoomStatusUpdateListener> d3, d<RealTimeMessageReceivedListener> d4, RoomConfig roomConfig) {
        this.lD();
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(d2, d3, d4);
            ((IGamesService)this.hw()).a((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.Yr, roomConfig.getInvitationId(), roomConfig.isSocketEnabled(), this.Ys);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(d<RoomUpdateListener> d2, String string2) {
        try {
            ((IGamesService)this.hw()).c((IGamesCallbacks)new RoomBinderCallbacks(d2), string2);
            this.lD();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public int a(d<RealTimeMultiplayer.ReliableMessageSentCallback> d2, byte[] byArray, String string2, String string3) {
        try {
            return ((IGamesService)this.hw()).a((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(d2), byArray, string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int a(byte[] byArray, String string2, String[] stringArray) {
        jx.b(stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.hw()).b(byArray, string2, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int d(byte[] byArray, String string2) {
        try {
            return ((IGamesService)this.hw()).b(byArray, string2, null);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            return -1;
        }
    }

    public RealTimeSocket s(String string2, String string3) {
        if (string3 == null || !ParticipantUtils.bY(string3)) {
            throw new IllegalArgumentException("Bad participant ID");
        }
        RealTimeSocket realTimeSocket = this.Ym.get(string3);
        if (realTimeSocket == null || realTimeSocket.isClosed()) {
            return this.bB(string3);
        }
        return realTimeSocket;
    }

    private RealTimeSocket bB(String string2) {
        RealTimeSocket realTimeSocket = ll.ii() ? this.bD(string2) : this.bC(string2);
        if (realTimeSocket != null) {
            this.Ym.put(string2, realTimeSocket);
        }
        return realTimeSocket;
    }

    private RealTimeSocket bC(String string2) {
        try {
            String string3 = ((IGamesService)this.hw()).bH(string2);
            if (string3 == null) {
                return null;
            }
            LocalSocket localSocket = new LocalSocket();
            localSocket.connect(new LocalSocketAddress(string3));
            return new RealTimeSocketImpl(localSocket, string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "Unable to create socket. Service died.");
        }
        catch (IOException iOException) {
            GamesLog.p("GamesClientImpl", "connect() call failed on socket: " + iOException.getMessage());
        }
        return null;
    }

    private RealTimeSocket bD(String string2) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = ((IGamesService)this.hw()).bN(string2);
            if (parcelFileDescriptor != null) {
                GamesLog.n("GamesClientImpl", "Created native libjingle socket.");
                return new LibjingleNativeSocket(parcelFileDescriptor);
            }
            GamesLog.p("GamesClientImpl", "Unable to create socket for " + string2);
            return null;
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "Unable to create socket. Service died.");
            return null;
        }
    }

    public void dT(int n2) {
        try {
            ((IGamesService)this.hw()).dT(n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public Intent ly() {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).ly();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent a(int n2, byte[] byArray, int n3, Bitmap bitmap, String string2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).a(n2, byArray, n3, string2);
            jx.b(bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public int lz() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.hw()).lz();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
        return n2;
    }

    public int lA() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.hw()).lA();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void b(BaseImplementation.b<Requests.UpdateRequestsResult> b2, String[] stringArray) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(b2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Requests.UpdateRequestsResult> b2, String[] stringArray) {
        try {
            ((IGamesService)this.hw()).b((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(b2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Requests.LoadRequestsResult> b2, int n2, int n3, int n4) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new RequestsLoadedBinderCallbacks(b2), n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<AppContents.LoadAppContentResult> b2, int n2, String string2, String[] stringArray, boolean bl2) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new AppContentLoadedBinderCallbacks(b2), n2, string2, stringArray, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public Intent b(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).b(nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent bE(String string2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).bE(string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void h(BaseImplementation.b<Quests.AcceptQuestResult> b2, String string2) {
        try {
            this.Yk.flush();
            ((IGamesService)this.hw()).u(new QuestAcceptedBinderCallbacks(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Quests.ClaimMilestoneResult> b2, String string2, String string3) {
        try {
            this.Yk.flush();
            ((IGamesService)this.hw()).f((IGamesCallbacks)new QuestMilestoneClaimBinderCallbacks(b2, string3), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Quests.LoadQuestsResult> b2, int[] nArray, int n2, boolean bl2) {
        try {
            this.Yk.flush();
            ((IGamesService)this.hw()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(b2), nArray, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Quests.LoadQuestsResult> b2, boolean bl2, String[] stringArray) {
        try {
            this.Yk.flush();
            ((IGamesService)this.hw()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(b2), stringArray, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void bF(String string2) {
        try {
            ((IGamesService)this.hw()).a(string2, this.Yp.lV(), this.Yp.lU());
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Quests.LoadQuestsResult> b2, String string2, String string3, int[] nArray, int n2, boolean bl2) {
        try {
            this.Yk.flush();
            ((IGamesService)this.hw()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(b2), string2, string3, nArray, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Quests.LoadQuestsResult> b2, String string2, String string3, boolean bl2, String[] stringArray) {
        try {
            this.Yk.flush();
            ((IGamesService)this.hw()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(b2), string2, string3, stringArray, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public int lB() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.hw()).lB();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
        return n2;
    }

    public int lC() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.hw()).lC();
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
        return n2;
    }

    public Intent a(String string2, boolean bl2, boolean bl3, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.hw()).a(string2, bl2, bl3, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void e(BaseImplementation.b<Snapshots.LoadSnapshotsResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.hw()).d((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Snapshots.OpenSnapshotResult> b2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.hw()).e((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(b2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Snapshots.CommitSnapshotResult> b2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        jx.a(!snapshotContents.isClosed(), "Snapshot already closed");
        a a2 = snapshotMetadataChange.mT();
        if (a2 != null) {
            a2.a(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.ir();
        snapshotContents.close();
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(b2), snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        jx.a(!snapshotContents.isClosed(), "Snapshot already closed");
        Contents contents = snapshotContents.ir();
        snapshotContents.close();
        try {
            ((IGamesService)this.hw()).a(contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void i(BaseImplementation.b<Snapshots.DeleteSnapshotResult> b2, String string2) {
        try {
            ((IGamesService)this.hw()).r(new SnapshotDeletedBinderCallbacks(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Snapshots.OpenSnapshotResult> b2, String string2, String string3, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) {
        jx.a(!snapshotContents.isClosed(), "SnapshotContents already closed");
        a a2 = snapshotMetadataChange.mT();
        if (a2 != null) {
            a2.a(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.ir();
        snapshotContents.close();
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(b2), string2, string3, (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(b2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void j(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string2) {
        try {
            ((IGamesService)this.hw()).e((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void k(BaseImplementation.b<GamesMetadata.LoadGameInstancesResult> b2, String string2) {
        try {
            ((IGamesService)this.hw()).f((IGamesCallbacks)new GameInstancesLoadedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, int n2, int n3, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(b2), n2, n3, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string2, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(b2), string2, n2, bl2, bl3, bl4, bl5);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.hw()).e(new ExtendedGamesLoadedBinderCallback(b2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.hw()).f(new ExtendedGamesLoadedBinderCallback(b2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void e(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.hw()).c(new ExtendedGamesLoadedBinderCallback(b2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void l(BaseImplementation.b<GamesMetadata.LoadGameSearchSuggestionsResult> b2, String string2) {
        try {
            ((IGamesService)this.hw()).q(new GameSearchSuggestionsLoadedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> b2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.hw()).d((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(b2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> b2, String string2, String string3, boolean bl2) {
        try {
            ((IGamesService)this.hw()).b((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(b2), string2, string3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, String string2, String string3, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(b2), string2, string3, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, String string2, String string3, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.hw()).b(new LeaderboardScoresLoadedBinderCallback(b2), string2, string3, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Players.LoadPlayersResult> b2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.hw()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Players.LoadPlayersResult> b2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.hw()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<Players.LoadPlayersResult> b2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.hw()).e(new PlayersLoadedBinderCallback(b2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void f(BaseImplementation.b<Players.LoadPlayersResult> b2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.hw()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Players.LoadPlayersResult> b2, String string2, String string3, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.hw()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), string2, string3, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void g(BaseImplementation.b<Players.LoadOwnerCoverPhotoUrisResult> b2) {
        try {
            ((IGamesService)this.hw()).j(new OwnerCoverPhotoUrisLoadedBinderCallback(b2));
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void m(BaseImplementation.b<Players.LoadXpForGameCategoriesResult> b2, String string2) {
        try {
            ((IGamesService)this.hw()).s(new PlayerXpForGameCategoriesLoadedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Players.LoadXpStreamResult> b2, String string2, int n2) {
        try {
            ((IGamesService)this.hw()).b((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(b2), string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<Players.LoadXpStreamResult> b2, String string2, int n2) {
        try {
            ((IGamesService)this.hw()).c((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(b2), string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void f(BaseImplementation.b<Players.LoadProfileSettingsResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.hw()).g((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void g(BaseImplementation.b<Status> b2, boolean bl2) {
        try {
            ((IGamesService)this.hw()).h((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Achievements.LoadAchievementsResult> b2, String string2, String string3, boolean bl2) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new AchievementsLoadedBinderCallback(b2), string2, string3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, String string2, String string3) {
        try {
            ((IGamesService)this.hw()).d((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(b2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, String string2, String string3) {
        try {
            ((IGamesService)this.hw()).e((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(b2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void e(BaseImplementation.b<Invitations.LoadInvitationsResult> b2, String string2, int n2) {
        try {
            ((IGamesService)this.hw()).b((IGamesCallbacks)new InvitationsLoadedBinderCallback(b2), string2, n2, false);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void n(BaseImplementation.b<Invitations.LoadInvitationsResult> b2, String string2) {
        try {
            ((IGamesService)this.hw()).k(new InvitationsLoadedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchesResult> b2, String string2, int n2, int[] nArray) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(b2), string2, n2, nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void h(BaseImplementation.b<Acls.LoadAclResult> b2) {
        try {
            ((IGamesService)this.hw()).h(new NotifyAclLoadedBinderCallback(b2));
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void o(BaseImplementation.b<Status> b2, String string2) {
        try {
            ((IGamesService)this.hw()).j(new NotifyAclUpdatedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void e(BaseImplementation.b<Notifications.GameMuteStatusChangeResult> b2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(b2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void p(BaseImplementation.b<Notifications.GameMuteStatusLoadResult> b2, String string2) {
        try {
            ((IGamesService)this.hw()).i(new GameMuteStatusLoadedBinderCallback(b2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void h(BaseImplementation.b<Notifications.ContactSettingLoadResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.hw()).e((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Status> b2, boolean bl2, Bundle bundle) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(b2), bl2, bundle);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void i(BaseImplementation.b<Notifications.InboxCountResult> b2) {
        try {
            ((IGamesService)this.hw()).t(new InboxCountsLoadedBinderCallback(b2), null);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Requests.SendRequestResult> b2, String string2, String[] stringArray, int n2, byte[] byArray, int n3) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new RequestSentBinderCallbacks(b2), string2, stringArray, n2, byArray, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Requests.UpdateRequestsResult> b2, String string2, String string3, String[] stringArray) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(b2), string2, string3, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Requests.LoadRequestsResult> b2, String string2, String string3, int n2, int n3, int n4) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new RequestsLoadedBinderCallbacks(b2), string2, string3, n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void f(BaseImplementation.b<Requests.LoadRequestSummariesResult> b2, String string2, int n2) {
        try {
            ((IGamesService)this.hw()).a((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(b2), string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Snapshots.LoadSnapshotsResult> b2, String string2, String string3, boolean bl2) {
        try {
            ((IGamesService)this.hw()).c((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(b2), string2, string3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.o("GamesClientImpl", "service died");
        }
    }

    private void lD() {
        for (RealTimeSocket realTimeSocket : this.Ym.values()) {
            try {
                realTimeSocket.close();
            }
            catch (IOException iOException) {
                GamesLog.c("GamesClientImpl", "IOException:", iOException);
            }
        }
        this.Ym.clear();
    }

    public void a(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.hw()).a(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                GamesLog.o("GamesClientImpl", "service died");
            }
        }
    }

    public void lE() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.hw()).lE();
            }
            catch (RemoteException remoteException) {
                GamesLog.o("GamesClientImpl", "service died");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Room R(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 && bundle != null) {
            this.Yq = bundle.getBoolean("show_welcome_popup");
        }
        super.a(n2, iBinder, bundle);
    }

    @Override
    protected /* synthetic */ IInterface l(IBinder iBinder) {
        return this.aC(iBinder);
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status Eb;
        private final String YB;

        DeleteSnapshotResultImpl(int statusCode, String snapshotId) {
            this.Eb = new Status(statusCode);
            this.YB = snapshotId;
        }

        @Override
        public Status getStatus() {
            return this.Eb;
        }

        @Override
        public String getSnapshotId() {
            return this.YB;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends b
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata YA;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.YA = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.YA;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends b
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot Zf;
        private final String Zg;
        private final Snapshot Zh;
        private final Contents Zi;
        private final SnapshotContents Zj;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents currentContents) {
            this(dataHolder, null, currentContents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder metadataHolder, String conflictId, Contents currentContents, Contents conflictContents, Contents resolutionContents) {
            super(metadataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(metadataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.Zf = null;
                    this.Zh = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    je.K(metadataHolder.getStatusCode() != 4004);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.Zf = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(currentContents));
                    this.Zh = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.Zf = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(currentContents));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(1));
                    this.Zh = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContentsEntity(conflictContents));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.Zg = conflictId;
            this.Zi = resolutionContents;
            this.Zj = new SnapshotContentsEntity(resolutionContents);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.Zf;
        }

        @Override
        public String getConflictId() {
            return this.Zg;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.Zh;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.Zj;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends b
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.JG);
        }
    }

    private static final class LoadAppContentsResultImpl
    extends b
    implements AppContents.LoadAppContentResult {
        private final ArrayList<DataHolder> YK;

        LoadAppContentsResultImpl(DataHolder[] appContentData) {
            super(appContentData[0]);
            this.YK = new ArrayList<DataHolder>(Arrays.asList(appContentData));
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends b
    implements Quests.ClaimMilestoneResult {
        private final Milestone Yz;
        private final Quest Yw;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String milestoneId) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.Yw = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.Yw.mQ();
                    int n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (!list.get(i2).getMilestoneId().equals(milestoneId)) continue;
                        this.Yz = list.get(i2);
                        return;
                    }
                    this.Yz = null;
                } else {
                    this.Yz = null;
                    this.Yw = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.Yz;
        }

        @Override
        public Quest getQuest() {
            return this.Yw;
        }
    }

    private static final class AcceptQuestResultImpl
    extends b
    implements Quests.AcceptQuestResult {
        private final Quest Yw;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.Yw = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.Yw;
        }
    }

    private static final class LoadQuestsResultImpl
    extends b
    implements Quests.LoadQuestsResult {
        private final DataHolder JG;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.JG = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.JG);
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends b
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status Eb;
        private final Bundle YV;

        LoadRequestsResultImpl(Status status, Bundle requestData) {
            this.Eb = status;
            this.YV = requestData;
        }

        @Override
        public Status getStatus() {
            return this.Eb;
        }

        @Override
        public GameRequestBuffer getRequests(int requestType) {
            String string2 = RequestType.dZ(requestType);
            if (!this.YV.containsKey(string2)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.YV.get(string2);
            return new GameRequestBuffer(dataHolder);
        }

        @Override
        public void release() {
            for (String string2 : this.YV.keySet()) {
                DataHolder dataHolder = (DataHolder)this.YV.getParcelable(string2);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends b
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes ZL;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.ZL = RequestUpdateOutcomes.W(dataHolder);
        }

        @Override
        public int getRequestOutcome(String requestId) {
            return this.ZL.getRequestOutcome(requestId);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.ZL.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends b
    implements Requests.SendRequestResult {
        private final GameRequest Zs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.Zs = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status Eb;
        private final Bundle YE;

        InboxCountResultImpl(Status status, Bundle inboxCounts) {
            this.Eb = status;
            this.YE = inboxCounts;
        }

        @Override
        public Status getStatus() {
            return this.Eb;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends b
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status Eb;
        private final String YC;
        private final boolean YD;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.Eb = new Status(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.YC = dataHolder.c("external_game_id", 0, 0);
                    this.YD = dataHolder.d("muted", 0, 0);
                } else {
                    this.YC = null;
                    this.YD = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public Status getStatus() {
            return this.Eb;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status Eb;
        private final String YC;
        private final boolean YD;

        public GameMuteStatusChangeResultImpl(int statusCode, String externalGameId, boolean isMuted) {
            this.Eb = new Status(statusCode);
            this.YC = externalGameId;
            this.YD = isMuted;
        }

        @Override
        public Status getStatus() {
            return this.Eb;
        }
    }

    private static final class LoadAclResultImpl
    extends b
    implements Acls.LoadAclResult {
        LoadAclResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status Eb;
        private final String Yy;

        CancelMatchResultImpl(Status status, String externalMatchId) {
            this.Eb = status;
            this.Yy = externalMatchId;
        }

        @Override
        public Status getStatus() {
            return this.Eb;
        }

        @Override
        public String getMatchId() {
            return this.Yy;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends b {
        final TurnBasedMatch Zc;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.Zc = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.Zc;
        }
    }

    private static final class SubmitScoreResultImpl
    extends b
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData ZE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.ZE = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.ZE;
        }
    }

    private static final class LoadOwnerCoverPhotoUrisResultImpl
    implements Players.LoadOwnerCoverPhotoUrisResult {
        private final Status Eb;
        private final Bundle DJ;

        LoadOwnerCoverPhotoUrisResultImpl(int statusCode, Bundle bundle) {
            this.Eb = new Status(statusCode);
            this.DJ = bundle;
        }

        @Override
        public Status getStatus() {
            return this.Eb;
        }
    }

    private static final class LoadProfileSettingsResultImpl
    extends b
    implements Players.LoadProfileSettingsResult {
        private final boolean Yh;
        private final boolean YU;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadProfileSettingsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                if (dataHolder.getCount() > 0) {
                    int n2 = dataHolder.au(0);
                    this.Yh = dataHolder.d("profile_visible", 0, n2);
                    this.YU = dataHolder.d("profile_visibility_explicitly_set", 0, n2);
                } else {
                    this.Yh = true;
                    this.YU = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public Status getStatus() {
            return this.Eb;
        }

        @Override
        public boolean isProfileVisible() {
            return this.Yh;
        }

        @Override
        public boolean isVisibilityExplicitlySet() {
            return this.YU;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends b
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer Za;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Za = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status Eb;
        private final List<String> YY;
        private final Bundle YZ;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle xpData) {
            this.Eb = status;
            this.YY = xpData.getStringArrayList("game_category_list");
            this.YZ = xpData;
        }

        @Override
        public Status getStatus() {
            return this.Eb;
        }
    }

    private static final class LoadPlayersResultImpl
    extends b
    implements Players.LoadPlayersResult {
        private final PlayerBuffer YT;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.YT = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.YT;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status Eb;
        private final LoadMatchesResponse YR;

        LoadMatchesResultImpl(Status status, Bundle matchData) {
            this.Eb = status;
            this.YR = new LoadMatchesResponse(matchData);
        }

        @Override
        public Status getStatus() {
            return this.Eb;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.YR;
        }

        @Override
        public void release() {
            this.YR.release();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends b
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer YQ;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.YQ = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.YQ;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends b
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity YS;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadPlayerScoreResultImpl(DataHolder scoreHolder) {
            super(scoreHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(scoreHolder);
            try {
                this.YS = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)leaderboardScoreBuffer.get(0).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.YS;
        }
    }

    private static final class LoadScoresResultImpl
    extends b
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity YW;
        private final LeaderboardScoreBuffer YX;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder leaderboard, DataHolder scores) {
            super(scores);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(leaderboard);
            try {
                this.YW = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.YX = new LeaderboardScoreBuffer(scores);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.YW;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.YX;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends b
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer YH;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.YH = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.YH;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends b
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        private final GameSearchSuggestionBuffer YO;

        LoadGameSearchSuggestionsResultImpl(DataHolder data) {
            super(data);
            this.YO = new GameSearchSuggestionBuffer(data);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends b
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer YN;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.YN = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadExtendedGamesResultImpl
    extends b
    implements GamesMetadata.LoadExtendedGamesResult {
        private final ExtendedGameBuffer YM;

        LoadExtendedGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.YM = new ExtendedGameBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends b
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer YP;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.YP = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.YP;
        }
    }

    private static final class LoadEventResultImpl
    extends b
    implements Events.LoadEventsResult {
        private final EventBuffer YL;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.YL = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.YL;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status Eb;
        private final String Xx;

        UpdateAchievementResultImpl(int statusCode, String achievementId) {
            this.Eb = new Status(statusCode);
            this.Xx = achievementId;
        }

        @Override
        public Status getStatus() {
            return this.Eb;
        }

        @Override
        public String getAchievementId() {
            return this.Xx;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends b
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer YJ;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.YJ = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.YJ;
        }
    }

    private static final class RealTimeMessageSentNotifier
    implements d.b<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int Iv;
        private final String Zp;
        private final int Zq;

        RealTimeMessageSentNotifier(int statusCode, int token, String recipientParticipantId) {
            this.Iv = statusCode;
            this.Zq = token;
            this.Zp = recipientParticipantId;
        }

        public void a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.Iv, this.Zq, this.Zp);
            }
        }

        @Override
        public void gG() {
        }

        @Override
        public /* synthetic */ void c(Object object) {
            this.a((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private static final class MessageReceivedNotifier
    implements d.b<RealTimeMessageReceivedListener> {
        private final RealTimeMessage Zd;

        MessageReceivedNotifier(RealTimeMessage message) {
            this.Zd = message;
        }

        public void a(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            realTimeMessageReceivedListener.onRealTimeMessageReceived(this.Zd);
        }

        @Override
        public void gG() {
        }

        @Override
        public /* synthetic */ void c(Object object) {
            this.a((RealTimeMessageReceivedListener)object);
        }
    }

    private static final class P2PDisconnectedNotifier
    implements d.b<RoomStatusUpdateListener> {
        private final String Zk;

        P2PDisconnectedNotifier(String participantId) {
            this.Zk = participantId;
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PDisconnected(this.Zk);
        }

        @Override
        public void gG() {
        }

        @Override
        public /* synthetic */ void c(Object object) {
            this.a((RoomStatusUpdateListener)object);
        }
    }

    private static final class P2PConnectedNotifier
    implements d.b<RoomStatusUpdateListener> {
        private final String Zk;

        P2PConnectedNotifier(String participantId) {
            this.Zk = participantId;
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PConnected(this.Zk);
        }

        @Override
        public void gG() {
        }

        @Override
        public /* synthetic */ void c(Object object) {
            this.a((RoomStatusUpdateListener)object);
        }
    }

    private static final class PeerDisconnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDisconnectedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private static final class PeerConnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerConnectedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private static final class PeerDeclinedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDeclinedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private static final class PeerLeftRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerLeftRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private static final class PeerJoinedRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerJoinedRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private static final class PeerInvitedToRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerInvitedToRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private static final class DisconnectedFromRoomNotifier
    extends AbstractRoomStatusNotifier {
        DisconnectedFromRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private static final class ConnectedToRoomNotifier
    extends AbstractRoomStatusNotifier {
        ConnectedToRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private static final class RoomAutoMatchingNotifier
    extends AbstractRoomStatusNotifier {
        RoomAutoMatchingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private static final class RoomConnectingNotifier
    extends AbstractRoomStatusNotifier {
        RoomConnectingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private static final class RoomConnectedNotifier
    extends AbstractRoomNotifier {
        RoomConnectedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomConnected(n2, room);
        }
    }

    private static final class LeftRoomNotifier
    implements d.b<RoomUpdateListener> {
        private final int Iv;
        private final String YI;

        LeftRoomNotifier(int statusCode, String roomId) {
            this.Iv = statusCode;
            this.YI = roomId;
        }

        public void a(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.Iv, this.YI);
        }

        @Override
        public void gG() {
        }

        @Override
        public /* synthetic */ void c(Object object) {
            this.a((RoomUpdateListener)object);
        }
    }

    private static final class JoinedRoomNotifier
    extends AbstractRoomNotifier {
        public JoinedRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onJoinedRoom(n2, room);
        }
    }

    private static final class RoomCreatedNotifier
    extends AbstractRoomNotifier {
        public RoomCreatedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomCreated(n2, room);
        }
    }

    private static abstract class AbstractPeerStatusNotifier
    extends AbstractRoomStatusNotifier {
        private final ArrayList<String> Yv = new ArrayList();

        AbstractPeerStatusNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder);
            int n2 = participantIds.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.Yv.add(participantIds[i2]);
            }
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.a(roomStatusUpdateListener, room, this.Yv);
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private static abstract class AbstractRoomStatusNotifier
    extends com.google.android.gms.common.api.a<RoomStatusUpdateListener> {
        AbstractRoomStatusNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.a(roomStatusUpdateListener, GamesClientImpl.R(dataHolder));
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2);
    }

    private static abstract class AbstractRoomNotifier
    extends com.google.android.gms.common.api.a<RoomUpdateListener> {
        AbstractRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        protected void a(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.a(roomUpdateListener, GamesClientImpl.R(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void a(RoomUpdateListener var1, Room var2, int var3);
    }

    private static final class NearbyPlayerDetectedNotifier
    implements d.b<OnNearbyPlayerDetectedListener> {
        private final Player Ze;

        public void a(OnNearbyPlayerDetectedListener onNearbyPlayerDetectedListener) {
            onNearbyPlayerDetectedListener.a(this.Ze);
        }

        @Override
        public void gG() {
        }

        @Override
        public /* synthetic */ void c(Object object) {
            this.a((OnNearbyPlayerDetectedListener)object);
        }
    }

    private static final class RequestRemovedNotifier
    implements d.b<OnRequestReceivedListener> {
        private final String Zt;

        RequestRemovedNotifier(String requestId) {
            this.Zt = requestId;
        }

        public void a(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.Zt);
        }

        @Override
        public void gG() {
        }

        @Override
        public /* synthetic */ void c(Object object) {
            this.a((OnRequestReceivedListener)object);
        }
    }

    private static final class RequestReceivedNotifier
    implements d.b<OnRequestReceivedListener> {
        private final GameRequest Zs;

        RequestReceivedNotifier(GameRequest request) {
            this.Zs = request;
        }

        public void a(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.Zs);
        }

        @Override
        public void gG() {
        }

        @Override
        public /* synthetic */ void c(Object object) {
            this.a((OnRequestReceivedListener)object);
        }
    }

    private static final class QuestCompletedNotifier
    implements d.b<QuestUpdateListener> {
        private final Quest Yw;

        QuestCompletedNotifier(Quest quest) {
            this.Yw = quest;
        }

        public void a(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.Yw);
        }

        @Override
        public void gG() {
        }

        @Override
        public /* synthetic */ void c(Object object) {
            this.a((QuestUpdateListener)object);
        }
    }

    private static final class MatchRemovedNotifier
    implements d.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final String Zb;

        MatchRemovedNotifier(String matchId) {
            this.Zb = matchId;
        }

        public void a(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.Zb);
        }

        @Override
        public void gG() {
        }

        @Override
        public /* synthetic */ void c(Object object) {
            this.a((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class MatchUpdateReceivedNotifier
    implements d.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch Zc;

        MatchUpdateReceivedNotifier(TurnBasedMatch match) {
            this.Zc = match;
        }

        public void a(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.Zc);
        }

        @Override
        public void gG() {
        }

        @Override
        public /* synthetic */ void c(Object object) {
            this.a((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class InvitationRemovedNotifier
    implements d.b<OnInvitationReceivedListener> {
        private final String YG;

        InvitationRemovedNotifier(String invitationId) {
            this.YG = invitationId;
        }

        public void a(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.YG);
        }

        @Override
        public void gG() {
        }

        @Override
        public /* synthetic */ void c(Object object) {
            this.a((OnInvitationReceivedListener)object);
        }
    }

    private static final class InvitationReceivedNotifier
    implements d.b<OnInvitationReceivedListener> {
        private final Invitation YF;

        InvitationReceivedNotifier(Invitation invitation) {
            this.YF = invitation;
        }

        public void a(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.YF);
        }

        @Override
        public void gG() {
        }

        @Override
        public /* synthetic */ void c(Object object) {
            this.a((OnInvitationReceivedListener)object);
        }
    }

    static final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Snapshots.DeleteSnapshotResult> Ea;

        public SnapshotDeletedBinderCallbacks(BaseImplementation.b<Snapshots.DeleteSnapshotResult> resultHolder) {
            this.Ea = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void i(int n2, String string2) {
            this.Ea.b(new DeleteSnapshotResultImpl(n2, string2));
        }
    }

    private static final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Snapshots.CommitSnapshotResult> ZB;

        public SnapshotCommittedBinderCallbacks(BaseImplementation.b<Snapshots.CommitSnapshotResult> resultHolder) {
            this.ZB = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void J(DataHolder dataHolder) {
            this.ZB.b(new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private static final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Snapshots.OpenSnapshotResult> ZC;

        public SnapshotOpenedBinderCallbacks(BaseImplementation.b<Snapshots.OpenSnapshotResult> resultHolder) {
            this.ZC = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void a(DataHolder dataHolder, Contents contents) {
            this.ZC.b(new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void a(DataHolder dataHolder, String string2, Contents contents, Contents contents2, Contents contents3) {
            this.ZC.b(new OpenSnapshotResultImpl(dataHolder, string2, contents, contents2, contents3));
        }
    }

    private static final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Snapshots.LoadSnapshotsResult> ZD;

        public SnapshotsLoadedBinderCallbacks(BaseImplementation.b<Snapshots.LoadSnapshotsResult> resultHolder) {
            this.ZD = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void I(DataHolder dataHolder) {
            this.ZD.b(new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private static final class AppContentLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<AppContents.LoadAppContentResult> Yx;

        public AppContentLoadedBinderCallbacks(BaseImplementation.b<AppContents.LoadAppContentResult> resultHolder) {
            this.Yx = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void a(DataHolder[] dataHolderArray) {
            this.Yx.b(new LoadAppContentsResultImpl(dataHolderArray));
        }
    }

    private static final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Quests.LoadQuestsResult> Zo;

        public QuestsLoadedBinderCallbacks(BaseImplementation.b<Quests.LoadQuestsResult> resultHolder) {
            this.Zo = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void O(DataHolder dataHolder) {
            this.Zo.b(new LoadQuestsResultImpl(dataHolder));
        }
    }

    private static final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Quests.ClaimMilestoneResult> Zm;
        private final String Zn;

        public QuestMilestoneClaimBinderCallbacks(BaseImplementation.b<Quests.ClaimMilestoneResult> resultHolder, String milestoneId) {
            this.Zm = jx.b(resultHolder, (Object)"Holder must not be null");
            this.Zn = jx.b(milestoneId, (Object)"MilestoneId must not be null");
        }

        @Override
        public void K(DataHolder dataHolder) {
            this.Zm.b(new ClaimMilestoneResultImpl(dataHolder, this.Zn));
        }
    }

    private static final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Quests.AcceptQuestResult> Zl;

        public QuestAcceptedBinderCallbacks(BaseImplementation.b<Quests.AcceptQuestResult> resultHolder) {
            this.Zl = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void L(DataHolder dataHolder) {
            this.Zl.b(new AcceptQuestResultImpl(dataHolder));
        }
    }

    private static final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Requests.LoadRequestSummariesResult> Zv;

        public RequestSummariesLoadedBinderCallbacks(BaseImplementation.b<Requests.LoadRequestSummariesResult> resultHolder) {
            this.Zv = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void H(DataHolder dataHolder) {
            this.Zv.b(new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private static final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Requests.LoadRequestsResult> Zw;

        public RequestsLoadedBinderCallbacks(BaseImplementation.b<Requests.LoadRequestsResult> resultHolder) {
            this.Zw = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void c(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.Zw.b(new LoadRequestsResultImpl(status, bundle));
        }
    }

    private static final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Requests.SendRequestResult> Zu;

        public RequestSentBinderCallbacks(BaseImplementation.b<Requests.SendRequestResult> resultHolder) {
            this.Zu = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void G(DataHolder dataHolder) {
            this.Zu.b(new SendRequestResultImpl(dataHolder));
        }
    }

    private static final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Requests.UpdateRequestsResult> Zx;

        public RequestsUpdatedBinderCallbacks(BaseImplementation.b<Requests.UpdateRequestsResult> resultHolder) {
            this.Zx = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void F(DataHolder dataHolder) {
            this.Zx.b(new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private static final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Status> Ea;

        public SignOutCompleteBinderCallbacks(BaseImplementation.b<Status> resultHolder) {
            this.Ea = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void fK() {
            Status status = new Status(0);
            this.Ea.b(status);
        }
    }

    private static final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Notifications.InboxCountResult> Ea;

        InboxCountsLoadedBinderCallback(BaseImplementation.b<Notifications.InboxCountResult> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void f(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.Ea.b(new InboxCountResultImpl(status, bundle));
        }
    }

    private static final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Status> Ea;

        ContactSettingsUpdatedBinderCallback(BaseImplementation.b<Status> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void dP(int n2) {
            this.Ea.b(new Status(n2));
        }
    }

    private static final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Notifications.ContactSettingLoadResult> Ea;

        ContactSettingsLoadedBinderCallback(BaseImplementation.b<Notifications.ContactSettingLoadResult> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void D(DataHolder dataHolder) {
            this.Ea.b(new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Notifications.GameMuteStatusLoadResult> Ea;

        GameMuteStatusLoadedBinderCallback(BaseImplementation.b<Notifications.GameMuteStatusLoadResult> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void B(DataHolder dataHolder) {
            this.Ea.b(new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Notifications.GameMuteStatusChangeResult> Ea;

        GameMuteStatusChangedBinderCallback(BaseImplementation.b<Notifications.GameMuteStatusChangeResult> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void a(int n2, String string2, boolean bl2) {
            this.Ea.b(new GameMuteStatusChangeResultImpl(n2, string2, bl2));
        }
    }

    private static final class NotifyAclUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Status> Ea;

        NotifyAclUpdatedBinderCallback(BaseImplementation.b<Status> resultHolder) {
            this.Ea = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void dO(int n2) {
            this.Ea.b(new Status(n2));
        }
    }

    private static final class NotifyAclLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Acls.LoadAclResult> Ea;

        NotifyAclLoadedBinderCallback(BaseImplementation.b<Acls.LoadAclResult> resultHolder) {
            this.Ea = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void C(DataHolder dataHolder) {
            this.Ea.b(new LoadAclResultImpl(dataHolder));
        }
    }

    private static final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final d<RealTimeMultiplayer.ReliableMessageSentCallback> Zr;

        public RealTimeReliableMessageBinderCallbacks(d<RealTimeMultiplayer.ReliableMessageSentCallback> messageSentCallbacks) {
            this.Zr = messageSentCallbacks;
        }

        @Override
        public void b(int n2, int n3, String string2) {
            if (this.Zr != null) {
                this.Zr.a(new RealTimeMessageSentNotifier(n2, n3, string2));
            }
        }
    }

    private static final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final d<? extends RoomUpdateListener> Zy;
        private final d<? extends RoomStatusUpdateListener> Zz;
        private final d<RealTimeMessageReceivedListener> ZA;

        public RoomBinderCallbacks(d<RoomUpdateListener> roomCallbacks) {
            this.Zy = jx.b(roomCallbacks, (Object)"Callbacks must not be null");
            this.Zz = null;
            this.ZA = null;
        }

        public RoomBinderCallbacks(d<? extends RoomUpdateListener> roomCallbacks, d<? extends RoomStatusUpdateListener> roomStatusCallbacks, d<RealTimeMessageReceivedListener> realTimeMessageReceivedCallbacks) {
            this.Zy = jx.b(roomCallbacks, (Object)"Callbacks must not be null");
            this.Zz = roomStatusCallbacks;
            this.ZA = realTimeMessageReceivedCallbacks;
        }

        @Override
        public void u(DataHolder dataHolder) {
            this.Zy.a(new RoomCreatedNotifier(dataHolder));
        }

        @Override
        public void v(DataHolder dataHolder) {
            this.Zy.a(new JoinedRoomNotifier(dataHolder));
        }

        @Override
        public void onLeftRoom(int statusCode, String externalRoomId) {
            this.Zy.a(new LeftRoomNotifier(statusCode, externalRoomId));
        }

        @Override
        public void y(DataHolder dataHolder) {
            this.Zy.a(new RoomConnectedNotifier(dataHolder));
        }

        @Override
        public void w(DataHolder dataHolder) {
            if (this.Zz != null) {
                this.Zz.a(new RoomConnectingNotifier(dataHolder));
            }
        }

        @Override
        public void x(DataHolder dataHolder) {
            if (this.Zz != null) {
                this.Zz.a(new RoomAutoMatchingNotifier(dataHolder));
            }
        }

        @Override
        public void z(DataHolder dataHolder) {
            if (this.Zz != null) {
                this.Zz.a(new ConnectedToRoomNotifier(dataHolder));
            }
        }

        @Override
        public void A(DataHolder dataHolder) {
            if (this.Zz != null) {
                this.Zz.a(new DisconnectedFromRoomNotifier(dataHolder));
            }
        }

        @Override
        public void e(DataHolder dataHolder, String[] stringArray) {
            if (this.Zz != null) {
                this.Zz.a(new PeerConnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void f(DataHolder dataHolder, String[] stringArray) {
            if (this.Zz != null) {
                this.Zz.a(new PeerDisconnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void a(DataHolder dataHolder, String[] stringArray) {
            if (this.Zz != null) {
                this.Zz.a(new PeerInvitedToRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void b(DataHolder dataHolder, String[] stringArray) {
            if (this.Zz != null) {
                this.Zz.a(new PeerJoinedRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void c(DataHolder dataHolder, String[] stringArray) {
            if (this.Zz != null) {
                this.Zz.a(new PeerLeftRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void d(DataHolder dataHolder, String[] stringArray) {
            if (this.Zz != null) {
                this.Zz.a(new PeerDeclinedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void onP2PConnected(String participantId) {
            if (this.Zz != null) {
                this.Zz.a(new P2PConnectedNotifier(participantId));
            }
        }

        @Override
        public void onP2PDisconnected(String participantId) {
            if (this.Zz != null) {
                this.Zz.a(new P2PDisconnectedNotifier(participantId));
            }
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage message) {
            if (this.ZA != null) {
                this.ZA.a(new MessageReceivedNotifier(message));
            }
        }
    }

    private static final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.CancelMatchResult> ZF;

        public TurnBasedMatchCanceledBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.CancelMatchResult> resultHolder) {
            this.ZF = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void h(int n2, String string2) {
            Status status = new Status(n2);
            this.ZF.b(new CancelMatchResultImpl(status, string2));
        }
    }

    private static final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.LeaveMatchResult> ZH;

        public TurnBasedMatchLeftBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.LeaveMatchResult> resultHolder) {
            this.ZH = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void s(DataHolder dataHolder) {
            this.ZH.b(new LeaveMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.UpdateMatchResult> ZJ;

        public TurnBasedMatchUpdatedBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.UpdateMatchResult> resultHolder) {
            this.ZJ = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void r(DataHolder dataHolder) {
            this.ZJ.b(new UpdateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> ZG;

        public TurnBasedMatchInitiatedBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> resultHolder) {
            this.ZG = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void q(DataHolder dataHolder) {
            this.ZG.b(new InitiateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.LoadMatchResult> ZI;

        public TurnBasedMatchLoadedBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchResult> resultHolder) {
            this.ZI = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void p(DataHolder dataHolder) {
            this.ZI.b(new LoadMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.LoadMatchesResult> ZK;

        public TurnBasedMatchesLoadedBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchesResult> resultHolder) {
            this.ZK = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void b(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.ZK.b(new LoadMatchesResultImpl(status, bundle));
        }
    }

    private static final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Leaderboards.SubmitScoreResult> Ea;

        public SubmitScoreBinderCallbacks(BaseImplementation.b<Leaderboards.SubmitScoreResult> resultHolder) {
            this.Ea = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void f(DataHolder dataHolder) {
            this.Ea.b(new SubmitScoreResultImpl(dataHolder));
        }
    }

    private static final class OwnerCoverPhotoUrisLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadOwnerCoverPhotoUrisResult> Ea;

        OwnerCoverPhotoUrisLoadedBinderCallback(BaseImplementation.b<Players.LoadOwnerCoverPhotoUrisResult> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void d(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            this.Ea.b(new LoadOwnerCoverPhotoUrisResultImpl(n2, bundle));
        }
    }

    private static final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Status> Ea;

        ProfileSettingsUpdatedBinderCallback(BaseImplementation.b<Status> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void dQ(int n2) {
            this.Ea.b(new Status(n2));
        }
    }

    static final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadProfileSettingsResult> Ea;

        ProfileSettingsLoadedBinderCallback(BaseImplementation.b<Players.LoadProfileSettingsResult> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void Q(DataHolder dataHolder) {
            this.Ea.b(new LoadProfileSettingsResultImpl(dataHolder));
        }
    }

    static final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadXpStreamResult> Ea;

        PlayerXpStreamLoadedBinderCallback(BaseImplementation.b<Players.LoadXpStreamResult> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void P(DataHolder dataHolder) {
            this.Ea.b(new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private static final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadXpForGameCategoriesResult> Ea;

        PlayerXpForGameCategoriesLoadedBinderCallback(BaseImplementation.b<Players.LoadXpForGameCategoriesResult> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void e(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.Ea.b(new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private static final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadPlayersResult> Ea;

        PlayersLoadedBinderCallback(BaseImplementation.b<Players.LoadPlayersResult> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void g(DataHolder dataHolder) {
            this.Ea.b(new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void h(DataHolder dataHolder) {
            this.Ea.b(new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final d<OnRequestReceivedListener> Qe;

        RequestReceivedBinderCallback(d<OnRequestReceivedListener> listener) {
            this.Qe = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void o(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.Qe.a(new RequestReceivedNotifier(gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String requestId) {
            this.Qe.a(new RequestRemovedNotifier(requestId));
        }
    }

    private static final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final d<QuestUpdateListener> Qe;

        QuestUpdateBinderCallback(d<QuestUpdateListener> listener) {
            this.Qe = listener;
        }

        @Override
        public void M(DataHolder dataHolder) {
            Quest quest = this.T(dataHolder);
            if (quest != null) {
                this.Qe.a(new QuestCompletedNotifier(quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest T(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private static final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final d<OnTurnBasedMatchUpdateReceivedListener> Qe;

        MatchUpdateReceivedBinderCallback(d<OnTurnBasedMatchUpdateReceivedListener> listener) {
            this.Qe = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void t(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.Qe.a(new MatchUpdateReceivedNotifier(turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String matchId) {
            this.Qe.a(new MatchRemovedNotifier(matchId));
        }
    }

    private static final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final d<OnInvitationReceivedListener> Qe;

        InvitationReceivedBinderCallback(d<OnInvitationReceivedListener> listener) {
            this.Qe = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void n(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.Qe.a(new InvitationReceivedNotifier(invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String invitationId) {
            this.Qe.a(new InvitationRemovedNotifier(invitationId));
        }
    }

    private static final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Invitations.LoadInvitationsResult> Ea;

        InvitationsLoadedBinderCallback(BaseImplementation.b<Invitations.LoadInvitationsResult> resultHolder) {
            this.Ea = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void m(DataHolder dataHolder) {
            this.Ea.b(new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private static final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Leaderboards.LoadPlayerScoreResult> Ea;

        PlayerLeaderboardScoreLoadedBinderCallback(BaseImplementation.b<Leaderboards.LoadPlayerScoreResult> resultHolder) {
            this.Ea = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void E(DataHolder dataHolder) {
            this.Ea.b(new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private static final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Leaderboards.LoadScoresResult> Ea;

        LeaderboardScoresLoadedBinderCallback(BaseImplementation.b<Leaderboards.LoadScoresResult> resultHolder) {
            this.Ea = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void a(DataHolder dataHolder, DataHolder dataHolder2) {
            this.Ea.b(new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private static final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> Ea;

        LeaderboardsLoadedBinderCallback(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> resultHolder) {
            this.Ea = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void e(DataHolder dataHolder) {
            this.Ea.b(new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private static final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<GamesMetadata.LoadGameSearchSuggestionsResult> Ea;

        GameSearchSuggestionsLoadedBinderCallback(BaseImplementation.b<GamesMetadata.LoadGameSearchSuggestionsResult> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void l(DataHolder dataHolder) {
            this.Ea.b(new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private static final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<GamesMetadata.LoadGameInstancesResult> Ea;

        GameInstancesLoadedBinderCallback(BaseImplementation.b<GamesMetadata.LoadGameInstancesResult> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void k(DataHolder dataHolder) {
            this.Ea.b(new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private static final class ExtendedGamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> Ea;

        ExtendedGamesLoadedBinderCallback(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void j(DataHolder dataHolder) {
            this.Ea.b(new LoadExtendedGamesResultImpl(dataHolder));
        }
    }

    private static final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Events.LoadEventsResult> Ea;

        EventsLoadedBinderCallback(BaseImplementation.b<Events.LoadEventsResult> resultHolder) {
            this.Ea = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void d(DataHolder dataHolder) {
            this.Ea.b(new LoadEventResultImpl(dataHolder));
        }
    }

    private static final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<GamesMetadata.LoadGamesResult> Ea;

        GamesLoadedBinderCallback(BaseImplementation.b<GamesMetadata.LoadGamesResult> holder) {
            this.Ea = jx.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void i(DataHolder dataHolder) {
            this.Ea.b(new LoadGamesResultImpl(dataHolder));
        }
    }

    private static final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Achievements.UpdateAchievementResult> Ea;

        AchievementUpdatedBinderCallback(BaseImplementation.b<Achievements.UpdateAchievementResult> resultHolder) {
            this.Ea = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void g(int n2, String string2) {
            this.Ea.b(new UpdateAchievementResultImpl(n2, string2));
        }
    }

    private static final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Achievements.LoadAchievementsResult> Ea;

        AchievementsLoadedBinderCallback(BaseImplementation.b<Achievements.LoadAchievementsResult> resultHolder) {
            this.Ea = jx.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void c(DataHolder dataHolder) {
            this.Ea.b(new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void r(String string2, int n2) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.hw()).o(string2, n2);
                } else {
                    GamesLog.p("GamesClientImpl", "Unable to increment event " + string2 + " by " + n2 + " because the games client is no longer connected");
                }
            }
            catch (RemoteException remoteException) {
                GamesLog.o("GamesClientImpl", "service died");
            }
        }
    }
}

