/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.PlayerLevelCreator;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;

public final class PlayerLevel
implements SafeParcelable {
    public static final PlayerLevelCreator CREATOR = new PlayerLevelCreator();
    private final int CK;
    private final int Xo;
    private final long Xp;
    private final long Xq;

    public PlayerLevel(int value, long minXp, long maxXp) {
        this(1, value, minXp, maxXp);
    }

    PlayerLevel(int versionCode, int levelNumber, long minXp, long maxXp) {
        jx.a(minXp >= 0L, "Min XP must be positive!");
        jx.a(maxXp > minXp, "Max XP must be more than min XP!");
        this.CK = versionCode;
        this.Xo = levelNumber;
        this.Xp = minXp;
        this.Xq = maxXp;
    }

    public int getVersionCode() {
        return this.CK;
    }

    public int getLevelNumber() {
        return this.Xo;
    }

    public long getMinXp() {
        return this.Xp;
    }

    public long getMaxXp() {
        return this.Xq;
    }

    public int hashCode() {
        return jv.hashCode(this.Xo, this.Xp, this.Xq);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevel)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PlayerLevel playerLevel = (PlayerLevel)obj;
        return jv.equal(playerLevel.getLevelNumber(), this.getLevelNumber()) && jv.equal(playerLevel.getMinXp(), this.getMinXp()) && jv.equal(playerLevel.getMaxXp(), this.getMaxXp());
    }

    public String toString() {
        return jv.h(this).a("LevelNumber", this.getLevelNumber()).a("MinXp", this.getMinXp()).a("MaxXp", this.getMaxXp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelCreator.a(this, out, flags);
    }
}

