/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;
import com.google.android.gms.internal.je;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.le;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int CK;
    private final String Xh;
    private final String OS;
    private final Uri WD;
    private final Uri WE;
    private final long Xi;
    private final int Xj;
    private final long Xk;
    private final String WO;
    private final String WP;
    private final String OH;
    private final MostRecentGameInfoEntity Xl;
    private final PlayerLevelInfo Xm;
    private final boolean Xn;

    public PlayerEntity(Player player) {
        this.CK = 11;
        this.Xh = player.getPlayerId();
        this.OS = player.getDisplayName();
        this.WD = player.getIconImageUri();
        this.WO = player.getIconImageUrl();
        this.WE = player.getHiResImageUri();
        this.WP = player.getHiResImageUrl();
        this.Xi = player.getRetrievedTimestamp();
        this.Xj = player.kE();
        this.Xk = player.getLastPlayedWithTimestamp();
        this.OH = player.getTitle();
        this.Xn = player.isProfileVisible();
        MostRecentGameInfo mostRecentGameInfo = player.kF();
        this.Xl = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.Xm = player.getLevelInfo();
        je.f(this.Xh);
        je.f(this.OS);
        je.K(this.Xi > 0L);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp, String iconImageUrl, String hiResImageUrl, String title, MostRecentGameInfoEntity mostRecentGameInfo, PlayerLevelInfo playerLevelInfo, boolean isProfileVisible) {
        this.CK = versionCode;
        this.Xh = playerId;
        this.OS = displayName;
        this.WD = iconImageUri;
        this.WO = iconImageUrl;
        this.WE = hiResImageUri;
        this.WP = hiResImageUrl;
        this.Xi = retrievedTimestamp;
        this.Xj = isInCircles;
        this.Xk = lastPlayedWithTimestamp;
        this.OH = title;
        this.Xn = isProfileVisible;
        this.Xl = mostRecentGameInfo;
        this.Xm = playerLevelInfo;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public String getPlayerId() {
        return this.Xh;
    }

    @Override
    public String getDisplayName() {
        return this.OS;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        le.b(this.OS, dataOut);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.WD;
    }

    @Override
    public String getIconImageUrl() {
        return this.WO;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.WE;
    }

    @Override
    public String getHiResImageUrl() {
        return this.WP;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.Xi;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.Xk;
    }

    @Override
    public int kE() {
        return this.Xj;
    }

    @Override
    public boolean isProfileVisible() {
        return this.Xn;
    }

    @Override
    public String getTitle() {
        return this.OH;
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        le.b(this.OH, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.Xm;
    }

    @Override
    public MostRecentGameInfo kF() {
        return this.Xl;
    }

    @Override
    public Player freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.b(this);
    }

    static int b(Player player) {
        return jv.hashCode(player.getPlayerId(), player.getDisplayName(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo());
    }

    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    static boolean a(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return jv.equal(player2.getPlayerId(), player.getPlayerId()) && jv.equal(player2.getDisplayName(), player.getDisplayName()) && jv.equal(player2.getIconImageUri(), player.getIconImageUri()) && jv.equal(player2.getHiResImageUri(), player.getHiResImageUri()) && jv.equal(player2.getRetrievedTimestamp(), player.getRetrievedTimestamp()) && jv.equal(player2.getTitle(), player.getTitle()) && jv.equal(player2.getLevelInfo(), player.getLevelInfo());
    }

    public String toString() {
        return PlayerEntity.c(this);
    }

    static String c(Player player) {
        return jv.h(player).a("PlayerId", player.getPlayerId()).a("DisplayName", player.getDisplayName()).a("IconImageUri", player.getIconImageUri()).a("IconImageUrl", player.getIconImageUrl()).a("HiResImageUri", player.getHiResImageUri()).a("HiResImageUrl", player.getHiResImageUrl()).a("RetrievedTimestamp", player.getRetrievedTimestamp()).a("Title", player.getTitle()).a("LevelInfo", player.getLevelInfo()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.hu()) {
            PlayerEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.Xh);
            dest.writeString(this.OS);
            dest.writeString(this.WD == null ? null : this.WD.toString());
            dest.writeString(this.WE == null ? null : this.WE.toString());
            dest.writeLong(this.Xi);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity cm(Parcel parcel) {
            boolean bl2 = PlayerEntity.c(PlayerEntity.ht());
            if (bl2 || PlayerEntity.aW(PlayerEntity.class.getCanonicalName())) {
                return super.cm(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            long l2 = parcel.readLong();
            int n2 = -1;
            long l3 = -1L;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            PlayerLevelInfo playerLevelInfo = null;
            MostRecentGameInfoEntity mostRecentGameInfoEntity = null;
            boolean bl3 = true;
            return new PlayerEntity(11, string2, string3, uri, uri2, l2, n2, l3, string6, string7, string8, mostRecentGameInfoEntity, playerLevelInfo, bl3);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cm(x0);
        }
    }
}

