/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.le;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int CK;
    private final String Fo;
    private final String OS;
    private final String WA;
    private final String WB;
    private final String UO;
    private final String WC;
    private final Uri WD;
    private final Uri WE;
    private final Uri WF;
    private final boolean WG;
    private final boolean WH;
    private final String WI;
    private final int WJ;
    private final int WK;
    private final int WL;
    private final boolean WM;
    private final boolean WN;
    private final String WO;
    private final String WP;
    private final String WQ;
    private final boolean WR;
    private final boolean WS;
    private final boolean WT;
    private final String WU;

    public GameEntity(Game game) {
        this.CK = 5;
        this.Fo = game.getApplicationId();
        this.WA = game.getPrimaryCategory();
        this.WB = game.getSecondaryCategory();
        this.UO = game.getDescription();
        this.WC = game.getDeveloperName();
        this.OS = game.getDisplayName();
        this.WD = game.getIconImageUri();
        this.WO = game.getIconImageUrl();
        this.WE = game.getHiResImageUri();
        this.WP = game.getHiResImageUrl();
        this.WF = game.getFeaturedImageUri();
        this.WQ = game.getFeaturedImageUrl();
        this.WG = game.ky();
        this.WH = game.kA();
        this.WI = game.kB();
        this.WJ = game.kC();
        this.WK = game.getAchievementTotalCount();
        this.WL = game.getLeaderboardCount();
        this.WM = game.isRealTimeMultiplayerEnabled();
        this.WN = game.isTurnBasedMultiplayerEnabled();
        this.WR = game.isMuted();
        this.WS = game.kz();
        this.WT = game.areSnapshotsEnabled();
        this.WU = game.getThemeColor();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed, boolean snapshotsEnabled, String themeColor) {
        this.CK = versionCode;
        this.Fo = applicationId;
        this.OS = displayName;
        this.WA = primaryCategory;
        this.WB = secondaryCategory;
        this.UO = description;
        this.WC = developerName;
        this.WD = iconImageUri;
        this.WO = iconImageUrl;
        this.WE = hiResImageUri;
        this.WP = hiResImageUrl;
        this.WF = featuredImageUri;
        this.WQ = featuredImageUrl;
        this.WG = playEnabledGame;
        this.WH = instanceInstalled;
        this.WI = instancePackageName;
        this.WJ = gameplayAclStatus;
        this.WK = achievementTotalCount;
        this.WL = leaderboardCount;
        this.WM = realTimeEnabled;
        this.WN = turnBasedEnabled;
        this.WR = muted;
        this.WS = identitySharingConfirmed;
        this.WT = snapshotsEnabled;
        this.WU = themeColor;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public String getApplicationId() {
        return this.Fo;
    }

    @Override
    public String getDisplayName() {
        return this.OS;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        le.b(this.OS, dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.WA;
    }

    @Override
    public String getSecondaryCategory() {
        return this.WB;
    }

    @Override
    public String getDescription() {
        return this.UO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        le.b(this.UO, dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.WC;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        le.b(this.WC, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.WD;
    }

    @Override
    public String getIconImageUrl() {
        return this.WO;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.WE;
    }

    @Override
    public String getHiResImageUrl() {
        return this.WP;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.WF;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.WQ;
    }

    @Override
    public boolean isMuted() {
        return this.WR;
    }

    @Override
    public boolean kz() {
        return this.WS;
    }

    @Override
    public boolean ky() {
        return this.WG;
    }

    @Override
    public boolean kA() {
        return this.WH;
    }

    @Override
    public String kB() {
        return this.WI;
    }

    @Override
    public int kC() {
        return this.WJ;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.WK;
    }

    @Override
    public int getLeaderboardCount() {
        return this.WL;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.WM;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.WN;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.WT;
    }

    @Override
    public String getThemeColor() {
        return this.WU;
    }

    @Override
    public Game freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.a(this);
    }

    static int a(Game game) {
        return jv.hashCode(game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.ky(), game.kA(), game.kB(), game.kC(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.kz(), game.areSnapshotsEnabled(), game.getThemeColor());
    }

    public boolean equals(Object obj) {
        return GameEntity.a(this, obj);
    }

    static boolean a(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return jv.equal(game2.getApplicationId(), game.getApplicationId()) && jv.equal(game2.getDisplayName(), game.getDisplayName()) && jv.equal(game2.getPrimaryCategory(), game.getPrimaryCategory()) && jv.equal(game2.getSecondaryCategory(), game.getSecondaryCategory()) && jv.equal(game2.getDescription(), game.getDescription()) && jv.equal(game2.getDeveloperName(), game.getDeveloperName()) && jv.equal(game2.getIconImageUri(), game.getIconImageUri()) && jv.equal(game2.getHiResImageUri(), game.getHiResImageUri()) && jv.equal(game2.getFeaturedImageUri(), game.getFeaturedImageUri()) && jv.equal(game2.ky(), game.ky()) && jv.equal(game2.kA(), game.kA()) && jv.equal(game2.kB(), game.kB()) && jv.equal(game2.kC(), game.kC()) && jv.equal(game2.getAchievementTotalCount(), game.getAchievementTotalCount()) && jv.equal(game2.getLeaderboardCount(), game.getLeaderboardCount()) && jv.equal(game2.isRealTimeMultiplayerEnabled(), game.isRealTimeMultiplayerEnabled()) && jv.equal(game2.isTurnBasedMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled() && jv.equal(game2.isMuted(), game.isMuted()) && jv.equal(game2.kz(), game.kz())) && jv.equal(game2.areSnapshotsEnabled(), game.areSnapshotsEnabled()) && jv.equal(game2.getThemeColor(), game.getThemeColor());
    }

    public String toString() {
        return GameEntity.b(this);
    }

    static String b(Game game) {
        return jv.h(game).a("ApplicationId", game.getApplicationId()).a("DisplayName", game.getDisplayName()).a("PrimaryCategory", game.getPrimaryCategory()).a("SecondaryCategory", game.getSecondaryCategory()).a("Description", game.getDescription()).a("DeveloperName", game.getDeveloperName()).a("IconImageUri", game.getIconImageUri()).a("IconImageUrl", game.getIconImageUrl()).a("HiResImageUri", game.getHiResImageUri()).a("HiResImageUrl", game.getHiResImageUrl()).a("FeaturedImageUri", game.getFeaturedImageUri()).a("FeaturedImageUrl", game.getFeaturedImageUrl()).a("PlayEnabledGame", game.ky()).a("InstanceInstalled", game.kA()).a("InstancePackageName", game.kB()).a("AchievementTotalCount", game.getAchievementTotalCount()).a("LeaderboardCount", game.getLeaderboardCount()).a("RealTimeMultiplayerEnabled", game.isRealTimeMultiplayerEnabled()).a("TurnBasedMultiplayerEnabled", game.isTurnBasedMultiplayerEnabled()).a("AreSnapshotsEnabled", game.areSnapshotsEnabled()).a("ThemeColor", game.getThemeColor()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.hu()) {
            GameEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.Fo);
            dest.writeString(this.OS);
            dest.writeString(this.WA);
            dest.writeString(this.WB);
            dest.writeString(this.UO);
            dest.writeString(this.WC);
            dest.writeString(this.WD == null ? null : this.WD.toString());
            dest.writeString(this.WE == null ? null : this.WE.toString());
            dest.writeString(this.WF == null ? null : this.WF.toString());
            dest.writeInt(this.WG ? 1 : 0);
            dest.writeInt(this.WH ? 1 : 0);
            dest.writeString(this.WI);
            dest.writeInt(this.WJ);
            dest.writeInt(this.WK);
            dest.writeInt(this.WL);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity cl(Parcel parcel) {
            boolean bl2 = GameEntity.c(GameEntity.ht());
            if (bl2 || GameEntity.aW(GameEntity.class.getCanonicalName())) {
                return super.cl(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            String string8 = parcel.readString();
            Uri uri = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri2 = string9 == null ? null : Uri.parse((String)string9);
            String string10 = parcel.readString();
            Uri uri3 = string10 == null ? null : Uri.parse((String)string10);
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            String string11 = parcel.readString();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            boolean bl5 = false;
            boolean bl6 = false;
            String string12 = null;
            String string13 = null;
            String string14 = null;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            String string15 = null;
            return new GameEntity(5, string2, string3, string4, string5, string6, string7, uri, uri2, uri3, bl3, bl4, string11, n2, n3, n4, bl5, bl6, string12, string13, string14, bl7, bl8, bl9, string15);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cl(x0);
        }
    }
}

