/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.d;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
implements SafeParcelable {
    private final int CK;
    private final long LW;
    private final long TO;
    private final List<DataSource> VH;
    private final List<DataType> TY;
    private final List<Session> VI;
    private final boolean VJ;
    private final boolean VK;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new d();

    DataDeleteRequest(int versionCode, long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions) {
        this.CK = versionCode;
        this.LW = startTimeMillis;
        this.TO = endTimeMillis;
        this.VH = Collections.unmodifiableList(dataSources);
        this.TY = Collections.unmodifiableList(dataTypes);
        this.VI = sessions;
        this.VJ = deleteAllData;
        this.VK = deleteAllSessions;
    }

    private DataDeleteRequest(Builder builder) {
        this.CK = 1;
        this.LW = builder.LW;
        this.TO = builder.TO;
        this.VH = Collections.unmodifiableList(builder.VH);
        this.TY = Collections.unmodifiableList(builder.TY);
        this.VI = Collections.unmodifiableList(builder.VI);
        this.VJ = builder.VJ;
        this.VK = builder.VK;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.LW, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.TO, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.VH;
    }

    public List<DataType> getDataTypes() {
        return this.TY;
    }

    public List<Session> getSessions() {
        return this.VI;
    }

    public boolean deleteAllData() {
        return this.VJ;
    }

    public boolean deleteAllSessions() {
        return this.VK;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataDeleteRequest && this.a((DataDeleteRequest)o2);
    }

    private boolean a(DataDeleteRequest dataDeleteRequest) {
        return this.LW == dataDeleteRequest.LW && this.TO == dataDeleteRequest.TO && jv.equal(this.VH, dataDeleteRequest.VH) && jv.equal(this.TY, dataDeleteRequest.TY) && jv.equal(this.VI, dataDeleteRequest.VI) && this.VJ == dataDeleteRequest.VJ && this.VK == dataDeleteRequest.VK;
    }

    public int hashCode() {
        return jv.hashCode(this.LW, this.TO);
    }

    public String toString() {
        return jv.h(this).a("startTimeMillis", this.LW).a("endTimeMillis", this.TO).a("dataSources", this.VH).a("dateTypes", this.TY).a("sessions", this.VI).a("deleteAllData", this.VJ).a("deleteAllSessions", this.VK).toString();
    }

    int getVersionCode() {
        return this.CK;
    }

    public boolean jR() {
        return this.VJ;
    }

    public boolean jS() {
        return this.VK;
    }

    public long jp() {
        return this.TO;
    }

    public long jo() {
        return this.LW;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        d.a(this, dest, flags);
    }

    public static class Builder {
        private long LW;
        private long TO;
        private List<DataSource> VH = new ArrayList<DataSource>();
        private List<DataType> TY = new ArrayList<DataType>();
        private List<Session> VI = new ArrayList<Session>();
        private boolean VJ = false;
        private boolean VK = false;

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            jx.b(startTime > 0L, "Invalid start time :%d", startTime);
            jx.b(endTime > startTime, "Invalid end time :%d", endTime);
            this.LW = timeUnit.toMillis(startTime);
            this.TO = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder deleteAllData() {
            jx.b(this.TY.isEmpty() && this.VH.isEmpty(), "Specific data source/type already specified for deletion. DataSources: %s DataTypes: %s", this.VH, this.TY);
            this.VJ = true;
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            jx.b(!this.VJ, (Object)"All data is already marked for deletion");
            jx.b(dataSource != null, (Object)"Must specify a valid data source");
            if (!this.VH.contains(dataSource)) {
                this.VH.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            jx.b(!this.VK, (Object)"All sessions already marked for deletion");
            jx.b(session != null, (Object)"Must specify a valid session");
            jx.b(session.getEndTime(TimeUnit.MILLISECONDS) > 0L, (Object)"Must specify a session that has already ended");
            this.VI.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            jx.b(this.VI.isEmpty(), "Specific sessions already added for deletion: %s", this.VI);
            this.VK = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            jx.b(!this.VJ, (Object)"All data is already marked for deletion");
            jx.b(dataType != null, (Object)"Must specify a valid data type");
            if (!this.TY.contains(dataType)) {
                this.TY.add(dataType);
            }
            return this;
        }

        public DataDeleteRequest build() {
            jx.a(this.LW > 0L && this.TO > this.LW, "Must specify a valid time interval");
            boolean bl2 = this.VJ || !this.VH.isEmpty() || !this.TY.isEmpty();
            boolean bl3 = this.VK || !this.VI.isEmpty();
            jx.a(bl2 || bl3, "No data or session marked for deletion");
            this.jT();
            return new DataDeleteRequest(this);
        }

        private void jT() {
            if (this.VI.isEmpty()) {
                return;
            }
            for (Session session : this.VI) {
                jx.a(session.getStartTime(TimeUnit.MILLISECONDS) >= this.LW && session.getEndTime(TimeUnit.MILLISECONDS) <= this.TO, "Session %s is outside the time interval [%d, %d]", session, this.LW, this.TO);
            }
        }
    }
}

