/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.a;
import com.google.android.gms.fitness.data.p;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import java.util.concurrent.TimeUnit;

public class Session
implements SafeParcelable {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int CK;
    private final long LW;
    private final long TO;
    private final String mName;
    private final String UN;
    private final String UO;
    private final int TZ;
    private final a Um;
    public static final Parcelable.Creator<Session> CREATOR = new p();

    Session(int versionCode, long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, a application) {
        this.CK = versionCode;
        this.LW = startTimeMillis;
        this.TO = endTimeMillis;
        this.mName = name;
        this.UN = identifier;
        this.UO = description;
        this.TZ = activityType;
        this.Um = application;
    }

    private Session(Builder builder) {
        this.CK = 2;
        this.LW = builder.LW;
        this.TO = builder.TO;
        this.mName = builder.mName;
        this.UN = builder.UN;
        this.UO = builder.UO;
        this.TZ = builder.TZ;
        this.Um = builder.Um;
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return c.a(intent, EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String activity) {
        return MIME_TYPE_PREFIX + activity;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.LW, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.TO, TimeUnit.MILLISECONDS);
    }

    public boolean isOngoing() {
        return this.TO == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.UN;
    }

    public String getDescription() {
        return this.UO;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.TZ);
    }

    public int jm() {
        return this.TZ;
    }

    public a jx() {
        return this.Um;
    }

    public String getAppPackageName() {
        return this.Um == null ? null : this.Um.getPackageName();
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof Session && this.a((Session)o2);
    }

    private boolean a(Session session) {
        return this.LW == session.LW && this.TO == session.TO && jv.equal(this.mName, session.mName) && jv.equal(this.UN, session.UN) && jv.equal(this.UO, session.UO) && jv.equal(this.Um, session.Um) && this.TZ == session.TZ;
    }

    public int hashCode() {
        return jv.hashCode(this.LW, this.TO, this.UN);
    }

    public String toString() {
        return jv.h(this).a("startTime", this.LW).a("endTime", this.TO).a("name", this.mName).a("identifier", this.UN).a("description", this.UO).a("activity", this.TZ).a("application", this.Um).toString();
    }

    int getVersionCode() {
        return this.CK;
    }

    public long jo() {
        return this.LW;
    }

    public long jp() {
        return this.TO;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        p.a(this, dest, flags);
    }

    public static class Builder {
        private long LW = 0L;
        private long TO = 0L;
        private String mName = null;
        private String UN;
        private String UO;
        private int TZ = 4;
        private a Um;

        public Builder setStartTime(long time, TimeUnit timeUnit) {
            jx.a(time > 0L, "Start time should be positive.");
            this.LW = timeUnit.toMillis(time);
            return this;
        }

        public Builder setEndTime(long time, TimeUnit timeUnit) {
            jx.a(time >= 0L, "End time should be positive.");
            this.TO = timeUnit.toMillis(time);
            return this;
        }

        public Builder setName(String name) {
            jx.b(name.length() <= 100, "Session name cannot exceed %d characters", 100);
            this.mName = name;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            jx.L(identifier != null && TextUtils.getTrimmedLength((CharSequence)identifier) > 0);
            this.UN = identifier;
            return this;
        }

        public Builder setDescription(String description) {
            jx.b(description.length() <= 1000, "Session description cannot exceed %d characters", 1000);
            this.UO = description;
            return this;
        }

        public Builder setActivity(String activity) {
            return this.cV(FitnessActivities.bs(activity));
        }

        public Builder cV(int n2) {
            this.TZ = n2;
            return this;
        }

        public Session build() {
            jx.a(this.LW > 0L, "Start time should be specified.");
            jx.a(this.TO == 0L || this.TO > this.LW, "End time should be later than start time.");
            if (this.UN == null) {
                this.UN = (this.mName == null ? "" : this.mName) + this.LW;
            }
            return new Session(this);
        }
    }
}

