/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.m;
import com.google.android.gms.internal.jv;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RawBucket
implements SafeParcelable {
    final int CK;
    final long LW;
    final long TO;
    final Session TQ;
    final int UI;
    final List<RawDataSet> Ua;
    final int Ub;
    final boolean Uc;
    public static final Parcelable.Creator<RawBucket> CREATOR = new m();

    RawBucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activity, List<RawDataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.CK = versionCode;
        this.LW = startTimeMillis;
        this.TO = endTimeMillis;
        this.TQ = session;
        this.UI = activity;
        this.Ua = dataSets;
        this.Ub = bucketType;
        this.Uc = serverHasMoreData;
    }

    public RawBucket(Bucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.CK = 2;
        this.LW = bucket.getStartTime(TimeUnit.MILLISECONDS);
        this.TO = bucket.getEndTime(TimeUnit.MILLISECONDS);
        this.TQ = bucket.getSession();
        this.UI = bucket.jm();
        this.Ub = bucket.getBucketType();
        this.Uc = bucket.jn();
        List<DataSet> list = bucket.getDataSets();
        this.Ua = new ArrayList<RawDataSet>(list.size());
        for (DataSet dataSet : list) {
            this.Ua.add(new RawDataSet(dataSet, uniqueDataSources, uniqueDataTypes));
        }
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof RawBucket && this.a((RawBucket)o2);
    }

    private boolean a(RawBucket rawBucket) {
        return this.LW == rawBucket.LW && this.TO == rawBucket.TO && this.UI == rawBucket.UI && jv.equal(this.Ua, rawBucket.Ua) && this.Ub == rawBucket.Ub && this.Uc == rawBucket.Uc;
    }

    public int hashCode() {
        return jv.hashCode(this.LW, this.TO, this.Ub);
    }

    public String toString() {
        return jv.h(this).a("startTime", this.LW).a("endTime", this.TO).a("activity", this.UI).a("dataSets", this.Ua).a("bucketType", this.Ub).a("serverHasMoreData", this.Uc).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        m.a(this, parcel, flags);
    }
}

