/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.i;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import com.google.android.gms.internal.mg;

public final class Device
implements SafeParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    private final int CK;
    private final String Uw;
    private final String Ux;
    private final String TU;
    private final String Uy;
    private final int Gt;
    private final int Uz;
    public static final Parcelable.Creator<Device> CREATOR = new i();

    public static Device getLocalDevice(Context context) {
        int n2 = Device.N(context);
        String string2 = Device.M(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string2, n2, 2);
    }

    private static String M(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    private static int N(Context context) {
        switch (Device.P(context)) {
            case 10: {
                return Device.O(context) ? 3 : 0;
            }
            case 8: 
            case 9: {
                return 0;
            }
        }
        return Device.R(context) ? 1 : 2;
    }

    public static boolean O(Context context) {
        Configuration configuration = context.getResources().getConfiguration();
        return (configuration.uiMode & 0xF) == 6;
    }

    private static int P(Context context) {
        return Device.Q(context) % 1000 / 100 + 5;
    }

    private static int Q(Context context) {
        try {
            String string2 = "com.google.android.gms";
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string2, 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"Fitness", (String)"Could not find package info for Google Play Services");
            return -1;
        }
    }

    private static boolean R(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager.getPhoneType() != 0;
    }

    public Device(String manufacturer, String model, String uid, int type) {
        this(manufacturer, model, "", uid, type, 0);
    }

    public Device(String manufacturer, String model, String version, String uid, int type) {
        this(manufacturer, model, uid, type);
    }

    public Device(String manufacturer, String model, String version, String uid, int type, int platformType) {
        this(1, manufacturer, model, "", uid, type, platformType);
    }

    Device(int versionCode, String manufacturer, String model, String version, String uid, int type, int platformType) {
        this.CK = versionCode;
        this.Uw = jx.i(manufacturer);
        this.Ux = jx.i(model);
        this.TU = "";
        this.Uy = jx.i(uid);
        this.Gt = type;
        this.Uz = platformType;
    }

    public String getManufacturer() {
        return this.Uw;
    }

    public String getModel() {
        return this.Ux;
    }

    public String getVersion() {
        return this.TU;
    }

    public String getUid() {
        return this.Uy;
    }

    public int getType() {
        return this.Gt;
    }

    public int jC() {
        return this.Uz;
    }

    private boolean jD() {
        return this.jC() == 1;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.Uw, this.Ux, this.Uy);
    }

    Device jE() {
        return new Device(mg.bw(this.Uw), mg.bw(this.Ux), mg.bw(this.TU), this.Uy, this.Gt);
    }

    public String jF() {
        return mg.jN() || this.jD() ? this.Uy : mg.bw(this.Uy);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.TU, this.Gt, this.Uz);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Device && this.a((Device)that);
    }

    private boolean a(Device device) {
        return jv.equal(this.Uw, device.Uw) && jv.equal(this.Ux, device.Ux) && jv.equal(this.TU, device.TU) && jv.equal(this.Uy, device.Uy) && this.Gt == device.Gt && this.Uz == device.Uz;
    }

    public int hashCode() {
        return jv.hashCode(this.Uw, this.Ux, this.TU, this.Uy, this.Gt);
    }

    int getVersionCode() {
        return this.CK;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        i.a(this, parcel, flags);
    }
}

