/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CreateFileRequest;
import com.google.android.gms.drive.internal.CreateFolderRequest;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.af;
import com.google.android.gms.drive.internal.p;
import com.google.android.gms.drive.internal.q;
import com.google.android.gms.drive.internal.r;
import com.google.android.gms.drive.internal.s;
import com.google.android.gms.drive.internal.t;
import com.google.android.gms.drive.internal.y;
import com.google.android.gms.drive.query.Filters;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.query.SearchableField;

public class v
extends y
implements DriveFolder {
    public v(DriveId driveId) {
        super(driveId);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listChildren(GoogleApiClient apiClient) {
        return this.queryChildren(apiClient, null);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> queryChildren(GoogleApiClient apiClient, Query query) {
        Query.Builder builder = new Query.Builder().addFilter(Filters.in(SearchableField.PARENTS, this.getDriveId()));
        if (query != null) {
            if (query.getFilter() != null) {
                builder.addFilter(query.getFilter());
            }
            builder.setPageToken(query.getPageToken());
            builder.setSortOrder(query.getSortOrder());
        }
        return new p().query(apiClient, builder.build());
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient apiClient, MetadataChangeSet changeSet, DriveContents driveContents) {
        return this.createFile(apiClient, changeSet, driveContents, null);
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient apiClient, MetadataChangeSet changeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        if (executionOptions == null) {
            executionOptions = new ExecutionOptions.Builder().build();
        }
        if (executionOptions.ix() != 0) {
            throw new IllegalStateException("May not set a conflict strategy for calls to createFile.");
        }
        return this.a(apiClient, changeSet, driveContents, executionOptions);
    }

    private PendingResult<DriveFolder.DriveFileResult> a(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        int n2;
        if (driveContents != null) {
            if (!(driveContents instanceof s)) {
                throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
            }
            if (driveContents.getDriveId() != null) {
                throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
            }
            if (driveContents.it()) {
                throw new IllegalArgumentException("DriveContents are already closed.");
            }
            n2 = driveContents.ir().getRequestId();
            driveContents.is();
        } else {
            n2 = 1;
        }
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if ("application/vnd.google-apps.folder".equals(metadataChangeSet.getMimeType())) {
            throw new IllegalArgumentException("May not create folders (mimetype: application/vnd.google-apps.folder) using this method. Use DriveFolder.createFolder() instead.");
        }
        return this.a(googleApiClient, metadataChangeSet, n2, 0, executionOptions);
    }

    private PendingResult<DriveFolder.DriveFileResult> a(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet, final int n2, final int n3, final ExecutionOptions executionOptions) {
        ExecutionOptions.a(googleApiClient, executionOptions);
        return googleApiClient.b(new d(googleApiClient){

            @Override
            protected void a(r r2) throws RemoteException {
                metadataChangeSet.iz().setContext(r2.getContext());
                CreateFileRequest createFileRequest = new CreateFileRequest(v.this.getDriveId(), metadataChangeSet.iz(), n2, n3, executionOptions);
                r2.iG().a(createFileRequest, (af)new a(this));
            }
        });
    }

    @Override
    public PendingResult<DriveFolder.DriveFolderResult> createFolder(GoogleApiClient apiClient, final MetadataChangeSet changeSet) {
        if (changeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if (changeSet.getMimeType() != null && !changeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
            throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
        }
        return apiClient.b(new f(apiClient){

            @Override
            protected void a(r r2) throws RemoteException {
                changeSet.iz().setContext(r2.getContext());
                r2.iG().a(new CreateFolderRequest(v.this.getDriveId(), changeSet.iz()), (af)new b(this));
            }
        });
    }

    private static class b
    extends com.google.android.gms.drive.internal.c {
        private final BaseImplementation.b<DriveFolder.DriveFolderResult> Ea;

        public b(BaseImplementation.b<DriveFolder.DriveFolderResult> b2) {
            this.Ea = b2;
        }

        @Override
        public void a(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.Ea.b(new e(Status.Kw, new v(onDriveIdResponse.getDriveId())));
        }

        @Override
        public void n(Status status) throws RemoteException {
            this.Ea.b(new e(status, null));
        }
    }

    private static class e
    implements DriveFolder.DriveFolderResult {
        private final Status Eb;
        private final DriveFolder Qo;

        public e(Status status, DriveFolder driveFolder) {
            this.Eb = status;
            this.Qo = driveFolder;
        }

        @Override
        public Status getStatus() {
            return this.Eb;
        }

        @Override
        public DriveFolder getDriveFolder() {
            return this.Qo;
        }
    }

    static abstract class f
    extends q<DriveFolder.DriveFolderResult> {
        f(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveFolder.DriveFolderResult s(Status status) {
            return new e(status, null);
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.s(status);
        }
    }

    private static class a
    extends com.google.android.gms.drive.internal.c {
        private final BaseImplementation.b<DriveFolder.DriveFileResult> Ea;

        public a(BaseImplementation.b<DriveFolder.DriveFileResult> b2) {
            this.Ea = b2;
        }

        @Override
        public void a(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.Ea.b(new c(Status.Kw, new t(onDriveIdResponse.getDriveId())));
        }

        @Override
        public void n(Status status) throws RemoteException {
            this.Ea.b(new c(status, null));
        }
    }

    private static class c
    implements DriveFolder.DriveFileResult {
        private final Status Eb;
        private final DriveFile Qn;

        public c(Status status, DriveFile driveFile) {
            this.Eb = status;
            this.Qn = driveFile;
        }

        @Override
        public Status getStatus() {
            return this.Eb;
        }

        @Override
        public DriveFile getDriveFile() {
            return this.Qn;
        }
    }

    static abstract class d
    extends q<DriveFolder.DriveFileResult> {
        d(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveFolder.DriveFileResult r(Status status) {
            return new c(status, null);
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.r(status);
        }
    }
}

