/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CloseContentsAndUpdateMetadataRequest;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.OpenContentsRequest;
import com.google.android.gms.drive.internal.af;
import com.google.android.gms.drive.internal.az;
import com.google.android.gms.drive.internal.bg;
import com.google.android.gms.drive.internal.p;
import com.google.android.gms.drive.internal.q;
import com.google.android.gms.drive.internal.r;
import com.google.android.gms.drive.internal.w;
import com.google.android.gms.internal.jx;
import java.io.InputStream;
import java.io.OutputStream;

public class s
implements DriveContents {
    private final Contents PW;
    private boolean mClosed = false;
    private boolean PX = false;
    private boolean PY = false;

    public s(Contents contents) {
        this.PW = jx.i(contents);
    }

    @Override
    public DriveId getDriveId() {
        return this.PW.getDriveId();
    }

    @Override
    public int getMode() {
        return this.PW.getMode();
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.it()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.PW.getParcelFileDescriptor();
    }

    @Override
    public InputStream getInputStream() {
        if (this.it()) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.PW.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.PX) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.PX = true;
        return this.PW.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.it()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.PW.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.PY) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.PY = true;
        return this.PW.getOutputStream();
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient apiClient) {
        if (this.it()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.PW.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.is();
        return apiClient.a(new p.b(apiClient){

            @Override
            protected void a(r r2) throws RemoteException {
                r2.iG().a(new OpenContentsRequest(s.this.getDriveId(), 0x20000000, s.this.PW.getRequestId()), (af)new az(this, null));
            }
        });
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet) {
        return this.commit(apiClient, changeSet, null);
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet, ExecutionOptions executionOptions) {
        if (executionOptions == null) {
            executionOptions = new ExecutionOptions.Builder().build();
        }
        if (this.PW.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        if (ExecutionOptions.ba(executionOptions.ix()) && !this.PW.ip()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        ExecutionOptions.a(apiClient, executionOptions);
        if (this.it()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        final MetadataChangeSet metadataChangeSet = changeSet != null ? changeSet : MetadataChangeSet.OE;
        final ExecutionOptions executionOptions2 = executionOptions;
        this.is();
        return apiClient.b(new q.a(apiClient){

            @Override
            protected void a(r r2) throws RemoteException {
                metadataChangeSet.iz().setContext(r2.getContext());
                r2.iG().a(new CloseContentsAndUpdateMetadataRequest(s.this.PW.getDriveId(), metadataChangeSet.iz(), s.this.PW, executionOptions2), (af)new bg(this));
            }
        });
    }

    @Override
    public void discard(GoogleApiClient apiClient) {
        if (this.it()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.is();
        apiClient.b(new q.a(apiClient){

            @Override
            protected void a(r r2) throws RemoteException {
                r2.iG().a(new CloseContentsRequest(s.this.PW, false), (af)new bg(this));
            }
        }).setResultCallback(new ResultCallback<Status>(){

            public void j(Status status) {
                if (!status.isSuccess()) {
                    w.p("DriveContentsImpl", "Error discarding contents");
                } else {
                    w.m("DriveContentsImpl", "Contents discarded");
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.j((Status)x0);
            }
        });
    }

    @Override
    public Contents ir() {
        return this.PW;
    }

    @Override
    public void is() {
        this.mClosed = true;
    }

    @Override
    public boolean it() {
        return this.mClosed;
    }
}

