/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.c;
import com.google.android.gms.drive.events.d;
import com.google.android.gms.drive.internal.AddEventListenerRequest;
import com.google.android.gms.drive.internal.CancelPendingActionsRequest;
import com.google.android.gms.drive.internal.DisconnectRequest;
import com.google.android.gms.drive.internal.RemoveEventListenerRequest;
import com.google.android.gms.drive.internal.aa;
import com.google.android.gms.drive.internal.ae;
import com.google.android.gms.drive.internal.af;
import com.google.android.gms.drive.internal.ag;
import com.google.android.gms.drive.internal.bg;
import com.google.android.gms.drive.internal.p;
import com.google.android.gms.drive.internal.q;
import com.google.android.gms.internal.jg;
import com.google.android.gms.internal.jl;
import com.google.android.gms.internal.js;
import com.google.android.gms.internal.jt;
import com.google.android.gms.internal.jx;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class r
extends jl<ae> {
    private final String DZ;
    private final String JK;
    private final Bundle PK;
    private final boolean PL;
    private DriveId PM;
    private DriveId PN;
    final GoogleApiClient.ConnectionCallbacks PO;
    final Map<DriveId, Map<c, aa>> PP = new HashMap<DriveId, Map<c, aa>>();

    public r(Context context, Looper looper, jg jg2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String[] stringArray, Bundle bundle) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, stringArray);
        this.DZ = jx.b(jg2.hm(), (Object)"Must call Api.ClientBuilder.setAccountName()");
        this.JK = jg2.hq();
        this.PO = connectionCallbacks;
        this.PK = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.PL = false;
                break;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    throw new IllegalStateException("Drive event service " + serviceInfo.name + " must be exported in AndroidManifest.xml");
                }
                this.PL = true;
                break;
            }
            default: {
                throw new IllegalStateException("AndroidManifest.xml can only define one service that handles the " + intent.getAction() + " action");
            }
        }
    }

    protected ae W(IBinder iBinder) {
        return ae.a.X(iBinder);
    }

    @Override
    protected String bL() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    @Override
    protected void a(jt jt2, jl.e e2) throws RemoteException {
        String string2 = this.getContext().getPackageName();
        jx.i(e2);
        jx.i(string2);
        jx.i(this.hv());
        Bundle bundle = new Bundle();
        if (!string2.equals(this.JK)) {
            bundle.putString("proxy_package_name", this.JK);
        }
        bundle.putAll(this.PK);
        jt2.a((js)e2, 6587000, string2, this.hv(), this.DZ, bundle);
    }

    @Override
    protected String bK() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public ae iG() throws DeadObjectException {
        return (ae)this.hw();
    }

    public DriveId iH() {
        return this.PM;
    }

    public DriveId iI() {
        return this.PN;
    }

    @Override
    public void disconnect() {
        if (this.isConnected()) {
            try {
                ae ae2 = (ae)this.hw();
                ae2.a(new DisconnectRequest());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        super.disconnect();
        this.PP.clear();
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            this.PM = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.PN = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
        }
        super.a(n2, iBinder, bundle);
    }

    public boolean iJ() {
        return this.PL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> a(GoogleApiClient googleApiClient, final DriveId driveId, final int n2, c c2) {
        jx.b(d.a(n2, driveId), (Object)"id");
        jx.b(c2, (Object)"listener");
        jx.a(this.isConnected(), "Client must be connected");
        Map<DriveId, Map<c, aa>> map = this.PP;
        synchronized (map) {
            aa aa2;
            Map<c, aa> map2 = this.PP.get(driveId);
            if (map2 == null) {
                map2 = new HashMap<c, aa>();
                this.PP.put(driveId, map2);
            }
            if ((aa2 = map2.get(c2)) == null) {
                aa2 = new aa(this.getLooper(), this.getContext(), n2, c2);
                map2.put(c2, aa2);
            } else if (aa2.bx(n2)) {
                return new p.j(googleApiClient, Status.Kw);
            }
            aa2.bw(n2);
            final aa aa3 = aa2;
            return googleApiClient.b(new q.a(googleApiClient){

                @Override
                protected void a(r r2) throws RemoteException {
                    r2.iG().a(new AddEventListenerRequest(driveId, n2), (ag)aa3, null, (af)new bg(this));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> b(GoogleApiClient googleApiClient, final DriveId driveId, final int n2, c c2) {
        jx.b(d.a(n2, driveId), (Object)"id");
        jx.a(this.isConnected(), "Client must be connected");
        jx.b(c2, (Object)"listener");
        Map<DriveId, Map<c, aa>> map = this.PP;
        synchronized (map) {
            Map<c, aa> map2 = this.PP.get(driveId);
            if (map2 == null) {
                return new p.j(googleApiClient, Status.Kw);
            }
            final aa aa2 = map2.remove(c2);
            if (aa2 == null) {
                return new p.j(googleApiClient, Status.Kw);
            }
            if (map2.isEmpty()) {
                this.PP.remove(driveId);
            }
            return googleApiClient.b(new q.a(googleApiClient){

                @Override
                protected void a(r r2) throws RemoteException {
                    r2.iG().a(new RemoveEventListenerRequest(driveId, n2), (ag)aa2, null, (af)new bg(this));
                }
            });
        }
    }

    PendingResult<Status> a(GoogleApiClient googleApiClient, final DriveId driveId, final int n2) {
        jx.b(d.a(n2, driveId), (Object)"id");
        jx.a(this.isConnected(), "Client must be connected");
        if (!this.PL) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient.b(new q.a(googleApiClient){

            @Override
            protected void a(r r2) throws RemoteException {
                r2.iG().a(new AddEventListenerRequest(driveId, n2), null, null, (af)new bg(this));
            }
        });
    }

    PendingResult<Status> b(GoogleApiClient googleApiClient, final DriveId driveId, final int n2) {
        jx.b(d.a(n2, driveId), (Object)"id");
        jx.a(this.isConnected(), "Client must be connected");
        return googleApiClient.b(new q.a(googleApiClient){

            @Override
            protected void a(r r2) throws RemoteException {
                r2.iG().a(new RemoveEventListenerRequest(driveId, n2), null, null, (af)new bg(this));
            }
        });
    }

    PendingResult<Status> cancelPendingActions(GoogleApiClient apiClient, final List<String> pendingTags) {
        jx.L(pendingTags != null);
        jx.L(!pendingTags.isEmpty());
        jx.a(this.isConnected(), "Client must be connected");
        return apiClient.b(new q.a(apiClient){

            @Override
            protected void a(r r2) throws RemoteException {
                r2.iG().a(new CancelPendingActionsRequest(pendingTags), (af)new bg(this));
            }
        });
    }

    @Override
    protected /* synthetic */ IInterface l(IBinder iBinder) {
        return this.W(iBinder);
    }
}

